/*
 * Enhanced Easy Network Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
#ifndef MESHUTILITY_H_INCLUDED
#define MESHUTILITY_H_INCLUDED

#include "./ENMDef.h"
#include "MeshCommon.h"

class MeshUtility
{
public:
    static int GetMeshNeighbor(char * ifname, PMESH_NEIGHBOR_INFO *nb);
    static int GetMeshChannel(const char * ifname, int * channel);
    static int SetMeshChannel(char * ifname, int channel);
    static int GetMeshHostname(const char * ifname, char * hostname);
    static int SetMeshHostname(char * ifname, char * hn);
    static int SwitchMesh(char * ifname, bool flag);
    static int ExecCommand(char * cmd);
    static int EnableGateway(char * exif);
    static int EnableClient(PMESH_GATEWAY_INFO meshGatewayInfo);
    static int UpdateResolvconf(char * dns1, char * dns2);
    static int GetResolvconf(char * dns1, char * dns2);
    static int GetMeshIp(const char * ifname, char * ip);
    static int GetMeshIpHelper(char * ifname, char * ip);
    static int SetNetworkIf(char * ifname, bool uord);
    static int SetNetworkIfAll(const char * ifname, bool uord);
    static int GetMeshGatewayInfo(PMESH_GATEWAY_INFO meshGatewayInfo);
    static int SetMeshOnlyMode(char* ifname, char mode);
    static int SetMeshID(char* ifname, const char *id = "MESH");
    static int SetMeshChannelOFFSET(int nflag);

};

#endif // MESHUTILITY_H_INCLUDED
