/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef WIN32
#include <afxwin.h>
#else
#include <syslog.h>
#endif

#include <stdio.h>
#include <string>
#include <stdarg.h>
#define LOG
#include "DCSCommon.h"
#define MAX_BUF_LEN 1024

void WINAPI DebugString(const char* format, ...)
{
	va_list arglist;
	char buffer[MAX_BUF_LEN];

	va_start (arglist,format);
	vsprintf(buffer, format, arglist);
	va_end (arglist);

	if (strlen(buffer) +1 < MAX_BUF_LEN)
		strcat(buffer, "\n");
#ifdef WIN32
	OutputDebugString ((LPCWSTR)buffer);
#else
//printf("%s\n",buffer);
//	syslog(LOG_ERR,buffer);
#endif

#ifdef LOG
#ifdef WIN32
	char logFile[100]="C:/temp/dcs.log";
#else
	char logFile[100]="/tmp/dcs.log";
#endif
	FILE* file;
	if ( (file = fopen(logFile, "a")) != NULL )
	{
		fprintf(file,"%s",buffer);
	}
	else
		return;
	fclose(file);
#endif
}

/*
int main(int argc, char* argv[])
{
    int i;
printf("Hello World!\n");

    for (i=0; i<3; i++)
        DebugString("Hello: %d", i);
return 0;
}
*/
