/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifdef WIN32
#include <afxwin.h>
#include "io.h"
#endif

#include "Crypto.h"
#include <iostream>
#include <openssl/des.h>
#include <fstream>
#include <string>
using namespace std;


#define DEFAULT_PASSWORD "DCS_HawkPeak_1234567890"
#ifdef WIN32

#else
#include <pwd.h>
#define STUDENT_PASSWORD_FILE "/home/student/.dcs/password"
#define PARENT_PASSWORD_FILE "/home/parent/.dcs/password"
#define ADMINISTRATOR_PASSWORD_FILE "/root/.dcs/password"

#endif

const char* Crypto::GetPassword()
{
//	return DEFAULT_PASSWORD;
	strcpy(password, DEFAULT_PASSWORD);
	//
	char pwd_path[MAX_PATH];
	//char password[MAX_PATH];
	memset(pwd_path, 0, MAX_PATH);

#ifdef WIN32
	char* ptemp = getenv("USERPROFILE");
	if (ptemp != NULL)
		strcpy(pwd_path,ptemp);
	else
		return DEFAULT_PASSWORD;

	string tmp=pwd_path;
	int nIndex=0;
	nIndex=(int)tmp.rfind('\\');
	if (nIndex<=0)
		return DEFAULT_PASSWORD;

	tmp=tmp.substr(0,nIndex);
	tmp += "\\";
	tmp += userID;
	tmp += "\\Application Data\\intel\\dcs\\password";

	memset(pwd_path, 0, MAX_PATH);
	strcpy(pwd_path,tmp.c_str());

#else
	struct passwd* pwd = getpwuid(userID);
	strcpy(pwd_path, pwd->pw_dir);
	strcat(pwd_path,"/.dcs/password");
#endif

	ifstream ifs;
#ifdef WIN32
	if ( _access(pwd_path,0) != -1)// file exist
#endif
	{
		ifs.open(pwd_path,ifstream::in);

		if ( ifs.is_open())
		{
			memset(password, 0, MAX_PATH);
			ifs.getline(password, MAX_PATH);
		}
		ifs.clear();
		ifs.close();
		if (strlen(password)>0)
		{
			return password;
		}
	}

	strcpy(password, DEFAULT_PASSWORD);
	return DEFAULT_PASSWORD;
}


int Crypto::EncryptMessage(unsigned char* clearMessage, int clearMessageLen, unsigned char *encryptedMessage, int* pLen)
{
	if (clearMessageLen < 0)
		return -1;
	if (clearMessage == NULL || encryptedMessage == NULL || pLen == NULL)
		return -1;

	try
	{
		GetPassword();
		std::string keystring(password);
		DES_cblock key[1];
		DES_key_schedule key_schedule;

		DES_string_to_key(keystring.c_str(), key);
		if (DES_set_key_checked(key, &key_schedule) != 0)
			throw "DES_set_key_schedule";

		int len = (clearMessageLen+7)/8 * 8;


		DES_cblock ivec;
		*pLen = len;

		memset((char*)&ivec, 0, sizeof(ivec));
		DES_ncbc_encrypt(clearMessage, encryptedMessage, len, &key_schedule, &ivec, 1);
		//std::cout << input << std::endl;


		// for (int i = 0; i < len; ++i)
		//    printf("%02x", (output)[i]);
		// std::cout << std::endl;

	}
	catch(const char* errstr)
	{
		std::cerr << errstr << std::endl;
		return -1;
	}
	return 0;

}

int Crypto::DecryptMessage(unsigned char* encryptedMessage, int encryptedLen, unsigned char *decryptedMessage, int* pLen)
{
	if ( encryptedLen < 0 )
		return -1;
	if (encryptedMessage==NULL || decryptedMessage== NULL || pLen==NULL)
		return -1;
	try
	{
		GetPassword();
		std::string keystring(password);

		DES_cblock key[1];
		DES_key_schedule key_schedule;

		DES_string_to_key(keystring.c_str(), key);
		if (DES_set_key_checked(key, &key_schedule) != 0)
			throw "DES_set_key_schedule";

		int len = (encryptedLen+7)/8 * 8;
		//memcpy(decryptedMessage, encryptedMessage, encryptedLen);
		//	for (int i=encryptedLen; i<len; i++)
		//		encryptedMessage[i]='\0';
		*pLen = encryptedLen;


		DES_cblock ivec;
		memset((char*)&ivec, 0, sizeof(ivec));
		DES_ncbc_encrypt(encryptedMessage, decryptedMessage, len, &key_schedule, &ivec, 0);

		//for (int i = 0; i < len; ++i)
		//    printf("%02x", (decryptedMessage)[i]);
		// std::cout << std::endl;

		//  std::cout << decryptedMessage << std::endl;
	}
	catch(const char* errstr)
	{
		std::cerr << errstr << std::endl;
		return -1;
	}
	return 0;
}
/*
int main()
{
Crypto crypto(3);
unsigned char m[] = "this";
unsigned char* pEncryptedMessage=NULL, *pDecryptedMessage=NULL;
int len = 1024;
pEncryptedMessage=new unsigned char[1024];
crypto.EncryptMessage(m,sizeof(m), pEncryptedMessage, &len);
std::cout<<len<<"," << pEncryptedMessage<<std::endl;
pDecryptedMessage=new unsigned char[1024];
crypto.DecryptMessage(pEncryptedMessage,len, pDecryptedMessage, &len);
std::cout<<len<<"," << pDecryptedMessage<<std::endl;
delete []pEncryptedMessage;
delete []pDecryptedMessage;
return 0;

}*/
