/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
 * @file UserSession.h
 *
 * Definition of UserSession library
 */

#ifndef USER_SESSION_H
#define USER_SESSION_H

#ifdef __cplusplus
extern "C" {
#endif

typedef enum UserSessionStatus_E {
	USS_ActiveSession,
	USS_ActiveRemoteSession,
	USS_InactiveSession,
	USS_Uninitialized,
	USS_UnexpectedError,
} UserSessionStatus;

int InitializeUserSessionStatus(void);
void UninitializeUserSessionStatus(void);
UserSessionStatus GetUserSessionStatus(void);

#ifdef __cplusplus
}
#endif

#endif /* USER_SESSION_H */
