/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_REQUEST_MANAGEMENT_H
#define DCS_REQUEST_MANAGEMENT_H
#include <map>
#include "DCSCommon.h"
#include "ConnMgmt.h"
using namespace std;
/** Typedef of the callback function. */
typedef void (CALLBACK *DCS_Callback) (PVOID pData);

typedef struct Event_Mapping_S{
	int moduleID;
	int eventID;
}Event_Mapping;

struct less_compare		//overloading operator < in order to use STL map for user-defined type
{
public:
	bool operator()(const Event_Mapping var1,const Event_Mapping var2) const
	{
		if (var1.moduleID == var2.moduleID)
			return var1.eventID < var2.eventID;
		else
			return var1.moduleID < var2.moduleID;
	}
};

typedef map<Event_Mapping, DCS_Callback, less_compare> CallbackMapping;//store the event responses
//typedef map<unsigned long, DCS_Response> ResponseMapping;//store the function responses

class ReqMgmt{
protected:
	ReqMgmt();

public:
	static	ReqMgmt*	Instance();
	~ReqMgmt();
/** generate event request, and send out to DCS*/
	DCS_Return_Code GenEventReq(int moduleID, int eventID, DCS_Callback callback);
	/** generate unregister event request, and send out to DCS*/
	DCS_Return_Code GenUnregisterEventReq(int moduleID, int eventID);
/** generate func request, and send out to DCS*/
	DCS_Return_Code GenFuncReq(int moduleID, int funcID, int paramLen, PVOID params);
    
/** receive the event happened response*/
	DCS_Return_Code DispatchEvent(DCS_Response* pResponse);

private:
	DCS_UserID GetUserID();
	DCS_ProcID GetProcessID();
	DCS_Return_Code RegisterEvent(int moduleID, int eventID, DCS_Callback callback);
	DCS_Return_Code UnregisterEvent(int moduleID, int eventID);
#ifdef _WIN32
	HANDLE m_hMutex;
#endif
	int Lock();
	int Unlock();
	int m_reqNum;
	static ReqMgmt* m_pInstance;
	//DCS_UserGroup m_userGroup;
//	DCS_Encrypt_ID m_encryptID;
	DCS_Callback m_callbackTbl[10][100];
	//CallbackMapping m_callbackTbl;
};

#endif

