/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DCS_CONNECTION_MANAGEMENT_H
#define DCS_CONNECTION_MANAGEMENT_H
#include "DCSCommon.h"
#include "PolicyDef.h"
#define MAX_MODULE_NUM 128

#include <set>

#ifdef WIN32
#include <afxsock.h>
#else
#include <stdlib.h>
#endif


typedef enum DCS_Request_Type_S{
	DCS_EVENT_REQUEST,
	DCS_FUNCTION_REQUEST,
	DCS_UNREGISTER_EVENT_REQUEST,
}DCS_Request_Type;

/*
typedef enum DCS_Encypt_ID_S{
	DCS_NO_ENCRYPTION,
	DCS_STUDENT_ENCRYPTION,
	DCS_PARENT_ENCRYPTION,
	DCS_ADMINISTRATOR_ENCRYPTION
}DCS_Encrypt_ID;
*/
typedef struct DCS_DataHeader_S
{
    int  msgID; /**< one unique message id*/
    DCS_Request_Type  msgType; /**< message id constants: DCS_EVENT_REQUEST or DCS_FUNCTION_REQUEST*/
	//DCS_Encrypt_ID  encryptID; /**< if the message is encrypted*/
#ifdef WIN32
	int userIdLen;
#endif
	long  dataLen; /**< message length*/
	DCS_UserID userID;
}DCS_DataHeader;

//the event request structure
typedef struct Event_Request_S{
	DCS_ProcID procId;
	int moduleId;
	int eventId;
//	void (* callback)(PVOID);
}Event_Request, *PEvent_Request;

//the function request structure
typedef struct Func_Request_S{
	DCS_ProcID procId;
	int moduleId;
	int funcId;
	int paramLen;
	PVOID params; //  the params points to the start address of the function params, the table will be directly sent to MODULE API Library.
}Func_Request, *PFunc_Request;

typedef struct DCS_Request_S{
	DCS_DataHeader header;
	union {
		Func_Request func;
		Event_Request evt;
	}request;
}DCS_Request;

class DCS_Response{
    //int  msgID; /**< one unique message id*/
public:
	int moduleID;
	int opID;
    DCS_Return_Code returnCode;
	int dataLen;
	char* data;
	~DCS_Response() { if (data) delete[] this->data; }
	DCS_Response(){moduleID=0; opID = 0; returnCode=DCS_SUCCESS;dataLen = 0;data=NULL;}
	DCS_Response(const DCS_Response& response)
	{
		this->dataLen = response.dataLen;
		this->moduleID = response.moduleID;
		this->opID = response.opID;
		this->returnCode = response.returnCode;
		if (response.dataLen > 0 && response.dataLen <= MAX_RETURN_DATA_LEN)
		{
	//		if (this->data != NULL) delete this->data;
			this->data = new char[response.dataLen];
			memcpy(this->data, response.data, response.dataLen);
		}
		else
		{
			this->dataLen = 0;
			this->data = NULL;
		}
	}
	DCS_Response& operator = (const DCS_Response& response){
		this->dataLen = response.dataLen;
		this->moduleID = response.moduleID;
		this->opID = response.opID;
		this->returnCode = response.returnCode;
		if (response.dataLen > 0 && response.dataLen <= MAX_RETURN_DATA_LEN)
		{
			if (this->data != NULL) delete []this->data;
			this->data = new char[response.dataLen];
			memcpy(this->data, response.data, response.dataLen);
		}
		else
		{
			this->dataLen = 0;
			this->data = NULL;
		}
		return *this;
	}

};

#ifdef WIN32

typedef SOCKET DCS_Socket;
#else
typedef int SOCKET_TYPE;
#endif

class ConnMgmt{
protected:
	ConnMgmt();

public:
	~ConnMgmt();
	static ConnMgmt* Instance();
	int Send(DCS_Socket clifd,DCS_Response* pResponse);
	int Recv(DCS_Socket clifd,DCS_Request* pRequest);
	int Send(DCS_Request* pRequest);
	int Recv(DCS_Response* pResponse);
	int SendToAll(DCS_Response* pResponse);

	int Disconnect(DCS_Socket clifd);
	int ShutdownServer();
    int ShutdownClient();
	DCS_Socket AcceptConnection();
	int Connect();
#ifdef WIN32
	int SetSocket(SOCKET);//for multi-thread, because MFC handle couldn't be auto-passed between threads
	SOCKET GetSocket();//for multi-thread, because MFC handle couldn't be auto-passed between threads
#endif
	//DCS_UserID GetUserID();
private:
	DCS_Socket Listen();
	int dcsClose(DCS_Socket fd);

	static int err;

	DCS_Socket listenfd;
	int m_cliNum;

#ifdef WIN32
	CRITICAL_SECTION m_clifdsLock; /**< lock to protect client ID */
#else
	pthread_mutex_t m_clifdsLock; /**< lock to protect client ID */
#endif

	/**
	 * @class LockHelper
	 *
	 * Provides auto lock and unlock approach by constructor and destructor.
	 */
#ifdef WIN32
	class LockHelper
	{
	public:
		LockHelper(CRITICAL_SECTION &lock)
			: m_Lock(lock)
		{
			EnterCriticalSection(&m_Lock);
		};

		~LockHelper()
		{
			LeaveCriticalSection(&m_Lock);
		};

	private:
		CRITICAL_SECTION &m_Lock;
	};
#else
	class LockHelper
	{
	public:
		LockHelper(pthread_mutex_t &lock)
			:m_Lock(lock)
		{
			pthread_mutex_lock(&m_Lock);
		};

		~LockHelper()
		{
			pthread_mutex_unlock(&m_Lock);
		};

	private:
		pthread_mutex_t m_Lock;
	};
#endif /* WIN32 */

	std::set<DCS_Socket> m_clifds;
	DCS_Socket fd;//connect fd to server
	//uid_t uid;
#ifdef _WIN32
	HANDLE m_hMutex;
#endif
	int Lock();
	int Unlock();

	static ConnMgmt* pInstance;
};

#endif
