#!/bin/sh
#
# Device Control Service installation script
# Copyright (C) 2008  Intel Corporation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License, version 2, as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

echo "Check user privilege..."
user=`whoami`
if [ "$user" != "root" ] ; then
	echo "You must have root privilege for installation"
	exit 1
fi

echo "Check dependences..."
if [ -f /usr/lib/libssl.so ] ; then
	echo "libssl installed"
else
	echo "please install libssl first"
	exit 1
fi

echo "Check dependences finished successfully"
echo ""

echo "Install drivers..."
mod_dir=/lib/modules/`uname -r`
drv_dir=$mod_dir/kernel/drivers/misc

echo "Copy driver modules to $drv_dir"
cp ./*.ko $drv_dir
if [ $? -ne 0 ] ; then
	echo "Copy driver modules failed. Installation terminated!"
	echo "Please run uninstall.sh first and run install.sh again!"
	exit 1
fi

echo "Add driver modules to $mod_dir/modules.dep"
accel_dep=`grep "$drv_dir/accel.ko" $mod_dir/modules.dep`
tablet_dep=`grep "$drv_dir/tablet.ko" $mod_dir/modules.dep`
vkbd_dep=`grep "$drv_dir/cmpc_vkd.ko" $mod_dir/modules.dep`

if [ -z $accel_dep ] ; then
	echo "$drv_dir/accel.ko:" >> $mod_dir/modules.dep
	if [ $? -ne 0 ]; then
		echo "Can't modify modules.dep. Installation terminated!"
		echo "Please run uninstall.sh first and install.sh again!"
		exit 1
	fi
fi

if [ -z $tablet_dep ] ; then
	echo "$drv_dir/tablet.ko:" >> $mod_dir/modules.dep
	if [ $? -ne 0 ]; then
		echo "Can't modify modules.dep. Installation terminated!"
		echo "Please run uninstall.sh first and install.sh again!"
		exit 1
	fi
fi

if [ -z $vkbd_dep ] ; then
	echo "$drv_dir/cmpc_vkd.ko:" >> $mod_dir/modules.dep
	if [ $? -ne 0 ]; then
		echo "Can't modify modules.dep. Installation terminated!"
		echo "Please run uninstall.sh first and install.sh again!"
		exit 1
	fi
fi

echo "Load driver moduels now"
modprobe accel
if [ $? -ne 0 ] ; then
	echo "Can't load accelerometer driver. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi

modprobe tablet
if [ $? -ne 0 ] ; then
	echo "Can't load tablet sensor driver. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi

modprobe cmpc_vkd
if [ $? -ne 0 ] ; then
	echo "Can't load virtual keyboard driver. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi

echo "Install drivers finished successfully"
echo ""

echo "Install plugins..."
echo "Create /usr/lib/dcs folder"
if [ ! -d /usr/lib/dcs ] ; then
	mkdir /usr/lib/dcs
	if [ $? -ne 0 ] ; then
		echo "Can't create folder. Installation terminated!"
		echo "Please run uninstall.sh first and install.sh again!"
		exit 1
	fi
fi

echo "Copy plugins to /usr/lib/dcs"
cp ./*plugin.so /usr/lib/dcs
if [ $? -ne 0 ] ; then
	echo "Copy plugins failed. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi

echo "Install plugins finished successfully"
echo ""

echo "Install Device Control Service..."
echo "Copy libDcsSdk.so to /usr/lib"
cp ./libDcsSdk.so /usr/lib
if [ $? -ne 0 ] ; then
	echo "Copy libDcsSdk.so failed. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi
chmod 755 /usr/lib/libDcsSdk.so

echo "Create /usr/bin/dcs folder"
if [ ! -d /usr/bin/dcs ] ; then
	mkdir /usr/bin/dcs
	if [ $? -ne 0 ] ; then
		echo "Can't create folder. Installation terminated!"
		echo "Please run uninstall.sh first and install.sh again!"
		exit 1
	fi
fi
chmod 755 /usr/bin/dcs

echo "Create /etc/dcs folder"
if [ ! -d /etc/dcs ] ; then
	mkdir /etc/dcs
	if [ $? -ne 0 ] ; then
		echo "Can't create folder. Installation terminated!"
		exit 1
	fi
fi
chmod 755 /etc/dcs

echo "Copy genpasswd to /usr/bin/dcs"
cp ./genpasswd /usr/bin/dcs/
if [ $? -ne 0 ]; then
	echo "Copy genpasswd failed. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi
chmod 755 /usr/bin/dcs/genpasswd

echo "Copy dcs to /usr/bin/dcs"
cp ./dcs /usr/bin/dcs/
if [ $? -ne 0 ]; then
	echo "Copy dcs failed. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi
chmod 755 /usr/bin/dcs/dcs
echo "Install Device Control Service finished successfully"
echo ""

echo "Install TSController..."
echo "Copy tscontroller to /usr/bin/dcs"
cp ./tscontroller ./empty.xbm ./checkmouse.sh ./hidecursor.sh \
./showcursor.sh ./index.theme /usr/bin/dcs/
if [ $? -ne 0 ] ; then
	echo "Copy tscontroller failed. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi

chmod 755 /usr/bin/dcs/tscontroller /usr/bin/dcs/checkmouse.sh \
/usr/bin/dcs/hidecursor.sh /usr/bin/dcs/showcursor.sh
chmod 644 /usr/bin/dcs/empty.xbm /usr/bin/dcs/index.theme

echo "Install transparent cursor"
./xcursor_install.sh

echo "Install TSController finished successfully"
echo ""

echo "Install Fn Key Monitor..."
echo "Copy Fn Key Monitor to /usr/bin/dcs"
cp ./FnKeyMon /usr/bin/dcs/
if [ $? -ne 0 ] ; then
	echo "Copy Fn Key Monitor failed. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi
chmod 755 /usr/bin/dcs/FnKeyMon

cp -r ./Images /usr/bin/dcs/
if [ $? -ne 0 ] ; then
	echo "Copy Fn Key Monitor failed. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi
chmod -R 755 /usr/bin/dcs/Images

echo "Copy Display Toggle to /usr/bin/dcs"
cp ./DisplayToggle /usr/bin/dcs/
if [ $? -ne 0 ] ; then
	echo "Copy Display Toggle failed. Installation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi
chmod 755 /usr/bin/dcs/DisplayToggle
echo "Install Fn Key Monitor finished successfully"
echo ""

init_file=/etc/init.d/dcs
echo "Create auto start script in $init_file"
echo '#!/bin/sh' > $init_file
if [ $? -ne 0 ] ; then
	echo "Can't create auto start script. Insallation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi
echo '#' >> $init_file
echo '# Device Control Service auto start script' >> $init_file
echo '# Copyright (C) 2008  Intel Corporation' >> $init_file
echo '#' >> $init_file
echo '# This program is free software; you can redistribute it and/or modify' >> $init_file
echo '# it under the terms of the GNU General Public License, version 2, as' >> $init_file
echo '# published by the Free Software Foundation.' >> $init_file
echo '#' >> $init_file
echo '# This program is distributed in the hope that it will be useful,' >> $init_file
echo '# but WITHOUT ANY WARRANTY; without even the implied warranty of' >> $init_file
echo '# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the' >> $init_file
echo '# GNU General Public License for more details.' >> $init_file
echo '#' >> $init_file
echo '# You should have received a copy of the GNU General Public License along' >> $init_file
echo '# with this program; if not, write to the Free Software Foundation, Inc.,' >> $init_file
echo '# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.' >> $init_file
echo '#' >> $init_file
echo 'modprobe accel' >> $init_file
echo 'modprobe cmpc_vkd' >> $init_file
echo 'modprobe tablet' >> $init_file
echo 'sleep 10' >> $init_file
echo '/usr/bin/dcs/dcs' >> $init_file
chmod 755 /etc/init.d/dcs

echo "Create symbol link for auto start script in /etc/rc2.d/S199dcs"
if [ ! -f /etc/rc2.d/S199dcs ] ; then
	ln -s $init_file /etc/rc2.d/S199dcs
	if [ $? -ne 0 ] ; then
		echo "Can't create symbol link. Installation terminated!"
		echo "Please run uninstall.sh first and install.sh again!"
		exit 1
	fi
fi

tscontroller_xinit=/etc/xdg/autostart/tscontroller.desktop
echo "Create X-Window auto start script in $tscontroller_xinit"
echo '[Desktop Entry]' > $tscontroller_xinit
if [ $? -ne 0 ] ; then
	echo "Can't create X-Windows auto start script. Insallation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi
echo 'Type=Application' >> $tscontroller_xinit
echo 'Encoding=UTF-8' >> $tscontroller_xinit
echo 'Version=1.0' >> $tscontroller_xinit
echo 'Name=tscontroller' >> $tscontroller_xinit
echo 'Comment=Tablet Screen Controller' >> $tscontroller_xinit
echo 'Exec=/usr/bin/dcs/tscontroller.sh' >> $tscontroller_xinit
echo 'Terminal=false' >> $tscontroller_xinit
echo 'OnlyShowIn=GNOME' >> $tscontroller_xinit
echo 'X-GNOME-Autostart-enabled=true' >> $tscontroller_xinit
chmod 644 $tscontroller_xinit

FnKeyMon_xinit=/etc/xdg/autostart/FnKeyMon.desktop
echo "Create X-Window auto start script in $FnKeyMon_xinit"
echo '[Desktop Entry]' > $FnKeyMon_xinit
if [ $? -ne 0 ] ; then
	echo "Can't create X-Windows auto start script. Insallation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi
echo 'Type=Application' >> $FnKeyMon_xinit
echo 'Encoding=UTF-8' >> $FnKeyMon_xinit
echo 'Version=1.0' >> $FnKeyMon_xinit
echo 'Name=FnKeyMon' >> $FnKeyMon_xinit
echo 'Comment=Fn Key Monitor' >> $FnKeyMon_xinit
echo 'Exec=/usr/bin/dcs/FnKeyMon' >> $FnKeyMon_xinit
echo 'Terminal=false' >> $FnKeyMon_xinit
echo 'OnlyShowIn=GNOME' >> $FnKeyMon_xinit
echo 'X-GNOME-Autostart-enabled=true' >> $FnKeyMon_xinit
chmod 644 $FnKeyMon_xinit

echo "Create auto start script finished successfully"
echo ""

ver_file=/usr/bin/dcs/.version
echo "Generate version infomation in $ver_file"
echo '0.8.0.0' > $ver_file
if [ $? -ne 0 ] ; then
	echo "Can't generate version information . Insallation terminated!"
	echo "Please run uninstall.sh first and install.sh again!"
	exit 1
fi

echo "Start Device Control Service"
/usr/bin/dcs/dcs &
echo "Wait 2 seconds for DCS"
sleep 2
echo "Start TSController"
/usr/bin/dcs/tscontroller &
echo "Start Fn Key Monitor"
/usr/bin/dcs/FnKeyMon &

echo "Installation finished successfully"
