/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_ICONVIEW_H_
#define _LAUNCHER_ICONVIEW_H_

#include <glib-object.h>
#include <clutter/clutter.h>
#include <tidy/tidy.h>

#include "launcher-menu.h"


#define LAUNCHER_TYPE_ICONVIEW (launcher_iconview_get_type ())

#define LAUNCHER_ICONVIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_ICONVIEW, LauncherIconview))

#define LAUNCHER_ICONVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_ICONVIEW, LauncherIconviewClass))

#define LAUNCHER_IS_ICONVIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_ICONVIEW))

#define LAUNCHER_IS_ICONVIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_ICONVIEW))

#define LAUNCHER_ICONVIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_ICONVIEW, LauncherIconviewClass))

typedef struct _LauncherIconview        LauncherIconview;
typedef struct _LauncherIconviewClass   LauncherIconviewClass;
typedef struct _LauncherIconviewPrivate LauncherIconviewPrivate;
 
struct _LauncherIconview
{
  TidyViewport        parent;	

  LauncherIconviewPrivate *priv;
};

struct _LauncherIconviewClass
{
  TidyViewportClass   parent_class;

  /*< signals />*/
  void (*category_selected) (LauncherIconview       *iconview, 
                             LauncherMenuCategory *category);
};

GType launcher_iconview_get_type (void) G_GNUC_CONST;

ClutterActor * launcher_iconview_new (void);

void           launcher_iconview_set_category (LauncherIconview     *view,
                                               LauncherMenuCategory *cat,
                                               gboolean              first_run);
gboolean       launcher_iconview_scroll_event (ClutterActor       *actor,
                                               ClutterScrollEvent *event,
                                               LauncherIconview   *view);
void           launcher_iconview_preload      (LauncherIconview     *view,
                                               LauncherMenuCategory *cat);

void           launcher_iconview_disable      (LauncherIconview   *view);

#endif /* _LAUNCHER_ICONVIEW_H_ */

