/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include "clutter-drag-dest.h"

#include "clutter-drag-server.h"


G_DEFINE_TYPE (ClutterDragDest, clutter_drag_dest, CLUTTER_TYPE_GROUP);

#define CLUTTER_DRAG_DEST_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj),\
  CLUTTER_TYPE_DRAG_DEST, \
  ClutterDragDestPrivate))

struct _ClutterDragDestPrivate
{
  gboolean windowed;
};

void      
clutter_drag_dest_enable (ClutterDragDest *dest)
{
  clutter_drag_server_add_drag_dest (clutter_drag_server_get_default (),dest);
}


gboolean 
clutter_drag_dest_drop (ClutterDragDest *dest,
                        gpointer         data)
{  
  ClutterDragDestClass *klass;

  g_return_val_if_fail (CLUTTER_IS_DRAG_DEST (dest), FALSE);
  
  klass = CLUTTER_DRAG_DEST_GET_CLASS (dest);
  g_return_val_if_fail (klass->drop != NULL, FALSE);

  return klass->drop (dest, data);
}

/* GObject stuff */
static void
clutter_drag_dest_finalize (GObject *object)
{
  ClutterDragDestPrivate *priv;

  priv = CLUTTER_DRAG_DEST_GET_PRIVATE (object);

  G_OBJECT_CLASS (clutter_drag_dest_parent_class)->finalize (object);
}

static void
clutter_drag_dest_class_init (ClutterDragDestClass *klass)
{
  GObjectClass        *obj_class = G_OBJECT_CLASS (klass);

  obj_class->finalize = clutter_drag_dest_finalize;

  g_type_class_add_private (obj_class, sizeof (ClutterDragDestPrivate));
}

static void
clutter_drag_dest_init (ClutterDragDest *drag_dest)
{
  ClutterDragDestPrivate *priv;

  priv = drag_dest->priv = CLUTTER_DRAG_DEST_GET_PRIVATE (drag_dest);
}
