/* monitor.c generated by valac, the Vala compiler
 * generated from monitor.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup Monitor
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <stdlib.h>
#include <time.h>
#include <gconf/gconf.h>


#define TYPE_MONITOR (monitor_get_type ())
#define MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITOR, Monitor))
#define MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITOR, MonitorClass))
#define IS_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITOR))
#define IS_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITOR))
#define MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITOR, MonitorClass))

typedef struct _Monitor Monitor;
typedef struct _MonitorClass MonitorClass;
typedef struct _MonitorPrivate MonitorPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))

struct _Monitor {
	GObject parent_instance;
	MonitorPrivate * priv;
};

struct _MonitorClass {
	GObjectClass parent_class;
};


static GMainLoop* monitor_loop;
static GMainLoop* monitor_loop = NULL;
static guint monitor_timeout_id;
static guint monitor_timeout_id = 0U;
static GPid monitor_pid;
static GPid monitor_pid = 0;
static gboolean monitor_show_version;
static gboolean monitor_show_version = FALSE;
static gpointer monitor_parent_class = NULL;

GType monitor_get_type (void);
enum  {
	MONITOR_DUMMY_PROPERTY
};
#define MONITOR_GCONF_DIR "/apps/deja-dup"
#define MONITOR_LAST_RUN_KEY "/apps/deja-dup/last-run"
#define MONITOR_PERIODIC_KEY "/apps/deja-dup/periodic"
#define MONITOR_PERIODIC_PERIOD_KEY "/apps/deja-dup/periodic-period"
static gboolean monitor_handle_options (gint* status);
static void monitor_today (GDate* result);
static void monitor_most_recent_scheduled_date (gint period, GDate* result);
static void monitor_next_run_date (GDate* result);
static void monitor_date_to_timeval (GDate* date, GTimeVal* result);
static glong monitor_seconds_until (GDate* date);
static void monitor_close_pid (GPid child_pid, gint status);
static gboolean monitor_seconds_until_next_run (glong* secs);
static void monitor_prepare_next_run (void);
static void monitor_prepare_tomorrow (void);
static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self);
static gboolean monitor_kickoff (void);
static gboolean _monitor_kickoff_gsource_func (gpointer self);
static void monitor_prepare_run (glong wait_time);
static void _monitor_prepare_next_run_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self);
static void monitor_watch_gconf (void);
static gint monitor_main (char** args, int args_length1);
Monitor* monitor_new (void);
Monitor* monitor_construct (GType object_type);
static void monitor_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GOptionEntry MONITOR_options[] = {{"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &monitor_show_version, N_ ("Show version"), NULL}, {NULL}};


static gboolean monitor_handle_options (gint* status) {
	gboolean result;
	*status = 0;
	if (monitor_show_version) {
		g_print ("%s %s\n", _ ("Déjà Dup Monitor"), VERSION);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static void monitor_today (GDate* result) {
	GTimeVal _tmp0_ = {0};
	GTimeVal cur_time;
	GDate _tmp1_ = {0};
	GDate cur_date;
	cur_time = (g_get_current_time (&_tmp0_), _tmp0_);
	g_get_current_time (&cur_time);
	cur_date = (memset (&_tmp1_, 0, sizeof (GDate)), _tmp1_);
	g_date_set_time_val (&cur_date, &cur_time);
	*result = cur_date;
	return;
}


static void monitor_most_recent_scheduled_date (gint period, GDate* result) {
	GDate _tmp0_ = {0};
	GDate epoch;
	GDate _tmp1_ = {0};
	GDate cur_date;
	gint between;
	gint mod;
	epoch = (memset (&_tmp0_, 0, sizeof (GDate)), _tmp0_);
	g_date_set_dmy (&epoch, (GDateDay) 1, 1, (GDateYear) 1970);
	cur_date = (monitor_today (&_tmp1_), _tmp1_);
	between = g_date_days_between (&epoch, &cur_date);
	mod = between % period;
	g_date_subtract_days (&cur_date, (guint) mod);
	*result = cur_date;
	return;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void monitor_next_run_date (GDate* result) {
	GError * _inner_error_;
	GConfClient* client;
	gboolean periodic = FALSE;
	char* last_run_string;
	gint period_days = 0;
	GDate _tmp7_ = {0};
	GDate last_run;
	GTimeVal _tmp8_ = {0};
	GTimeVal last_run_tval;
	GDate _tmp11_ = {0};
	GDate last_scheduled;
	_inner_error_ = NULL;
	client = _g_object_ref0 (gconf_client_get_default ());
	last_run_string = NULL;
	{
		gboolean _tmp0_;
		const char* _tmp1_;
		char* _tmp2_;
		gint _tmp3_;
		_tmp0_ = gconf_client_get_bool (client, MONITOR_PERIODIC_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		periodic = _tmp0_;
		_tmp1_ = gconf_client_get_string (client, MONITOR_LAST_RUN_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		last_run_string = (_tmp2_ = g_strdup (_tmp1_), _g_free0 (last_run_string), _tmp2_);
		_tmp3_ = gconf_client_get_int (client, MONITOR_PERIODIC_PERIOD_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
			goto __finally0;
		}
		period_days = _tmp3_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GDate _tmp4_ = {0};
			g_error ("monitor.vala:91: %s", e->message);
			*result = (memset (&_tmp4_, 0, sizeof (GDate)), _tmp4_);
			_g_error_free0 (e);
			_g_object_unref0 (client);
			_g_free0 (last_run_string);
			return;
			_g_error_free0 (e);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	if (!periodic) {
		GDate _tmp5_ = {0};
		*result = (memset (&_tmp5_, 0, sizeof (GDate)), _tmp5_);
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		return;
	}
	if (last_run_string == NULL) {
		GDate _tmp6_ = {0};
		*result = (monitor_today (&_tmp6_), _tmp6_);
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		return;
	}
	if (period_days <= 0) {
		period_days = 1;
	}
	last_run = (memset (&_tmp7_, 0, sizeof (GDate)), _tmp7_);
	last_run_tval = (g_get_current_time (&_tmp8_), _tmp8_);
	if (!g_time_val_from_iso8601 (last_run_string, &last_run_tval)) {
		GDate _tmp9_ = {0};
		*result = (monitor_today (&_tmp9_), _tmp9_);
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		return;
	}
	g_date_set_time_val (&last_run, &last_run_tval);
	if (!g_date_valid (&last_run)) {
		GDate _tmp10_ = {0};
		*result = (monitor_today (&_tmp10_), _tmp10_);
		_g_object_unref0 (client);
		_g_free0 (last_run_string);
		return;
	}
	last_scheduled = (monitor_most_recent_scheduled_date (period_days, &_tmp11_), _tmp11_);
	if (g_date_compare (&last_scheduled, &last_run) <= 0) {
		g_date_add_days (&last_scheduled, (guint) period_days);
	}
	*result = last_scheduled;
	_g_object_unref0 (client);
	_g_free0 (last_run_string);
	return;
}


static void monitor_date_to_timeval (GDate* date, GTimeVal* result) {
	struct tm time = {0};
	time_t timet;
	GTimeVal _tmp0_ = {0};
	GTimeVal tval;
	g_date_to_struct_tm (date, &time);
	time.tm_hour = 0;
	time.tm_min = 0;
	time.tm_sec = 0;
	timet = mktime (&time);
	tval = (g_get_current_time (&_tmp0_), _tmp0_);
	tval.tv_sec = (glong) timet;
	tval.tv_usec = (glong) 0;
	*result = tval;
	return;
}


static glong monitor_seconds_until (GDate* date) {
	glong result;
	GTimeVal _tmp0_ = {0};
	GTimeVal cur_time;
	GTimeVal _tmp1_ = {0};
	GTimeVal next_time;
	cur_time = (g_get_current_time (&_tmp0_), _tmp0_);
	g_get_current_time (&cur_time);
	next_time = (monitor_date_to_timeval (date, &_tmp1_), _tmp1_);
	result = next_time.tv_sec - cur_time.tv_sec;
	return result;
}


static void monitor_close_pid (GPid child_pid, gint status) {
	g_spawn_close_pid (child_pid);
	monitor_pid = (GPid) 0;
}


static void _monitor_close_pid_gchild_watch_func (GPid pid, gint status, gpointer self) {
	monitor_close_pid (pid, status);
}


static gboolean monitor_kickoff (void) {
	gboolean result;
	GError * _inner_error_;
	glong wait_time = 0L;
	_inner_error_ = NULL;
	if (!monitor_seconds_until_next_run (&wait_time)) {
		result = FALSE;
		return result;
	}
	if (wait_time > 0) {
		monitor_prepare_next_run ();
		result = FALSE;
		return result;
	}
	monitor_prepare_tomorrow ();
	if (monitor_pid == ((GPid) 0)) {
		{
			char** _tmp0_;
			gint argv_size;
			gint argv_length1;
			char** argv;
			char* _tmp1_;
			char* _tmp2_;
			argv = (_tmp0_ = g_new0 (char*, 2 + 1), argv_length1 = 2, argv_size = argv_length1, _tmp0_);
			argv[0] = (_tmp1_ = g_strdup ("deja-dup-applet"), _g_free0 (argv[0]), _tmp1_);
			argv[1] = (_tmp2_ = NULL, _g_free0 (argv[1]), _tmp2_);
			g_spawn_async (NULL, argv, NULL, ((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &monitor_pid, &_inner_error_);
			if (_inner_error_ != NULL) {
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				goto __catch1_g_error;
				goto __finally1;
			}
			g_child_watch_add (monitor_pid, _monitor_close_pid_gchild_watch_func, NULL);
			argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("monitor.vala:191: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally1:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	} else {
		g_debug ("monitor.vala:195: Not rerunning deja-dup-applet, already doing so.");
	}
	result = FALSE;
	return result;
}


static gboolean monitor_seconds_until_next_run (glong* secs) {
	gboolean result;
	GDate _tmp0_ = {0};
	GDate next_date;
	next_date = (monitor_next_run_date (&_tmp0_), _tmp0_);
	if (!g_date_valid (&next_date)) {
		g_debug ("monitor.vala:204: Invalid next run date.  Not scheduling a backup.");
		result = FALSE;
		return result;
	}
	*secs = monitor_seconds_until (&next_date);
	result = TRUE;
	return result;
}


static gboolean _monitor_kickoff_gsource_func (gpointer self) {
	return monitor_kickoff ();
}


static void monitor_prepare_run (glong wait_time) {
	if (monitor_timeout_id != 0) {
		g_source_remove (monitor_timeout_id);
	}
	if (wait_time > 0) {
		g_debug ("monitor.vala:219: Waiting %ld seconds until next backup.", wait_time);
		monitor_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) wait_time, _monitor_kickoff_gsource_func, NULL, NULL);
	} else {
		g_debug ("monitor.vala:223: Late by %ld seconds.  Backing up now.", wait_time * (-1));
		monitor_kickoff ();
	}
}


static void monitor_prepare_tomorrow (void) {
	GDate _tmp0_ = {0};
	GDate tomorrow;
	glong secs;
	tomorrow = (monitor_today (&_tmp0_), _tmp0_);
	g_date_add_days (&tomorrow, (guint) 1);
	secs = monitor_seconds_until (&tomorrow);
	monitor_prepare_run (secs);
}


static void monitor_prepare_next_run (void) {
	glong wait_time = 0L;
	if (!monitor_seconds_until_next_run (&wait_time)) {
		return;
	}
	monitor_prepare_run (wait_time);
}


static void _monitor_prepare_next_run_gconf_client_notify_func (GConfClient* client, guint cnxn_id, GConfEntry* entry, gpointer self) {
	monitor_prepare_next_run ();
}


static void monitor_watch_gconf (void) {
	GError * _inner_error_;
	GConfClient* client;
	_inner_error_ = NULL;
	client = _g_object_ref0 (gconf_client_get_default ());
	{
		gconf_client_add_dir (client, MONITOR_GCONF_DIR, GCONF_CLIENT_PRELOAD_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		gconf_client_notify_add (client, MONITOR_LAST_RUN_KEY, _monitor_prepare_next_run_gconf_client_notify_func, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		gconf_client_notify_add (client, MONITOR_PERIODIC_KEY, _monitor_prepare_next_run_gconf_client_notify_func, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
		gconf_client_notify_add (client, MONITOR_PERIODIC_PERIOD_KEY, _monitor_prepare_next_run_gconf_client_notify_func, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
			goto __finally2;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("monitor.vala:256: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (client);
}


static gint monitor_main (char** args, int args_length1) {
	gint result;
	GError * _inner_error_;
	GOptionContext* context;
	gint status = 0;
	GMainLoop* _tmp1_;
	_inner_error_ = NULL;
	textdomain (GETTEXT_PACKAGE);
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	g_set_application_name (_ ("Déjà Dup Monitor"));
	context = g_option_context_new ("");
	g_option_context_add_main_entries (context, MONITOR_options, GETTEXT_PACKAGE);
	{
		g_option_context_parse (context, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
			goto __finally3;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char* _tmp0_;
			g_printerr ("%s\n\n%s", e->message, _tmp0_ = g_option_context_get_help (context, TRUE, NULL));
			_g_free0 (_tmp0_);
			result = 1;
			_g_error_free0 (e);
			_g_option_context_free0 (context);
			return result;
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return 0;
	}
	if (!monitor_handle_options (&status)) {
		result = status;
		_g_option_context_free0 (context);
		return result;
	}
	monitor_loop = (_tmp1_ = g_main_loop_new (NULL, FALSE), _g_main_loop_unref0 (monitor_loop), _tmp1_);
	monitor_prepare_next_run ();
	monitor_watch_gconf ();
	g_main_loop_run (monitor_loop);
	result = 0;
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return monitor_main (argv, argc);
}


Monitor* monitor_construct (GType object_type) {
	Monitor * self;
	self = (Monitor*) g_object_new (object_type, NULL);
	return self;
}


Monitor* monitor_new (void) {
	return monitor_construct (TYPE_MONITOR);
}


static void monitor_class_init (MonitorClass * klass) {
	monitor_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = monitor_finalize;
}


static void monitor_instance_init (Monitor * self) {
}


static void monitor_finalize (GObject* obj) {
	Monitor * self;
	self = MONITOR (obj);
	G_OBJECT_CLASS (monitor_parent_class)->finalize (obj);
}


GType monitor_get_type (void) {
	static GType monitor_type_id = 0;
	if (monitor_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (MonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Monitor), 0, (GInstanceInitFunc) monitor_instance_init, NULL };
		monitor_type_id = g_type_register_static (G_TYPE_OBJECT, "Monitor", &g_define_type_info, 0);
	}
	return monitor_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}




