/*
 * OWL (OpenedHand Widget Library) Colour Palette.
 *
 * Author: Rob Bradford  <rob@openedhand.com>
 *
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _OWL_COLOUR_PALETTE
#define _OWL_COLOUR_PALETTE

#include <glib-object.h>
#include <gtk/gtk.h>

#include "owlcolourswatch.h"

G_BEGIN_DECLS

#define OWL_TYPE_COLOUR_PALETTE owl_colour_palette_get_type()

#define OWL_COLOUR_PALETTE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
  OWL_TYPE_COLOUR_PALETTE, OwlColourPalette))

#define OWL_COLOUR_PALETTE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), \
  OWL_TYPE_COLOUR_PALETTE, OwlColourPaletteClass))

#define OWL_IS_COLOUR_PALETTE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
  OWL_TYPE_COLOUR_PALETTE))

#define OWL_IS_COLOUR_PALETTE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
  OWL_TYPE_COLOUR_PALETTE))

#define OWL_COLOUR_PALETTE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), \
  OWL_TYPE_COLOUR_PALETTE, OwlColourPaletteClass))

typedef struct {
  GtkTable parent;
} OwlColourPalette;

typedef struct {
  GtkTableClass parent_class;
  void (* colour_selected) (OwlColourPalette *palette, OwlColourSwatch *swatch);
} OwlColourPaletteClass;

GType owl_colour_palette_get_type (void);
GtkWidget* owl_colour_palette_new (guint n_rows, guint n_columns);
void owl_colour_palette_set_colours (OwlColourPalette *palette, guint32 colours[], guint nr_colours);

G_END_DECLS

#endif /* _OWL_COLOUR_PALETTE */
