/*
 * OWL (OpenedHand Widget Library) Colour Button.
 *
 * Author: Rob Bradford  <rob@openedhand.com>
 *
 * Copyright (C) 2007 OpenedHand Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "owlcolourbutton.h"
#include "owlcolourswatch.h"
#include "owlcolourselectordialog.h"

#include <gtk/gtk.h>

G_DEFINE_TYPE (OwlColourButton, owl_colour_button, GTK_TYPE_BUTTON);

#define COLOUR_BUTTON_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), OWL_TYPE_COLOUR_BUTTON, OwlColourButtonPrivate))

typedef struct _OwlColourButtonPrivate OwlColourButtonPrivate;

struct _OwlColourButtonPrivate
{
  GtkWidget *swatch;
};

static void
owl_colour_button_get_property (GObject *object, guint property_id,
                              GValue *value, GParamSpec *pspec)
{
  switch (property_id) {
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
  }
}

static void
owl_colour_button_set_property (GObject *object, guint property_id,
                              const GValue *value, GParamSpec *pspec)
{
  switch (property_id) {
  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
  }
}

static void
owl_colour_button_dispose (GObject *object)
{
  if (G_OBJECT_CLASS (owl_colour_button_parent_class)->dispose)
    G_OBJECT_CLASS (owl_colour_button_parent_class)->dispose (object);
}

static void
owl_colour_button_finalize (GObject *object)
{
  G_OBJECT_CLASS (owl_colour_button_parent_class)->finalize (object);
}

static void
owl_colour_button_class_init (OwlColourButtonClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_class_add_private (klass, sizeof (OwlColourButtonPrivate));

  object_class->get_property = owl_colour_button_get_property;
  object_class->set_property = owl_colour_button_set_property;
  object_class->dispose = owl_colour_button_dispose;
  object_class->finalize = owl_colour_button_finalize;
}


static void
button_clicked (GtkButton *button, gpointer user_data)
{
  GtkWidget *dialog;
  gint res;
  OwlColourButtonPrivate *priv = COLOUR_BUTTON_PRIVATE (user_data);

  dialog = owl_colour_selector_dialog_new ();

  res = gtk_dialog_run (GTK_DIALOG(dialog));

  switch (res)
    {
      case (GTK_RESPONSE_OK):
        {
          guint32 new_colour;
          GtkWidget *swatch = priv->swatch;

          new_colour = owl_colour_selector_dialog_get_colour (OWL_COLOUR_SELECTOR_DIALOG (dialog));
          owl_colour_swatch_set_colour (OWL_COLOUR_SWATCH (swatch), new_colour);
        }
      case (GTK_RESPONSE_CANCEL):
      default:
        gtk_widget_destroy (dialog);
    }
}


guint32
owl_colour_button_get_colour (OwlColourButton *self)
{
  OwlColourButtonPrivate *priv = COLOUR_BUTTON_PRIVATE (self);

  return owl_colour_swatch_get_colour (OWL_COLOUR_SWATCH(priv->swatch));
}

void
owl_colour_button_set_colour (OwlColourButton *self, guint32 colour)
{
  OwlColourButtonPrivate *priv = COLOUR_BUTTON_PRIVATE (self);

  owl_colour_swatch_set_colour (OWL_COLOUR_SWATCH (priv->swatch), colour);
}

static void
owl_colour_button_init (OwlColourButton *self)
{
  OwlColourButtonPrivate *priv = COLOUR_BUTTON_PRIVATE (self);
  GtkWidget *hbox;
  GtkWidget *alignment;

  hbox = gtk_hbox_new (FALSE, 0);
  alignment = gtk_alignment_new (0.5, 0.5, 0.5, 0.5);

  priv->swatch = owl_colour_swatch_new ();

  gtk_container_add (GTK_CONTAINER (alignment), priv->swatch);
  gtk_box_pack_start (GTK_BOX (hbox), alignment, TRUE, TRUE, 0);

  gtk_container_add (GTK_CONTAINER (self), hbox);

  g_signal_connect (G_OBJECT (self), "clicked", (GCallback)button_clicked, self);
}

GtkWidget*
owl_colour_button_new (void)
{
  return GTK_WIDGET(g_object_new (OWL_TYPE_COLOUR_BUTTON, NULL));
}

