.\"
.\" "$Id: accept.man 6649 2007-07-11 21:46:42Z mike $"
.\"
.\"   accept/reject man page for the Common UNIX Printing System (CUPS).
.\"
.\"   Copyright 2007 by Apple Inc.
.\"   Copyright 1997-2006 by Easy Software Products.
.\"
.\"   These coded instructions, statements, and computer programs are the
.\"   property of Apple Inc. and are protected by Federal copyright
.\"   law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\"   which should have been included with this file.  If this file is
.\"   file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH accept 8 "Common UNIX Printing System" "12 February 2006" "Apple Inc."
.SH NAME
accept/reject \- accept/reject jobs sent to a destination
.SH SYNOPSIS
.B accept
[ -E ] [ -U
.I username
] [ -h
.I hostname[:port]
] destination(s)
.br
.B reject
[ -E ] [ -U
.I username
] [ -h
.I hostname[:port]
] [ -r
.I reason
] destination(s)
.SH DESCRIPTION
\fIaccept\fR instructs the printing system to accept print jobs to the
specified destinations.
.LP
\fIreject\fR instructs the printing system to reject print jobs to the
specified destinations. The \fI-r\fR option sets the reason for rejecting
print jobs. If not specified the reason defaults to "Reason Unknown".
.SH OPTIONS
The following options are supported by both \fIaccept\fR and
\fIreject\fR:
.TP 5
-E
.br
Forces encryption when connecting to the server.
.TP 5
-U username
.br
Sets the username that is sent when connecting to the server.
.TP 5
-h hostname[:port]
.br
Chooses an alternate server.
.TP 5
-r "reason"
.br
Sets the reason string that is shown for a printer that is
rejecting jobs.
.SH COMPATIBILITY
Unlike the System V printing system, CUPS allows printer names to
contain any printable character except SPACE, TAB, "/", or "#".
Also, printer and class names are \fInot\fR case-sensitive.
.LP
The CUPS versions of \fIaccept\fR and \fIreject\fR may ask the
user for an access password depending on the printing system
configuration. This differs from the System V versions which
require the root user to execute these commands.
.SH SEE ALSO
\fIcancel(1)\fR, \fIcupsenable(8)\fR, \fIlp(1)\fR,
\fIlpadmin(8)\fR, \fIlpstat(1)\fR,
.br
http://localhost:631/help
.SH COPYRIGHT
Copyright 2007 by Apple Inc.
.\"
.\" End of "$Id: accept.man 6649 2007-07-11 21:46:42Z mike $".
.\"
