/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_VBOX_H_
#define _CTK_VBOX_H_

#include <glib.h>
#include <clutter/clutter.h>

#include <ctk/ctk-box.h>

#define CTK_TYPE_VBOX (ctk_vbox_get_type ())

#define CTK_VBOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_VBOX, CtkVBox))

#define CTK_VBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_VBOX, CtkVBoxClass))

#define CTK_IS_VBOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_VBOX))

#define CTK_IS_VBOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_VBOX))

#define CTK_VBOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_VBOX, CtkVBoxClass))

typedef struct _CtkVBox        CtkVBox;
typedef struct _CtkVBoxClass   CtkVBoxClass;
 
struct _CtkVBox
{
  CtkBox        parent;	
};

struct _CtkVBoxClass
{
  CtkBoxClass   parent_class;
};

GType          ctk_vbox_get_type  (void) G_GNUC_CONST;

ClutterActor * ctk_vbox_new       (guint spacing);

#endif /* _CTK_VBOX_H_ */

