/*
 * Copyright 2009 Canonical Ltd.
 * 
 * This program is free software: you can redistribute it and/or modify it 
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the 
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by 
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranties of 
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the applicable version of the GNU Lesser General Public 
 * License for more details.
 * 
 * You should have received a copy of both the GNU Lesser General Public 
 * License version 3 and version 2.1 along with this program.  If not, see 
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_TEXT_H_
#define _CTK_TEXT_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <ctk/ctk-actor.h>

G_BEGIN_DECLS

#define CTK_TYPE_TEXT (ctk_text_get_type ())

#define CTK_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_TEXT, CtkText))

#define CTK_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_TEXT, CtkTextClass))

#define CTK_IS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_TEXT))

#define CTK_IS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_TEXT))

#define CTK_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_TEXT, CtkTextClass))

typedef struct _CtkText        CtkText;
typedef struct _CtkTextClass   CtkTextClass;
typedef struct _CtkTextPrivate CtkTextPrivate;
 
struct _CtkText
{
  ClutterText parent;	

  CtkTextPrivate *priv;
};

struct _CtkTextClass
{
  /*< private >*/
  ClutterTextClass  parent_class;

  /*< public >*/
  /* signals, not vfuncs */

  /* vtable */

  /*< private >*/
  /* padding */
  void (*_ctk_padding1) (void);
  void (*_ctk_padding2) (void);
  void (*_ctk_padding3) (void);
  void (*_ctk_padding4) (void);
  void (*_ctk_padding5) (void);
  void (*_ctk_padding6) (void);
};

GType          ctk_text_get_type      (void) G_GNUC_CONST;

ClutterActor * ctk_text_new           (const gchar    *text);

void           ctk_text_set_alignment (CtkText        *self,
                                       PangoAlignment  alignment);

PangoAlignment ctk_text_get_alignment (CtkText        *self);

G_END_DECLS

#endif /* _CTK_TEXT_H_ */

