################################################################################
#23456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789 
#       10        20        30        40        50        60        70        80
#
# Copyright 2009 Canonical Ltd.
# 
# This program is free software: you can redistribute it and/or modify it 
# under the terms of either or both of the following licenses:
#
# 1) the GNU Lesser General Public License version 3, as published by the 
#    Free Software Foundation; and/or
# 2) the GNU Lesser General Public License version 2.1, as published by 
#    the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the applicable version of the GNU Lesser General Public 
# License for more details.
# 
# You should have received a copy of both the GNU Lesser General Public 
# License version 3 and version 2.1 along with this program.  If not, see 
# <http://www.gnu.org/licenses/>
#
# Authored by: Mirco Müller <mirco.mueller@canonical.com>
#
# what does this do:
#     gnuplot-script to generate a graph-diagram to show min/avg/max fps values
#     of different versions of unity during different test-cases on certain
#     hardware
#
# needs input:
#     ./output-fps.csv
#
# outputs:
#     ./output-fps.svg
#
################################################################################

output_width  = 800
output_height = 600
output_font   = "Candara,16"
min_color     = "#ff0000"
avg_color     = "#0000ff"
max_color     = "#00ff00"
output_file   = "output-fps.svg"
input_file    = "output-fps.csv"
title_string  = "Test #1 - nvidia GeForce 8800GTS"

set title title_string
set label "min. fps" at 9,200 tc rgb min_color font output_font
set label "avg. fps" at 9,220 tc rgb avg_color font output_font
set label "max. fps" at 9,240 tc rgb max_color font output_font
unset key
unset border
set xtics axis out scale 0.5 nomirror (\
"0.0.1" 0,\
"0.0.2" 1,\
"0.0.3" 2,\
"0.1.0" 3,\
"0.1.4" 4,\
"0.1.7" 5,\
"0.1.8" 6,\
"0.2.0" 7,\
"0.2.1" 8,\
"trunk" 9,\
"0.3.7" 10\
)

set ytics axis out scale 0.5 nomirror
set xzeroaxis lt rgb "#000000"
set yzeroaxis lt rgb "#000000"
set yrange [0:250]
set ylabel 'framerate (fps) - higher is better'
set xlabel 'unity version/branch'
set term svg size output_width,output_height fixed font output_font
set outp output_file
plot input_file using 1:3 with lines lt rgb min_color lw 3.0, \
     input_file using 1:4 with lines lt rgb avg_color lw 3.0, \
     input_file using 1:5 with lines lt rgb max_color lw 3.0

