/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Jay Taoko <jay.taoko@canonical.com>
 *
 */

#ifndef _CTK_PERSPECTIVE_CORRECT_RENDERING_H_
#define _CTK_PERSPECTIVE_CORRECT_RENDERING_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/ctk-utils.h>
#include <clutk/ctk-actor.h>
#include <clutk/ctk-render-target.h>
#include <clutk/ctk-effect-context.h>

G_BEGIN_DECLS



typedef struct _CtkProjectedTextureVertex CtkProjectedTextureVertex;

/**
 * CtkProjectedTextureVertex:
 * @x: projected x coord
 * @y: projected y coord
 * @z: projected z coord
 * @w: w coord from the perspective transformation
 * @s: texture coordinate
 * @t: texture coordinate
 * @r: texture coordinate
 * @q: texture coordinate
 * @color: Color at the vertex
 */
struct _CtkProjectedTextureVertex
{
  gfloat x, y, z, w;
  gfloat s, t, r, q;
  CoglColor color;
};


void ctk_render_projected_polygon      (CtkProjectedTextureVertex *V, guint tex_mask_id, gint window_w, gint window_h);
void ctk_render_projected_polygon_2Tex (CtkProjectedTextureVertex *V, guint tex_mask_id, guint tex_id, gint window_w, gint window_h);

void ctk_get_actor_screen_coord (CtkActor* actor, gfloat *x, gfloat *y, gfloat *width, gfloat *height);

guint ctk_create_opengl_texture_from_pixbuf (GdkPixbuf *pixbuf);
guint ctk_create_opengl_texture_from_file (const char* filename);

void ctk_delete_opengl_texture (guint opengl_texture_id);

G_END_DECLS

#endif /* _CTK_PERSPECTIVE_CORRECT_RENDERING_H_ */
