/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Gordon Allott <gord.allott@canonical.com>
 *
 */

#ifndef _CTK_CHECK_MENU_ITEM_H_
#define _CTK_CHECK_MENU_ITEM_H_

#include <glib.h>
#include <clutk/ctk-actor.h>
#include <clutk/ctk-menu-item.h>

G_BEGIN_DECLS

#define CTK_TYPE_CHECK_MENU_ITEM             (ctk_check_menu_item_get_type ())
#define CTK_CHECK_MENU_ITEM(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), CTK_TYPE_CHECK_MENU_ITEM, CtkCheckMenuItem))
#define CTK_CHECK_MENU_ITEM_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), CTK_TYPE_CHECK_MENU_ITEM, CtkCheckMenuItemClass))
#define CTK_IS_CHECK_MENU_ITEM(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CTK_TYPE_CHECK_MENU_ITEM))
#define CTK_IS_CHECK_MENU_ITEM_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), CTK_TYPE_CHECK_MENU_ITEM))
#define CTK_CHECK_MENU_ITEM_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), CTK_TYPE_CHECK_MENU_ITEM, CtkCheckMenuItemClass))

typedef struct _CtkCheckMenuItemClass CtkCheckMenuItemClass;
typedef struct _CtkCheckMenuItem CtkCheckMenuItem;
typedef struct _CtkCheckMenuItemPrivate CtkCheckMenuItemPrivate;

struct _CtkCheckMenuItemClass
{
  CtkMenuItemClass parent_class;

  /* Signals */
  void(* toggled) (CtkCheckMenuItem *self);
};

struct _CtkCheckMenuItem
{
  CtkMenuItem parent_instance;
  CtkCheckMenuItemPrivate *priv;
};

GType ctk_check_menu_item_get_type (void) G_GNUC_CONST;

CtkCheckMenuItem *ctk_check_menu_item_new             (void);
CtkCheckMenuItem *ctk_check_menu_item_new_with_label  (const gchar *label);

gboolean ctk_check_menu_item_get_inconsistent (CtkCheckMenuItem *menuitem);
void ctk_check_menu_item_set_inconsistent     (CtkCheckMenuItem *menuitem, gboolean setting);
gboolean ctk_check_menu_item_get_active       (CtkCheckMenuItem *menuitem);
void ctk_check_menu_item_set_active           (CtkCheckMenuItem *menuitem, gboolean is_active);

G_END_DECLS

#endif /* _CTK_CHECK_MENU_ITEM_H_ */
