/*
 * Copyright 2009 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of either or both of the following licenses:
 *
 * 1) the GNU Lesser General Public License version 3, as published by the
 * Free Software Foundation; and/or
 * 2) the GNU Lesser General Public License version 2.1, as published by
 * the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the applicable version of the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of both the GNU Lesser General Public
 * License version 3 and version 2.1 along with this program.  If not, see
 * <http://www.gnu.org/licenses/>
 *
 * Authored by: Jay Taoko <jay.taoko@canonical.com>
 *
 */

#ifndef _CTK_ASM_ARB_PRIVATE_H_
#define _CTK_ASM_ARB_PRIVATE_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <clutk/ctk-utils.h>
#include <clutk/ctk-gfx-private.h>
#include <clutk/ctk-actor.h>
#include <clutk/ctk-render-target.h>
#include <clutk/ctk-effect-context.h>

G_BEGIN_DECLS

#define ATTRIB_INVALID             -1
#define ATTRIB_POSITION             0
#define ATTRIB_WEIGHT               1
#define ATTRIB_NORMAL               2
#define ATTRIB_COLOR                3
#define ATTRIB_COLOR_PRIMARY        3
#define ATTRIB_COLOR_SECONDARY      4
#define ATTRIB_COLOR_FOGCOORD       5
#define ATTRIB_COLOR_TEXCOORD       8
#define ATTRIB_COLOR_TEXCOORD0      8
#define ATTRIB_COLOR_TEXCOORD1      9
#define ATTRIB_COLOR_TEXCOORD2      10
#define ATTRIB_COLOR_TEXCOORD3      11
#define ATTRIB_COLOR_TEXCOORD4      12
#define ATTRIB_COLOR_TEXCOORD5      13
#define ATTRIB_COLOR_TEXCOORD6      14
#define ATTRIB_COLOR_TEXCOORD7      15

typedef struct
{
	guint shvert;
	guint shfrag;
} ShaderProgramASM;

ShaderProgramASM* g_shTexture_asm;
ShaderProgramASM* g_shColor_asm;
ShaderProgramASM* g_shTextureAlpha_asm;
ShaderProgramASM* g_shBlur_asm;
ShaderProgramASM* g_shExp_asm;
ShaderProgramASM* g_shMultipassBlur_asm;
ShaderProgramASM* g_shTextureMask_asm;
ShaderProgramASM* g_shTextureColorMask_asm;
ShaderProgramASM* g_shTextureUVPerspDivision_asm;
ShaderProgramASM* g_shTextureUVPerspDivision_2Tex_asm;

/* ARB program */
ShaderProgramASM* ctk_create_shader_asm_program_from_source(const char* vtx_filename, const char* frag_filename);
void ctk_delete_shader_asm_program(ShaderProgramASM *sh);

void ctk_render_quad_rt_asm(CtkRenderTarget* rt, ShaderProgramASM *shader, int window_w, int window_h, int x, int y, int w, int h,
                            gfloat red, gfloat green, gfloat blue,
                            gfloat Opacity);

void ctk_render_quad_asm(guint texid, guint texwidth, guint texheight, ShaderProgramASM *shader,
                         int window_w, int window_h, int x, int y, int w, int h,
                         gfloat red, gfloat green, gfloat blue,
                         gfloat Opacity);

void ctk_render_custom_quad_asm(guint texid, guint texwidth, guint texheight, ShaderProgramASM *shader, int window_w, int window_h,
                                ClutterVertex vtx[4],
                                gfloat red, gfloat green, gfloat blue,
                                gfloat Opacity);

void ctk_render_custom_quad_asm_test(guint texid0, guint texid1, guint texid2, int window_w, int window_h, float x, float y, float width, float height);

void ctk_render_quad_alpha_mask_asm(
      unsigned int texid,
      unsigned int texture_width,
      unsigned int texture_height,
      gfloat red, gfloat green, gfloat blue, gfloat alpha,
      int window_w, int window_h, int x, int y, int w, int h);

void ctk_render_texture_exponent_asm (guint              tex_id,
                                  guint             texwidth,
                                  guint             texheight,
                                  gint              window_w,
                                  gint              window_h,
                                  gint              x,
                                  gint              y,
                                  gint              w,
                                  gint              h,
                                  gfloat            exponent);

void custom_render_quad_gaussian_blur_separable_asm(CtkRenderTarget* rt,
                                    gboolean horizontal, gfloat sigma,
                                    int window_w, int window_h, int x, int y, int w, int h);

void custom_render_quad_texture_mask_asm(unsigned int base_texid,
      unsigned int texid,
      unsigned int texture_width,
      unsigned int texture_height,
      ShaderProgramASM *shader,
      int window_w,
      int window_h,
      int x,
      int y,
      int w,
      int h,
      float opacity);

void ctk_copy_rendertarget_to_rendertarget_asm(CtkRenderTarget* rt_src,
      float u0,
      float v0,
      float u1,
      float v1,
      CtkRenderTarget* rt_dst,
      int x_dst,
      int y_dst,
      int w_dst,
      int h_dst);

void ctk_copy_render_target_to_cached_texture_asm(CtkEffectContext *fxctx, CtkRenderTarget* rt_src, guint texid);
/* End ARB Program*/

void opengl_blur_pass (guint pSrcTexture,   /* texture to read from      */
      guint     src_width,
      guint     src_height,
		  GLfloat	  fDeviation,	                /* std. deviatino to use     */
		  gboolean	HorizontalDirection,	      /* do which pass of the blur */
		  GLint		  iWindowWidth,	              /* width of window/context   */
		  GLint		  iWindowHeight,	            /* height of window/context  */
      gboolean  invertTexCoord);

void ctk_render_masked_texture_asm (guint             tex_id,
                                    guint             tex_mask_id,
                                    guint             texwidth,
                                    guint             texheight,
                                    ShaderProgramASM* shader,
                                    gint              window_w,
                                    gint              window_h,
                                    gint              x,
                                    gint              y,
                                    gint              w,
                                    gint              h,
                                    gfloat            opacity);

void ctk_render_masked2_texture_asm (guint             tex_id,
                                     guint             tex_mask_id,
                                     guint             texwidth,
                                     guint             texheight,
                                     ShaderProgramASM* shader,
                                     gint              window_w,
                                     gint              window_h,
                                     gint              x,
                                     gint              y,
                                     gint              w,
                                     gint              h,
                                     gfloat            opacity);

void ctk_render_masked3_texture_asm (guint             tex_id,
                                     guint             tex_mask_id,
                                     guint             texwidth,
                                     guint             texheight,
                                     gfloat*           tex_coord,           
                                     gfloat*           mask_coord,
                                     ShaderProgramASM* shader,
                                     gint              window_w,
                                     gint              window_h,
                                     gint              x,
                                     gint              y,
                                     gint              w,
                                     gint              h,
                                     gfloat            opacity);

void ctk_render_texture_part(guint texid, gint x, gint y, gint width, gint height, float u0, float v0, float u1, float v1, int window_w, int window_h);

void
ctk_render_texture_part_with_mask (guint          tex_id,
                                guint             tex_mask_id,
                                gint              x,
                                gint              y,
                                gint              w,
                                gint              h,
                                float u0, float v0, float u1, float v1,
                                float U0, float V0, float U1, float V1,
                                gint              window_w,
                                gint              window_h,
                                gfloat            opacity);

G_END_DECLS

#endif /* _CTK_ASM_ARB_PRIVATE_H_ */

