
#version 120
uniform sampler2D Tex0;
uniform vec2 TextureSize;
uniform float TapScale = 3.0;

uniform float weights[7] = {0.006,0.061,0.242,0.383,0.242,0.061,0.006};

void main()
{
    vec4 sum   = vec4(0.0, 0.0, 0.0, 0.0);
    vec2 delta = vec2(0.0, 1.0 / TextureSize.y);
    vec2 scale = vec2(1.0, TapScale);

    vec2 texCoord = vec2(gl_TexCoord[0].s, gl_TexCoord[0].t);
    texCoord += 0.5 / TextureSize;
    vec2 center = texCoord;
    texCoord -= 3.0 * delta;
   
    for(int i = 0; i < 7; ++i)
    {
        sum += texture2D(Tex0, (texCoord - center) * scale + center) * weights[i];
        texCoord += delta;
    }
    gl_FragColor = vec4(sum.x, sum.y, sum.z, sum.w);
}
