/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CTK_BUTTON_H_
#define _CTK_BUTTON_H_

#include <glib.h>
#include <clutter-gtk/clutter-gtk.h>
#include <clutk/ctk-bin.h>
#include <clutk/ctk-image.h>
#include <clutk/ctk-text.h>
#include <clutk/ctk-types.h>

G_BEGIN_DECLS

#define CTK_TYPE_BUTTON (ctk_button_get_type ())

#define CTK_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CTK_TYPE_BUTTON, CtkButton))

#define CTK_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CTK_TYPE_BUTTON, CtkButtonClass))

#define CTK_IS_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CTK_TYPE_BUTTON))

#define CTK_IS_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CTK_TYPE_BUTTON))

#define CTK_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CTK_TYPE_BUTTON, CtkButtonClass))

typedef struct _CtkButton        CtkButton;
typedef struct _CtkButtonClass   CtkButtonClass;
typedef struct _CtkButtonPrivate CtkButtonPrivate;
 
struct _CtkButton
{
  CtkBin       parent;	

  CtkButtonPrivate *priv;
};

struct _CtkButtonClass
{
  CtkBinClass   parent_class;

  /*< signals />*/
  void (*clicked)           (CtkButton *item);
  void (*show_context_menu) (CtkButton *item, guint32 event_time);
};

GType          ctk_button_get_type (void) G_GNUC_CONST;

ClutterActor * ctk_button_new             (CtkOrientation orientation);

void           ctk_button_set_label       (CtkButton      *button,
                                           const gchar    *label);

const gchar  * ctk_button_get_label       (CtkButton      *button);

void           ctk_button_set_image       (CtkButton      *button,
                                           CtkImage       *image);

CtkImage *     ctk_button_get_image       (CtkButton      *button);

void           ctk_button_set_text        (CtkButton      *button,
                                           CtkText        *text);

CtkText      * ctk_button_get_text        (CtkButton      *button);

void           ctk_button_set_orientation (CtkButton      *button,
                                           CtkOrientation  orient);

CtkOrientation ctk_button_get_orientation (CtkButton      *button);

G_END_DECLS

#endif /* _CTK_BUTTON_H_ */

