// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
#ifndef WEBKIT_GLUE_WEBTHREAD_IMPL_H_
#define WEBKIT_GLUE_WEBTHREAD_IMPL_H_

#include <map>

#include "base/threading/thread.h"
#include "base/memory/scoped_ptr.h"
#include "third_party/WebKit/Source/WebKit/chromium/public/platform/WebThread.h"
#include "webkit/glue/webkit_glue_export.h"

namespace webkit_glue {

class WebThreadBase : public WebKit::WebThread {
 public:
  virtual ~WebThreadBase();

  virtual void addTaskObserver(TaskObserver* observer);
  virtual void removeTaskObserver(TaskObserver* observer);

 protected:
  WebThreadBase();

 private:
  class TaskObserverAdapter;

  virtual bool IsCurrentThread() const = 0;

  typedef std::map<TaskObserver*, TaskObserverAdapter*> TaskObserverMap;
  TaskObserverMap task_observer_map_;
};

class WebThreadImpl : public WebThreadBase {
 public:
  WEBKIT_GLUE_EXPORT explicit WebThreadImpl(const char* name);
  WEBKIT_GLUE_EXPORT virtual ~WebThreadImpl();

  virtual void postTask(Task* task);
  virtual void postDelayedTask(Task* task, long long delay_ms);

  virtual void enterRunLoop();
  virtual void exitRunLoop();

  MessageLoop* message_loop() const { return thread_->message_loop(); }

 private:
  virtual bool IsCurrentThread() const OVERRIDE;
  scoped_ptr<base::Thread> thread_;
};

class WebThreadImplForMessageLoop : public WebThreadBase {
 public:
  WEBKIT_GLUE_EXPORT explicit WebThreadImplForMessageLoop(
      base::MessageLoopProxy* message_loop);
  WEBKIT_GLUE_EXPORT virtual ~WebThreadImplForMessageLoop();

  virtual void postTask(Task* task);
  virtual void postDelayedTask(Task* task, long long delay_ms);

  virtual void enterRunLoop();
  virtual void exitRunLoop();

 private:
  virtual bool IsCurrentThread() const OVERRIDE;
  scoped_refptr<base::MessageLoopProxy> message_loop_;
};

} // namespace webkit_glue

#endif
