// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated by transport_security_state_static_generate.go

#ifndef NET_BASE_TRANSPORT_SECURITY_STATE_STATIC_H_
#define NET_BASE_TRANSPORT_SECURITY_STATE_STATIC_H_

// These are SubjectPublicKeyInfo hashes for public key pinning. The
// hashes are base64 encoded, SHA1 digests.

static const char kSPKIHash_TestSPKI[] =
    "sha1/AAAAAAAAAAAAAAAAAAAAAAAAAAA=";

static const char kSPKIHash_VeriSignClass3[] =
    "sha1/4n972HfV354KP560yw4uqe/baXc=";

static const char kSPKIHash_VeriSignClass3_G3[] =
    "sha1/IvGeLsbqzPxdI0b0wuj2xVTdXgc=";

static const char kSPKIHash_Google1024[] =
    "sha1/QMVAHW+MuvCLAO3vse6H0AWzuc0=";

static const char kSPKIHash_Google2048[] =
    "sha1/AbkhxY0L343gKf+cki7NVWp+ozk=";

static const char kSPKIHash_EquifaxSecureCA[] =
    "sha1/SOZo+SvSspXXR9gjIBBPM5iQn9Q=";

static const char kSPKIHash_Aetna[] =
    "sha1/klKqFN6/gK4wqtlOYDhwJKVDLxo=";

static const char kSPKIHash_GeoTrustGlobal[] =
    "sha1/wHqYaI2J+6sFZAwRfap9ZbjKzE4=";

static const char kSPKIHash_GeoTrustPrimary[] =
    "sha1/sBmJ5+/7Sq/LFI9YRjl2IkFQ4bo=";

static const char kSPKIHash_Intel[] =
    "sha1/DsYq91myCBCQJW/D3f2KZjEwK8U=";

static const char kSPKIHash_TCTrustCenter[] =
    "sha1/gzuEEAB/bkqdQS3EIjk2by7lW+k=";

static const char kSPKIHash_Vodafone[] =
    "sha1/DX/hXFUUNmiZ/EDWIgjvIuvRFRw=";

static const char kSPKIHash_RapidSSL[] =
    "sha1/o5OZxATDsgmwgcIfIWIneMJ0jkw=";

static const char kSPKIHash_DigiCertEVRoot[] =
    "sha1/gzF+YoVCU9bXeDGQ7JGQVumRueM=";

static const char kSPKIHash_Tor1[] =
    "sha1/juNxSTv9UANmpC9kF5GKpmWNx3Y=";

static const char kSPKIHash_Tor2[] =
    "sha1/lia43lPolzSPVIq34Dw57uYcLD8=";

static const char kSPKIHash_Tor3[] =
    "sha1/rzEyQIKOh77j87n5bjWUNguXF8Y=";

static const char kSPKIHash_VeriSignClass1[] =
    "sha1/I0PRSKJViZuUfUYaeX7ATP7RcLc=";

static const char kSPKIHash_VeriSignClass3_G4[] =
    "sha1/7WYxNdMb1OymFMQp4xkGn5TBJlA=";

static const char kSPKIHash_VeriSignClass4_G3[] =
    "sha1/PANDaGiVHPNpKri0Jtq6j+ki5b0=";

static const char kSPKIHash_VeriSignClass1_G3[] =
    "sha1/VRmyeKyygdftp6vBg5nDu2kEJLU=";

static const char kSPKIHash_VeriSignClass2_G3[] =
    "sha1/Wr7Fddyu87COJxlD/H8lDD32YeM=";

static const char kSPKIHash_VeriSignClass3_G2[] =
    "sha1/GiG0lStik84Ys2XsnA6TTLOB5tQ=";

static const char kSPKIHash_VeriSignClass2_G2[] =
    "sha1/Eje6RRfurSkm/cHN/r7t8t7ZFFw=";

static const char kSPKIHash_VeriSignClass3_G5[] =
    "sha1/sYEIGhmkwJQf+uiVKMEkyZs0rMc=";

static const char kSPKIHash_VeriSignUniversal[] =
    "sha1/u8I+KQuzKHcdrT6iTb30I70GsD0=";

static const char kSPKIHash_Twitter1[] =
    "sha1/Vv7zwhR9TtOIN/29MFI4cgHld40=";

static const char kSPKIHash_GeoTrustGlobal2[] =
    "sha1/cTg28gIxU0crbrplRqkQFVggBQk=";

static const char kSPKIHash_GeoTrustUniversal[] =
    "sha1/h+hbY1PGI6MSjLD/u/VR/lmADiI=";

static const char kSPKIHash_GeoTrustUniversal2[] =
    "sha1/Xk9ThoXdT57KX9wNRW99UbHcm3s=";

static const char kSPKIHash_GeoTrustPrimary_G2[] =
    "sha1/vb6nG6txV/nkddlU0rcngBqCJoI=";

static const char kSPKIHash_GeoTrustPrimary_G3[] =
    "sha1/nKmNAK90Dd2BgNITRaWLjy6UONY=";

static const char kSPKIHash_Entrust_2048[] =
    "sha1/VeSB0RGAvtiJuQijMfmhJAkWuXA=";

static const char kSPKIHash_Entrust_EV[] =
    "sha1/ukKwgYhTiB2GY71MwF4I/upuu3c=";

static const char kSPKIHash_Entrust_G2[] =
    "sha1/qzDTr0vY8WtYae5FaSnahLhzlIg=";

static const char kSPKIHash_Entrust_SSL[] =
    "sha1/8BdiE1U9s/8KAGv7UISX8+1i0Bo=";

static const char kSPKIHash_AAACertificateServices[] =
    "sha1/xDAoxdPjCAwQRIssd7okU5dgu/k=";

static const char kSPKIHash_AddTrustClass1CARoot[] =
    "sha1/i9vXzKBoU0IW9MErJUT8Apyli0c=";

static const char kSPKIHash_AddTrustExternalCARoot[] =
    "sha1/T5x9IXmcrQ7YuQxXnxoCmeeQ84c=";

static const char kSPKIHash_AddTrustPublicCARoot[] =
    "sha1/qFdl1ugyyMUZY3Namhd0OoHf7i4=";

static const char kSPKIHash_AddTrustQualifiedCARoot[] =
    "sha1/vOS3IxJVmOVjQRkcUOS2R8J2Bdc=";

static const char kSPKIHash_COMODOCertificationAuthority[] =
    "sha1/EeSR0cnkwOuazs9zVF3h8agwPsM=";

static const char kSPKIHash_SecureCertificateServices[] =
    "sha1/PLQahC71XPIaPaVKyNG+OQh2N7w=";

static const char kSPKIHash_TrustedCertificateServices[] =
    "sha1//nLI678ML7sOJhOTkzwsqY3cJJQ=";

static const char kSPKIHash_UTNDATACorpSGC[] =
    "sha1/UzLRs89/+uDxoF2FTpLSnkUdtE8=";

static const char kSPKIHash_UTNUSERFirstClientAuthenticationandEmail[] =
    "sha1/iYJnfcSdJnAAS7RQSHzePa4Ebn0=";

static const char kSPKIHash_UTNUSERFirstHardware[] =
    "sha1/oXJfJhsomEOVXQc31YWWnUvSw0U=";

static const char kSPKIHash_UTNUSERFirstObject[] =
    "sha1/2u1kdBScFDyr3ZmpvVsoTYs8ydg=";

static const char kSPKIHash_GTECyberTrustGlobalRoot[] =
    "sha1/WXkS3mF11m/EI7d3E3THlt5viHI=";

static const char kSPKIHash_Tor2web[] =
    "sha1/GeW1hxvUgy7I9ZSX/sZe+0jjM7E=";

static const char kSPKIHash_AlphaSSL_G2[] =
    "sha1/5STpjjF9yPytkFN8kecNpHCTkF8=";

static const char kSPKIHash_CryptoCat1[] =
    "sha1/TIfOhSz0wE1nqeDsUQx/OxSz6ck=";

// The following is static data describing the hosts that are hardcoded with
// certificate pins or HSTS information.

// kNoRejectedPublicKeys is a placeholder for when no public keys are rejected.
static const char* const kNoRejectedPublicKeys[] = {
  NULL,
};

static const char* const kTestAcceptableCerts[] = {
  kSPKIHash_TestSPKI,
  NULL,
};
#define kTestPins { \
  kTestAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kGoogleAcceptableCerts[] = {
  kSPKIHash_VeriSignClass3,
  kSPKIHash_VeriSignClass3_G3,
  kSPKIHash_Google1024,
  kSPKIHash_Google2048,
  kSPKIHash_EquifaxSecureCA,
  kSPKIHash_GeoTrustGlobal,
  NULL,
};
static const char* const kGoogleRejectedCerts[] = {
  kSPKIHash_Aetna,
  kSPKIHash_Intel,
  kSPKIHash_TCTrustCenter,
  kSPKIHash_Vodafone,
  NULL,
};
#define kGooglePins { \
  kGoogleAcceptableCerts, \
  kGoogleRejectedCerts, \
}

static const char* const kTorAcceptableCerts[] = {
  kSPKIHash_RapidSSL,
  kSPKIHash_DigiCertEVRoot,
  kSPKIHash_Tor1,
  kSPKIHash_Tor2,
  kSPKIHash_Tor3,
  NULL,
};
#define kTorPins { \
  kTorAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kTwitterComAcceptableCerts[] = {
  kSPKIHash_VeriSignClass1,
  kSPKIHash_VeriSignClass3,
  kSPKIHash_VeriSignClass3_G4,
  kSPKIHash_VeriSignClass4_G3,
  kSPKIHash_VeriSignClass3_G3,
  kSPKIHash_VeriSignClass1_G3,
  kSPKIHash_VeriSignClass2_G3,
  kSPKIHash_VeriSignClass3_G2,
  kSPKIHash_VeriSignClass2_G2,
  kSPKIHash_VeriSignClass3_G5,
  kSPKIHash_VeriSignUniversal,
  kSPKIHash_GeoTrustGlobal,
  kSPKIHash_GeoTrustGlobal2,
  kSPKIHash_GeoTrustUniversal,
  kSPKIHash_GeoTrustUniversal2,
  kSPKIHash_GeoTrustPrimary,
  kSPKIHash_GeoTrustPrimary_G2,
  kSPKIHash_GeoTrustPrimary_G3,
  kSPKIHash_Twitter1,
  NULL,
};
#define kTwitterComPins { \
  kTwitterComAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kTwitterCDNAcceptableCerts[] = {
  kSPKIHash_VeriSignClass1,
  kSPKIHash_VeriSignClass3,
  kSPKIHash_VeriSignClass3_G4,
  kSPKIHash_VeriSignClass4_G3,
  kSPKIHash_VeriSignClass3_G3,
  kSPKIHash_VeriSignClass1_G3,
  kSPKIHash_VeriSignClass2_G3,
  kSPKIHash_VeriSignClass3_G2,
  kSPKIHash_VeriSignClass2_G2,
  kSPKIHash_VeriSignClass3_G5,
  kSPKIHash_VeriSignUniversal,
  kSPKIHash_GeoTrustGlobal,
  kSPKIHash_GeoTrustGlobal2,
  kSPKIHash_GeoTrustUniversal,
  kSPKIHash_GeoTrustUniversal2,
  kSPKIHash_GeoTrustPrimary,
  kSPKIHash_GeoTrustPrimary_G2,
  kSPKIHash_GeoTrustPrimary_G3,
  kSPKIHash_Twitter1,
  kSPKIHash_Entrust_2048,
  kSPKIHash_Entrust_EV,
  kSPKIHash_Entrust_G2,
  kSPKIHash_Entrust_SSL,
  kSPKIHash_AAACertificateServices,
  kSPKIHash_AddTrustClass1CARoot,
  kSPKIHash_AddTrustExternalCARoot,
  kSPKIHash_AddTrustPublicCARoot,
  kSPKIHash_AddTrustQualifiedCARoot,
  kSPKIHash_COMODOCertificationAuthority,
  kSPKIHash_SecureCertificateServices,
  kSPKIHash_TrustedCertificateServices,
  kSPKIHash_UTNDATACorpSGC,
  kSPKIHash_UTNUSERFirstClientAuthenticationandEmail,
  kSPKIHash_UTNUSERFirstHardware,
  kSPKIHash_UTNUSERFirstObject,
  kSPKIHash_GTECyberTrustGlobalRoot,
  NULL,
};
#define kTwitterCDNPins { \
  kTwitterCDNAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kTor2webAcceptableCerts[] = {
  kSPKIHash_AlphaSSL_G2,
  kSPKIHash_Tor2web,
  NULL,
};
#define kTor2webPins { \
  kTor2webAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

static const char* const kCryptoCatAcceptableCerts[] = {
  kSPKIHash_DigiCertEVRoot,
  kSPKIHash_CryptoCat1,
  NULL,
};
#define kCryptoCatPins { \
  kCryptoCatAcceptableCerts, \
  kNoRejectedPublicKeys, \
}

#define kNoPins {\
  NULL, NULL, \
}

static const struct HSTSPreload kPreloadedSTS[] = {
  {25, true, "\013pinningtest\007appspot\003com", false, kTestPins, DOMAIN_APPSPOT_COM },
  {12, true, "\006google\003com", false, kGooglePins, DOMAIN_GOOGLE_COM },
  {19, true, "\006health\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {21, true, "\010checkout\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {19, true, "\006chrome\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004docs\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {18, true, "\005sites\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {25, true, "\014spreadsheets\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {22, false, "\011appengine\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {22, true, "\011encrypted\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {21, true, "\010accounts\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {21, true, "\010profiles\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004mail\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {23, true, "\012talkgadget\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004talk\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {29, true, "\020hostedtalkgadget\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004plus\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {19, true, "\006script\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {20, true, "\007history\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {20, true, "\006market\007android\003com", true, kGooglePins, DOMAIN_ANDROID_COM },
  {26, true, "\003ssl\020google-analytics\003com", true, kGooglePins, DOMAIN_GOOGLE_ANALYTICS_COM },
  {18, true, "\005drive\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {16, true, "\012googleplex\003com", true, kGooglePins, DOMAIN_GOOGLEPLEX_COM },
  {19, true, "\006groups\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {17, true, "\004apis\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {32, true, "\022chromiumcodereview\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {24, true, "\012codereview\007appspot\003com", true, kGooglePins, DOMAIN_APPSPOT_COM },
  {25, true, "\012codereview\010chromium\003org", true, kGooglePins, DOMAIN_CHROMIUM_ORG },
  {17, false, "\004code\006google\003com", true, kGooglePins, DOMAIN_GOOGLE_COM },
  {16, true, "\012googlecode\003com", false, kGooglePins, DOMAIN_GOOGLECODE_COM },
  {23, true, "\005chart\004apis\006google\003com", false, kGooglePins, DOMAIN_GOOGLE_COM },
  {11, true, "\005ytimg\003com", false, kGooglePins, DOMAIN_YTIMG_COM },
  {23, true, "\021googleusercontent\003com", false, kGooglePins, DOMAIN_GOOGLEUSERCONTENT_COM },
  {13, true, "\007youtube\003com", false, kGooglePins, DOMAIN_YOUTUBE_COM },
  {16, true, "\012googleapis\003com", false, kGooglePins, DOMAIN_GOOGLEAPIS_COM },
  {22, true, "\020googleadservices\003com", false, kGooglePins, DOMAIN_GOOGLEADSERVICES_COM },
  {13, true, "\007appspot\003com", false, kGooglePins, DOMAIN_APPSPOT_COM },
  {23, true, "\021googlesyndication\003com", false, kGooglePins, DOMAIN_GOOGLESYNDICATION_COM },
  {17, true, "\013doubleclick\003net", false, kGooglePins, DOMAIN_DOUBLECLICK_NET },
  {17, true, "\003ssl\007gstatic\003com", false, kGooglePins, DOMAIN_GSTATIC_COM },
  {10, true, "\005youtu\002be", false, kGooglePins, DOMAIN_YOUTU_BE },
  {13, true, "\007android\003com", false, kGooglePins, DOMAIN_ANDROID_COM },
  {20, true, "\016googlecommerce\003com", false, kGooglePins, DOMAIN_GOOGLECOMMERCE_COM },
  {12, true, "\006urchin\003com", false, kGooglePins, DOMAIN_URCHIN_COM },
  {8, true, "\003goo\002gl", false, kGooglePins, DOMAIN_GOO_GL },
  {6, true, "\001g\002co", false, kGooglePins, DOMAIN_G_CO },
  {11, true, "\006google\002ac", false, kGooglePins, DOMAIN_GOOGLE_AC },
  {11, true, "\006google\002ad", false, kGooglePins, DOMAIN_GOOGLE_AD },
  {11, true, "\006google\002ae", false, kGooglePins, DOMAIN_GOOGLE_AE },
  {11, true, "\006google\002af", false, kGooglePins, DOMAIN_GOOGLE_AF },
  {11, true, "\006google\002ag", false, kGooglePins, DOMAIN_GOOGLE_AG },
  {11, true, "\006google\002am", false, kGooglePins, DOMAIN_GOOGLE_AM },
  {11, true, "\006google\002as", false, kGooglePins, DOMAIN_GOOGLE_AS },
  {11, true, "\006google\002at", false, kGooglePins, DOMAIN_GOOGLE_AT },
  {11, true, "\006google\002az", false, kGooglePins, DOMAIN_GOOGLE_AZ },
  {11, true, "\006google\002ba", false, kGooglePins, DOMAIN_GOOGLE_BA },
  {11, true, "\006google\002be", false, kGooglePins, DOMAIN_GOOGLE_BE },
  {11, true, "\006google\002bf", false, kGooglePins, DOMAIN_GOOGLE_BF },
  {11, true, "\006google\002bg", false, kGooglePins, DOMAIN_GOOGLE_BG },
  {11, true, "\006google\002bi", false, kGooglePins, DOMAIN_GOOGLE_BI },
  {11, true, "\006google\002bj", false, kGooglePins, DOMAIN_GOOGLE_BJ },
  {11, true, "\006google\002bs", false, kGooglePins, DOMAIN_GOOGLE_BS },
  {11, true, "\006google\002by", false, kGooglePins, DOMAIN_GOOGLE_BY },
  {11, true, "\006google\002ca", false, kGooglePins, DOMAIN_GOOGLE_CA },
  {12, true, "\006google\003cat", false, kGooglePins, DOMAIN_GOOGLE_CAT },
  {11, true, "\006google\002cc", false, kGooglePins, DOMAIN_GOOGLE_CC },
  {11, true, "\006google\002cd", false, kGooglePins, DOMAIN_GOOGLE_CD },
  {11, true, "\006google\002cf", false, kGooglePins, DOMAIN_GOOGLE_CF },
  {11, true, "\006google\002cg", false, kGooglePins, DOMAIN_GOOGLE_CG },
  {11, true, "\006google\002ch", false, kGooglePins, DOMAIN_GOOGLE_CH },
  {11, true, "\006google\002ci", false, kGooglePins, DOMAIN_GOOGLE_CI },
  {11, true, "\006google\002cl", false, kGooglePins, DOMAIN_GOOGLE_CL },
  {11, true, "\006google\002cm", false, kGooglePins, DOMAIN_GOOGLE_CM },
  {11, true, "\006google\002cn", false, kGooglePins, DOMAIN_GOOGLE_CN },
  {14, true, "\006google\002co\002ao", false, kGooglePins, DOMAIN_CO_AO },
  {14, true, "\006google\002co\002bw", false, kGooglePins, DOMAIN_CO_BW },
  {14, true, "\006google\002co\002ck", false, kGooglePins, DOMAIN_CO_CK },
  {14, true, "\006google\002co\002cr", false, kGooglePins, DOMAIN_CO_CR },
  {14, true, "\006google\002co\002hu", false, kGooglePins, DOMAIN_CO_HU },
  {14, true, "\006google\002co\002id", false, kGooglePins, DOMAIN_CO_ID },
  {14, true, "\006google\002co\002il", false, kGooglePins, DOMAIN_CO_IL },
  {14, true, "\006google\002co\002im", false, kGooglePins, DOMAIN_CO_IM },
  {14, true, "\006google\002co\002in", false, kGooglePins, DOMAIN_CO_IN },
  {14, true, "\006google\002co\002je", false, kGooglePins, DOMAIN_CO_JE },
  {14, true, "\006google\002co\002jp", false, kGooglePins, DOMAIN_CO_JP },
  {14, true, "\006google\002co\002ke", false, kGooglePins, DOMAIN_CO_KE },
  {14, true, "\006google\002co\002kr", false, kGooglePins, DOMAIN_CO_KR },
  {14, true, "\006google\002co\002ls", false, kGooglePins, DOMAIN_CO_LS },
  {14, true, "\006google\002co\002ma", false, kGooglePins, DOMAIN_CO_MA },
  {14, true, "\006google\002co\002mz", false, kGooglePins, DOMAIN_CO_MZ },
  {14, true, "\006google\002co\002nz", false, kGooglePins, DOMAIN_CO_NZ },
  {14, true, "\006google\002co\002th", false, kGooglePins, DOMAIN_CO_TH },
  {14, true, "\006google\002co\002tz", false, kGooglePins, DOMAIN_CO_TZ },
  {14, true, "\006google\002co\002ug", false, kGooglePins, DOMAIN_CO_UG },
  {14, true, "\006google\002co\002uk", false, kGooglePins, DOMAIN_CO_UK },
  {14, true, "\006google\002co\002uz", false, kGooglePins, DOMAIN_CO_UZ },
  {14, true, "\006google\002co\002ve", false, kGooglePins, DOMAIN_CO_VE },
  {14, true, "\006google\002co\002vi", false, kGooglePins, DOMAIN_CO_VI },
  {14, true, "\006google\002co\002za", false, kGooglePins, DOMAIN_CO_ZA },
  {14, true, "\006google\002co\002zm", false, kGooglePins, DOMAIN_CO_ZM },
  {14, true, "\006google\002co\002zw", false, kGooglePins, DOMAIN_CO_ZW },
  {15, true, "\006google\003com\002af", false, kGooglePins, DOMAIN_COM_AF },
  {15, true, "\006google\003com\002ag", false, kGooglePins, DOMAIN_COM_AG },
  {15, true, "\006google\003com\002ai", false, kGooglePins, DOMAIN_COM_AI },
  {15, true, "\006google\003com\002ar", false, kGooglePins, DOMAIN_COM_AR },
  {15, true, "\006google\003com\002au", false, kGooglePins, DOMAIN_COM_AU },
  {15, true, "\006google\003com\002bd", false, kGooglePins, DOMAIN_COM_BD },
  {15, true, "\006google\003com\002bh", false, kGooglePins, DOMAIN_COM_BH },
  {15, true, "\006google\003com\002bn", false, kGooglePins, DOMAIN_COM_BN },
  {15, true, "\006google\003com\002bo", false, kGooglePins, DOMAIN_COM_BO },
  {15, true, "\006google\003com\002br", false, kGooglePins, DOMAIN_COM_BR },
  {15, true, "\006google\003com\002by", false, kGooglePins, DOMAIN_COM_BY },
  {15, true, "\006google\003com\002bz", false, kGooglePins, DOMAIN_COM_BZ },
  {15, true, "\006google\003com\002cn", false, kGooglePins, DOMAIN_COM_CN },
  {15, true, "\006google\003com\002co", false, kGooglePins, DOMAIN_COM_CO },
  {15, true, "\006google\003com\002cu", false, kGooglePins, DOMAIN_COM_CU },
  {15, true, "\006google\003com\002cy", false, kGooglePins, DOMAIN_COM_CY },
  {15, true, "\006google\003com\002do", false, kGooglePins, DOMAIN_COM_DO },
  {15, true, "\006google\003com\002ec", false, kGooglePins, DOMAIN_COM_EC },
  {15, true, "\006google\003com\002eg", false, kGooglePins, DOMAIN_COM_EG },
  {15, true, "\006google\003com\002et", false, kGooglePins, DOMAIN_COM_ET },
  {15, true, "\006google\003com\002fj", false, kGooglePins, DOMAIN_COM_FJ },
  {15, true, "\006google\003com\002ge", false, kGooglePins, DOMAIN_COM_GE },
  {15, true, "\006google\003com\002gh", false, kGooglePins, DOMAIN_COM_GH },
  {15, true, "\006google\003com\002gi", false, kGooglePins, DOMAIN_COM_GI },
  {15, true, "\006google\003com\002gr", false, kGooglePins, DOMAIN_COM_GR },
  {15, true, "\006google\003com\002gt", false, kGooglePins, DOMAIN_COM_GT },
  {15, true, "\006google\003com\002hk", false, kGooglePins, DOMAIN_COM_HK },
  {15, true, "\006google\003com\002iq", false, kGooglePins, DOMAIN_COM_IQ },
  {15, true, "\006google\003com\002jm", false, kGooglePins, DOMAIN_COM_JM },
  {15, true, "\006google\003com\002jo", false, kGooglePins, DOMAIN_COM_JO },
  {15, true, "\006google\003com\002kh", false, kGooglePins, DOMAIN_COM_KH },
  {15, true, "\006google\003com\002kw", false, kGooglePins, DOMAIN_COM_KW },
  {15, true, "\006google\003com\002lb", false, kGooglePins, DOMAIN_COM_LB },
  {15, true, "\006google\003com\002ly", false, kGooglePins, DOMAIN_COM_LY },
  {15, true, "\006google\003com\002mt", false, kGooglePins, DOMAIN_COM_MT },
  {15, true, "\006google\003com\002mx", false, kGooglePins, DOMAIN_COM_MX },
  {15, true, "\006google\003com\002my", false, kGooglePins, DOMAIN_COM_MY },
  {15, true, "\006google\003com\002na", false, kGooglePins, DOMAIN_COM_NA },
  {15, true, "\006google\003com\002nf", false, kGooglePins, DOMAIN_COM_NF },
  {15, true, "\006google\003com\002ng", false, kGooglePins, DOMAIN_COM_NG },
  {15, true, "\006google\003com\002ni", false, kGooglePins, DOMAIN_COM_NI },
  {15, true, "\006google\003com\002np", false, kGooglePins, DOMAIN_COM_NP },
  {15, true, "\006google\003com\002nr", false, kGooglePins, DOMAIN_COM_NR },
  {15, true, "\006google\003com\002om", false, kGooglePins, DOMAIN_COM_OM },
  {15, true, "\006google\003com\002pa", false, kGooglePins, DOMAIN_COM_PA },
  {15, true, "\006google\003com\002pe", false, kGooglePins, DOMAIN_COM_PE },
  {15, true, "\006google\003com\002ph", false, kGooglePins, DOMAIN_COM_PH },
  {15, true, "\006google\003com\002pk", false, kGooglePins, DOMAIN_COM_PK },
  {15, true, "\006google\003com\002pl", false, kGooglePins, DOMAIN_COM_PL },
  {15, true, "\006google\003com\002pr", false, kGooglePins, DOMAIN_COM_PR },
  {15, true, "\006google\003com\002py", false, kGooglePins, DOMAIN_COM_PY },
  {15, true, "\006google\003com\002qa", false, kGooglePins, DOMAIN_COM_QA },
  {15, true, "\006google\003com\002ru", false, kGooglePins, DOMAIN_COM_RU },
  {15, true, "\006google\003com\002sa", false, kGooglePins, DOMAIN_COM_SA },
  {15, true, "\006google\003com\002sb", false, kGooglePins, DOMAIN_COM_SB },
  {15, true, "\006google\003com\002sg", false, kGooglePins, DOMAIN_COM_SG },
  {15, true, "\006google\003com\002sl", false, kGooglePins, DOMAIN_COM_SL },
  {15, true, "\006google\003com\002sv", false, kGooglePins, DOMAIN_COM_SV },
  {15, true, "\006google\003com\002tj", false, kGooglePins, DOMAIN_COM_TJ },
  {15, true, "\006google\003com\002tn", false, kGooglePins, DOMAIN_COM_TN },
  {15, true, "\006google\003com\002tr", false, kGooglePins, DOMAIN_COM_TR },
  {15, true, "\006google\003com\002tw", false, kGooglePins, DOMAIN_COM_TW },
  {15, true, "\006google\003com\002ua", false, kGooglePins, DOMAIN_COM_UA },
  {15, true, "\006google\003com\002uy", false, kGooglePins, DOMAIN_COM_UY },
  {15, true, "\006google\003com\002vc", false, kGooglePins, DOMAIN_COM_VC },
  {15, true, "\006google\003com\002ve", false, kGooglePins, DOMAIN_COM_VE },
  {15, true, "\006google\003com\002vn", false, kGooglePins, DOMAIN_COM_VN },
  {11, true, "\006google\002cv", false, kGooglePins, DOMAIN_GOOGLE_CV },
  {11, true, "\006google\002cz", false, kGooglePins, DOMAIN_GOOGLE_CZ },
  {11, true, "\006google\002de", false, kGooglePins, DOMAIN_GOOGLE_DE },
  {11, true, "\006google\002dj", false, kGooglePins, DOMAIN_GOOGLE_DJ },
  {11, true, "\006google\002dk", false, kGooglePins, DOMAIN_GOOGLE_DK },
  {11, true, "\006google\002dm", false, kGooglePins, DOMAIN_GOOGLE_DM },
  {11, true, "\006google\002dz", false, kGooglePins, DOMAIN_GOOGLE_DZ },
  {11, true, "\006google\002ee", false, kGooglePins, DOMAIN_GOOGLE_EE },
  {11, true, "\006google\002es", false, kGooglePins, DOMAIN_GOOGLE_ES },
  {11, true, "\006google\002fi", false, kGooglePins, DOMAIN_GOOGLE_FI },
  {11, true, "\006google\002fm", false, kGooglePins, DOMAIN_GOOGLE_FM },
  {11, true, "\006google\002fr", false, kGooglePins, DOMAIN_GOOGLE_FR },
  {11, true, "\006google\002ga", false, kGooglePins, DOMAIN_GOOGLE_GA },
  {11, true, "\006google\002ge", false, kGooglePins, DOMAIN_GOOGLE_GE },
  {11, true, "\006google\002gg", false, kGooglePins, DOMAIN_GOOGLE_GG },
  {11, true, "\006google\002gl", false, kGooglePins, DOMAIN_GOOGLE_GL },
  {11, true, "\006google\002gm", false, kGooglePins, DOMAIN_GOOGLE_GM },
  {11, true, "\006google\002gp", false, kGooglePins, DOMAIN_GOOGLE_GP },
  {11, true, "\006google\002gr", false, kGooglePins, DOMAIN_GOOGLE_GR },
  {11, true, "\006google\002gy", false, kGooglePins, DOMAIN_GOOGLE_GY },
  {11, true, "\006google\002hk", false, kGooglePins, DOMAIN_GOOGLE_HK },
  {11, true, "\006google\002hn", false, kGooglePins, DOMAIN_GOOGLE_HN },
  {11, true, "\006google\002hr", false, kGooglePins, DOMAIN_GOOGLE_HR },
  {11, true, "\006google\002ht", false, kGooglePins, DOMAIN_GOOGLE_HT },
  {11, true, "\006google\002hu", false, kGooglePins, DOMAIN_GOOGLE_HU },
  {11, true, "\006google\002ie", false, kGooglePins, DOMAIN_GOOGLE_IE },
  {11, true, "\006google\002im", false, kGooglePins, DOMAIN_GOOGLE_IM },
  {13, true, "\006google\004info", false, kGooglePins, DOMAIN_GOOGLE_INFO },
  {11, true, "\006google\002iq", false, kGooglePins, DOMAIN_GOOGLE_IQ },
  {11, true, "\006google\002is", false, kGooglePins, DOMAIN_GOOGLE_IS },
  {11, true, "\006google\002it", false, kGooglePins, DOMAIN_GOOGLE_IT },
  {14, true, "\006google\002it\002ao", false, kGooglePins, DOMAIN_IT_AO },
  {11, true, "\006google\002je", false, kGooglePins, DOMAIN_GOOGLE_JE },
  {11, true, "\006google\002jo", false, kGooglePins, DOMAIN_GOOGLE_JO },
  {13, true, "\006google\004jobs", false, kGooglePins, DOMAIN_GOOGLE_JOBS },
  {11, true, "\006google\002jp", false, kGooglePins, DOMAIN_GOOGLE_JP },
  {11, true, "\006google\002kg", false, kGooglePins, DOMAIN_GOOGLE_KG },
  {11, true, "\006google\002ki", false, kGooglePins, DOMAIN_GOOGLE_KI },
  {11, true, "\006google\002kz", false, kGooglePins, DOMAIN_GOOGLE_KZ },
  {11, true, "\006google\002la", false, kGooglePins, DOMAIN_GOOGLE_LA },
  {11, true, "\006google\002li", false, kGooglePins, DOMAIN_GOOGLE_LI },
  {11, true, "\006google\002lk", false, kGooglePins, DOMAIN_GOOGLE_LK },
  {11, true, "\006google\002lt", false, kGooglePins, DOMAIN_GOOGLE_LT },
  {11, true, "\006google\002lu", false, kGooglePins, DOMAIN_GOOGLE_LU },
  {11, true, "\006google\002lv", false, kGooglePins, DOMAIN_GOOGLE_LV },
  {11, true, "\006google\002md", false, kGooglePins, DOMAIN_GOOGLE_MD },
  {11, true, "\006google\002me", false, kGooglePins, DOMAIN_GOOGLE_ME },
  {11, true, "\006google\002mg", false, kGooglePins, DOMAIN_GOOGLE_MG },
  {11, true, "\006google\002mk", false, kGooglePins, DOMAIN_GOOGLE_MK },
  {11, true, "\006google\002ml", false, kGooglePins, DOMAIN_GOOGLE_ML },
  {11, true, "\006google\002mn", false, kGooglePins, DOMAIN_GOOGLE_MN },
  {11, true, "\006google\002ms", false, kGooglePins, DOMAIN_GOOGLE_MS },
  {11, true, "\006google\002mu", false, kGooglePins, DOMAIN_GOOGLE_MU },
  {11, true, "\006google\002mv", false, kGooglePins, DOMAIN_GOOGLE_MV },
  {11, true, "\006google\002mw", false, kGooglePins, DOMAIN_GOOGLE_MW },
  {11, true, "\006google\002ne", false, kGooglePins, DOMAIN_GOOGLE_NE },
  {14, true, "\006google\002ne\002jp", false, kGooglePins, DOMAIN_NE_JP },
  {12, true, "\006google\003net", false, kGooglePins, DOMAIN_GOOGLE_NET },
  {11, true, "\006google\002nl", false, kGooglePins, DOMAIN_GOOGLE_NL },
  {11, true, "\006google\002no", false, kGooglePins, DOMAIN_GOOGLE_NO },
  {11, true, "\006google\002nr", false, kGooglePins, DOMAIN_GOOGLE_NR },
  {11, true, "\006google\002nu", false, kGooglePins, DOMAIN_GOOGLE_NU },
  {15, true, "\006google\003off\002ai", false, kGooglePins, DOMAIN_OFF_AI },
  {11, true, "\006google\002pk", false, kGooglePins, DOMAIN_GOOGLE_PK },
  {11, true, "\006google\002pl", false, kGooglePins, DOMAIN_GOOGLE_PL },
  {11, true, "\006google\002pn", false, kGooglePins, DOMAIN_GOOGLE_PN },
  {11, true, "\006google\002ps", false, kGooglePins, DOMAIN_GOOGLE_PS },
  {11, true, "\006google\002pt", false, kGooglePins, DOMAIN_GOOGLE_PT },
  {11, true, "\006google\002ro", false, kGooglePins, DOMAIN_GOOGLE_RO },
  {11, true, "\006google\002rs", false, kGooglePins, DOMAIN_GOOGLE_RS },
  {11, true, "\006google\002ru", false, kGooglePins, DOMAIN_GOOGLE_RU },
  {11, true, "\006google\002rw", false, kGooglePins, DOMAIN_GOOGLE_RW },
  {11, true, "\006google\002sc", false, kGooglePins, DOMAIN_GOOGLE_SC },
  {11, true, "\006google\002se", false, kGooglePins, DOMAIN_GOOGLE_SE },
  {11, true, "\006google\002sh", false, kGooglePins, DOMAIN_GOOGLE_SH },
  {11, true, "\006google\002si", false, kGooglePins, DOMAIN_GOOGLE_SI },
  {11, true, "\006google\002sk", false, kGooglePins, DOMAIN_GOOGLE_SK },
  {11, true, "\006google\002sm", false, kGooglePins, DOMAIN_GOOGLE_SM },
  {11, true, "\006google\002sn", false, kGooglePins, DOMAIN_GOOGLE_SN },
  {11, true, "\006google\002so", false, kGooglePins, DOMAIN_GOOGLE_SO },
  {11, true, "\006google\002st", false, kGooglePins, DOMAIN_GOOGLE_ST },
  {11, true, "\006google\002td", false, kGooglePins, DOMAIN_GOOGLE_TD },
  {11, true, "\006google\002tg", false, kGooglePins, DOMAIN_GOOGLE_TG },
  {11, true, "\006google\002tk", false, kGooglePins, DOMAIN_GOOGLE_TK },
  {11, true, "\006google\002tl", false, kGooglePins, DOMAIN_GOOGLE_TL },
  {11, true, "\006google\002tm", false, kGooglePins, DOMAIN_GOOGLE_TM },
  {11, true, "\006google\002tn", false, kGooglePins, DOMAIN_GOOGLE_TN },
  {11, true, "\006google\002to", false, kGooglePins, DOMAIN_GOOGLE_TO },
  {11, true, "\006google\002tp", false, kGooglePins, DOMAIN_GOOGLE_TP },
  {11, true, "\006google\002tt", false, kGooglePins, DOMAIN_GOOGLE_TT },
  {11, true, "\006google\002us", false, kGooglePins, DOMAIN_GOOGLE_US },
  {11, true, "\006google\002uz", false, kGooglePins, DOMAIN_GOOGLE_UZ },
  {11, true, "\006google\002vg", false, kGooglePins, DOMAIN_GOOGLE_VG },
  {11, true, "\006google\002vu", false, kGooglePins, DOMAIN_GOOGLE_VU },
  {11, true, "\006google\002ws", false, kGooglePins, DOMAIN_GOOGLE_WS },
  {23, true, "\005learn\013doubleclick\003net", false, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\003www\006paypal\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\003www\006elanex\003biz", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006jottit\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\015sunshinepress\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, false, "\003www\013noisebridge\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, false, "\004neg9\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006riseup\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, false, "\006factor\002cc", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\007members\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\007support\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\002id\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, true, "\005lists\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\007webmail\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {24, true, "\011roundcube\010mayfirst\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {28, false, "\016aladdinschools\007appspot\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\011ottospora\002nl", true, kNoPins, DOMAIN_NOT_PINNED },
  {25, false, "\003www\017paycheckrecords\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010lastpass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\003www\010lastpass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\010keyerror\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\010entropia\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\010entropia\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\005romab\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\012logentries\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\003www\012logentries\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006stripe\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {27, true, "\025cloudsecurityalliance\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\005login\004sapo\002pt", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\015mattmccutchen\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006betnet\002fr", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\010uprotect\002it", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010squareup\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\004cert\002se", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006crypto\002is", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, true, "\005simon\007butcher\004name", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\004linx\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007dropcam\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\007dropcam\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {30, true, "\010ebanking\014indovinabank\003com\002vn", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007epoxate\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {21, true, "\004blog\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {22, true, "\005check\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {20, true, "\003www\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {21, true, "\004dist\012torproject\003org", true, kTorPins, DOMAIN_TORPROJECT_ORG },
  {22, true, "\003www\014moneybookers\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\013ledgerscope\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, false, "\003www\013ledgerscope\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, false, "\004kyps\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\003www\004kyps\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003app\007recurly\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003api\007recurly\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007greplin\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\007greplin\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {27, true, "\006luneta\016nearbuysystems\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006ubertt\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\004pixi\002me", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\010grepular\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\003www\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {26, false, "\011developer\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {30, false, "\003www\011developer\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {24, false, "\007sandbox\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {28, false, "\003www\007sandbox\012mydigipass\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\006crypto\003cat", true, kCryptoCatPins, DOMAIN_CRYPTO_CAT },
  {25, true, "\014bigshinylock\006minazo\003net", true, kNoPins, DOMAIN_NOT_PINNED },
  {10, true, "\005crate\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007twitter\003com", true, kTwitterComPins, DOMAIN_TWITTER_COM },
  {17, true, "\003www\007twitter\003com", true, kTwitterComPins, DOMAIN_TWITTER_COM },
  {17, true, "\003api\007twitter\003com", false, kTwitterCDNPins, DOMAIN_TWITTER_COM },
  {19, true, "\005oauth\007twitter\003com", false, kTwitterComPins, DOMAIN_TWITTER_COM },
  {20, true, "\006mobile\007twitter\003com", false, kTwitterComPins, DOMAIN_TWITTER_COM },
  {17, true, "\003dev\007twitter\003com", false, kTwitterComPins, DOMAIN_TWITTER_COM },
  {22, true, "\010business\007twitter\003com", false, kTwitterComPins, DOMAIN_TWITTER_COM },
  {22, true, "\010platform\007twitter\003com", false, kTwitterCDNPins, DOMAIN_TWITTER_COM },
  {15, true, "\003si0\005twimg\003com", false, kTwitterCDNPins, DOMAIN_TWIMG_COM },
  {23, true, "\010twimg0-a\010akamaihd\003net", false, kTwitterCDNPins, DOMAIN_AKAMAIHD_NET },
  {22, true, "\020braintreegateway\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {23, false, "\021braintreepayments\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {27, false, "\003www\021braintreepayments\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {24, false, "\022emailprivacytester\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\007tor2web\003org", false, kTor2webPins, DOMAIN_TOR2WEB_ORG },
  {25, true, "\010business\007medbank\003com\002mt", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\005arivo\003com\002br", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, true, "\003www\013apollo-auto\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\003www\005cueup\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, false, "\005jitsi\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\003www\005jitsi\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\010download\005jitsi\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {8, true, "\003sol\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010irccloud\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\003www\010irccloud\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {20, false, "\005alpha\010irccloud\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {11, true, "\006passwd\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011browserid\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\005login\007persona\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007neonisi\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\003www\007neonisi\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\005shops\007neonisi\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\014piratenlogin\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011howrandom\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\010intercom\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003api\010intercom\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\010intercom\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\010fatzebra\003com\002au", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\007csawctf\004poly\003edu", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\014makeyourlaws\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, false, "\003www\014makeyourlaws\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, true, "\003iop\006intuit\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, false, "\010surfeasy\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\003www\010surfeasy\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\011packagist\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, false, "\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, false, "\003www\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, false, "\011mylookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, false, "\003www\011mylookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {16, false, "\002dm\007lookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\002dm\011mylookout\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\011itriskltd\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\012stocktrade\002de", true, kNoPins, DOMAIN_NOT_PINNED },
  {13, true, "\007rhcloud\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, true, "\011openshift\006redhat\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, false, "\014therapynotes\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {22, false, "\003www\014therapynotes\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {9, true, "\003wiz\003biz", true, kNoPins, DOMAIN_NOT_PINNED },
  {14, true, "\002my\006onlime\002ch", true, kNoPins, DOMAIN_NOT_PINNED },
  {19, true, "\007webmail\006onlime\002ch", true, kNoPins, DOMAIN_NOT_PINNED },
  {15, true, "\003crm\006onlime\002ch", true, kNoPins, DOMAIN_NOT_PINNED },
  {12, true, "\003www\003gov\002uk", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\014silentcircle\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\014silentcircle\003org", true, kNoPins, DOMAIN_NOT_PINNED },
  {18, true, "\015serverdensity\002io", true, kNoPins, DOMAIN_NOT_PINNED },
  {17, true, "\002my\010alfresco\003com", true, kNoPins, DOMAIN_NOT_PINNED },
  {21, true, "\007webmail\010gigahost\002dk", true, kNoPins, DOMAIN_NOT_PINNED },
};
static const size_t kNumPreloadedSTS = ARRAYSIZE_UNSAFE(kPreloadedSTS);

static const struct HSTSPreload kPreloadedSNISTS[] = {
  {11, false, "\005gmail\003com", true, kGooglePins, DOMAIN_GMAIL_COM },
  {16, false, "\012googlemail\003com", true, kGooglePins, DOMAIN_GOOGLEMAIL_COM },
  {15, false, "\003www\005gmail\003com", true, kGooglePins, DOMAIN_GMAIL_COM },
  {20, false, "\003www\012googlemail\003com", true, kGooglePins, DOMAIN_GOOGLEMAIL_COM },
  {22, true, "\020google-analytics\003com", false, kGooglePins, DOMAIN_GOOGLE_ANALYTICS_COM },
  {18, true, "\014googlegroups\003com", false, kGooglePins, DOMAIN_GOOGLEGROUPS_COM },
};
static const size_t kNumPreloadedSNISTS = ARRAYSIZE_UNSAFE(kPreloadedSNISTS);

#endif // NET_BASE_TRANSPORT_SECURITY_STATE_STATIC_H_
