/* Copyright (c) 2012 The Chromium Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */
#ifndef LIBRARIES_NACL_MOUNTS_MOUNT_HTML5FS_H_
#define LIBRARIES_NACL_MOUNTS_MOUNT_HTML5FS_H_

#include <pthread.h>
#include "nacl_mounts/mount.h"
#include "nacl_mounts/pepper_interface.h"

class MountNode;

class MountHtml5Fs: public Mount {
 public:
  virtual MountNode *Open(const Path& path, int mode);
  virtual int Close(MountNode* node);
  virtual int Unlink(const Path& path);
  virtual int Mkdir(const Path& path, int permissions);
  virtual int Rmdir(const Path& path);
  virtual int Remove(const Path& path);

  PP_Resource filesystem_resource() { return filesystem_resource_; }

 protected:
  MountHtml5Fs();

  virtual bool Init(int dev, StringMap_t& args, PepperInterface* ppapi);
  virtual void Destroy();

  bool IsFilesystemOpen();

 private:
  static void FilesystemOpenCallbackThunk(void* user_data, int32_t result);
  void FilesystemOpenCallback(int32_t result);

  PP_Resource filesystem_resource_;
  bool filesystem_open_;  // protected by lock_.

  friend class Mount;
};

#endif  // LIBRARIES_NACL_MOUNTS_MOUNT_HTML5FS_H_
