/* native_client/src/trusted/validator_ragel/gen/validator_x86_64.c
 * THIS FILE IS AUTO-GENERATED. DO NOT EDIT.
 * Compiled for x86-64 mode.
 */

/*
 * This is the core of amd64-mode validator.  Please note that this file
 * combines ragel machine description and C language actions.  Please read
 * validator_internals.html first to understand how the whole thing is built:
 * it explains how the byte sequences are constructed, what constructs like
 * “@{}” or “REX_WRX?” mean, etc.
 */

#include <assert.h>
#include <errno.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "native_client/src/trusted/validator_ragel/unreviewed/validator_internal.h"





static const int x86_64_validator_start = 891;
static const int x86_64_validator_first_final = 891;
static const int x86_64_validator_error = 0;

static const int x86_64_validator_en_main = 891;



Bool ValidateChunkAMD64(const uint8_t *data, size_t size,
                        uint32_t options,
                        const NaClCPUFeaturesX86 *cpu_features,
                        ValidationCallbackFunc user_callback,
                        void *callback_data) {
  bitmap_word valid_targets_small[2];
  bitmap_word jump_dests_small[2];
  bitmap_word *valid_targets;
  bitmap_word *jump_dests;
  const uint8_t *current_position;
  const uint8_t *end_of_bundle;
  int result = TRUE;

  CHECK(sizeof valid_targets_small == sizeof jump_dests_small);
  CHECK(size % kBundleSize == 0);

  /*
   * For a very small sequences (one bundle) malloc is too expensive.
   *
   * Note1: we allocate one extra bit, because we set valid jump target bits
   * _after_ instructions, so there will be one at the end of the chunk.
   *
   * Note2: we don't ever mark first bit as a valid jump target but this is
   * not a problem because any aligned address is valid jump target.
   */
  if ((size + 1) <= (sizeof valid_targets_small * 8)) {
    memset(valid_targets_small, 0, sizeof valid_targets_small);
    valid_targets = valid_targets_small;
    memset(jump_dests_small, 0, sizeof jump_dests_small);
    jump_dests = jump_dests_small;
  } else {
    valid_targets = BitmapAllocate(size + 1);
    jump_dests = BitmapAllocate(size + 1);
    if (!valid_targets || !jump_dests) {
      free(jump_dests);
      free(valid_targets);
      errno = ENOMEM;
      return FALSE;
    }
  }

  /*
   * This option is usually used in tests: we will process the whole chunk
   * in one pass. Usually each bundle is processed separately which means
   * instructions (and super-instructions) can not cross borders of the bundle.
   */
  if (options & PROCESS_CHUNK_AS_A_CONTIGUOUS_STREAM)
    end_of_bundle = data + size;
  else
    end_of_bundle = data + kBundleSize;

  /*
   * Main loop.  Here we process the data array bundle-after-bundle.
   * Ragel-produced DFA does all the checks with one exception: direct jumps.
   * It collects the two arrays: valid_targets and jump_dests which are used
   * to test direct jumps later.
   */
  for (current_position = data;
       current_position < data + size;
       current_position = end_of_bundle,
       end_of_bundle = current_position + kBundleSize) {
    /* Start of the instruction being processed.  */
    const uint8_t *instruction_start = current_position;
    int current_state;
    uint32_t instruction_info_collected = 0;
    /* Keeps one byte of information per operand in the current instruction:
     *  2 bits for register kinds,
     *  5 bits for register numbers (16 regs plus RIZ). */
    uint32_t operand_states = 0;
    enum OperandName base = NO_REG;
    enum OperandName index = NO_REG;
    enum OperandName restricted_register =
      RESTRICTED_REGISTER_INITIAL_VALUE(options);
    uint8_t rex_prefix = FALSE;
    /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
    uint8_t vex_prefix2 = VEX_R | VEX_X | VEX_B;
    uint8_t vex_prefix3 = 0x00;

    
	{
	( current_state) = x86_64_validator_start;
	}

    
	{
	if ( ( current_position) == ( end_of_bundle) )
		goto _test_eof;
	goto _resume;

_again:
	switch ( ( current_state) ) {
		case 917: goto tr0;
		case 924: goto tr7;
		case 925: goto tr8;
		case 930: goto tr13;
		case 931: goto tr14;
		case 934: goto tr17;
		case 935: goto tr18;
		case 942: goto tr25;
		case 943: goto tr26;
		case 948: goto tr31;
		case 949: goto tr32;
		case 952: goto tr35;
		case 959: goto tr42;
		case 960: goto tr43;
		case 965: goto tr48;
		case 966: goto tr49;
		case 969: goto tr52;
		case 973: goto tr56;
		case 976: goto tr59;
		case 978: goto tr61;
		case 986: goto tr69;
		case 995: goto tr78;
		case 1013: goto tr96;
		case 1017: goto tr100;
		case 1018: goto tr101;
		case 1019: goto tr102;
		case 1020: goto tr103;
		case 1027: goto tr110;
		case 1032: goto tr115;
		case 1033: goto tr116;
		case 1044: goto tr127;
		case 1045: goto tr128;
		case 1055: goto tr138;
		case 1062: goto tr145;
		case 1063: goto tr146;
		case 1070: goto tr153;
		case 1089: goto tr172;
		case 1103: goto tr186;
		case 1105: goto tr188;
		case 1108: goto tr191;
		case 1119: goto tr202;
		case 1120: goto tr203;
		case 1121: goto tr204;
		case 1123: goto tr206;
		case 1133: goto tr216;
		case 1143: goto tr226;
		case 1147: goto tr230;
		case 1151: goto tr234;
		case 1161: goto tr244;
		case 1173: goto tr256;
		case 1174: goto tr257;
		case 1175: goto tr258;
		case 1222: goto tr305;
		case 1261: goto tr344;
		case 1268: goto tr351;
		case 1273: goto tr356;
		case 1274: goto tr357;
		case 1277: goto tr360;
		case 1294: goto tr377;
		case 1295: goto tr378;
		case 1296: goto tr379;
		case 1303: goto tr386;
		case 1304: goto tr387;
		case 1308: goto tr391;
		case 1309: goto tr392;
		case 1322: goto tr405;
		case 1337: goto tr420;
		case 1341: goto tr424;
		case 1383: goto tr466;
		case 1384: goto tr467;
		case 1391: goto tr474;
		case 1396: goto tr479;
		case 1397: goto tr480;
		case 1407: goto tr490;
		case 1409: goto tr492;
		case 1416: goto tr499;
		case 1417: goto tr500;
		case 1427: goto tr510;
		case 1461: goto tr544;
		case 1472: goto tr555;
		case 1482: goto tr565;
		case 1504: goto tr587;
		case 1543: goto tr626;
		case 1579: goto tr662;
		case 1621: goto tr704;
		case 1622: goto tr705;
		case 1640: goto tr723;
		case 1647: goto tr730;
		case 1686: goto tr769;
		case 1794: goto tr877;
		case 1797: goto tr880;
		case 1799: goto tr882;
		case 1800: goto tr883;
		case 1803: goto tr886;
		case 1806: goto tr889;
		case 1808: goto tr891;
		case 1913: goto tr996;
		case 2001: goto tr1084;
		case 2004: goto tr1087;
		case 2143: goto tr1226;
		case 2146: goto tr1229;
		case 2148: goto tr1231;
		case 2151: goto tr1234;
		case 2216: goto tr1299;
		case 2257: goto tr1340;
		case 2262: goto tr1345;
		case 2272: goto tr1355;
		case 2273: goto tr1356;
		case 2277: goto tr1360;
		case 2281: goto tr1364;
		case 2294: goto tr1377;
		case 2295: goto tr1378;
		case 2299: goto tr1382;
		case 2300: goto tr1383;
		case 891: goto st891;
		case 998: goto tr81;
		case 1000: goto tr83;
		case 1152: goto tr235;
		case 1167: goto tr250;
		case 1310: goto tr393;
		case 1413: goto tr496;
		case 1332: goto tr415;
		case 1453: goto tr536;
		case 1468: goto tr551;
		case 1592: goto tr675;
		case 2082: goto tr1165;
		case 1: goto st1;
		case 1056: goto tr139;
		case 1106: goto tr189;
		case 1109: goto tr192;
		case 1134: goto tr217;
		case 1297: goto tr380;
		case 1342: goto tr425;
		case 1944: goto tr1027;
		case 2: goto st2;
		case 919: goto tr2;
		case 922: goto tr5;
		case 926: goto tr9;
		case 933: goto tr16;
		case 1057: goto tr140;
		case 1060: goto tr143;
		case 1107: goto tr190;
		case 1110: goto tr193;
		case 1115: goto tr198;
		case 1117: goto tr200;
		case 1135: goto tr218;
		case 1138: goto tr221;
		case 1298: goto tr381;
		case 1301: goto tr384;
		case 1343: goto tr426;
		case 1346: goto tr429;
		case 2003: goto tr1086;
		case 2076: goto tr1159;
		case 3: goto st3;
		case 4: goto st4;
		case 5: goto st5;
		case 6: goto st6;
		case 920: goto tr3;
		case 932: goto tr15;
		case 1058: goto tr141;
		case 1111: goto tr194;
		case 1113: goto tr196;
		case 1136: goto tr219;
		case 1299: goto tr382;
		case 1344: goto tr427;
		case 2002: goto tr1085;
		case 7: goto st7;
		case 1059: goto tr142;
		case 1112: goto tr195;
		case 1114: goto tr197;
		case 1137: goto tr220;
		case 1300: goto tr383;
		case 1345: goto tr428;
		case 1875: goto tr958;
		case 8: goto st8;
		case 1061: goto tr144;
		case 1116: goto tr199;
		case 1118: goto tr201;
		case 1139: goto tr222;
		case 1302: goto tr385;
		case 1347: goto tr430;
		case 1876: goto tr959;
		case 9: goto st9;
		case 996: goto tr79;
		case 1153: goto tr236;
		case 1255: goto tr338;
		case 1495: goto tr578;
		case 2080: goto tr1163;
		case 10: goto st10;
		case 989: goto tr72;
		case 1006: goto tr89;
		case 1154: goto tr237;
		case 1169: goto tr252;
		case 1311: goto tr394;
		case 1414: goto tr497;
		case 1330: goto tr413;
		case 1454: goto tr537;
		case 1469: goto tr552;
		case 1488: goto tr571;
		case 1613: goto tr696;
		case 2091: goto tr1174;
		case 2095: goto tr1178;
		case 2079: goto tr1162;
		case 2081: goto tr1164;
		case 2198: goto tr1281;
		case 2209: goto tr1292;
		case 2211: goto tr1294;
		case 2220: goto tr1303;
		case 2223: goto tr1306;
		case 2224: goto tr1307;
		case 2225: goto tr1308;
		case 2229: goto tr1312;
		case 2230: goto tr1313;
		case 2231: goto tr1314;
		case 2232: goto tr1315;
		case 11: goto st11;
		case 936: goto tr19;
		case 1779: goto tr862;
		case 1782: goto tr865;
		case 2131: goto tr1214;
		case 2133: goto tr1216;
		case 12: goto st12;
		case 944: goto tr27;
		case 951: goto tr34;
		case 937: goto tr20;
		case 940: goto tr23;
		case 1796: goto tr879;
		case 1805: goto tr888;
		case 1823: goto tr906;
		case 1826: goto tr909;
		case 2145: goto tr1228;
		case 2150: goto tr1233;
		case 2160: goto tr1243;
		case 2162: goto tr1245;
		case 13: goto st13;
		case 14: goto st14;
		case 15: goto st15;
		case 16: goto st16;
		case 950: goto tr33;
		case 938: goto tr21;
		case 1795: goto tr878;
		case 1804: goto tr887;
		case 2144: goto tr1227;
		case 2149: goto tr1232;
		case 17: goto st17;
		case 939: goto tr22;
		case 1760: goto tr843;
		case 1765: goto tr848;
		case 2120: goto tr1203;
		case 2124: goto tr1207;
		case 18: goto st18;
		case 941: goto tr24;
		case 1761: goto tr844;
		case 1766: goto tr849;
		case 2121: goto tr1204;
		case 2125: goto tr1208;
		case 19: goto st19;
		case 1002: goto tr85;
		case 1256: goto tr339;
		case 20: goto st20;
		case 953: goto tr36;
		case 21: goto st21;
		case 961: goto tr44;
		case 968: goto tr51;
		case 954: goto tr37;
		case 957: goto tr40;
		case 22: goto st22;
		case 23: goto st23;
		case 24: goto st24;
		case 25: goto st25;
		case 967: goto tr50;
		case 955: goto tr38;
		case 26: goto st26;
		case 956: goto tr39;
		case 27: goto st27;
		case 958: goto tr41;
		case 28: goto st28;
		case 1132: goto tr215;
		case 1372: goto tr455;
		case 1377: goto tr460;
		case 1378: goto tr461;
		case 1104: goto tr187;
		case 1122: goto tr205;
		case 1155: goto tr238;
		case 1176: goto tr259;
		case 1365: goto tr448;
		case 1232: goto tr315;
		case 1285: goto tr368;
		case 1340: goto tr423;
		case 1528: goto tr611;
		case 1531: goto tr614;
		case 1596: goto tr679;
		case 2051: goto tr1134;
		case 29: goto st29;
		case 1204: goto tr287;
		case 1205: goto tr288;
		case 1210: goto tr293;
		case 1211: goto tr294;
		case 1240: goto tr323;
		case 1156: goto tr239;
		case 1177: goto tr260;
		case 1197: goto tr280;
		case 1293: goto tr376;
		case 30: goto st30;
		case 31: goto st31;
		case 32: goto st32;
		case 33: goto st33;
		case 974: goto tr57;
		case 0: goto st0;
		case 34: goto st34;
		case 35: goto st35;
		case 36: goto st36;
		case 1064: goto tr147;
		case 1021: goto tr104;
		case 37: goto st37;
		case 1072: goto tr155;
		case 1075: goto tr158;
		case 1028: goto tr111;
		case 1035: goto tr118;
		case 1022: goto tr105;
		case 1025: goto tr108;
		case 1065: goto tr148;
		case 1068: goto tr151;
		case 38: goto st38;
		case 39: goto st39;
		case 40: goto st40;
		case 41: goto st41;
		case 1073: goto tr156;
		case 1034: goto tr117;
		case 1023: goto tr106;
		case 1066: goto tr149;
		case 42: goto st42;
		case 1067: goto tr150;
		case 1024: goto tr107;
		case 43: goto st43;
		case 1069: goto tr152;
		case 1026: goto tr109;
		case 44: goto st44;
		case 45: goto st45;
		case 1036: goto tr119;
		case 1046: goto tr129;
		case 1051: goto tr134;
		case 1052: goto tr135;
		case 46: goto st46;
		case 47: goto st47;
		case 1038: goto tr121;
		case 1041: goto tr124;
		case 1047: goto tr130;
		case 1054: goto tr137;
		case 48: goto st48;
		case 49: goto st49;
		case 50: goto st50;
		case 51: goto st51;
		case 1039: goto tr122;
		case 1053: goto tr136;
		case 52: goto st52;
		case 53: goto st53;
		case 54: goto st54;
		case 980: goto tr63;
		case 985: goto tr68;
		case 991: goto tr74;
		case 1015: goto tr98;
		case 1077: goto tr160;
		case 1483: goto tr566;
		case 1494: goto tr577;
		case 1507: goto tr590;
		case 1508: goto tr591;
		case 1510: goto tr593;
		case 1511: goto tr594;
		case 1749: goto tr832;
		case 2073: goto tr1156;
		case 2092: goto tr1175;
		case 2093: goto tr1176;
		case 2094: goto tr1177;
		case 2195: goto tr1278;
		case 2196: goto tr1279;
		case 2203: goto tr1286;
		case 2217: goto tr1300;
		case 2218: goto tr1301;
		case 2221: goto tr1304;
		case 55: goto st55;
		case 56: goto st56;
		case 982: goto tr65;
		case 1009: goto tr92;
		case 1016: goto tr99;
		case 1079: goto tr162;
		case 1484: goto tr567;
		case 1509: goto tr592;
		case 2074: goto tr1157;
		case 2205: goto tr1288;
		case 2197: goto tr1280;
		case 2219: goto tr1302;
		case 57: goto st57;
		case 58: goto st58;
		case 59: goto st59;
		case 60: goto st60;
		case 2188: goto tr1271;
		case 1078: goto tr161;
		case 2187: goto tr1270;
		case 2190: goto tr1273;
		case 1339: goto tr422;
		case 1606: goto tr689;
		case 1512: goto tr595;
		case 61: goto st61;
		case 62: goto st62;
		case 1008: goto tr91;
		case 992: goto tr75;
		case 1080: goto tr163;
		case 1490: goto tr573;
		case 1514: goto tr597;
		case 1513: goto tr596;
		case 1519: goto tr602;
		case 1520: goto tr603;
		case 1518: goto tr601;
		case 1744: goto tr827;
		case 2075: goto tr1158;
		case 2107: goto tr1190;
		case 2112: goto tr1195;
		case 2103: goto tr1186;
		case 2200: goto tr1283;
		case 2226: goto tr1309;
		case 2222: goto tr1305;
		case 63: goto st63;
		case 1099: goto tr182;
		case 1131: goto tr214;
		case 1081: goto tr164;
		case 1090: goto tr173;
		case 1095: goto tr178;
		case 1096: goto tr179;
		case 1124: goto tr207;
		case 1278: goto tr361;
		case 1530: goto tr613;
		case 1529: goto tr612;
		case 1521: goto tr604;
		case 1532: goto tr615;
		case 1539: goto tr622;
		case 2013: goto tr1096;
		case 2010: goto tr1093;
		case 2207: goto tr1290;
		case 64: goto st64;
		case 1125: goto tr208;
		case 1279: goto tr362;
		case 1522: goto tr605;
		case 1533: goto tr616;
		case 1946: goto tr1029;
		case 65: goto st65;
		case 1083: goto tr166;
		case 1086: goto tr169;
		case 1091: goto tr174;
		case 1098: goto tr181;
		case 1126: goto tr209;
		case 1129: goto tr212;
		case 1280: goto tr363;
		case 1283: goto tr366;
		case 1523: goto tr606;
		case 1526: goto tr609;
		case 1534: goto tr617;
		case 1537: goto tr620;
		case 2012: goto tr1095;
		case 2078: goto tr1161;
		case 66: goto st66;
		case 67: goto st67;
		case 68: goto st68;
		case 69: goto st69;
		case 1084: goto tr167;
		case 1097: goto tr180;
		case 1127: goto tr210;
		case 1281: goto tr364;
		case 1524: goto tr607;
		case 1535: goto tr618;
		case 2011: goto tr1094;
		case 70: goto st70;
		case 1128: goto tr211;
		case 1282: goto tr365;
		case 1525: goto tr608;
		case 1536: goto tr619;
		case 1879: goto tr962;
		case 71: goto st71;
		case 1130: goto tr213;
		case 1284: goto tr367;
		case 1527: goto tr610;
		case 1538: goto tr621;
		case 1880: goto tr963;
		case 72: goto st72;
		case 990: goto tr73;
		case 1014: goto tr97;
		case 1331: goto tr414;
		case 1338: goto tr421;
		case 1489: goto tr572;
		case 1591: goto tr674;
		case 2006: goto tr1089;
		case 73: goto st73;
		case 74: goto st74;
		case 75: goto st75;
		case 76: goto st76;
		case 77: goto st77;
		case 78: goto st78;
		case 79: goto st79;
		case 999: goto tr82;
		case 1333: goto tr416;
		case 1496: goto tr579;
		case 1516: goto tr599;
		case 1595: goto tr678;
		case 2110: goto tr1193;
		case 2113: goto tr1196;
		case 80: goto st80;
		case 81: goto st81;
		case 1003: goto tr86;
		case 1004: goto tr87;
		case 1318: goto tr401;
		case 1467: goto tr550;
		case 82: goto st82;
		case 83: goto st83;
		case 1007: goto tr90;
		case 84: goto st84;
		case 85: goto st85;
		case 1011: goto tr94;
		case 1335: goto tr418;
		case 1499: goto tr582;
		case 1593: goto tr676;
		case 2008: goto tr1091;
		case 86: goto st86;
		case 87: goto st87;
		case 1355: goto tr438;
		case 1356: goto tr439;
		case 1361: goto tr444;
		case 1362: goto tr445;
		case 1241: goto tr324;
		case 1158: goto tr241;
		case 1348: goto tr431;
		case 1312: goto tr395;
		case 1381: goto tr464;
		case 1408: goto tr491;
		case 88: goto st88;
		case 89: goto st89;
		case 90: goto st90;
		case 91: goto st91;
		case 92: goto st92;
		case 93: goto st93;
		case 1145: goto tr228;
		case 94: goto st94;
		case 95: goto st95;
		case 1233: goto tr316;
		case 1242: goto tr325;
		case 1247: goto tr330;
		case 1248: goto tr331;
		case 1286: goto tr369;
		case 1816: goto tr899;
		case 1813: goto tr896;
		case 96: goto st96;
		case 97: goto st97;
		case 98: goto st98;
		case 99: goto st99;
		case 2316: goto tr1399;
		case 100: goto st100;
		case 101: goto st101;
		case 1162: goto tr245;
		case 102: goto st102;
		case 1198: goto tr281;
		case 103: goto st103;
		case 1206: goto tr289;
		case 1213: goto tr296;
		case 1199: goto tr282;
		case 1202: goto tr285;
		case 104: goto st104;
		case 105: goto st105;
		case 106: goto st106;
		case 107: goto st107;
		case 1212: goto tr295;
		case 1200: goto tr283;
		case 108: goto st108;
		case 1201: goto tr284;
		case 109: goto st109;
		case 1203: goto tr286;
		case 110: goto st110;
		case 1163: goto tr246;
		case 111: goto st111;
		case 1221: goto tr304;
		case 1223: goto tr306;
		case 1228: goto tr311;
		case 1229: goto tr312;
		case 1251: goto tr334;
		case 1214: goto tr297;
		case 112: goto st112;
		case 1215: goto tr298;
		case 113: goto st113;
		case 1224: goto tr307;
		case 1231: goto tr314;
		case 1216: goto tr299;
		case 1219: goto tr302;
		case 114: goto st114;
		case 115: goto st115;
		case 116: goto st116;
		case 117: goto st117;
		case 1230: goto tr313;
		case 1217: goto tr300;
		case 118: goto st118;
		case 1218: goto tr301;
		case 119: goto st119;
		case 1220: goto tr303;
		case 120: goto st120;
		case 121: goto st121;
		case 122: goto st122;
		case 1287: goto tr370;
		case 1787: goto tr870;
		case 123: goto st123;
		case 1235: goto tr318;
		case 1238: goto tr321;
		case 1243: goto tr326;
		case 1250: goto tr333;
		case 1288: goto tr371;
		case 1291: goto tr374;
		case 1815: goto tr898;
		case 1831: goto tr914;
		case 124: goto st124;
		case 125: goto st125;
		case 126: goto st126;
		case 127: goto st127;
		case 1236: goto tr319;
		case 1249: goto tr332;
		case 1289: goto tr372;
		case 1814: goto tr897;
		case 128: goto st128;
		case 1290: goto tr373;
		case 1772: goto tr855;
		case 129: goto st129;
		case 1292: goto tr375;
		case 1773: goto tr856;
		case 130: goto st130;
		case 131: goto st131;
		case 1252: goto tr335;
		case 132: goto st132;
		case 1253: goto tr336;
		case 892: goto st892;
		case 2317: goto tr1400;
		case 133: goto st133;
		case 134: goto st134;
		case 1257: goto tr340;
		case 135: goto st135;
		case 1258: goto tr341;
		case 893: goto st893;
		case 2318: goto tr1401;
		case 136: goto st136;
		case 1168: goto tr251;
		case 137: goto st137;
		case 1259: goto tr342;
		case 1429: goto tr512;
		case 894: goto st894;
		case 2319: goto tr1402;
		case 138: goto st138;
		case 1171: goto tr254;
		case 139: goto st139;
		case 1262: goto tr345;
		case 140: goto st140;
		case 1269: goto tr352;
		case 1276: goto tr359;
		case 1263: goto tr346;
		case 1266: goto tr349;
		case 141: goto st141;
		case 142: goto st142;
		case 143: goto st143;
		case 144: goto st144;
		case 1275: goto tr358;
		case 1264: goto tr347;
		case 145: goto st145;
		case 1265: goto tr348;
		case 146: goto st146;
		case 1267: goto tr350;
		case 147: goto st147;
		case 148: goto st148;
		case 149: goto st149;
		case 150: goto st150;
		case 151: goto st151;
		case 152: goto st152;
		case 153: goto st153;
		case 154: goto st154;
		case 155: goto st155;
		case 156: goto st156;
		case 157: goto st157;
		case 158: goto st158;
		case 159: goto st159;
		case 160: goto st160;
		case 161: goto st161;
		case 162: goto st162;
		case 1192: goto tr275;
		case 163: goto st163;
		case 164: goto st164;
		case 165: goto st165;
		case 166: goto st166;
		case 167: goto st167;
		case 168: goto st168;
		case 169: goto st169;
		case 170: goto st170;
		case 2320: goto tr1403;
		case 171: goto st171;
		case 172: goto st172;
		case 173: goto st173;
		case 174: goto st174;
		case 175: goto st175;
		case 1314: goto tr397;
		case 1752: goto tr835;
		case 1753: goto tr836;
		case 176: goto st176;
		case 1349: goto tr432;
		case 177: goto st177;
		case 1357: goto tr440;
		case 1364: goto tr447;
		case 1350: goto tr433;
		case 1353: goto tr436;
		case 178: goto st178;
		case 179: goto st179;
		case 180: goto st180;
		case 181: goto st181;
		case 1363: goto tr446;
		case 1351: goto tr434;
		case 182: goto st182;
		case 1352: goto tr435;
		case 183: goto st183;
		case 1354: goto tr437;
		case 184: goto st184;
		case 1315: goto tr398;
		case 1464: goto tr547;
		case 185: goto st185;
		case 1366: goto tr449;
		case 186: goto st186;
		case 1373: goto tr456;
		case 1380: goto tr463;
		case 1367: goto tr450;
		case 1370: goto tr453;
		case 187: goto st187;
		case 188: goto st188;
		case 189: goto st189;
		case 190: goto st190;
		case 1379: goto tr462;
		case 1368: goto tr451;
		case 191: goto st191;
		case 1369: goto tr452;
		case 192: goto st192;
		case 1371: goto tr454;
		case 193: goto st193;
		case 194: goto st194;
		case 195: goto st195;
		case 1382: goto tr465;
		case 196: goto st196;
		case 1319: goto tr402;
		case 197: goto st197;
		case 1320: goto tr403;
		case 198: goto st198;
		case 1321: goto tr404;
		case 1470: goto tr553;
		case 199: goto st199;
		case 1385: goto tr468;
		case 200: goto st200;
		case 1392: goto tr475;
		case 1399: goto tr482;
		case 1386: goto tr469;
		case 1389: goto tr472;
		case 201: goto st201;
		case 202: goto st202;
		case 203: goto st203;
		case 204: goto st204;
		case 1398: goto tr481;
		case 1387: goto tr470;
		case 205: goto st205;
		case 1388: goto tr471;
		case 206: goto st206;
		case 1390: goto tr473;
		case 207: goto st207;
		case 1323: goto tr406;
		case 208: goto st208;
		case 209: goto st209;
		case 210: goto st210;
		case 211: goto st211;
		case 212: goto st212;
		case 213: goto st213;
		case 214: goto st214;
		case 215: goto st215;
		case 216: goto st216;
		case 217: goto st217;
		case 218: goto st218;
		case 219: goto st219;
		case 220: goto st220;
		case 2338: goto tr1421;
		case 221: goto st221;
		case 1410: goto tr493;
		case 222: goto st222;
		case 1411: goto tr494;
		case 223: goto st223;
		case 224: goto st224;
		case 1415: goto tr498;
		case 225: goto st225;
		case 1418: goto tr501;
		case 226: goto st226;
		case 1419: goto tr502;
		case 895: goto st895;
		case 2339: goto tr1422;
		case 227: goto st227;
		case 1420: goto tr503;
		case 228: goto st228;
		case 1422: goto tr505;
		case 2280: goto tr1363;
		case 896: goto st896;
		case 2346: goto tr1429;
		case 229: goto st229;
		case 1423: goto tr506;
		case 230: goto st230;
		case 1424: goto tr507;
		case 231: goto st231;
		case 1425: goto tr508;
		case 897: goto st897;
		case 232: goto st232;
		case 1426: goto tr509;
		case 1500: goto tr583;
		case 2248: goto tr1331;
		case 233: goto st233;
		case 2348: goto tr1431;
		case 234: goto st234;
		case 235: goto st235;
		case 1170: goto tr253;
		case 236: goto st236;
		case 1260: goto tr343;
		case 1430: goto tr513;
		case 898: goto st898;
		case 2362: goto tr1445;
		case 237: goto st237;
		case 1431: goto tr514;
		case 238: goto st238;
		case 1432: goto tr515;
		case 239: goto st239;
		case 1433: goto tr516;
		case 899: goto st899;
		case 2349: goto tr1432;
		case 240: goto st240;
		case 2350: goto tr1433;
		case 241: goto st241;
		case 2351: goto tr1434;
		case 242: goto st242;
		case 2363: goto tr1446;
		case 243: goto st243;
		case 244: goto st244;
		case 2353: goto tr1436;
		case 245: goto st245;
		case 2354: goto tr1437;
		case 246: goto st246;
		case 1435: goto tr518;
		case 247: goto st247;
		case 1436: goto tr519;
		case 248: goto st248;
		case 1437: goto tr520;
		case 249: goto st249;
		case 1441: goto tr524;
		case 250: goto st250;
		case 1438: goto tr521;
		case 251: goto st251;
		case 1442: goto tr525;
		case 252: goto st252;
		case 1439: goto tr522;
		case 253: goto st253;
		case 1443: goto tr526;
		case 254: goto st254;
		case 255: goto st255;
		case 256: goto st256;
		case 257: goto st257;
		case 1440: goto tr523;
		case 258: goto st258;
		case 1447: goto tr530;
		case 259: goto st259;
		case 260: goto st260;
		case 261: goto st261;
		case 262: goto st262;
		case 2355: goto tr1438;
		case 263: goto st263;
		case 1451: goto tr534;
		case 264: goto st264;
		case 1452: goto tr535;
		case 265: goto st265;
		case 2356: goto tr1439;
		case 266: goto st266;
		case 267: goto st267;
		case 1552: goto tr635;
		case 1553: goto tr636;
		case 1558: goto tr641;
		case 1559: goto tr642;
		case 1545: goto tr628;
		case 1455: goto tr538;
		case 1473: goto tr556;
		case 1569: goto tr652;
		case 1587: goto tr670;
		case 268: goto st268;
		case 269: goto st269;
		case 270: goto st270;
		case 271: goto st271;
		case 272: goto st272;
		case 273: goto st273;
		case 274: goto st274;
		case 275: goto st275;
		case 276: goto st276;
		case 277: goto st277;
		case 278: goto st278;
		case 279: goto st279;
		case 280: goto st280;
		case 281: goto st281;
		case 282: goto st282;
		case 1493: goto tr576;
		case 2005: goto tr1088;
		case 2204: goto tr1287;
		case 2202: goto tr1285;
		case 2227: goto tr1310;
		case 283: goto st283;
		case 284: goto st284;
		case 285: goto st285;
		case 286: goto st286;
		case 287: goto st287;
		case 288: goto st288;
		case 1562: goto tr645;
		case 1570: goto tr653;
		case 1575: goto tr658;
		case 1576: goto tr659;
		case 1580: goto tr663;
		case 289: goto st289;
		case 290: goto st290;
		case 1459: goto tr542;
		case 291: goto st291;
		case 292: goto st292;
		case 1463: goto tr546;
		case 293: goto st293;
		case 1546: goto tr629;
		case 294: goto st294;
		case 1554: goto tr637;
		case 1561: goto tr644;
		case 1547: goto tr630;
		case 1550: goto tr633;
		case 295: goto st295;
		case 296: goto st296;
		case 297: goto st297;
		case 298: goto st298;
		case 1560: goto tr643;
		case 1548: goto tr631;
		case 299: goto st299;
		case 1549: goto tr632;
		case 300: goto st300;
		case 1551: goto tr634;
		case 301: goto st301;
		case 302: goto st302;
		case 1581: goto tr664;
		case 303: goto st303;
		case 1564: goto tr647;
		case 1567: goto tr650;
		case 1571: goto tr654;
		case 1578: goto tr661;
		case 1582: goto tr665;
		case 1585: goto tr668;
		case 304: goto st304;
		case 305: goto st305;
		case 306: goto st306;
		case 307: goto st307;
		case 1565: goto tr648;
		case 1577: goto tr660;
		case 1583: goto tr666;
		case 308: goto st308;
		case 1584: goto tr667;
		case 309: goto st309;
		case 1586: goto tr669;
		case 310: goto st310;
		case 311: goto st311;
		case 312: goto st312;
		case 313: goto st313;
		case 314: goto st314;
		case 315: goto st315;
		case 316: goto st316;
		case 317: goto st317;
		case 1460: goto tr543;
		case 318: goto st318;
		case 319: goto st319;
		case 320: goto st320;
		case 321: goto st321;
		case 322: goto st322;
		case 323: goto st323;
		case 324: goto st324;
		case 325: goto st325;
		case 326: goto st326;
		case 327: goto st327;
		case 328: goto st328;
		case 329: goto st329;
		case 330: goto st330;
		case 1603: goto tr686;
		case 331: goto st331;
		case 332: goto st332;
		case 333: goto st333;
		case 334: goto st334;
		case 335: goto st335;
		case 336: goto st336;
		case 337: goto st337;
		case 338: goto st338;
		case 1611: goto tr694;
		case 339: goto st339;
		case 340: goto st340;
		case 1614: goto tr697;
		case 341: goto st341;
		case 1615: goto tr698;
		case 900: goto st900;
		case 2367: goto tr1450;
		case 342: goto st342;
		case 1616: goto tr699;
		case 343: goto st343;
		case 1617: goto tr700;
		case 1618: goto tr701;
		case 1619: goto tr702;
		case 901: goto st901;
		case 2369: goto tr1452;
		case 344: goto st344;
		case 345: goto st345;
		case 2370: goto tr1453;
		case 346: goto st346;
		case 2371: goto tr1454;
		case 347: goto st347;
		case 2372: goto tr1455;
		case 348: goto st348;
		case 349: goto st349;
		case 2321: goto tr1404;
		case 350: goto st350;
		case 2373: goto tr1456;
		case 351: goto st351;
		case 2374: goto tr1457;
		case 352: goto st352;
		case 2324: goto tr1407;
		case 353: goto st353;
		case 354: goto st354;
		case 355: goto st355;
		case 1625: goto tr708;
		case 356: goto st356;
		case 357: goto st357;
		case 1626: goto tr709;
		case 358: goto st358;
		case 359: goto st359;
		case 2327: goto tr1410;
		case 360: goto st360;
		case 1629: goto tr712;
		case 1641: goto tr724;
		case 902: goto st902;
		case 2375: goto tr1458;
		case 361: goto st361;
		case 1631: goto tr714;
		case 362: goto st362;
		case 1632: goto tr715;
		case 363: goto st363;
		case 1633: goto tr716;
		case 903: goto st903;
		case 2376: goto tr1459;
		case 364: goto st364;
		case 1634: goto tr717;
		case 365: goto st365;
		case 1636: goto tr719;
		case 2256: goto tr1339;
		case 904: goto st904;
		case 2383: goto tr1466;
		case 366: goto st366;
		case 1637: goto tr720;
		case 367: goto st367;
		case 1638: goto tr721;
		case 368: goto st368;
		case 1639: goto tr722;
		case 905: goto st905;
		case 2384: goto tr1467;
		case 369: goto st369;
		case 370: goto st370;
		case 2328: goto tr1411;
		case 371: goto st371;
		case 1630: goto tr713;
		case 1642: goto tr725;
		case 906: goto st906;
		case 2388: goto tr1471;
		case 372: goto st372;
		case 1643: goto tr726;
		case 373: goto st373;
		case 1644: goto tr727;
		case 374: goto st374;
		case 1645: goto tr728;
		case 907: goto st907;
		case 375: goto st375;
		case 1646: goto tr729;
		case 1653: goto tr736;
		case 2009: goto tr1092;
		case 376: goto st376;
		case 2390: goto tr1473;
		case 377: goto st377;
		case 378: goto st378;
		case 2391: goto tr1474;
		case 379: goto st379;
		case 2392: goto tr1475;
		case 380: goto st380;
		case 2393: goto tr1476;
		case 381: goto st381;
		case 2394: goto tr1477;
		case 382: goto st382;
		case 383: goto st383;
		case 2395: goto tr1478;
		case 384: goto st384;
		case 2396: goto tr1479;
		case 385: goto st385;
		case 2397: goto tr1480;
		case 386: goto st386;
		case 2398: goto tr1481;
		case 387: goto st387;
		case 388: goto st388;
		case 389: goto st389;
		case 1651: goto tr734;
		case 390: goto st390;
		case 391: goto st391;
		case 1652: goto tr735;
		case 392: goto st392;
		case 393: goto st393;
		case 394: goto st394;
		case 1656: goto tr739;
		case 395: goto st395;
		case 1676: goto tr759;
		case 396: goto st396;
		case 1680: goto tr763;
		case 1906: goto tr989;
		case 1907: goto tr990;
		case 397: goto st397;
		case 398: goto st398;
		case 1727: goto tr810;
		case 1685: goto tr768;
		case 1693: goto tr776;
		case 1688: goto tr771;
		case 399: goto st399;
		case 400: goto st400;
		case 1728: goto tr811;
		case 1687: goto tr770;
		case 401: goto st401;
		case 402: goto st402;
		case 1745: goto tr828;
		case 1729: goto tr812;
		case 1712: goto tr795;
		case 1689: goto tr772;
		case 403: goto st403;
		case 404: goto st404;
		case 405: goto st405;
		case 406: goto st406;
		case 1681: goto tr764;
		case 1873: goto tr956;
		case 1908: goto tr991;
		case 1921: goto tr1004;
		case 1904: goto tr987;
		case 407: goto st407;
		case 1878: goto tr961;
		case 408: goto st408;
		case 1677: goto tr760;
		case 409: goto st409;
		case 1678: goto tr761;
		case 410: goto st410;
		case 1679: goto tr762;
		case 411: goto st411;
		case 1657: goto tr740;
		case 412: goto st412;
		case 1695: goto tr778;
		case 413: goto st413;
		case 1698: goto tr781;
		case 1872: goto tr955;
		case 1893: goto tr976;
		case 1894: goto tr977;
		case 1895: goto tr978;
		case 414: goto st414;
		case 1874: goto tr957;
		case 415: goto st415;
		case 1696: goto tr779;
		case 416: goto st416;
		case 1697: goto tr780;
		case 417: goto st417;
		case 1658: goto tr741;
		case 418: goto st418;
		case 1700: goto tr783;
		case 419: goto st419;
		case 1702: goto tr785;
		case 1704: goto tr787;
		case 420: goto st420;
		case 1703: goto tr786;
		case 421: goto st421;
		case 1701: goto tr784;
		case 422: goto st422;
		case 1659: goto tr742;
		case 423: goto st423;
		case 1705: goto tr788;
		case 424: goto st424;
		case 1709: goto tr792;
		case 1971: goto tr1054;
		case 1972: goto tr1055;
		case 425: goto st425;
		case 426: goto st426;
		case 1710: goto tr793;
		case 1943: goto tr1026;
		case 1973: goto tr1056;
		case 1976: goto tr1059;
		case 1969: goto tr1052;
		case 427: goto st427;
		case 1706: goto tr789;
		case 428: goto st428;
		case 1707: goto tr790;
		case 429: goto st429;
		case 1708: goto tr791;
		case 430: goto st430;
		case 1660: goto tr743;
		case 431: goto st431;
		case 1713: goto tr796;
		case 432: goto st432;
		case 1716: goto tr799;
		case 1942: goto tr1025;
		case 1958: goto tr1041;
		case 1959: goto tr1042;
		case 1960: goto tr1043;
		case 433: goto st433;
		case 1714: goto tr797;
		case 434: goto st434;
		case 1715: goto tr798;
		case 435: goto st435;
		case 1661: goto tr744;
		case 436: goto st436;
		case 1717: goto tr800;
		case 437: goto st437;
		case 1719: goto tr802;
		case 1720: goto tr803;
		case 438: goto st438;
		case 1718: goto tr801;
		case 439: goto st439;
		case 1662: goto tr745;
		case 440: goto st440;
		case 1721: goto tr804;
		case 441: goto st441;
		case 1725: goto tr808;
		case 2040: goto tr1123;
		case 2041: goto tr1124;
		case 442: goto st442;
		case 1726: goto tr809;
		case 2000: goto tr1083;
		case 2042: goto tr1125;
		case 2050: goto tr1133;
		case 2038: goto tr1121;
		case 443: goto st443;
		case 1722: goto tr805;
		case 444: goto st444;
		case 1723: goto tr806;
		case 445: goto st445;
		case 1724: goto tr807;
		case 446: goto st446;
		case 1663: goto tr746;
		case 447: goto st447;
		case 1731: goto tr814;
		case 448: goto st448;
		case 1734: goto tr817;
		case 1998: goto tr1081;
		case 2027: goto tr1110;
		case 2028: goto tr1111;
		case 2029: goto tr1112;
		case 449: goto st449;
		case 1732: goto tr815;
		case 450: goto st450;
		case 1733: goto tr816;
		case 451: goto st451;
		case 1664: goto tr747;
		case 452: goto st452;
		case 1735: goto tr818;
		case 453: goto st453;
		case 1737: goto tr820;
		case 1738: goto tr821;
		case 454: goto st454;
		case 1736: goto tr819;
		case 455: goto st455;
		case 1665: goto tr748;
		case 456: goto st456;
		case 1739: goto tr822;
		case 457: goto st457;
		case 1743: goto tr826;
		case 2105: goto tr1188;
		case 2106: goto tr1189;
		case 458: goto st458;
		case 1740: goto tr823;
		case 459: goto st459;
		case 1741: goto tr824;
		case 460: goto st460;
		case 1742: goto tr825;
		case 461: goto st461;
		case 1666: goto tr749;
		case 462: goto st462;
		case 1746: goto tr829;
		case 463: goto st463;
		case 1747: goto tr830;
		case 464: goto st464;
		case 1748: goto tr831;
		case 465: goto st465;
		case 1667: goto tr750;
		case 466: goto st466;
		case 1750: goto tr833;
		case 467: goto st467;
		case 1751: goto tr834;
		case 468: goto st468;
		case 1668: goto tr751;
		case 469: goto st469;
		case 1754: goto tr837;
		case 470: goto st470;
		case 471: goto st471;
		case 1882: goto tr965;
		case 1759: goto tr842;
		case 1764: goto tr847;
		case 2119: goto tr1202;
		case 2123: goto tr1206;
		case 472: goto st472;
		case 473: goto st473;
		case 1755: goto tr838;
		case 474: goto st474;
		case 1756: goto tr839;
		case 475: goto st475;
		case 476: goto st476;
		case 477: goto st477;
		case 1669: goto tr752;
		case 478: goto st478;
		case 1767: goto tr850;
		case 479: goto st479;
		case 480: goto st480;
		case 1771: goto tr854;
		case 481: goto st481;
		case 1768: goto tr851;
		case 482: goto st482;
		case 1769: goto tr852;
		case 483: goto st483;
		case 1670: goto tr753;
		case 484: goto st484;
		case 1774: goto tr857;
		case 485: goto st485;
		case 486: goto st486;
		case 487: goto st487;
		case 1775: goto tr858;
		case 488: goto st488;
		case 1776: goto tr859;
		case 489: goto st489;
		case 490: goto st490;
		case 491: goto st491;
		case 1671: goto tr754;
		case 492: goto st492;
		case 1783: goto tr866;
		case 493: goto st493;
		case 494: goto st494;
		case 1784: goto tr867;
		case 495: goto st495;
		case 1785: goto tr868;
		case 496: goto st496;
		case 1672: goto tr755;
		case 497: goto st497;
		case 1788: goto tr871;
		case 498: goto st498;
		case 499: goto st499;
		case 500: goto st500;
		case 1789: goto tr872;
		case 501: goto st501;
		case 502: goto st502;
		case 1790: goto tr873;
		case 503: goto st503;
		case 504: goto st504;
		case 505: goto st505;
		case 1791: goto tr874;
		case 506: goto st506;
		case 507: goto st507;
		case 1673: goto tr756;
		case 508: goto st508;
		case 1809: goto tr892;
		case 509: goto st509;
		case 510: goto st510;
		case 1810: goto tr893;
		case 511: goto st511;
		case 1811: goto tr894;
		case 512: goto st512;
		case 1674: goto tr757;
		case 513: goto st513;
		case 1817: goto tr900;
		case 514: goto st514;
		case 515: goto st515;
		case 516: goto st516;
		case 1818: goto tr901;
		case 517: goto st517;
		case 1819: goto tr902;
		case 518: goto st518;
		case 519: goto st519;
		case 520: goto st520;
		case 1820: goto tr903;
		case 521: goto st521;
		case 1675: goto tr758;
		case 522: goto st522;
		case 1827: goto tr910;
		case 523: goto st523;
		case 524: goto st524;
		case 1828: goto tr911;
		case 525: goto st525;
		case 1829: goto tr912;
		case 526: goto st526;
		case 527: goto st527;
		case 1832: goto tr915;
		case 528: goto st528;
		case 1852: goto tr935;
		case 529: goto st529;
		case 530: goto st530;
		case 1853: goto tr936;
		case 531: goto st531;
		case 1854: goto tr937;
		case 532: goto st532;
		case 1855: goto tr938;
		case 533: goto st533;
		case 1856: goto tr939;
		case 534: goto st534;
		case 1857: goto tr940;
		case 535: goto st535;
		case 1858: goto tr941;
		case 536: goto st536;
		case 1859: goto tr942;
		case 537: goto st537;
		case 1860: goto tr943;
		case 538: goto st538;
		case 539: goto st539;
		case 1861: goto tr944;
		case 540: goto st540;
		case 1892: goto tr975;
		case 1896: goto tr979;
		case 1881: goto tr964;
		case 1883: goto tr966;
		case 541: goto st541;
		case 1862: goto tr945;
		case 542: goto st542;
		case 1863: goto tr946;
		case 543: goto st543;
		case 1864: goto tr947;
		case 544: goto st544;
		case 1865: goto tr948;
		case 545: goto st545;
		case 1866: goto tr949;
		case 546: goto st546;
		case 1867: goto tr950;
		case 547: goto st547;
		case 1868: goto tr951;
		case 548: goto st548;
		case 1869: goto tr952;
		case 549: goto st549;
		case 1870: goto tr953;
		case 550: goto st550;
		case 1833: goto tr916;
		case 551: goto st551;
		case 1884: goto tr967;
		case 552: goto st552;
		case 1885: goto tr968;
		case 553: goto st553;
		case 1886: goto tr969;
		case 554: goto st554;
		case 1887: goto tr970;
		case 555: goto st555;
		case 1888: goto tr971;
		case 556: goto st556;
		case 1889: goto tr972;
		case 557: goto st557;
		case 1890: goto tr973;
		case 558: goto st558;
		case 1891: goto tr974;
		case 559: goto st559;
		case 1834: goto tr917;
		case 560: goto st560;
		case 1897: goto tr980;
		case 561: goto st561;
		case 1905: goto tr988;
		case 562: goto st562;
		case 563: goto st563;
		case 2043: goto tr1126;
		case 1912: goto tr995;
		case 1920: goto tr1003;
		case 1915: goto tr998;
		case 564: goto st564;
		case 565: goto st565;
		case 2044: goto tr1127;
		case 1914: goto tr997;
		case 566: goto st566;
		case 567: goto st567;
		case 2108: goto tr1191;
		case 2045: goto tr1128;
		case 1975: goto tr1058;
		case 1916: goto tr999;
		case 568: goto st568;
		case 569: goto st569;
		case 570: goto st570;
		case 571: goto st571;
		case 1898: goto tr981;
		case 572: goto st572;
		case 1899: goto tr982;
		case 573: goto st573;
		case 1900: goto tr983;
		case 574: goto st574;
		case 1901: goto tr984;
		case 575: goto st575;
		case 1902: goto tr985;
		case 576: goto st576;
		case 1903: goto tr986;
		case 577: goto st577;
		case 1835: goto tr918;
		case 578: goto st578;
		case 1922: goto tr1005;
		case 579: goto st579;
		case 580: goto st580;
		case 1923: goto tr1006;
		case 581: goto st581;
		case 1924: goto tr1007;
		case 582: goto st582;
		case 1925: goto tr1008;
		case 583: goto st583;
		case 1926: goto tr1009;
		case 584: goto st584;
		case 1927: goto tr1010;
		case 585: goto st585;
		case 1928: goto tr1011;
		case 586: goto st586;
		case 1929: goto tr1012;
		case 587: goto st587;
		case 1930: goto tr1013;
		case 588: goto st588;
		case 589: goto st589;
		case 1931: goto tr1014;
		case 590: goto st590;
		case 1957: goto tr1040;
		case 1961: goto tr1044;
		case 1947: goto tr1030;
		case 1948: goto tr1031;
		case 591: goto st591;
		case 1932: goto tr1015;
		case 592: goto st592;
		case 1933: goto tr1016;
		case 593: goto st593;
		case 1934: goto tr1017;
		case 594: goto st594;
		case 1935: goto tr1018;
		case 595: goto st595;
		case 1936: goto tr1019;
		case 596: goto st596;
		case 1937: goto tr1020;
		case 597: goto st597;
		case 1938: goto tr1021;
		case 598: goto st598;
		case 1939: goto tr1022;
		case 599: goto st599;
		case 1940: goto tr1023;
		case 600: goto st600;
		case 1836: goto tr919;
		case 601: goto st601;
		case 1949: goto tr1032;
		case 602: goto st602;
		case 1950: goto tr1033;
		case 603: goto st603;
		case 1951: goto tr1034;
		case 604: goto st604;
		case 1952: goto tr1035;
		case 605: goto st605;
		case 1953: goto tr1036;
		case 606: goto st606;
		case 1954: goto tr1037;
		case 607: goto st607;
		case 1955: goto tr1038;
		case 608: goto st608;
		case 1956: goto tr1039;
		case 609: goto st609;
		case 1837: goto tr920;
		case 610: goto st610;
		case 1962: goto tr1045;
		case 611: goto st611;
		case 1970: goto tr1053;
		case 612: goto st612;
		case 613: goto st613;
		case 1963: goto tr1046;
		case 614: goto st614;
		case 1964: goto tr1047;
		case 615: goto st615;
		case 1965: goto tr1048;
		case 616: goto st616;
		case 1966: goto tr1049;
		case 617: goto st617;
		case 1967: goto tr1050;
		case 618: goto st618;
		case 1968: goto tr1051;
		case 619: goto st619;
		case 1838: goto tr921;
		case 620: goto st620;
		case 1977: goto tr1060;
		case 621: goto st621;
		case 622: goto st622;
		case 1999: goto tr1082;
		case 623: goto st623;
		case 1978: goto tr1061;
		case 624: goto st624;
		case 1979: goto tr1062;
		case 625: goto st625;
		case 1980: goto tr1063;
		case 626: goto st626;
		case 1981: goto tr1064;
		case 627: goto st627;
		case 1982: goto tr1065;
		case 628: goto st628;
		case 1983: goto tr1066;
		case 2169: goto tr1252;
		case 629: goto st629;
		case 1984: goto tr1067;
		case 630: goto st630;
		case 1985: goto tr1068;
		case 631: goto st631;
		case 1986: goto tr1069;
		case 632: goto st632;
		case 633: goto st633;
		case 1987: goto tr1070;
		case 634: goto st634;
		case 2026: goto tr1109;
		case 2030: goto tr1113;
		case 2014: goto tr1097;
		case 2016: goto tr1099;
		case 635: goto st635;
		case 1988: goto tr1071;
		case 636: goto st636;
		case 1989: goto tr1072;
		case 637: goto st637;
		case 1990: goto tr1073;
		case 638: goto st638;
		case 2015: goto tr1098;
		case 639: goto st639;
		case 1991: goto tr1074;
		case 640: goto st640;
		case 1992: goto tr1075;
		case 641: goto st641;
		case 1993: goto tr1076;
		case 642: goto st642;
		case 1994: goto tr1077;
		case 643: goto st643;
		case 1995: goto tr1078;
		case 644: goto st644;
		case 1996: goto tr1079;
		case 645: goto st645;
		case 2017: goto tr1100;
		case 646: goto st646;
		case 1839: goto tr922;
		case 647: goto st647;
		case 2018: goto tr1101;
		case 648: goto st648;
		case 2019: goto tr1102;
		case 649: goto st649;
		case 2020: goto tr1103;
		case 650: goto st650;
		case 2021: goto tr1104;
		case 651: goto st651;
		case 2022: goto tr1105;
		case 652: goto st652;
		case 2023: goto tr1106;
		case 653: goto st653;
		case 2024: goto tr1107;
		case 654: goto st654;
		case 2025: goto tr1108;
		case 655: goto st655;
		case 1840: goto tr923;
		case 656: goto st656;
		case 2031: goto tr1114;
		case 657: goto st657;
		case 2039: goto tr1122;
		case 658: goto st658;
		case 2032: goto tr1115;
		case 659: goto st659;
		case 2033: goto tr1116;
		case 660: goto st660;
		case 661: goto st661;
		case 2048: goto tr1131;
		case 2052: goto tr1135;
		case 662: goto st662;
		case 2049: goto tr1132;
		case 663: goto st663;
		case 2034: goto tr1117;
		case 664: goto st664;
		case 2035: goto tr1118;
		case 665: goto st665;
		case 2036: goto tr1119;
		case 666: goto st666;
		case 2037: goto tr1120;
		case 667: goto st667;
		case 1841: goto tr924;
		case 668: goto st668;
		case 2053: goto tr1136;
		case 2163: goto tr1246;
		case 669: goto st669;
		case 670: goto st670;
		case 2054: goto tr1137;
		case 2164: goto tr1247;
		case 671: goto st671;
		case 2055: goto tr1138;
		case 672: goto st672;
		case 2056: goto tr1139;
		case 673: goto st673;
		case 2057: goto tr1140;
		case 2167: goto tr1250;
		case 674: goto st674;
		case 2058: goto tr1141;
		case 2168: goto tr1251;
		case 675: goto st675;
		case 2059: goto tr1142;
		case 2170: goto tr1253;
		case 676: goto st676;
		case 2060: goto tr1143;
		case 2171: goto tr1254;
		case 677: goto st677;
		case 2061: goto tr1144;
		case 2172: goto tr1255;
		case 678: goto st678;
		case 679: goto st679;
		case 2062: goto tr1145;
		case 680: goto st680;
		case 2063: goto tr1146;
		case 681: goto st681;
		case 2064: goto tr1147;
		case 2175: goto tr1258;
		case 682: goto st682;
		case 2065: goto tr1148;
		case 2176: goto tr1259;
		case 683: goto st683;
		case 2066: goto tr1149;
		case 2177: goto tr1260;
		case 684: goto st684;
		case 2067: goto tr1150;
		case 2178: goto tr1261;
		case 685: goto st685;
		case 2068: goto tr1151;
		case 686: goto st686;
		case 2069: goto tr1152;
		case 687: goto st687;
		case 2070: goto tr1153;
		case 688: goto st688;
		case 2071: goto tr1154;
		case 689: goto st689;
		case 1842: goto tr925;
		case 690: goto st690;
		case 2083: goto tr1166;
		case 691: goto st691;
		case 2084: goto tr1167;
		case 692: goto st692;
		case 2085: goto tr1168;
		case 693: goto st693;
		case 2086: goto tr1169;
		case 694: goto st694;
		case 2087: goto tr1170;
		case 695: goto st695;
		case 2088: goto tr1171;
		case 696: goto st696;
		case 2089: goto tr1172;
		case 697: goto st697;
		case 2090: goto tr1173;
		case 698: goto st698;
		case 1843: goto tr926;
		case 699: goto st699;
		case 2096: goto tr1179;
		case 700: goto st700;
		case 2104: goto tr1187;
		case 701: goto st701;
		case 2097: goto tr1180;
		case 702: goto st702;
		case 2098: goto tr1181;
		case 703: goto st703;
		case 704: goto st704;
		case 2111: goto tr1194;
		case 705: goto st705;
		case 2099: goto tr1182;
		case 706: goto st706;
		case 2100: goto tr1183;
		case 707: goto st707;
		case 2101: goto tr1184;
		case 708: goto st708;
		case 2102: goto tr1185;
		case 709: goto st709;
		case 1844: goto tr927;
		case 710: goto st710;
		case 2114: goto tr1197;
		case 711: goto st711;
		case 712: goto st712;
		case 1845: goto tr928;
		case 713: goto st713;
		case 2116: goto tr1199;
		case 714: goto st714;
		case 715: goto st715;
		case 2117: goto tr1200;
		case 716: goto st716;
		case 717: goto st717;
		case 1846: goto tr929;
		case 718: goto st718;
		case 2126: goto tr1209;
		case 719: goto st719;
		case 720: goto st720;
		case 1847: goto tr930;
		case 721: goto st721;
		case 2128: goto tr1211;
		case 722: goto st722;
		case 723: goto st723;
		case 2129: goto tr1212;
		case 724: goto st724;
		case 725: goto st725;
		case 1848: goto tr931;
		case 726: goto st726;
		case 2134: goto tr1217;
		case 727: goto st727;
		case 728: goto st728;
		case 729: goto st729;
		case 2135: goto tr1218;
		case 730: goto st730;
		case 731: goto st731;
		case 2136: goto tr1219;
		case 732: goto st732;
		case 1849: goto tr932;
		case 733: goto st733;
		case 2140: goto tr1223;
		case 734: goto st734;
		case 735: goto st735;
		case 2141: goto tr1224;
		case 736: goto st736;
		case 737: goto st737;
		case 1850: goto tr933;
		case 738: goto st738;
		case 2152: goto tr1235;
		case 2179: goto tr1262;
		case 739: goto st739;
		case 2153: goto tr1236;
		case 2180: goto tr1263;
		case 740: goto st740;
		case 741: goto st741;
		case 2154: goto tr1237;
		case 2181: goto tr1264;
		case 742: goto st742;
		case 2155: goto tr1238;
		case 2182: goto tr1265;
		case 743: goto st743;
		case 1851: goto tr934;
		case 744: goto st744;
		case 2157: goto tr1240;
		case 745: goto st745;
		case 746: goto st746;
		case 2158: goto tr1241;
		case 747: goto st747;
		case 748: goto st748;
		case 749: goto st749;
		case 2165: goto tr1248;
		case 750: goto st750;
		case 2166: goto tr1249;
		case 751: goto st751;
		case 2173: goto tr1256;
		case 752: goto st752;
		case 2174: goto tr1257;
		case 753: goto st753;
		case 754: goto st754;
		case 755: goto st755;
		case 2184: goto tr1267;
		case 756: goto st756;
		case 757: goto st757;
		case 2185: goto tr1268;
		case 758: goto st758;
		case 759: goto st759;
		case 760: goto st760;
		case 761: goto st761;
		case 762: goto st762;
		case 2201: goto tr1284;
		case 763: goto st763;
		case 764: goto st764;
		case 2192: goto tr1275;
		case 765: goto st765;
		case 2193: goto tr1276;
		case 766: goto st766;
		case 767: goto st767;
		case 768: goto st768;
		case 2194: goto tr1277;
		case 769: goto st769;
		case 770: goto st770;
		case 771: goto st771;
		case 2213: goto tr1296;
		case 772: goto st772;
		case 2214: goto tr1297;
		case 773: goto st773;
		case 774: goto st774;
		case 2215: goto tr1298;
		case 775: goto st775;
		case 2322: goto tr1405;
		case 776: goto st776;
		case 2323: goto tr1406;
		case 777: goto st777;
		case 778: goto st778;
		case 2233: goto tr1316;
		case 779: goto st779;
		case 2237: goto tr1320;
		case 780: goto st780;
		case 2234: goto tr1317;
		case 781: goto st781;
		case 2238: goto tr1321;
		case 2241: goto tr1324;
		case 782: goto st782;
		case 2235: goto tr1318;
		case 783: goto st783;
		case 2239: goto tr1322;
		case 784: goto st784;
		case 2236: goto tr1319;
		case 785: goto st785;
		case 2240: goto tr1323;
		case 2242: goto tr1325;
		case 786: goto st786;
		case 787: goto st787;
		case 788: goto st788;
		case 789: goto st789;
		case 790: goto st790;
		case 2243: goto tr1326;
		case 791: goto st791;
		case 2247: goto tr1330;
		case 792: goto st792;
		case 2244: goto tr1327;
		case 793: goto st793;
		case 2249: goto tr1332;
		case 2252: goto tr1335;
		case 794: goto st794;
		case 2245: goto tr1328;
		case 795: goto st795;
		case 2250: goto tr1333;
		case 796: goto st796;
		case 2246: goto tr1329;
		case 797: goto st797;
		case 2251: goto tr1334;
		case 2253: goto tr1336;
		case 798: goto st798;
		case 799: goto st799;
		case 800: goto st800;
		case 2254: goto tr1337;
		case 801: goto st801;
		case 802: goto st802;
		case 2255: goto tr1338;
		case 803: goto st803;
		case 1635: goto tr718;
		case 804: goto st804;
		case 2377: goto tr1460;
		case 805: goto st805;
		case 2378: goto tr1461;
		case 806: goto st806;
		case 807: goto st807;
		case 2380: goto tr1463;
		case 808: goto st808;
		case 2258: goto tr1341;
		case 2265: goto tr1348;
		case 908: goto st908;
		case 2404: goto tr1487;
		case 809: goto st809;
		case 2259: goto tr1342;
		case 810: goto st810;
		case 2260: goto tr1343;
		case 811: goto st811;
		case 2261: goto tr1344;
		case 909: goto st909;
		case 2405: goto tr1488;
		case 812: goto st812;
		case 813: goto st813;
		case 814: goto st814;
		case 2263: goto tr1346;
		case 815: goto st815;
		case 816: goto st816;
		case 2264: goto tr1347;
		case 817: goto st817;
		case 2381: goto tr1464;
		case 818: goto st818;
		case 819: goto st819;
		case 2266: goto tr1349;
		case 820: goto st820;
		case 2368: goto tr1451;
		case 821: goto st821;
		case 2267: goto tr1350;
		case 822: goto st822;
		case 2268: goto tr1351;
		case 2269: goto tr1352;
		case 2270: goto tr1353;
		case 910: goto st910;
		case 2409: goto tr1492;
		case 823: goto st823;
		case 824: goto st824;
		case 2410: goto tr1493;
		case 825: goto st825;
		case 2411: goto tr1494;
		case 826: goto st826;
		case 2412: goto tr1495;
		case 827: goto st827;
		case 828: goto st828;
		case 2413: goto tr1496;
		case 829: goto st829;
		case 2414: goto tr1497;
		case 830: goto st830;
		case 831: goto st831;
		case 2275: goto tr1358;
		case 832: goto st832;
		case 833: goto st833;
		case 2276: goto tr1359;
		case 834: goto st834;
		case 2352: goto tr1435;
		case 835: goto st835;
		case 836: goto st836;
		case 837: goto st837;
		case 2278: goto tr1361;
		case 838: goto st838;
		case 839: goto st839;
		case 2279: goto tr1362;
		case 840: goto st840;
		case 1421: goto tr504;
		case 841: goto st841;
		case 2340: goto tr1423;
		case 842: goto st842;
		case 2341: goto tr1424;
		case 843: goto st843;
		case 844: goto st844;
		case 2343: goto tr1426;
		case 845: goto st845;
		case 2282: goto tr1365;
		case 2288: goto tr1371;
		case 911: goto st911;
		case 2415: goto tr1498;
		case 846: goto st846;
		case 2283: goto tr1366;
		case 847: goto st847;
		case 2284: goto tr1367;
		case 848: goto st848;
		case 2285: goto tr1368;
		case 912: goto st912;
		case 2416: goto tr1499;
		case 849: goto st849;
		case 850: goto st850;
		case 851: goto st851;
		case 2286: goto tr1369;
		case 852: goto st852;
		case 853: goto st853;
		case 2287: goto tr1370;
		case 854: goto st854;
		case 2344: goto tr1427;
		case 855: goto st855;
		case 856: goto st856;
		case 2289: goto tr1372;
		case 857: goto st857;
		case 2337: goto tr1420;
		case 858: goto st858;
		case 2290: goto tr1373;
		case 859: goto st859;
		case 2292: goto tr1375;
		case 913: goto st913;
		case 2420: goto tr1503;
		case 860: goto st860;
		case 861: goto st861;
		case 2421: goto tr1504;
		case 862: goto st862;
		case 863: goto st863;
		case 2422: goto tr1505;
		case 864: goto st864;
		case 2291: goto tr1374;
		case 865: goto st865;
		case 2297: goto tr1380;
		case 914: goto st914;
		case 2423: goto tr1506;
		case 866: goto st866;
		case 867: goto st867;
		case 2424: goto tr1507;
		case 868: goto st868;
		case 869: goto st869;
		case 2425: goto tr1508;
		case 870: goto st870;
		case 2335: goto tr1418;
		case 871: goto st871;
		case 2302: goto tr1385;
		case 872: goto st872;
		case 2303: goto tr1386;
		case 2304: goto tr1387;
		case 2305: goto tr1388;
		case 915: goto st915;
		case 2426: goto tr1509;
		case 873: goto st873;
		case 874: goto st874;
		case 2427: goto tr1510;
		case 875: goto st875;
		case 2428: goto tr1511;
		case 876: goto st876;
		case 2429: goto tr1512;
		case 877: goto st877;
		case 878: goto st878;
		case 2430: goto tr1513;
		case 879: goto st879;
		case 2431: goto tr1514;
		case 880: goto st880;
		case 2336: goto tr1419;
		case 881: goto st881;
		case 2308: goto tr1391;
		case 882: goto st882;
		case 2309: goto tr1392;
		case 2310: goto tr1393;
		case 2311: goto tr1394;
		case 916: goto st916;
		case 2432: goto tr1515;
		case 883: goto st883;
		case 884: goto st884;
		case 2433: goto tr1516;
		case 885: goto st885;
		case 2434: goto tr1517;
		case 886: goto st886;
		case 2435: goto tr1518;
		case 887: goto st887;
		case 888: goto st888;
		case 2436: goto tr1519;
		case 889: goto st889;
		case 2437: goto tr1520;
		case 890: goto st890;
	default: break;
	}

	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof;
_resume:
	switch ( ( current_state) )
	{
tr0:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr7:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr8:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr13:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr14:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr17:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr18:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr25:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr26:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr31:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr32:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr35:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr42:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr43:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr48:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr49:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr52:
	{
    SET_IMM_TYPE(IMM8);
    SET_IMM_PTR(current_position);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr56:
	{
    SET_IMM_TYPE(IMM32);
    SET_IMM_PTR(current_position - 3);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr59:
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr61:
	{ SET_CPU_FEATURE(CPUFeature_3DNOW);     }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr69:
	{ SET_CPU_FEATURE(CPUFeature_TSC);       }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr78:
	{ SET_CPU_FEATURE(CPUFeature_MMX);       }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr96:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr100:
	{ SET_CPU_FEATURE(CPUFeature_MON);       }
	{  SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{ SET_OPERAND_NAME(0, REG_RDX); }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr101:
	{ SET_CPU_FEATURE(CPUFeature_MON);       }
	{  SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{ SET_OPERAND_NAME(0, REG_RCX); }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr102:
	{ SET_CPU_FEATURE(CPUFeature_FXSR);      }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr103:
	{ SET_CPU_FEATURE(CPUFeature_3DPRFTCH);  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr110:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr115:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr116:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr127:
	{
    instruction_info_collected |= LAST_BYTE_IS_NOT_IMMEDIATE;
  }
	{ SET_CPU_FEATURE(CPUFeature_E3DNOW);    }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr128:
	{
    instruction_info_collected |= LAST_BYTE_IS_NOT_IMMEDIATE;
  }
	{ SET_CPU_FEATURE(CPUFeature_3DNOW);     }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr138:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr145:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr146:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr153:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr172:
	{
    SET_IMM_TYPE(IMM8);
    SET_IMM_PTR(current_position);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr186:
	{
    Rel32Operand(current_position + 1, data, jump_dests, size,
                 &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr188:
	{ SET_CPU_FEATURE(CPUFeature_FXSR);      }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr191:
	{ SET_CPU_FEATURE(CPUFeature_CLFLUSH);   }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr202:
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr203:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr204:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_OPERAND_NAME(1, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process2Operands(&restricted_register, &instruction_info_collected,
                     rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr206:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_OPERAND_NAME(1, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process2OperandsZeroExtends(&restricted_register,
                                &instruction_info_collected, rex_prefix,
                                operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr216:
	{ SET_CPU_FEATURE(CPUFeature_CX8);       }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr226:
	{
    SET_IMM_TYPE(IMM32);
    SET_IMM_PTR(current_position - 3);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr230:
	{
    Rel8Operand(current_position + 1, data, jump_dests, size,
                &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr234:
	{
    SET_IMM_TYPE(IMM32);
    SET_IMM_PTR(current_position - 3);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr244:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{  SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr256:
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{ SET_OPERAND_TYPE(1, OPERAND_TYPE_32_BIT); }
	{ SET_OPERAND_NAME(1, REG_RAX); }
	{
    Process2OperandsZeroExtends(&restricted_register,
                                &instruction_info_collected, rex_prefix,
                                operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr257:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{ SET_OPERAND_TYPE(1, OPERAND_TYPE_32_BIT); }
	{ SET_OPERAND_NAME(1, REG_RAX); }
	{
    Process2OperandsZeroExtends(&restricted_register,
                                &instruction_info_collected, rex_prefix,
                                operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr258:
	{ SET_CPU_FEATURE(CPUFeature_x87);       }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr305:
	{
    SET_IMM_TYPE(IMM8);
    SET_IMM_PTR(current_position);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr344:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr351:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr356:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr357:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr360:
	{  SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr377:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr378:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr379:
	{ SET_CPU_FEATURE(CPUFeature_x87);       }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr386:
	{ SET_CPU_FEATURE(CPUFeature_CMOVx87);   }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr387:
	{ SET_CPU_FEATURE(CPUFeature_x87);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	{ SET_OPERAND_NAME(0, REG_RAX); }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr391:
	{
    Rel32Operand(current_position + 1, data, jump_dests, size,
                 &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
      if (((current_position - data) & kBundleMask) != kBundleMask)
        instruction_info_collected |= BAD_CALL_ALIGNMENT;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr392:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr405:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{ SET_OPERAND_TYPE(1, OPERAND_TYPE_64_BIT); }
	{ SET_OPERAND_NAME(1, REG_RAX); }
	{
    Process2Operands(&restricted_register, &instruction_info_collected,
                     rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr420:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr424:
	{ SET_CPU_FEATURE(CPUFeature_CX16);      }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr466:
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr467:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr474:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr479:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr480:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr490:
	{
    SET_IMM_TYPE(IMM64);
    SET_IMM_PTR(current_position - 7);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr492:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr499:
	{ if (restricted_register == REG_RSP)
         instruction_info_collected |= RESTRICTED_REGISTER_USED;
       else
         instruction_info_collected |= UNRESTRICTED_RSP_PROCESSED;
       restricted_register = NO_REG;
       UnmarkValidJumpTarget((instruction_start - data), valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr500:
	{ if (restricted_register == REG_RBP)
         instruction_info_collected |= RESTRICTED_REGISTER_USED;
       else
         instruction_info_collected |= UNRESTRICTED_RBP_PROCESSED;
       restricted_register = NO_REG;
       UnmarkValidJumpTarget((instruction_start - data), valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr510:
	{
       ExpandSuperinstructionBySandboxingBytes(
         3 /* mov */ + 4 /* lea */, &instruction_start, data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr544:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr555:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	{ SET_OPERAND_TYPE(1, OPERAND_TYPE_16_BIT); }
	{ SET_OPERAND_NAME(1, REG_RAX); }
	{
    Process2Operands(&restricted_register, &instruction_info_collected,
                     rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr565:
	{
    SET_IMM_TYPE(IMM16);
    SET_IMM_PTR(current_position - 1);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr587:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr626:
	{
    SET_IMM_TYPE(IMM16);
    SET_IMM_PTR(current_position - 1);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr662:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr704:
	{
      ProcessNaclCallOrJmpAddToRegNoRex(&instruction_info_collected,
                                        &instruction_start, current_position,
                                        data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
      if (((current_position - data) & kBundleMask) != kBundleMask)
        instruction_info_collected |= BAD_CALL_ALIGNMENT;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr705:
	{
      ProcessNaclCallOrJmpAddToRegNoRex(&instruction_info_collected,
                                        &instruction_start, current_position,
                                        data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr723:
	{
       ExpandSuperinstructionBySandboxingBytes(
         2 /* mov */ + 4 /* lea */ + 3 /* mov */ + 4 /* lea */
         /* == 3 (* mov *) + 4 (* lea *) + 2 (* mov *) + 4 (* lea *) */,
         &instruction_start, data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr730:
	{
       ExpandSuperinstructionBySandboxingBytes(
         2 /* mov */ + 4 /* lea */, &instruction_start, data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr769:
	{
    instruction_info_collected |= LAST_BYTE_IS_NOT_IMMEDIATE;
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr877:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr880:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr882:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr883:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr886:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr889:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr891:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr996:
	{
    SET_IMM_TYPE(IMM2);
    SET_IMM_PTR(current_position);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1084:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1087:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1226:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1229:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1231:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1234:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1299:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{
    Process0Operands(&restricted_register, &instruction_info_collected);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1340:
	{
       ExpandSuperinstructionBySandboxingBytes(
         2 /* mov */ + 4 /* lea */, &instruction_start, data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1345:
	{
       ExpandSuperinstructionBySandboxingBytes(
         2 /* mov */ + 4 /* lea */ + 2 /* mov */ + 4 /* lea */,
         &instruction_start, data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1355:
	{
      ProcessNaclCallOrJmpAddToRMNoRex(&instruction_info_collected,
                                       &instruction_start, current_position,
                                       data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
      if (((current_position - data) & kBundleMask) != kBundleMask)
        instruction_info_collected |= BAD_CALL_ALIGNMENT;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1356:
	{
      ProcessNaclCallOrJmpAddToRMNoRex(&instruction_info_collected,
                                       &instruction_start, current_position,
                                       data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1360:
	{
       ExpandSuperinstructionBySandboxingBytes(
         3 /* mov */ + 4 /* lea */ + 3 /* mov */ + 4 /* lea */,
         &instruction_start, data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1364:
	{
       ExpandSuperinstructionBySandboxingBytes(
         3 /* mov */ + 4 /* lea */, &instruction_start, data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1377:
	{
      ProcessNaclCallOrJmpAddToRMWithRex(&instruction_info_collected,
                                         &instruction_start, current_position,
                                         data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
      if (((current_position - data) & kBundleMask) != kBundleMask)
        instruction_info_collected |= BAD_CALL_ALIGNMENT;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1378:
	{
      ProcessNaclCallOrJmpAddToRMWithRex(&instruction_info_collected,
                                         &instruction_start, current_position,
                                         data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1382:
	{
      ProcessNaclCallOrJmpAddToRegWithRex(&instruction_info_collected,
                                          &instruction_start, current_position,
                                          data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
      if (((current_position - data) & kBundleMask) != kBundleMask)
        instruction_info_collected |= BAD_CALL_ALIGNMENT;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
tr1383:
	{
      ProcessNaclCallOrJmpAddToRegWithRex(&instruction_info_collected,
                                          &instruction_start, current_position,
                                          data, valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st891;
st891:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof891;
case 891:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2321, 2322, 2321, 2323, 2324, 2323, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr81:
	{ SET_CPU_FEATURE(CPUFeature_CMOV);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	goto st1;
tr83:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st1;
tr235:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	goto st1;
tr250:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	goto st1;
tr393:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st1;
tr496:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st1;
tr415:
	{ SET_CPU_FEATURE(CPUFeature_MMX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st1;
tr536:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st1;
tr551:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st1;
tr675:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st1;
tr1165:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st1;
st1:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof1;
case 1:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr139:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st2;
tr189:
	{ SET_CPU_FEATURE(CPUFeature_FXSR);      }
	goto st2;
tr192:
	{ SET_CPU_FEATURE(CPUFeature_CLFLUSH);   }
	goto st2;
tr217:
	{ SET_CPU_FEATURE(CPUFeature_CX8);       }
	goto st2;
tr380:
	{ SET_CPU_FEATURE(CPUFeature_x87);       }
	goto st2;
tr425:
	{ SET_CPU_FEATURE(CPUFeature_CX16);      }
	goto st2;
tr1027:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st2;
st2:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof2;
case 2:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 925;
		goto _again;
	}
tr2:
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr5:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr9:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st3;
tr16:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st3;
tr140:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr143:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr190:
	{ SET_CPU_FEATURE(CPUFeature_FXSR);      }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr193:
	{ SET_CPU_FEATURE(CPUFeature_CLFLUSH);   }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr198:
	{ SET_CPU_FEATURE(CPUFeature_FXSR);      }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr200:
	{ SET_CPU_FEATURE(CPUFeature_CLFLUSH);   }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr218:
	{ SET_CPU_FEATURE(CPUFeature_CX8);       }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr221:
	{ SET_CPU_FEATURE(CPUFeature_CX8);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr381:
	{ SET_CPU_FEATURE(CPUFeature_x87);       }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr384:
	{ SET_CPU_FEATURE(CPUFeature_x87);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr426:
	{ SET_CPU_FEATURE(CPUFeature_CX16);      }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr429:
	{ SET_CPU_FEATURE(CPUFeature_CX16);      }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr1086:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
tr1159:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st3;
st3:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof3;
case 3:
	goto st4;
st4:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof4;
case 4:
	goto st5;
st5:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof5;
case 5:
	goto st6;
st6:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof6;
case 6:
	goto tr13;
tr3:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st7;
tr15:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st7;
tr141:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st7;
tr194:
	{ SET_CPU_FEATURE(CPUFeature_FXSR);      }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st7;
tr196:
	{ SET_CPU_FEATURE(CPUFeature_CLFLUSH);   }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st7;
tr219:
	{ SET_CPU_FEATURE(CPUFeature_CX8);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st7;
tr382:
	{ SET_CPU_FEATURE(CPUFeature_x87);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st7;
tr427:
	{ SET_CPU_FEATURE(CPUFeature_CX16);      }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st7;
tr1085:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st7;
st7:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof7;
case 7:
	goto tr14;
tr142:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st8;
tr195:
	{ SET_CPU_FEATURE(CPUFeature_FXSR);      }
	goto st8;
tr197:
	{ SET_CPU_FEATURE(CPUFeature_CLFLUSH);   }
	goto st8;
tr220:
	{ SET_CPU_FEATURE(CPUFeature_CX8);       }
	goto st8;
tr383:
	{ SET_CPU_FEATURE(CPUFeature_x87);       }
	goto st8;
tr428:
	{ SET_CPU_FEATURE(CPUFeature_CX16);      }
	goto st8;
tr958:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st8;
st8:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof8;
case 8:
	goto tr15;
tr144:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st9;
tr199:
	{ SET_CPU_FEATURE(CPUFeature_FXSR);      }
	goto st9;
tr201:
	{ SET_CPU_FEATURE(CPUFeature_CLFLUSH);   }
	goto st9;
tr222:
	{ SET_CPU_FEATURE(CPUFeature_CX8);       }
	goto st9;
tr385:
	{ SET_CPU_FEATURE(CPUFeature_x87);       }
	goto st9;
tr430:
	{ SET_CPU_FEATURE(CPUFeature_CX16);      }
	goto st9;
tr959:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st9;
st9:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof9;
case 9:
	goto tr16;
tr79:
	{ SET_CPU_FEATURE(CPUFeature_MMX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st10;
tr236:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st10;
tr338:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st10;
tr578:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st10;
tr1163:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st10;
st10:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof10;
case 10:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr72:
	{ SET_CPU_FEATURE(CPUFeature_CMOV);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr89:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr237:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	goto st11;
tr252:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	goto st11;
tr394:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr497:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr413:
	{ SET_CPU_FEATURE(CPUFeature_CMOV);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr537:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st11;
tr552:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st11;
tr571:
	{ SET_CPU_FEATURE(CPUFeature_CMOV);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st11;
tr696:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE42);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr1174:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr1178:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr1162:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr1164:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr1281:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr1292:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr1294:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE42);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr1303:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr1306:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_POPCNT);    }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr1307:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_TZCNT);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr1308:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_LZCNT);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st11;
tr1312:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr1313:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_POPCNT);    }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr1314:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_TZCNT);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
tr1315:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_LZCNT);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st11;
st11:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof11;
case 11:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 935;
		goto _again;
	}
tr19:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st12;
tr862:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st12;
tr865:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st12;
tr1214:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st12;
tr1216:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st12;
st12:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof12;
case 12:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 943;
		goto _again;
	}
tr27:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st13;
tr34:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st13;
tr20:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
tr23:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
tr879:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
tr888:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
tr906:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
tr909:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
tr1228:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
tr1233:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
tr1243:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
tr1245:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st13;
st13:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof13;
case 13:
	goto st14;
st14:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof14;
case 14:
	goto st15;
st15:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof15;
case 15:
	goto st16;
st16:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof16;
case 16:
	goto tr31;
tr33:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st17;
tr21:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st17;
tr878:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st17;
tr887:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st17;
tr1227:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st17;
tr1232:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st17;
st17:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof17;
case 17:
	goto tr32;
tr22:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st18;
tr843:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st18;
tr848:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st18;
tr1203:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st18;
tr1207:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st18;
st18:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof18;
case 18:
	goto tr33;
tr24:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st19;
tr844:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st19;
tr849:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st19;
tr1204:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st19;
tr1208:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st19;
st19:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof19;
case 19:
	goto tr34;
tr85:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st20;
tr339:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st20;
st20:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof20;
case 20:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 952;
		goto _again;
	}
tr36:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st21;
st21:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof21;
case 21:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 960;
		goto _again;
	}
tr44:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st22;
tr51:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st22;
tr37:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st22;
tr40:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st22;
st22:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof22;
case 22:
	goto st23;
st23:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof23;
case 23:
	goto st24;
st24:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof24;
case 24:
	goto st25;
st25:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof25;
case 25:
	goto tr48;
tr50:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st26;
tr38:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st26;
st26:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof26;
case 26:
	goto tr49;
tr39:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st27;
st27:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof27;
case 27:
	goto tr50;
tr41:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st28;
st28:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof28;
case 28:
	goto tr51;
tr215:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
tr455:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st29;
tr460:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st29;
tr461:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st29;
tr187:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
tr205:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
tr238:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	{ SET_OPERAND_NAME(0, REG_RAX); }
	goto st29;
tr259:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	goto st29;
tr448:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st29;
tr315:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
tr368:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
tr423:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
tr611:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
tr614:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
tr679:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
tr1134:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st29;
st29:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof29;
case 29:
	goto tr52;
tr287:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st30;
tr288:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st30;
tr293:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st30;
tr294:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st30;
tr323:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st30;
tr239:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{ SET_OPERAND_NAME(0, REG_RAX); }
	goto st30;
tr260:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st30;
tr280:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st30;
tr376:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st30;
st30:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof30;
case 30:
	goto st31;
st31:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof31;
case 31:
	goto st32;
st32:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof32;
case 32:
	goto st33;
st33:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof33;
case 33:
	goto tr56;
tr57:
	{
        result &= user_callback(instruction_start, current_position,
                                UNRECOGNIZED_INSTRUCTION, callback_data);
        /*
         * Process the next bundle: “continue” here is for the “for” cycle in
         * the ValidateChunkAMD64 function.
         *
         * It does not affect the case which we really care about (when code
         * is validatable), but makes it possible to detect more errors in one
         * run in tools like ncval.
         */
        continue;
    }
	goto st0;
st0:
( current_state) = 0;
	goto _out;
st34:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof34;
case 34:
	{
		static const unsigned short jump_table[] = { 974, 35, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 974, 36, 978, 45, 980, 980, 56, 982, 980, 980, 56, 982, 58, 974, 974, 974, 974, 974, 974, 59, 974, 974, 974, 974, 974, 974, 974, 974, 980, 980, 985, 982, 985, 985, 980, 980, 974, 986, 974, 974, 974, 974, 974, 974, 60, 974, 62, 974, 974, 974, 974, 974, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 990, 980, 980, 980, 980, 980, 980, 980, 980, 980, 985, 985, 980, 980, 980, 980, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 974, 974, 991, 991, 992, 74, 74, 75, 991, 991, 991, 995, 974, 974, 974, 974, 974, 974, 996, 991, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 974, 974, 976, 974, 999, 1000, 974, 974, 974, 974, 974, 974, 999, 1000, 81, 1002, 1003, 1004, 974, 974, 974, 974, 1002, 1002, 974, 974, 83, 974, 1006, 1006, 1002, 1002, 1003, 1007, 1008, 1009, 85, 1011, 1008, 87, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 974, 991, 991, 991, 985, 991, 974, 1014, 991, 991, 1015, 991, 991, 991, 1015, 991, 1015, 991, 991, 1015, 1015, 991, 974, 1016, 991, 991, 1015, 991, 991, 991, 1015, 991, 974, 991, 991, 991, 985, 991, 1015, 974, 991, 991, 991, 985, 991, 991, 991, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st35:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof35;
case 35:
	switch( (*( current_position)) ) {
		case 200u: goto tr100;
		case 201u: goto tr101;
		case 208u: goto tr102;
	}
	goto tr57;
st36:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof36;
case 36:
	{
		static const unsigned char jump_table[] = { 46, 46, 46, 46, 47, 48, 46, 46, 46, 46, 46, 46, 47, 48, 46, 46, 0, 0, 0, 0, 0, 0, 0, 0, 46, 46, 46, 46, 47, 48, 46, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 49, 49, 49, 50, 49, 49, 49, 49, 49, 49, 49, 50, 49, 49, 49, 0, 0, 0, 0, 0, 0, 0, 0, 49, 49, 49, 49, 50, 49, 49, 49, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 51, 52, 51, 51, 51, 51, 51, 51, 51, 52, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 51, 51, 51, 51, 52, 51, 51, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 974;
		goto _again;
	}
tr147:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st37;
tr104:
	{ SET_CPU_FEATURE(CPUFeature_3DPRFTCH);  }
	goto st37;
st37:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof37;
case 37:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1027;
		goto _again;
	}
tr155:
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st38;
tr158:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st38;
tr111:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st38;
tr118:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st38;
tr105:
	{ SET_CPU_FEATURE(CPUFeature_3DPRFTCH);  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st38;
tr108:
	{ SET_CPU_FEATURE(CPUFeature_3DPRFTCH);  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st38;
tr148:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st38;
tr151:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st38;
st38:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof38;
case 38:
	goto st39;
st39:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof39;
case 39:
	goto st40;
st40:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof40;
case 40:
	goto st41;
st41:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof41;
case 41:
	goto tr115;
tr156:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st42;
tr117:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st42;
tr106:
	{ SET_CPU_FEATURE(CPUFeature_3DPRFTCH);  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st42;
tr149:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st42;
st42:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof42;
case 42:
	goto tr116;
tr150:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st43;
tr107:
	{ SET_CPU_FEATURE(CPUFeature_3DPRFTCH);  }
	goto st43;
st43:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof43;
case 43:
	goto tr117;
tr152:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st44;
tr109:
	{ SET_CPU_FEATURE(CPUFeature_3DPRFTCH);  }
	goto st44;
st44:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof44;
case 44:
	goto tr118;
st45:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof45;
case 45:
	{
		static const unsigned short jump_table[] = { 1036, 1036, 1036, 1036, 47, 1038, 1036, 1036, 1036, 1036, 1036, 1036, 47, 1038, 1036, 1036, 1036, 1036, 1036, 1036, 47, 1038, 1036, 1036, 1036, 1036, 1036, 1036, 47, 1038, 1036, 1036, 1036, 1036, 1036, 1036, 47, 1038, 1036, 1036, 1036, 1036, 1036, 1036, 47, 1038, 1036, 1036, 1036, 1036, 1036, 1036, 47, 1038, 1036, 1036, 1036, 1036, 1036, 1036, 47, 1038, 1036, 1036, 1039, 1039, 1039, 1039, 53, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 53, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 53, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 53, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 53, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 53, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 53, 1039, 1039, 1039, 1039, 1039, 1039, 1039, 53, 1039, 1039, 1039, 1041, 1041, 1041, 1041, 54, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 54, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 54, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 54, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 54, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 54, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 54, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 54, 1041, 1041, 1041, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr119:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st46;
tr129:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st46;
tr134:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st46;
tr135:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st46;
st46:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof46;
case 46:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 0, 0, 0, 70, 0, 71, 0, 0, 0, 71, 0, 71, 71, 0, 0, 71, 0, 0, 0, 71, 0, 71, 0, 0, 0, 71, 0, 71, 71, 0, 0, 71, 0, 0, 0, 71, 0, 71, 0, 0, 0, 71, 0, 71, 71, 0, 0, 0, 70, 0, 0, 0, 71, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 974;
		goto _again;
	}
st47:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof47;
case 47:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1046;
		goto _again;
	}
tr121:
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st48;
tr124:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st48;
tr130:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st48;
tr137:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st48;
st48:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof48;
case 48:
	goto st49;
st49:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof49;
case 49:
	goto st50;
st50:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof50;
case 50:
	goto st51;
st51:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof51;
case 51:
	goto tr134;
tr122:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st52;
tr136:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st52;
st52:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof52;
case 52:
	goto tr135;
st53:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof53;
case 53:
	goto tr136;
st54:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof54;
case 54:
	goto tr137;
tr63:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st55;
tr68:
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st55;
tr74:
	{ SET_CPU_FEATURE(CPUFeature_MMX);       }
	goto st55;
tr98:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	goto st55;
tr160:
	{ SET_CPU_FEATURE(CPUFeature_SSSE3);     }
	goto st55;
tr566:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st55;
tr577:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE3);      }
	goto st55;
tr590:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSSE3);     }
	goto st55;
tr591:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	goto st55;
tr593:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE42);     }
	goto st55;
tr594:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_AES);       }
	goto st55;
tr832:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st55;
tr1156:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st55;
tr1175:
	{ SET_CPU_FEATURE(CPUFeature_FMA);       }
	goto st55;
tr1176:
	{ SET_CPU_FEATURE(CPUFeature_AESAVX);    }
	goto st55;
tr1177:
	{ SET_CPU_FEATURE(CPUFeature_F16C);      }
	goto st55;
tr1278:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st55;
tr1279:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE3);      }
	goto st55;
tr1286:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st55;
tr1300:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st55;
tr1301:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE3);      }
	goto st55;
tr1304:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st55;
st55:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof55;
case 55:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st56:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof56;
case 56:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 1055;
		goto _again;
	}
tr65:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st57;
tr92:
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st57;
tr99:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	goto st57;
tr162:
	{ SET_CPU_FEATURE(CPUFeature_MOVBE);     }
	goto st57;
tr567:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st57;
tr592:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	goto st57;
tr1157:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st57;
tr1288:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE3);      }
	goto st57;
tr1280:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE4A);     }
	goto st57;
tr1302:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE4A);     }
	goto st57;
st57:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof57;
case 57:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st58:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof58;
case 58:
	{
		static const unsigned char jump_table[] = { 89, 89, 89, 89, 90, 91, 89, 89, 89, 89, 89, 89, 90, 91, 89, 89, 89, 89, 89, 89, 90, 91, 89, 89, 89, 89, 89, 89, 90, 91, 89, 89, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 92, 92, 92, 92, 93, 92, 92, 92, 92, 92, 92, 92, 93, 92, 92, 92, 92, 92, 92, 92, 93, 92, 92, 92, 92, 92, 92, 92, 93, 92, 92, 92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94, 94, 94, 94, 95, 94, 94, 94, 94, 94, 94, 94, 95, 94, 94, 94, 94, 94, 94, 94, 95, 94, 94, 94, 94, 94, 94, 94, 95, 94, 94, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 974;
		goto _again;
	}
st59:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof59;
case 59:
	switch( (*( current_position)) ) {
		case 4u: goto st37;
		case 5u: goto tr155;
		case 68u: goto st43;
		case 132u: goto st44;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 7u )
			goto tr153;
	} else if ( (*( current_position)) > 71u ) {
		if ( (*( current_position)) > 135u ) {
			if ( 192u <= (*( current_position)) && (*( current_position)) <= 199u )
				goto tr59;
		} else if ( (*( current_position)) >= 128u )
			goto tr158;
	} else
		goto tr156;
	goto tr57;
st60:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof60;
case 60:
	switch( (*( current_position)) ) {
		case 4u: goto tr74;
		case 240u: goto tr161;
		case 241u: goto tr162;
	}
	if ( (*( current_position)) > 11u ) {
		if ( 28u <= (*( current_position)) && (*( current_position)) <= 30u )
			goto tr160;
	} else
		goto tr160;
	goto tr57;
tr1271:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st61;
tr161:
	{ SET_CPU_FEATURE(CPUFeature_MOVBE);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st61;
tr1270:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	goto st61;
tr1273:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st61;
tr422:
	{ SET_CPU_FEATURE(CPUFeature_MOVBE);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st61;
tr689:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st61;
tr595:
	{ SET_CPU_FEATURE(CPUFeature_MOVBE);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st61;
st61:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof61;
case 61:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39, 39 };
		( current_state) = jump_table[(*( current_position))] + 935;
		goto _again;
	}
st62:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof62;
case 62:
	if ( (*( current_position)) == 15u )
		goto tr163;
	goto tr57;
tr91:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st63;
tr75:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	goto st63;
tr163:
	{ SET_CPU_FEATURE(CPUFeature_SSSE3);     }
	goto st63;
tr573:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st63;
tr597:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSSE3);     }
	goto st63;
tr596:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	goto st63;
tr602:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE42);     }
	goto st63;
tr603:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_AES);       }
	goto st63;
tr601:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_CLMUL);     }
	goto st63;
tr827:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st63;
tr1158:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st63;
tr1190:
	{ SET_CPU_FEATURE(CPUFeature_AESAVX);    }
	goto st63;
tr1195:
	{ SET_CPU_FEATURE(CPUFeature_F16C);      }
	goto st63;
tr1186:
	{ SET_CPU_FEATURE(CPUFeature_CLMULAVX);  }
	goto st63;
tr1283:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st63;
tr1309:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st63;
tr1305:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st63;
st63:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof63;
case 63:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr182:
	{ SET_CPU_FEATURE(CPUFeature_MMX);       }
	goto st64;
tr214:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	goto st64;
tr164:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st64;
tr173:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st64;
tr178:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st64;
tr179:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st64;
tr207:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st64;
tr361:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st64;
tr613:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st64;
tr612:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	goto st64;
tr604:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st64;
tr615:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st64;
tr622:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st64;
tr1096:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st64;
tr1093:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st64;
tr1290:
	{
    SET_IMM2_TYPE(IMM8);
    SET_IMM2_PTR(current_position);
  }
	goto st64;
st64:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof64;
case 64:
	goto tr172;
tr208:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	goto st65;
tr362:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st65;
tr605:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	goto st65;
tr616:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st65;
tr1029:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st65;
st65:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof65;
case 65:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1090;
		goto _again;
	}
tr166:
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr169:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr174:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st66;
tr181:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st66;
tr209:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr212:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr363:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr366:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr606:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr609:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr617:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr620:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr1095:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
tr1161:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st66;
st66:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof66;
case 66:
	goto st67;
st67:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof67;
case 67:
	goto st68;
st68:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof68;
case 68:
	goto st69;
st69:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof69;
case 69:
	goto tr178;
tr167:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st70;
tr180:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st70;
tr210:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st70;
tr364:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st70;
tr607:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st70;
tr618:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st70;
tr1094:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st70;
st70:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof70;
case 70:
	goto tr179;
tr211:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	goto st71;
tr365:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st71;
tr608:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	goto st71;
tr619:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st71;
tr962:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st71;
st71:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof71;
case 71:
	goto tr180;
tr213:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	goto st72;
tr367:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st72;
tr610:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	goto st72;
tr621:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	goto st72;
tr963:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st72;
st72:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof72;
case 72:
	goto tr181;
tr73:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st73;
tr97:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st73;
tr414:
	{ SET_CPU_FEATURE(CPUFeature_SSE);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st73;
tr421:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st73;
tr572:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st73;
tr674:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st73;
tr1089:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st73;
st73:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof73;
case 73:
	if ( 192u <= (*( current_position)) )
		goto tr25;
	goto tr57;
st74:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof74;
case 74:
	if ( (*( current_position)) < 224u ) {
		if ( 208u <= (*( current_position)) && (*( current_position)) <= 215u )
			goto tr182;
	} else if ( (*( current_position)) > 231u ) {
		if ( 240u <= (*( current_position)) && (*( current_position)) <= 247u )
			goto tr182;
	} else
		goto tr182;
	goto tr57;
st75:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof75;
case 75:
	if ( (*( current_position)) > 215u ) {
		if ( 240u <= (*( current_position)) && (*( current_position)) <= 247u )
			goto tr182;
	} else if ( (*( current_position)) >= 208u )
		goto tr182;
	goto tr57;
st76:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof76;
case 76:
	goto st77;
st77:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof77;
case 77:
	goto st78;
st78:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof78;
case 78:
	goto st79;
st79:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof79;
case 79:
	goto tr186;
tr82:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st80;
tr416:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st80;
tr579:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st80;
tr599:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st80;
tr678:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE41);     }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st80;
tr1193:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st80;
tr1196:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st80;
st80:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof80;
case 80:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st81:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof81;
case 81:
	{
		static const unsigned char jump_table[] = { 131, 131, 131, 131, 132, 133, 131, 131, 131, 131, 131, 131, 132, 133, 131, 131, 81, 81, 81, 81, 82, 83, 81, 81, 81, 81, 81, 81, 82, 83, 81, 81, 131, 131, 131, 131, 132, 133, 131, 131, 131, 131, 131, 131, 132, 133, 131, 131, 131, 131, 131, 131, 132, 133, 131, 131, 134, 134, 134, 134, 135, 136, 134, 134, 137, 137, 137, 137, 138, 137, 137, 137, 137, 137, 137, 137, 138, 137, 137, 137, 84, 84, 84, 84, 85, 84, 84, 84, 84, 84, 84, 84, 85, 84, 84, 84, 137, 137, 137, 137, 138, 137, 137, 137, 137, 137, 137, 137, 138, 137, 137, 137, 137, 137, 137, 137, 138, 137, 137, 137, 139, 139, 139, 139, 140, 139, 139, 139, 141, 141, 141, 141, 142, 141, 141, 141, 141, 141, 141, 141, 142, 141, 141, 141, 86, 86, 86, 86, 87, 86, 86, 86, 86, 86, 86, 86, 87, 86, 86, 86, 141, 141, 141, 141, 142, 141, 141, 141, 141, 141, 141, 141, 142, 141, 141, 141, 141, 141, 141, 141, 142, 141, 141, 141, 143, 143, 143, 143, 144, 143, 143, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 0, 0, 0, 0, 0, 0, 0, 145, 0, 0, 0, 0, 0, 0, 0, 146, 0, 0, 0, 0, 0, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 974;
		goto _again;
	}
tr86:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_8_BIT); }
	{ SET_OPERAND_TYPE(1, OPERAND_TYPE_8_BIT); }
	goto st82;
tr87:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{ SET_OPERAND_TYPE(1, OPERAND_TYPE_32_BIT); }
	goto st82;
tr401:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{ SET_OPERAND_TYPE(1, OPERAND_TYPE_64_BIT); }
	goto st82;
tr550:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	{ SET_OPERAND_TYPE(1, OPERAND_TYPE_16_BIT); }
	goto st82;
st82:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof82;
case 82:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186, 186 };
		( current_state) = jump_table[(*( current_position))] + 935;
		goto _again;
	}
st83:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof83;
case 83:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 64, 64, 64, 64, 64, 64, 64, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr90:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{ SET_OPERAND_TYPE(1, OPERAND_TYPE_32_BIT); }
	goto st84;
st84:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof84;
case 84:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188, 188 };
		( current_state) = jump_table[(*( current_position))] + 935;
		goto _again;
	}
st85:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof85;
case 85:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 1124;
		goto _again;
	}
tr94:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st86;
tr418:
	{ SET_CPU_FEATURE(CPUFeature_EMMXSSE);   }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st86;
tr582:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st86;
tr676:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st86;
tr1091:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st86;
st86:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof86;
case 86:
	if ( 192u <= (*( current_position)) )
		goto tr215;
	goto tr57;
st87:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof87;
case 87:
	switch( (*( current_position)) ) {
		case 12u: goto tr217;
		case 13u: goto tr218;
		case 76u: goto tr220;
		case 140u: goto tr222;
	}
	if ( (*( current_position)) < 72u ) {
		if ( 8u <= (*( current_position)) && (*( current_position)) <= 15u )
			goto tr216;
	} else if ( (*( current_position)) > 79u ) {
		if ( 136u <= (*( current_position)) && (*( current_position)) <= 143u )
			goto tr221;
	} else
		goto tr219;
	goto tr57;
tr438:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st88;
tr439:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st88;
tr444:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st88;
tr445:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st88;
tr324:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st88;
tr241:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{ SET_OPERAND_NAME(0, REG_RAX); }
	goto st88;
tr431:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st88;
tr395:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{ SET_OPERAND_NAME(0, REG_RAX); }
	goto st88;
tr464:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st88;
tr491:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st88;
st88:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof88;
case 88:
	goto st89;
st89:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof89;
case 89:
	goto st90;
st90:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof90;
case 90:
	goto st91;
st91:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof91;
case 91:
	goto tr226;
st92:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof92;
case 92:
	switch( (*( current_position)) ) {
		case 15u: goto st93;
		case 227u: goto st95;
	}
	if ( (*( current_position)) > 79u ) {
		if ( 112u <= (*( current_position)) && (*( current_position)) <= 127u )
			goto st95;
	} else if ( (*( current_position)) >= 64u )
		goto tr228;
	goto tr57;
st93:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof93;
case 93:
	if ( 128u <= (*( current_position)) && (*( current_position)) <= 143u )
		goto st76;
	goto tr57;
tr228:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st94;
st94:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof94;
case 94:
	switch( (*( current_position)) ) {
		case 15u: goto st93;
		case 227u: goto st95;
	}
	if ( 112u <= (*( current_position)) && (*( current_position)) <= 127u )
		goto st95;
	goto tr57;
st95:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof95;
case 95:
	goto tr230;
tr316:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st96;
tr325:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st96;
tr330:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st96;
tr331:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st96;
tr369:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st96;
tr899:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	goto st96;
tr896:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st96;
st96:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof96;
case 96:
	goto st97;
st97:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof97;
case 97:
	goto st98;
st98:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof98;
case 98:
	goto st99;
st99:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof99;
case 99:
	goto tr234;
tr1399:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st100;
st100:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof100;
case 100:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 101, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1168, 1169, 1170, 974, 1171, 974, 148, 1173, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st101:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof101;
case 101:
	{
		static const unsigned short jump_table[] = { 974, 35, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 36, 978, 45, 980, 980, 56, 982, 980, 980, 56, 982, 58, 974, 974, 974, 974, 974, 974, 59, 974, 974, 974, 974, 974, 974, 974, 974, 980, 980, 985, 982, 985, 985, 980, 980, 974, 986, 974, 974, 974, 974, 974, 974, 60, 974, 62, 974, 974, 974, 974, 974, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 990, 980, 980, 980, 980, 980, 980, 980, 980, 980, 985, 985, 980, 980, 980, 980, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 974, 974, 991, 991, 992, 74, 74, 75, 991, 991, 991, 995, 974, 974, 974, 974, 974, 974, 996, 991, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 974, 974, 976, 974, 999, 1000, 974, 974, 974, 974, 974, 974, 999, 1000, 81, 1002, 1003, 1004, 974, 974, 974, 974, 1002, 1002, 974, 974, 83, 974, 1006, 1006, 1002, 1002, 1003, 1007, 1008, 1009, 85, 1011, 1008, 87, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 974, 991, 991, 991, 985, 991, 974, 1014, 991, 991, 1015, 991, 991, 991, 1015, 991, 1015, 991, 991, 1015, 1015, 991, 974, 1016, 991, 991, 1015, 991, 991, 991, 1015, 991, 974, 991, 991, 991, 985, 991, 1015, 974, 991, 991, 991, 985, 991, 991, 991, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr245:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st102;
st102:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof102;
case 102:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 1197;
		goto _again;
	}
tr281:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st103;
st103:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof103;
case 103:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1205;
		goto _again;
	}
tr289:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st104;
tr296:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st104;
tr282:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st104;
tr285:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st104;
st104:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof104;
case 104:
	goto st105;
st105:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof105;
case 105:
	goto st106;
st106:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof106;
case 106:
	goto st107;
st107:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof107;
case 107:
	goto tr293;
tr295:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st108;
tr283:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st108;
st108:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof108;
case 108:
	goto tr294;
tr284:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st109;
st109:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof109;
case 109:
	goto tr295;
tr286:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st110;
st110:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof110;
case 110:
	goto tr296;
tr246:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st111;
st111:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof111;
case 111:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 1214;
		goto _again;
	}
tr304:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st112;
tr306:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st112;
tr311:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st112;
tr312:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st112;
tr334:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st112;
tr297:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st112;
st112:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof112;
case 112:
	goto tr305;
tr298:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st113;
st113:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof113;
case 113:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1223;
		goto _again;
	}
tr307:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st114;
tr314:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st114;
tr299:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st114;
tr302:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st114;
st114:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof114;
case 114:
	goto st115;
st115:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof115;
case 115:
	goto st116;
st116:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof116;
case 116:
	goto st117;
st117:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof117;
case 117:
	goto tr311;
tr313:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st118;
tr300:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st118;
st118:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof118;
case 118:
	goto tr312;
tr301:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st119;
st119:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof119;
case 119:
	goto tr313;
tr303:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st120;
st120:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof120;
case 120:
	goto tr314;
st121:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof121;
case 121:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 64, 64, 64, 64, 64, 64, 64, 64 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st122:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof122;
case 122:
	{
		static const unsigned short jump_table[] = { 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1241, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 1240, 96, 96, 96, 96, 96, 96, 96, 96 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr370:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st123;
tr870:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	goto st123;
st123:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof123;
case 123:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1242;
		goto _again;
	}
tr318:
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st124;
tr321:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st124;
tr326:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st124;
tr333:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st124;
tr371:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st124;
tr374:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st124;
tr898:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st124;
tr914:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st124;
st124:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof124;
case 124:
	goto st125;
st125:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof125;
case 125:
	goto st126;
st126:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof126;
case 126:
	goto st127;
st127:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof127;
case 127:
	goto tr330;
tr319:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st128;
tr332:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st128;
tr372:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st128;
tr897:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st128;
st128:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof128;
case 128:
	goto tr331;
tr373:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st129;
tr855:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	goto st129;
st129:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof129;
case 129:
	goto tr332;
tr375:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st130;
tr856:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	goto st130;
st130:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof130;
case 130:
	goto tr333;
st131:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof131;
case 131:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1252, 1252, 1252, 1252, 1252, 1252, 1252, 1252, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 64, 64, 64, 64, 64, 64, 64, 64 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr335:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st132;
st132:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof132;
case 132:
	if ( (*( current_position)) == 224u )
		goto tr336;
	goto tr305;
tr336:
	{
    SET_IMM_TYPE(IMM8);
    SET_IMM_PTR(current_position);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st892;
st892:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof892;
case 892:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2335, 2322, 2335, 2336, 2324, 2336, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1400:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st133;
st133:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof133;
case 133:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 101, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 134, 55, 55, 1003, 1007, 1167, 1255, 1169, 1256, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st134:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof134;
case 134:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1257, 1257, 1257, 1257, 1257, 1257, 1257, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 64, 64, 64, 64, 64, 64, 64, 64 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr340:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st135;
st135:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof135;
case 135:
	if ( (*( current_position)) == 224u )
		goto tr341;
	goto tr305;
tr341:
	{
    SET_IMM_TYPE(IMM8);
    SET_IMM_PTR(current_position);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st893;
st893:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof893;
case 893:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2321, 2322, 2321, 2323, 2337, 2323, 2337, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1401:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st136;
st136:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof136;
case 136:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 101, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1168, 1169, 1170, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr251:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st137;
st137:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof137;
case 137:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 1259, 934, 934, 934, 934, 934, 934, 934, 934, 1260 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr342:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st894;
tr512:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st894;
st894:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof894;
case 894:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2338, 2322, 2321, 2323, 2324, 2323, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1402:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st138;
st138:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof138;
case 138:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 101, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1255, 1169, 1256, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr254:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st139;
st139:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof139;
case 139:
	{
		static const unsigned short jump_table[] = { 1261, 1261, 1261, 1261, 1262, 1263, 1261, 1261, 1261, 1261, 1261, 1261, 1262, 1263, 1261, 1261, 1261, 1261, 1261, 1261, 1262, 1263, 1261, 1261, 1261, 1261, 1261, 1261, 1262, 1263, 1261, 1261, 1261, 1261, 1261, 1261, 1262, 1263, 1261, 1261, 1261, 1261, 1261, 1261, 1262, 1263, 1261, 1261, 1261, 1261, 1261, 1261, 1262, 1263, 1261, 1261, 1261, 1261, 1261, 1261, 1262, 1263, 1261, 1261, 1264, 1264, 1264, 1264, 1265, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1265, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1265, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1265, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1265, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1265, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1265, 1264, 1264, 1264, 1264, 1264, 1264, 1264, 1265, 1264, 1264, 1264, 1266, 1266, 1266, 1266, 1267, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1267, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1267, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1267, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1267, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1267, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1267, 1266, 1266, 1266, 1266, 1266, 1266, 1266, 1267, 1266, 1266, 1266, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr345:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st140;
st140:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof140;
case 140:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1268;
		goto _again;
	}
tr352:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st141;
tr359:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st141;
tr346:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st141;
tr349:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st141;
st141:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof141;
case 141:
	goto st142;
st142:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof142;
case 142:
	goto st143;
st143:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof143;
case 143:
	goto st144;
st144:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof144;
case 144:
	goto tr356;
tr358:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st145;
tr347:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st145;
st145:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof145;
case 145:
	goto tr357;
tr348:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st146;
st146:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof146;
case 146:
	goto tr358;
tr350:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st147;
st147:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof147;
case 147:
	goto tr359;
st148:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof148;
case 148:
	switch( (*( current_position)) ) {
		case 4u: goto st2;
		case 5u: goto tr2;
		case 68u: goto st8;
		case 132u: goto st9;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 7u )
			goto tr0;
	} else if ( (*( current_position)) > 71u ) {
		if ( (*( current_position)) > 135u ) {
			if ( 192u <= (*( current_position)) && (*( current_position)) <= 199u )
				goto tr360;
		} else if ( (*( current_position)) >= 128u )
			goto tr5;
	} else
		goto tr3;
	goto tr57;
st149:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof149;
case 149:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 974, 974, 974, 974, 974, 974, 974, 974, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st150:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof150;
case 150:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 974, 974, 974, 974, 974, 974, 974, 974, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st151:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof151;
case 151:
	switch( (*( current_position)) ) {
		case 4u: goto tr362;
		case 5u: goto tr363;
		case 68u: goto tr365;
		case 132u: goto tr367;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 7u )
			goto tr361;
	} else if ( (*( current_position)) > 71u ) {
		if ( (*( current_position)) > 135u ) {
			if ( 192u <= (*( current_position)) && (*( current_position)) <= 199u )
				goto tr368;
		} else if ( (*( current_position)) >= 128u )
			goto tr366;
	} else
		goto tr364;
	goto tr57;
st152:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof152;
case 152:
	switch( (*( current_position)) ) {
		case 4u: goto tr370;
		case 5u: goto tr371;
		case 68u: goto tr373;
		case 132u: goto tr375;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 7u )
			goto tr369;
	} else if ( (*( current_position)) > 71u ) {
		if ( (*( current_position)) > 135u ) {
			if ( 192u <= (*( current_position)) && (*( current_position)) <= 199u )
				goto tr376;
		} else if ( (*( current_position)) >= 128u )
			goto tr374;
	} else
		goto tr372;
	goto tr57;
st153:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof153;
case 153:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 974, 974, 974, 974, 974, 974, 974, 974, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st154:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof154;
case 154:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 974, 974, 974, 974, 974, 974, 974, 974, 1295, 1295, 1295, 1295, 1295, 1295, 1295, 1295 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st155:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof155;
case 155:
	{
		static const unsigned char jump_table[] = { 121, 121, 121, 121, 122, 123, 121, 121, 121, 121, 121, 121, 122, 123, 121, 121, 121, 121, 121, 121, 122, 123, 121, 121, 121, 121, 121, 121, 122, 123, 121, 121, 121, 121, 121, 121, 122, 123, 121, 121, 121, 121, 121, 121, 122, 123, 121, 121, 121, 121, 121, 121, 122, 123, 121, 121, 121, 121, 121, 121, 122, 123, 121, 121, 124, 124, 124, 124, 125, 124, 124, 124, 124, 124, 124, 124, 125, 124, 124, 124, 124, 124, 124, 124, 125, 124, 124, 124, 124, 124, 124, 124, 125, 124, 124, 124, 124, 124, 124, 124, 125, 124, 124, 124, 124, 124, 124, 124, 125, 124, 124, 124, 124, 124, 124, 124, 125, 124, 124, 124, 124, 124, 124, 124, 125, 124, 124, 124, 126, 126, 126, 126, 127, 126, 126, 126, 126, 126, 126, 126, 127, 126, 126, 126, 126, 126, 126, 126, 127, 126, 126, 126, 126, 126, 126, 126, 127, 126, 126, 126, 126, 126, 126, 126, 127, 126, 126, 126, 126, 126, 126, 126, 127, 126, 126, 126, 126, 126, 126, 126, 127, 126, 126, 126, 126, 126, 126, 126, 127, 126, 126, 126, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1175;
		goto _again;
	}
st156:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof156;
case 156:
	{
		static const unsigned short jump_table[] = { 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 974, 974, 974, 974, 974, 974, 974, 974, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 974, 974, 974, 974, 974, 974, 974, 974, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 974, 974, 974, 974, 974, 974, 974, 974, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1175, 1175, 974, 974, 1175, 1175, 974, 974, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 974, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st157:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof157;
case 157:
	{
		static const unsigned short jump_table[] = { 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st158:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof158;
case 158:
	{
		static const unsigned short jump_table[] = { 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 974, 974, 974, 974, 974, 974, 974, 974, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 974, 974, 974, 974, 974, 974, 974, 974, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 974, 974, 974, 974, 974, 974, 974, 974, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 974, 974, 974, 974, 974, 974, 974, 974, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 974, 974, 974, 974, 974, 974, 974, 974, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 974, 974, 974, 974, 974, 974, 974, 974, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 1303, 974, 974, 1175, 1175, 974, 974, 974, 974, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st159:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof159;
case 159:
	{
		static const unsigned short jump_table[] = { 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st160:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof160;
case 160:
	{
		static const unsigned short jump_table[] = { 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 974, 974, 974, 974, 974, 974, 974, 974, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 974, 974, 974, 974, 974, 974, 974, 974, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 974, 974, 974, 974, 974, 974, 974, 974, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st161:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof161;
case 161:
	{
		static const unsigned short jump_table[] = { 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1175, 974, 974, 974, 974, 974, 974, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st162:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof162;
case 162:
	{
		static const unsigned short jump_table[] = { 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1296, 1296, 1296, 1296, 1297, 1298, 1296, 1296, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1299, 1299, 1299, 1299, 1300, 1299, 1299, 1299, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 1302, 1301, 1301, 1301, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1304, 974, 974, 974, 974, 974, 974, 974, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 1175, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr275:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st163;
st163:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof163;
case 163:
	goto st164;
st164:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof164;
case 164:
	goto st165;
st165:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof165;
case 165:
	goto st166;
st166:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof166;
case 166:
	goto tr391;
st167:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof167;
case 167:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 64, 64, 64, 64, 64, 64, 64, 64, 974, 974, 974, 974, 974, 974, 974, 974, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st168:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof168;
case 168:
	{
		static const unsigned short jump_table[] = { 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 96, 96, 96, 96, 96, 96, 96, 96, 974, 974, 974, 974, 974, 974, 974, 974, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st169:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof169;
case 169:
	switch( (*( current_position)) ) {
		case 4u: goto st2;
		case 5u: goto tr2;
		case 12u: goto st2;
		case 13u: goto tr2;
		case 68u: goto st8;
		case 76u: goto st8;
		case 132u: goto st9;
		case 140u: goto st9;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 15u )
			goto tr0;
	} else if ( (*( current_position)) > 79u ) {
		if ( (*( current_position)) > 143u ) {
			if ( 192u <= (*( current_position)) && (*( current_position)) <= 207u )
				goto tr377;
		} else if ( (*( current_position)) >= 128u )
			goto tr5;
	} else
		goto tr3;
	goto tr57;
st170:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof170;
case 170:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1403:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st171;
st171:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof171;
case 171:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 195, 55, 55, 1003, 1318, 1167, 1319, 1169, 1320, 974, 1321, 974, 148, 976, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st172:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof172;
case 172:
	{
		static const unsigned short jump_table[] = { 974, 35, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 36, 978, 45, 980, 980, 56, 982, 980, 980, 56, 982, 58, 974, 974, 974, 974, 974, 974, 59, 974, 974, 974, 974, 974, 974, 974, 974, 980, 980, 985, 982, 985, 985, 980, 980, 974, 986, 974, 974, 974, 974, 974, 974, 173, 974, 62, 974, 974, 974, 974, 974, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1331, 980, 980, 980, 980, 980, 980, 980, 980, 980, 985, 985, 980, 980, 980, 980, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 974, 974, 991, 991, 992, 74, 74, 75, 991, 991, 991, 995, 974, 974, 974, 974, 974, 974, 1332, 991, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 974, 974, 976, 974, 1333, 1310, 974, 974, 974, 974, 974, 974, 1333, 1310, 81, 1311, 1003, 1318, 974, 974, 974, 974, 1311, 1311, 974, 974, 174, 974, 1311, 1311, 1311, 1311, 1003, 1318, 1008, 1009, 85, 1335, 1008, 175, 1337, 1337, 1337, 1337, 1337, 1337, 1337, 1337, 974, 991, 991, 991, 985, 991, 974, 1338, 991, 991, 1015, 991, 991, 991, 1015, 991, 1015, 991, 991, 1015, 1015, 991, 974, 1016, 991, 991, 1015, 991, 991, 991, 1015, 991, 974, 991, 991, 991, 985, 991, 1015, 974, 991, 991, 991, 985, 991, 991, 991, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st173:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof173;
case 173:
	switch( (*( current_position)) ) {
		case 4u: goto tr74;
		case 240u: goto tr422;
		case 241u: goto tr162;
	}
	if ( (*( current_position)) > 11u ) {
		if ( 28u <= (*( current_position)) && (*( current_position)) <= 30u )
			goto tr160;
	} else
		goto tr160;
	goto tr57;
st174:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof174;
case 174:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 64, 64, 64, 64, 64, 64, 64, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st175:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof175;
case 175:
	switch( (*( current_position)) ) {
		case 12u: goto tr425;
		case 13u: goto tr426;
		case 76u: goto tr428;
		case 140u: goto tr430;
	}
	if ( (*( current_position)) < 72u ) {
		if ( 8u <= (*( current_position)) && (*( current_position)) <= 15u )
			goto tr424;
	} else if ( (*( current_position)) > 79u ) {
		if ( 136u <= (*( current_position)) && (*( current_position)) <= 143u )
			goto tr429;
	} else
		goto tr427;
	goto tr57;
tr397:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st176;
tr835:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st176;
tr836:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st176;
st176:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof176;
case 176:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 1348;
		goto _again;
	}
tr432:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st177;
st177:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof177;
case 177:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1356;
		goto _again;
	}
tr440:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st178;
tr447:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st178;
tr433:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st178;
tr436:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st178;
st178:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof178;
case 178:
	goto st179;
st179:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof179;
case 179:
	goto st180;
st180:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof180;
case 180:
	goto st181;
st181:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof181;
case 181:
	goto tr444;
tr446:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st182;
tr434:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st182;
st182:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof182;
case 182:
	goto tr445;
tr435:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st183;
st183:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof183;
case 183:
	goto tr446;
tr437:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st184;
st184:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof184;
case 184:
	goto tr447;
tr398:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st185;
tr547:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st185;
st185:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof185;
case 185:
	{
		static const unsigned char jump_table[] = { 233, 233, 233, 233, 234, 235, 233, 233, 233, 233, 233, 233, 234, 235, 233, 233, 233, 233, 233, 233, 234, 235, 233, 233, 233, 233, 233, 233, 234, 235, 233, 233, 233, 233, 233, 233, 234, 235, 233, 233, 233, 233, 233, 233, 234, 235, 233, 233, 233, 233, 233, 233, 234, 235, 233, 233, 233, 233, 233, 233, 234, 235, 233, 233, 236, 236, 236, 236, 237, 236, 236, 236, 236, 236, 236, 236, 237, 236, 236, 236, 236, 236, 236, 236, 237, 236, 236, 236, 236, 236, 236, 236, 237, 236, 236, 236, 236, 236, 236, 236, 237, 236, 236, 236, 236, 236, 236, 236, 237, 236, 236, 236, 236, 236, 236, 236, 237, 236, 236, 236, 236, 236, 236, 236, 237, 236, 236, 236, 238, 238, 238, 238, 239, 238, 238, 238, 238, 238, 238, 238, 239, 238, 238, 238, 238, 238, 238, 238, 239, 238, 238, 238, 238, 238, 238, 238, 239, 238, 238, 238, 238, 238, 238, 238, 239, 238, 238, 238, 238, 238, 238, 238, 239, 238, 238, 238, 238, 238, 238, 238, 239, 238, 238, 238, 238, 238, 238, 238, 239, 238, 238, 238, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1132;
		goto _again;
	}
tr449:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st186;
st186:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof186;
case 186:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1372;
		goto _again;
	}
tr456:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st187;
tr463:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st187;
tr450:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st187;
tr453:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st187;
st187:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof187;
case 187:
	goto st188;
st188:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof188;
case 188:
	goto st189;
st189:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof189;
case 189:
	goto st190;
st190:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof190;
case 190:
	goto tr460;
tr462:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st191;
tr451:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st191;
st191:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof191;
case 191:
	goto tr461;
tr452:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st192;
st192:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof192;
case 192:
	goto tr462;
tr454:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st193;
st193:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof193;
case 193:
	goto tr463;
st194:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof194;
case 194:
	{
		static const unsigned short jump_table[] = { 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 1381, 96, 96, 96, 96, 96, 96, 96, 96 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st195:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof195;
case 195:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1382, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 64, 64, 64, 64, 64, 64, 64, 64 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr465:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st196;
st196:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof196;
case 196:
	if ( (*( current_position)) <= 127u )
		goto tr52;
	goto tr466;
tr402:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st197;
st197:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof197;
case 197:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 1383, 924, 924, 924, 924, 924, 924, 1383, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr403:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st198;
st198:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof198;
case 198:
	{
		static const unsigned short jump_table[] = { 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 1383, 942, 942, 942, 942, 942, 942, 1383, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr404:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st199;
tr553:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st199;
st199:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof199;
case 199:
	{
		static const unsigned short jump_table[] = { 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr468:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st200;
st200:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof200;
case 200:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1391;
		goto _again;
	}
tr475:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st201;
tr482:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st201;
tr469:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st201;
tr472:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st201;
st201:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof201;
case 201:
	goto st202;
st202:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof202;
case 202:
	goto st203;
st203:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof203;
case 203:
	goto st204;
st204:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof204;
case 204:
	goto tr479;
tr481:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st205;
tr470:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st205;
st205:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof205;
case 205:
	goto tr480;
tr471:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st206;
st206:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof206;
case 206:
	goto tr481;
tr473:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st207;
st207:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof207;
case 207:
	goto tr482;
tr406:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st208;
st208:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof208;
case 208:
	goto st209;
st209:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof209;
case 209:
	goto st210;
st210:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof210;
case 210:
	goto st211;
st211:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof211;
case 211:
	goto st212;
st212:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof212;
case 212:
	goto st213;
st213:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof213;
case 213:
	goto st214;
st214:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof214;
case 214:
	goto st215;
st215:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof215;
case 215:
	goto tr490;
st216:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof216;
case 216:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 974, 974, 974, 974, 974, 974, 974, 974, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st217:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof217;
case 217:
	switch( (*( current_position)) ) {
		case 4u: goto tr370;
		case 5u: goto tr371;
		case 68u: goto tr373;
		case 132u: goto tr375;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 7u )
			goto tr369;
	} else if ( (*( current_position)) > 71u ) {
		if ( (*( current_position)) > 135u ) {
			if ( 192u <= (*( current_position)) && (*( current_position)) <= 199u )
				goto tr491;
		} else if ( (*( current_position)) >= 128u )
			goto tr374;
	} else
		goto tr372;
	goto tr57;
st218:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof218;
case 218:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 974, 974, 974, 974, 974, 974, 974, 974, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st219:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof219;
case 219:
	{
		static const unsigned short jump_table[] = { 1233, 1233, 1233, 1233, 123, 1235, 1233, 1233, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 1236, 1236, 1236, 1236, 129, 1236, 1236, 1236, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 1238, 1238, 1238, 1238, 130, 1238, 1238, 1238, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 96, 96, 96, 96, 96, 96, 96, 96, 974, 974, 974, 974, 974, 974, 974, 974, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st220:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof220;
case 220:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1421:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st221;
st221:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof221;
case 221:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1410, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1415, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr493:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st222;
st222:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof222;
case 222:
	{
		static const unsigned short jump_table[] = { 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 1416, 942, 942, 942, 942, 942, 942, 942, 1417, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr494:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st223;
st223:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof223;
case 223:
	{
		static const unsigned short jump_table[] = { 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 1416, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st224:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof224;
case 224:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 1340, 64, 64, 64, 64, 64, 64, 64, 64 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr498:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st225;
st225:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof225;
case 225:
	{
		static const unsigned short jump_table[] = { 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1418, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr501:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st226;
st226:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof226;
case 226:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 28, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1391;
		goto _again;
	}
tr502:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st895;
st895:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof895;
case 895:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2339, 2317, 2340, 2317, 2319, 2317, 2319, 2317, 2341, 2321, 2322, 2321, 2323, 2324, 2323, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 844, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2343, 1169, 2344, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 2281, 2281, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 856, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1422:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st227;
st227:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof227;
case 227:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 101, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1420, 1169, 1421, 974, 1171, 974, 148, 1173, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr503:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st228;
st228:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof228;
case 228:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 1259, 934, 934, 934, 934, 934, 934, 934, 934, 1422 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr505:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st896;
tr1363:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st896;
st896:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof896;
case 896:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2346, 2322, 2321, 2323, 2324, 2323, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1429:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st229;
st229:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof229;
case 229:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1410, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1423, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr506:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st230;
st230:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof230;
case 230:
	{
		static const unsigned short jump_table[] = { 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1424, 1386, 1384, 1384, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr507:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st231;
st231:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof231;
case 231:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 34, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1391;
		goto _again;
	}
tr508:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st897;
st897:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof897;
case 897:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 232, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2348, 2349, 2350, 2349, 2351, 2349, 2351, 2349, 2352, 2353, 2354, 2353, 2355, 2356, 2355, 2356, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 836, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 2277, 2277, 2277, 2277, 64, 96, 1427, 1427, 974, 974, 1427, 1427, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 790, 799, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 837, 839, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st232:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof232;
case 232:
	{
		static const unsigned short jump_table[] = { 974, 35, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 974, 36, 978, 45, 980, 980, 56, 982, 980, 980, 56, 982, 58, 974, 974, 974, 974, 974, 974, 59, 974, 974, 974, 974, 974, 974, 974, 974, 980, 980, 985, 982, 985, 985, 980, 980, 974, 986, 974, 974, 974, 974, 974, 974, 60, 974, 62, 974, 974, 974, 974, 974, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 990, 980, 980, 980, 980, 980, 980, 980, 980, 980, 985, 985, 980, 980, 980, 980, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 974, 974, 991, 991, 992, 74, 74, 75, 991, 991, 991, 995, 974, 974, 974, 974, 974, 974, 996, 991, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 974, 974, 976, 974, 999, 1000, 974, 974, 974, 974, 974, 974, 999, 1000, 81, 1002, 1003, 1004, 974, 974, 974, 974, 1002, 1002, 974, 974, 83, 974, 1006, 1006, 1002, 1002, 1003, 1007, 1008, 1009, 85, 1011, 1008, 87, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 974, 991, 991, 991, 985, 991, 974, 1014, 991, 991, 1015, 991, 991, 991, 1015, 991, 1015, 991, 991, 1015, 1015, 991, 974, 1016, 991, 991, 1015, 991, 991, 991, 1015, 991, 974, 991, 991, 991, 985, 991, 1015, 1426, 991, 991, 991, 985, 991, 991, 991, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr509:
	{ SET_CPU_FEATURE(CPUFeature_EMMX);      }
	goto st233;
tr583:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st233;
tr1331:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st233;
st233:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof233;
case 233:
	if ( 192u <= (*( current_position)) )
		goto tr510;
	goto tr57;
tr1431:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st234;
st234:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof234;
case 234:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 235, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1168, 1169, 1170, 974, 1171, 974, 148, 1173, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st235:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof235;
case 235:
	{
		static const unsigned short jump_table[] = { 974, 35, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 36, 978, 45, 980, 980, 56, 982, 980, 980, 56, 982, 58, 974, 974, 974, 974, 974, 974, 59, 974, 974, 974, 974, 974, 974, 974, 974, 980, 980, 985, 982, 985, 985, 980, 980, 974, 986, 974, 974, 974, 974, 974, 974, 60, 974, 62, 974, 974, 974, 974, 974, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 990, 980, 980, 980, 980, 980, 980, 980, 980, 980, 985, 985, 980, 980, 980, 980, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 974, 974, 991, 991, 992, 74, 74, 75, 991, 991, 991, 995, 974, 974, 974, 974, 974, 974, 996, 991, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 974, 974, 976, 974, 999, 1000, 974, 974, 974, 974, 974, 974, 999, 1000, 81, 1002, 1003, 1004, 974, 974, 974, 974, 1002, 1002, 974, 974, 83, 974, 1006, 1006, 1002, 1002, 1003, 1007, 1008, 1009, 85, 1011, 1008, 87, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 974, 991, 991, 991, 985, 991, 974, 1014, 991, 991, 1015, 991, 991, 991, 1015, 991, 1015, 991, 991, 1015, 1015, 991, 974, 1016, 991, 991, 1015, 991, 991, 991, 1015, 991, 974, 991, 991, 991, 985, 991, 1015, 1426, 991, 991, 991, 985, 991, 991, 991, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr253:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st236;
st236:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof236;
case 236:
	{
		static const unsigned short jump_table[] = { 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 1429, 959, 959, 959, 959, 959, 959, 959, 959, 1430 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr343:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st898;
tr513:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st898;
st898:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof898;
case 898:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2362, 2322, 2321, 2323, 2324, 2323, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1445:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st237;
st237:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof237;
case 237:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1410, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1431, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr514:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st238;
st238:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof238;
case 238:
	{
		static const unsigned short jump_table[] = { 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1432, 1386, 1384, 1384, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr515:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st239;
st239:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof239;
case 239:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 42, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1391;
		goto _again;
	}
tr516:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st899;
st899:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof899;
case 899:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 232, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2348, 2349, 2350, 2349, 2351, 2349, 2351, 2349, 2363, 2353, 2354, 2353, 2355, 2356, 2355, 2356, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 267, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 1427, 1427, 974, 974, 1427, 1427, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 790, 799, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 831, 833, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1432:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st240;
st240:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof240;
case 240:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 235, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 134, 55, 55, 1003, 1007, 1167, 1255, 1169, 1256, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1433:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st241;
st241:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof241;
case 241:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 235, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1168, 1169, 1170, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1434:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st242;
st242:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof242;
case 242:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 235, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1255, 1169, 1256, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1446:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st243;
st243:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof243;
case 243:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 244, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 195, 55, 55, 1003, 1318, 1167, 1319, 1169, 1320, 974, 1321, 974, 148, 976, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 1427, 974, 974, 974, 1427, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st244:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof244;
case 244:
	{
		static const unsigned short jump_table[] = { 974, 35, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 36, 978, 45, 980, 980, 56, 982, 980, 980, 56, 982, 58, 974, 974, 974, 974, 974, 974, 59, 974, 974, 974, 974, 974, 974, 974, 974, 980, 980, 985, 982, 985, 985, 980, 980, 974, 986, 974, 974, 974, 974, 974, 974, 173, 974, 62, 974, 974, 974, 974, 974, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1331, 980, 980, 980, 980, 980, 980, 980, 980, 980, 985, 985, 980, 980, 980, 980, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 974, 974, 991, 991, 992, 74, 74, 75, 991, 991, 991, 995, 974, 974, 974, 974, 974, 974, 1332, 991, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 974, 974, 976, 974, 1333, 1310, 974, 974, 974, 974, 974, 974, 1333, 1310, 81, 1311, 1003, 1318, 974, 974, 974, 974, 1311, 1311, 974, 974, 174, 974, 1311, 1311, 1311, 1311, 1003, 1318, 1008, 1009, 85, 1335, 1008, 175, 1337, 1337, 1337, 1337, 1337, 1337, 1337, 1337, 974, 991, 991, 991, 985, 991, 974, 1338, 991, 991, 1015, 991, 991, 991, 1015, 991, 1015, 991, 991, 1015, 1015, 991, 974, 1016, 991, 991, 1015, 991, 991, 991, 1015, 991, 974, 991, 991, 991, 985, 991, 1015, 1426, 991, 991, 991, 985, 991, 991, 991, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1436:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st245;
st245:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof245;
case 245:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1410, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 244, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1437:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st246;
st246:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof246;
case 246:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 244, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1319, 1169, 1320, 974, 1435, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr518:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st247;
st247:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof247;
case 247:
	{
		static const unsigned short jump_table[] = { 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1436, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1437, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1438, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1439, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1440, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr519:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st248;
st248:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof248;
case 248:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 25, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1391;
		goto _again;
	}
tr520:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st249;
st249:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof249;
case 249:
	if ( (*( current_position)) == 60u )
		goto tr524;
	goto tr481;
tr524:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st250;
st250:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof250;
case 250:
	if ( (*( current_position)) == 0u )
		goto tr499;
	goto tr480;
tr521:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st251;
st251:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof251;
case 251:
	if ( (*( current_position)) == 61u )
		goto tr525;
	goto tr481;
tr525:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st252;
st252:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof252;
case 252:
	if ( (*( current_position)) == 0u )
		goto tr500;
	goto tr480;
tr522:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st253;
st253:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof253;
case 253:
	if ( (*( current_position)) == 60u )
		goto tr526;
	goto tr482;
tr526:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st254;
st254:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof254;
case 254:
	if ( (*( current_position)) == 0u )
		goto st255;
	goto st202;
st255:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof255;
case 255:
	if ( (*( current_position)) == 0u )
		goto st256;
	goto st203;
st256:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof256;
case 256:
	if ( (*( current_position)) == 0u )
		goto st257;
	goto st204;
st257:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof257;
case 257:
	if ( (*( current_position)) == 0u )
		goto tr499;
	goto tr479;
tr523:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st258;
st258:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof258;
case 258:
	if ( (*( current_position)) == 61u )
		goto tr530;
	goto tr482;
tr530:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st259;
st259:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof259;
case 259:
	if ( (*( current_position)) == 0u )
		goto st260;
	goto st202;
st260:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof260;
case 260:
	if ( (*( current_position)) == 0u )
		goto st261;
	goto st203;
st261:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof261;
case 261:
	if ( (*( current_position)) == 0u )
		goto st262;
	goto st204;
st262:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof262;
case 262:
	if ( (*( current_position)) == 0u )
		goto tr500;
	goto tr479;
tr1438:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st263;
st263:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof263;
case 263:
	{
		static const unsigned short jump_table[] = { 1152, 1451, 1154, 1311, 1155, 1312, 974, 974, 1152, 1452, 1154, 1311, 1155, 1312, 974, 244, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr534:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st264;
st264:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof264;
case 264:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 1416, 1417, 924, 924 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr535:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st265;
st265:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof265;
case 265:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 1416, 924, 924, 924 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1439:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st266;
st266:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof266;
case 266:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 244, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st267:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof267;
case 267:
	{
		static const unsigned short jump_table[] = { 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 270, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 286, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 55, 974, 55, 974, 289, 974, 974, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 976, 976, 976, 976, 976, 976, 976, 976, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 974, 974, 974, 1454, 974, 974, 323, 974, 289, 1463, 974, 1464, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 302, 974, 311, 974, 55, 974, 1467, 974, 1468, 974, 1469, 974, 1470, 974, 312, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 289, 974, 1427, 974, 974, 974, 1427, 974, 974, 974, 974, 974, 974, 974, 974, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 974, 313, 974, 974, 974, 974, 974, 314, 974, 974, 974, 974, 974, 974, 974, 974, 974, 315, 974, 315, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 328, 974, 336, 974, 974, 974, 974, 316, 974, 974, 974, 974, 974, 974, 974, 317 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr635:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st268;
tr636:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st268;
tr641:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st268;
tr642:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st268;
tr628:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st268;
tr538:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	{ SET_OPERAND_NAME(0, REG_RAX); }
	goto st268;
tr556:
	{
    SET_OPERAND_NAME(0, RegFromOpcode(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st268;
tr652:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st268;
tr670:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st268;
st268:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof268;
case 268:
	goto st269;
st269:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof269;
case 269:
	goto tr565;
st270:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof270;
case 270:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1484, 1484, 1483, 1483, 1484, 1484, 974, 974, 974, 974, 974, 974, 974, 271, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 277, 974, 278, 974, 974, 974, 974, 974, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1489, 1483, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1490, 281, 281, 282, 1483, 1483, 1483, 974, 974, 1493, 974, 974, 1494, 1494, 1495, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 1454, 974, 1467, 974, 974, 974, 974, 1454, 1454, 974, 974, 284, 974, 1454, 1454, 1454, 1454, 974, 1467, 1490, 974, 285, 1499, 1490, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1489, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1500, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st271:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof271;
case 271:
	switch( (*( current_position)) ) {
		case 68u: goto st272;
		case 132u: goto st274;
	}
	goto tr57;
st272:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof272;
case 272:
	if ( (*( current_position)) == 0u )
		goto st273;
	goto tr57;
st273:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof273;
case 273:
	if ( (*( current_position)) == 0u )
		goto tr587;
	goto tr57;
st274:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof274;
case 274:
	if ( (*( current_position)) == 0u )
		goto st275;
	goto tr57;
st275:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof275;
case 275:
	if ( (*( current_position)) == 0u )
		goto st276;
	goto tr57;
st276:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof276;
case 276:
	if ( (*( current_position)) == 0u )
		goto st272;
	goto tr57;
st277:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof277;
case 277:
	{
		static const unsigned short jump_table[] = { 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 974, 974, 974, 974, 1508, 974, 974, 974, 1508, 1508, 974, 1508, 974, 974, 974, 974, 1507, 1507, 1507, 974, 1508, 1508, 1508, 1508, 1508, 1508, 974, 974, 1508, 1508, 1509, 1508, 974, 974, 974, 974, 1508, 1508, 1508, 1508, 1508, 1508, 974, 1510, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1511, 1511, 1511, 1511, 1511, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1512, 1079, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st278:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof278;
case 278:
	switch( (*( current_position)) ) {
		case 15u: goto tr597;
		case 32u: goto st280;
		case 68u: goto tr601;
		case 223u: goto tr603;
	}
	if ( (*( current_position)) < 22u ) {
		if ( (*( current_position)) > 14u ) {
			if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
				goto st279;
		} else if ( (*( current_position)) >= 8u )
			goto tr596;
	} else if ( (*( current_position)) > 23u ) {
		if ( (*( current_position)) < 64u ) {
			if ( 33u <= (*( current_position)) && (*( current_position)) <= 34u )
				goto tr596;
		} else if ( (*( current_position)) > 66u ) {
			if ( 96u <= (*( current_position)) && (*( current_position)) <= 99u )
				goto tr602;
		} else
			goto tr596;
	} else
		goto tr599;
	goto tr57;
st279:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof279;
case 279:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 1521;
		goto _again;
	}
st280:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof280;
case 280:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 };
		( current_state) = jump_table[(*( current_position))] + 1521;
		goto _again;
	}
st281:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof281;
case 281:
	if ( (*( current_position)) < 224u ) {
		if ( 208u <= (*( current_position)) && (*( current_position)) <= 215u )
			goto tr613;
	} else if ( (*( current_position)) > 231u ) {
		if ( 240u <= (*( current_position)) && (*( current_position)) <= 247u )
			goto tr613;
	} else
		goto tr613;
	goto tr57;
st282:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof282;
case 282:
	if ( (*( current_position)) > 223u ) {
		if ( 240u <= (*( current_position)) )
			goto tr613;
	} else if ( (*( current_position)) >= 208u )
		goto tr613;
	goto tr57;
tr576:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE4A);     }
	goto st283;
tr1088:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st283;
tr1287:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st283;
tr1285:
	{
    SET_REPNZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE4A);     }
	goto st283;
tr1310:
	{
    SET_REPZ_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st283;
st283:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof283;
case 283:
	if ( 192u <= (*( current_position)) )
		goto tr59;
	goto tr57;
st284:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof284;
case 284:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 64, 64, 64, 64, 64, 64, 64, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st285:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof285;
case 285:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 1532;
		goto _again;
	}
st286:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof286;
case 286:
	if ( (*( current_position)) == 15u )
		goto st287;
	goto tr57;
st287:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof287;
case 287:
	if ( (*( current_position)) == 31u )
		goto st288;
	goto tr57;
st288:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof288;
case 288:
	if ( (*( current_position)) == 132u )
		goto st274;
	goto tr57;
tr645:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st289;
tr653:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st289;
tr658:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st289;
tr659:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st289;
tr663:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st289;
st289:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof289;
case 289:
	goto st290;
st290:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof290;
case 290:
	goto tr626;
tr542:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st291;
st291:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof291;
case 291:
	{
		static const unsigned short jump_table[] = { 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 292, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 55, 974, 55, 974, 289, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 974, 974, 974, 1454, 974, 974, 974, 974, 289, 1463, 974, 1464, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 302, 974, 311, 974, 55, 974, 1467, 974, 1468, 974, 1469, 974, 1470, 974, 312, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 289, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 974, 313, 974, 974, 974, 974, 974, 314, 974, 974, 974, 974, 974, 974, 974, 974, 974, 315, 974, 315, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 316, 974, 974, 974, 974, 974, 974, 974, 317 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st292:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof292;
case 292:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1484, 1484, 1483, 1483, 1484, 1484, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 277, 974, 278, 974, 974, 974, 974, 974, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1489, 1483, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1490, 281, 281, 282, 1483, 1483, 1483, 974, 974, 1493, 974, 974, 1494, 1494, 1495, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 1454, 974, 1467, 974, 974, 974, 974, 1454, 1454, 974, 974, 284, 974, 1454, 1454, 1454, 1454, 974, 1467, 1490, 974, 285, 1499, 1490, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1489, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1500, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr546:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_16_BIT); }
	goto st293;
st293:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof293;
case 293:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 };
		( current_state) = jump_table[(*( current_position))] + 1545;
		goto _again;
	}
tr629:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st294;
st294:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof294;
case 294:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1553;
		goto _again;
	}
tr637:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st295;
tr644:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st295;
tr630:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st295;
tr633:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st295;
st295:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof295;
case 295:
	goto st296;
st296:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof296;
case 296:
	goto st297;
st297:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof297;
case 297:
	goto st298;
st298:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof298;
case 298:
	goto tr641;
tr643:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st299;
tr631:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st299;
st299:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof299;
case 299:
	goto tr642;
tr632:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st300;
st300:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof300;
case 300:
	goto tr643;
tr634:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st301;
st301:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof301;
case 301:
	goto tr644;
st302:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof302;
case 302:
	{
		static const unsigned short jump_table[] = { 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 1569, 289, 289, 289, 289, 289, 289, 289, 289 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr664:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st303;
st303:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof303;
case 303:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1570;
		goto _again;
	}
tr647:
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st304;
tr650:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st304;
tr654:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st304;
tr661:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st304;
tr665:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st304;
tr668:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st304;
st304:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof304;
case 304:
	goto st305;
st305:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof305;
case 305:
	goto st306;
st306:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof306;
case 306:
	goto st307;
st307:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof307;
case 307:
	goto tr658;
tr648:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st308;
tr660:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st308;
tr666:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st308;
st308:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof308;
case 308:
	goto tr659;
tr667:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st309;
st309:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof309;
case 309:
	goto tr660;
tr669:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	goto st310;
st310:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof310;
case 310:
	goto tr661;
st311:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof311;
case 311:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 64, 64, 64, 64, 64, 64, 64, 64 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st312:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof312;
case 312:
	switch( (*( current_position)) ) {
		case 4u: goto st2;
		case 5u: goto tr2;
		case 68u: goto st8;
		case 132u: goto st9;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 7u )
			goto tr0;
	} else if ( (*( current_position)) > 71u ) {
		if ( (*( current_position)) > 135u ) {
			if ( 192u <= (*( current_position)) && (*( current_position)) <= 199u )
				goto tr662;
		} else if ( (*( current_position)) >= 128u )
			goto tr5;
	} else
		goto tr3;
	goto tr57;
st313:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof313;
case 313:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 974, 974, 974, 974, 974, 974, 974, 974, 1531, 1531, 1531, 1531, 1531, 1531, 1531, 1531 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st314:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof314;
case 314:
	switch( (*( current_position)) ) {
		case 4u: goto tr664;
		case 5u: goto tr665;
		case 68u: goto tr667;
		case 132u: goto tr669;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 7u )
			goto tr663;
	} else if ( (*( current_position)) > 71u ) {
		if ( (*( current_position)) > 135u ) {
			if ( 192u <= (*( current_position)) && (*( current_position)) <= 199u )
				goto tr670;
		} else if ( (*( current_position)) >= 128u )
			goto tr668;
	} else
		goto tr666;
	goto tr57;
st315:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof315;
case 315:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 974, 974, 974, 974, 974, 974, 974, 974, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st316:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof316;
case 316:
	{
		static const unsigned short jump_table[] = { 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 289, 289, 289, 289, 289, 289, 289, 289, 974, 974, 974, 974, 974, 974, 974, 974, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st317:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof317;
case 317:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr543:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st318;
st318:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof318;
case 318:
	if ( (*( current_position)) == 15u )
		goto st319;
	goto tr57;
st319:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof319;
case 319:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1484, 1484, 1483, 1483, 1484, 1484, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 320, 974, 321, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1591, 1483, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1490, 281, 281, 282, 1483, 1483, 1483, 974, 974, 1493, 974, 974, 1494, 1494, 1592, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1490, 974, 285, 1593, 1490, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1591, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1500, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st320:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof320;
case 320:
	{
		static const unsigned short jump_table[] = { 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 1507, 974, 974, 974, 974, 1508, 974, 974, 974, 1508, 1508, 974, 1508, 974, 974, 974, 974, 1507, 1507, 1507, 974, 1508, 1508, 1508, 1508, 1508, 1508, 974, 974, 1508, 1508, 1509, 1508, 974, 974, 974, 974, 1508, 1508, 1508, 1508, 1508, 1508, 974, 1510, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 1508, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1511, 1511, 1511, 1511, 1511, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st321:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof321;
case 321:
	switch( (*( current_position)) ) {
		case 15u: goto tr597;
		case 32u: goto st280;
		case 68u: goto tr601;
		case 223u: goto tr603;
	}
	if ( (*( current_position)) < 22u ) {
		if ( (*( current_position)) > 14u ) {
			if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
				goto st322;
		} else if ( (*( current_position)) >= 8u )
			goto tr596;
	} else if ( (*( current_position)) > 23u ) {
		if ( (*( current_position)) < 64u ) {
			if ( 33u <= (*( current_position)) && (*( current_position)) <= 34u )
				goto tr596;
		} else if ( (*( current_position)) > 66u ) {
			if ( 96u <= (*( current_position)) && (*( current_position)) <= 99u )
				goto tr602;
		} else
			goto tr596;
	} else
		goto tr678;
	goto tr57;
st322:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof322;
case 322:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 0, 0, 0, 0, 1, 2, 0, 0, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 3, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 5, 5, 5, 5, 6, 5, 5, 5, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75, 75 };
		( current_state) = jump_table[(*( current_position))] + 1521;
		goto _again;
	}
st323:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof323;
case 323:
	switch( (*( current_position)) ) {
		case 46u: goto st286;
		case 102u: goto st324;
	}
	goto tr57;
st324:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof324;
case 324:
	switch( (*( current_position)) ) {
		case 46u: goto st286;
		case 102u: goto st325;
	}
	goto tr57;
st325:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof325;
case 325:
	switch( (*( current_position)) ) {
		case 46u: goto st286;
		case 102u: goto st326;
	}
	goto tr57;
st326:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof326;
case 326:
	switch( (*( current_position)) ) {
		case 46u: goto st286;
		case 102u: goto st327;
	}
	goto tr57;
st327:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof327;
case 327:
	if ( (*( current_position)) == 46u )
		goto st286;
	goto tr57;
st328:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof328;
case 328:
	switch( (*( current_position)) ) {
		case 1u: goto st57;
		case 9u: goto st57;
		case 15u: goto st329;
		case 17u: goto st57;
		case 25u: goto st57;
		case 33u: goto st57;
		case 41u: goto st57;
		case 49u: goto st57;
		case 129u: goto st332;
		case 131u: goto st333;
		case 135u: goto tr689;
		case 247u: goto st334;
		case 255u: goto st335;
	}
	if ( 64u <= (*( current_position)) && (*( current_position)) <= 71u )
		goto tr686;
	goto tr57;
st329:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof329;
case 329:
	switch( (*( current_position)) ) {
		case 177u: goto tr689;
		case 186u: goto st330;
		case 193u: goto tr689;
	}
	goto tr57;
st330:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof330;
case 330:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr686:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st331;
st331:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof331;
case 331:
	switch( (*( current_position)) ) {
		case 1u: goto st57;
		case 9u: goto st57;
		case 15u: goto st329;
		case 17u: goto st57;
		case 25u: goto st57;
		case 33u: goto st57;
		case 41u: goto st57;
		case 49u: goto st57;
		case 129u: goto st332;
		case 131u: goto st333;
		case 135u: goto tr689;
		case 247u: goto st334;
		case 255u: goto st335;
	}
	goto tr57;
st332:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof332;
case 332:
	{
		static const unsigned short jump_table[] = { 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 1562, 1562, 1562, 1562, 303, 1564, 1562, 1562, 974, 974, 974, 974, 974, 974, 974, 974, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 1565, 1565, 1565, 1565, 309, 1565, 1565, 1565, 974, 974, 974, 974, 974, 974, 974, 974, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 1567, 1567, 1567, 1567, 310, 1567, 1567, 1567, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st333:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof333;
case 333:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 974, 974, 974, 974, 974, 974, 974, 974, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 974, 974, 974, 974, 974, 974, 974, 974, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st334:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof334;
case 334:
	switch( (*( current_position)) ) {
		case 20u: goto st2;
		case 21u: goto tr2;
		case 28u: goto st2;
		case 29u: goto tr2;
		case 84u: goto st8;
		case 92u: goto st8;
		case 148u: goto st9;
		case 156u: goto st9;
	}
	if ( (*( current_position)) < 80u ) {
		if ( 16u <= (*( current_position)) && (*( current_position)) <= 31u )
			goto tr0;
	} else if ( (*( current_position)) > 95u ) {
		if ( 144u <= (*( current_position)) && (*( current_position)) <= 159u )
			goto tr5;
	} else
		goto tr3;
	goto tr57;
st335:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof335;
case 335:
	switch( (*( current_position)) ) {
		case 4u: goto st2;
		case 5u: goto tr2;
		case 12u: goto st2;
		case 13u: goto tr2;
		case 68u: goto st8;
		case 76u: goto st8;
		case 132u: goto st9;
		case 140u: goto st9;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 15u )
			goto tr0;
	} else if ( (*( current_position)) > 79u ) {
		if ( 128u <= (*( current_position)) && (*( current_position)) <= 143u )
			goto tr5;
	} else
		goto tr3;
	goto tr57;
st336:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof336;
case 336:
	if ( (*( current_position)) == 15u )
		goto st337;
	if ( 64u <= (*( current_position)) && (*( current_position)) <= 71u )
		goto tr694;
	goto tr57;
st337:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof337;
case 337:
	if ( (*( current_position)) == 56u )
		goto st338;
	goto tr57;
st338:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof338;
case 338:
	if ( (*( current_position)) == 241u )
		goto tr696;
	goto tr57;
tr694:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st339;
st339:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof339;
case 339:
	if ( (*( current_position)) == 15u )
		goto st337;
	goto tr57;
st340:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof340;
case 340:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1081, 1081, 1081, 1081, 65, 1083, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1122, 1614, 1614, 1614, 1614, 1614, 1614, 1614, 1614, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 1251, 64, 64, 64, 64, 64, 64, 64, 64 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr697:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st341;
st341:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof341;
case 341:
	if ( (*( current_position)) == 224u )
		goto tr698;
	goto tr305;
tr698:
	{
    SET_IMM_TYPE(IMM8);
    SET_IMM_PTR(current_position);
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st900;
st900:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof900;
case 900:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2367, 2322, 2367, 2368, 2324, 2368, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1450:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st342;
st342:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof342;
case 342:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1616, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr699:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st343;
st343:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof343;
case 343:
	{
		static const unsigned short jump_table[] = { 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 935, 935, 935, 935, 936, 937, 935, 935, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 942, 942, 942, 942, 942, 942, 942, 1617, 942, 942, 942, 942, 942, 942, 942, 1617, 942, 942, 942, 942, 942, 942, 942, 1617, 942, 942, 942, 942, 942, 942, 942, 1617, 942, 942, 942, 942, 942, 942, 942, 1618, 942, 942, 942, 942, 942, 942, 942, 1619, 942, 942, 942, 942, 942, 942, 942, 1617, 942, 942, 942, 942, 942, 942, 942, 1617 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr700:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st901;
tr701:
	{ if (restricted_register == REG_RSP)
         instruction_info_collected |= RESTRICTED_REGISTER_USED;
       else
         instruction_info_collected |= UNRESTRICTED_RSP_PROCESSED;
       restricted_register = NO_REG;
       UnmarkValidJumpTarget((instruction_start - data), valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st901;
tr702:
	{ if (restricted_register == REG_RBP)
         instruction_info_collected |= RESTRICTED_REGISTER_USED;
       else
         instruction_info_collected |= UNRESTRICTED_RBP_PROCESSED;
       restricted_register = NO_REG;
       UnmarkValidJumpTarget((instruction_start - data), valid_targets);
    }
	{
       instruction_info_collected |= SPECIAL_INSTRUCTION;
    }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st901;
st901:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof901;
case 901:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2369, 2317, 2370, 2317, 2371, 2317, 2371, 2317, 2372, 2321, 2373, 2321, 2374, 2324, 2374, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 345 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1452:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st344;
st344:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof344;
case 344:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 101, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1168, 1169, 1170, 974, 1171, 974, 148, 1173, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 345 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st345:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof345;
case 345:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1309, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 974, 974, 974, 974, 974, 974, 974, 974, 1622, 1622, 1622, 1622, 1622, 1622, 1622, 1622, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1453:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st346;
st346:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof346;
case 346:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 101, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1168, 1169, 1170, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 345 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1454:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st347;
st347:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof347;
case 347:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 101, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1255, 1169, 1256, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 345 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1455:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st348;
st348:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof348;
case 348:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 195, 55, 55, 1003, 1318, 1167, 1319, 1169, 1320, 974, 1321, 974, 148, 976, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 349 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st349:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof349;
case 349:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 917, 917, 917, 917, 2, 919, 917, 917, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1409, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 974, 974, 974, 974, 974, 974, 974, 974, 1622, 1622, 1622, 1622, 1622, 1622, 1622, 1622, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1404:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st350;
st350:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof350;
case 350:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1410, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1456:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st351;
st351:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof351;
case 351:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1319, 1169, 1320, 974, 1435, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 349 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1457:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st352;
st352:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof352;
case 352:
	{
		static const unsigned short jump_table[] = { 1152, 1451, 1154, 1311, 1155, 1312, 974, 974, 1152, 1452, 1154, 1311, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 349 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1407:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st353;
st353:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof353;
case 353:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st354:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof354;
case 354:
	{
		static const unsigned short jump_table[] = { 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 355, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 286, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 55, 974, 55, 974, 289, 974, 974, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1625, 1626, 1626, 1626, 1626, 1626, 1626, 1626, 1626, 976, 976, 976, 976, 976, 976, 976, 976, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 974, 974, 974, 1454, 974, 974, 323, 974, 289, 1463, 974, 1464, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 302, 974, 311, 974, 55, 974, 1467, 974, 1468, 974, 1469, 974, 1470, 974, 312, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 289, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 974, 313, 974, 974, 974, 974, 974, 314, 974, 974, 974, 974, 974, 974, 974, 974, 974, 315, 974, 315, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 328, 974, 336, 974, 974, 974, 974, 316, 974, 974, 974, 974, 974, 974, 974, 317 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st355:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof355;
case 355:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1484, 1484, 1483, 1483, 1484, 1484, 974, 974, 974, 974, 974, 974, 974, 271, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 277, 974, 278, 974, 974, 974, 974, 974, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1489, 1483, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1490, 281, 281, 282, 1483, 1483, 1483, 974, 974, 1493, 974, 974, 1494, 1494, 1495, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 1454, 974, 1467, 974, 974, 974, 974, 1454, 1454, 974, 974, 284, 974, 1454, 1454, 1454, 1454, 974, 1467, 1490, 974, 285, 1499, 1490, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1489, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr708:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st356;
st356:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof356;
case 356:
	{
		static const unsigned short jump_table[] = { 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 357, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 55, 974, 55, 974, 289, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 974, 974, 974, 1454, 974, 974, 974, 974, 289, 1463, 974, 1464, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 302, 974, 311, 974, 55, 974, 1467, 974, 1468, 974, 1469, 974, 1470, 974, 312, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 289, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 974, 313, 974, 974, 974, 974, 974, 314, 974, 974, 974, 974, 974, 974, 974, 974, 974, 315, 974, 315, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 316, 974, 974, 974, 974, 974, 974, 974, 317 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st357:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof357;
case 357:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1484, 1484, 1483, 1483, 1484, 1484, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 277, 974, 278, 974, 974, 974, 974, 974, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1489, 1483, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1490, 281, 281, 282, 1483, 1483, 1483, 974, 974, 1493, 974, 974, 1494, 1494, 1495, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 1454, 974, 1467, 974, 974, 974, 974, 1454, 1454, 974, 974, 284, 974, 1454, 1454, 1454, 1454, 974, 1467, 1490, 974, 285, 1499, 1490, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1489, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr709:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st358;
st358:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof358;
case 358:
	if ( (*( current_position)) == 15u )
		goto st359;
	goto tr57;
st359:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof359;
case 359:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1484, 1484, 1483, 1483, 1484, 1484, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 320, 974, 321, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1591, 1483, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1490, 281, 281, 282, 1483, 1483, 1483, 974, 974, 1493, 974, 974, 1494, 1494, 1592, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1490, 974, 285, 1593, 1490, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1591, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1410:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st360;
st360:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof360;
case 360:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 1629, 934, 934, 934, 934, 934, 934, 934, 934, 1630 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr712:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st902;
tr724:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st902;
st902:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof902;
case 902:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2375, 2322, 2321, 2323, 2324, 2323, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1458:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st361;
st361:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof361;
case 361:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1410, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1631, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr714:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st362;
st362:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof362;
case 362:
	{
		static const unsigned short jump_table[] = { 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1632, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr715:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st363;
st363:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof363;
case 363:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 242, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1391;
		goto _again;
	}
tr716:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st903;
st903:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof903;
case 903:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2376, 2317, 2377, 2317, 2319, 2317, 2319, 2317, 2378, 2321, 2322, 2321, 2323, 2324, 2323, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 807, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2380, 1169, 2381, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 2257, 2257, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 819, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1459:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st364;
st364:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof364;
case 364:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 101, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1634, 1169, 1635, 974, 1171, 974, 148, 1173, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr717:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st365;
st365:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof365;
case 365:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 917, 917, 917, 917, 2, 919, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 1259, 934, 934, 934, 934, 934, 934, 934, 934, 1636 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr719:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st904;
tr1339:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st904;
st904:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof904;
case 904:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2383, 2322, 2321, 2323, 2324, 2323, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1466:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st366;
st366:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof366;
case 366:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1410, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1637, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr720:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st367;
st367:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof367;
case 367:
	{
		static const unsigned short jump_table[] = { 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1638, 1386, 1384, 1384, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr721:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st368;
st368:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof368;
case 368:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 248, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1391;
		goto _again;
	}
tr722:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st905;
st905:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof905;
case 905:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 232, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2348, 2349, 2350, 2349, 2351, 2349, 2351, 2349, 2384, 2353, 2354, 2353, 2355, 2356, 2355, 2356, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 370, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 1640, 1640, 1640, 1640, 64, 96, 1427, 1427, 974, 974, 1427, 1427, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 790, 799, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 800, 802, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1467:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st369;
st369:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof369;
case 369:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 244, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 195, 55, 55, 1003, 1318, 1167, 1319, 1169, 1320, 974, 1321, 974, 148, 976, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1640, 974, 1640, 64, 96, 974, 1427, 974, 974, 974, 1427, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st370:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof370;
case 370:
	{
		static const unsigned short jump_table[] = { 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 270, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 286, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 55, 974, 55, 974, 289, 974, 974, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1459, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 1460, 976, 976, 976, 976, 976, 976, 976, 976, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 974, 974, 974, 1454, 974, 974, 323, 974, 289, 1463, 974, 1464, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 302, 974, 311, 974, 55, 974, 1467, 974, 1468, 974, 1469, 974, 1470, 974, 312, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1640, 974, 1640, 974, 289, 974, 1427, 974, 974, 974, 1427, 974, 974, 974, 974, 974, 974, 974, 974, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 974, 313, 974, 974, 974, 974, 974, 314, 974, 974, 974, 974, 974, 974, 974, 974, 974, 315, 974, 315, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 328, 974, 336, 974, 974, 974, 974, 316, 974, 974, 974, 974, 974, 974, 974, 317 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1411:
	{
    instruction_info_collected |= MODIFIABLE_INSTRUCTION;
  }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st371;
st371:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof371;
case 371:
	{
		static const unsigned short jump_table[] = { 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 952, 952, 952, 952, 953, 954, 952, 952, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 955, 955, 955, 955, 956, 955, 955, 955, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 957, 957, 957, 957, 958, 957, 957, 957, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 959, 1641, 959, 959, 959, 959, 959, 959, 959, 959, 1642 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr713:
	{
    SET_OPERAND_NAME(0, RMFromModRM(*current_position) |
                        BaseExtentionFromREX(GET_REX_PREFIX()) |
                        BaseExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st906;
tr725:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	{
    Process1OperandZeroExtends(&restricted_register,
                               &instruction_info_collected, rex_prefix,
                               operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st906;
st906:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof906;
case 906:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 34, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2316, 2317, 2318, 2317, 2319, 2317, 2319, 2317, 2320, 2388, 2322, 2321, 2323, 2324, 2323, 2324, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 354, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 778, 787, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 788, 789, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1471:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st372;
st372:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof372;
case 372:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1410, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 172, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1643, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr726:
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st373;
st373:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof373;
case 373:
	{
		static const unsigned short jump_table[] = { 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1385, 1386, 1384, 1384, 1384, 1384, 1384, 1384, 1644, 1386, 1384, 1384, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1387, 1387, 1387, 1387, 1388, 1387, 1387, 1387, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 1389, 1389, 1389, 1389, 1390, 1389, 1389, 1389, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr727:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st374;
st374:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof374;
case 374:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 254, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1391;
		goto _again;
	}
tr728:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    Process1Operand(&restricted_register, &instruction_info_collected,
                    rex_prefix, operand_states);
  }
	{
       if ((instruction_info_collected & VALIDATION_ERRORS_MASK) ||
           (options & CALL_USER_CALLBACK_ON_EACH_INSTRUCTION)) {
         result &= user_callback(
             instruction_start, current_position,
             instruction_info_collected |
             ((restricted_register << RESTRICTED_REGISTER_SHIFT) &
              RESTRICTED_REGISTER_MASK), callback_data);
       }
       /* On successful match the instruction start must point to the next byte
        * to be able to report the new offset as the start of instruction
        * causing error.  */
       instruction_start = current_position + 1;
       /* Mark this position as a valid target for jump.  */
       MarkValidJumpTarget(current_position + 1 - data, valid_targets);
       /* Clear variables.  */
       instruction_info_collected = 0;
       SET_REX_PREFIX(FALSE);
       /* Top three bits of VEX2 are inverted: see AMD/Intel manual.  */
       SET_VEX_PREFIX2(VEX_R | VEX_X | VEX_B);
       SET_VEX_PREFIX3(0x00);
       operand_states = 0;
     }
	goto st907;
st907:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof907;
case 907:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 375, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 92, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 92, 974, 2390, 2391, 2392, 2391, 2393, 2391, 2393, 2391, 2394, 2395, 2396, 2395, 2397, 2398, 2397, 2398, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 388, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 340, 55, 55, 1003, 1007, 1167, 2327, 1169, 2328, 974, 1171, 974, 394, 976, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 1647, 1647, 974, 974, 1647, 1647, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 527, 749, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 754, 974, 760, 770, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st375:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof375;
case 375:
	{
		static const unsigned short jump_table[] = { 974, 35, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 974, 36, 978, 45, 980, 980, 56, 982, 980, 980, 56, 982, 58, 974, 974, 974, 974, 974, 974, 59, 974, 974, 974, 974, 974, 974, 974, 974, 980, 980, 985, 982, 985, 985, 980, 980, 974, 986, 974, 974, 974, 974, 974, 974, 60, 974, 62, 974, 974, 974, 974, 974, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 990, 980, 980, 980, 980, 980, 980, 980, 980, 980, 985, 985, 980, 980, 980, 980, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 974, 974, 991, 991, 992, 74, 74, 75, 991, 991, 991, 995, 974, 974, 974, 974, 974, 974, 996, 991, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 974, 974, 976, 974, 999, 1000, 974, 974, 974, 974, 974, 974, 999, 1000, 81, 1002, 1003, 1004, 974, 974, 974, 974, 1002, 1002, 974, 974, 83, 974, 1006, 1006, 1002, 1002, 1003, 1007, 1008, 1009, 85, 1011, 1008, 87, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 974, 991, 991, 991, 985, 991, 974, 1014, 991, 991, 1015, 991, 991, 991, 1015, 991, 1015, 991, 991, 1015, 1015, 991, 974, 1016, 991, 991, 1015, 991, 991, 991, 1015, 991, 974, 991, 991, 991, 985, 991, 1015, 1646, 991, 991, 991, 985, 991, 991, 991, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr729:
	{ SET_CPU_FEATURE(CPUFeature_EMMX);      }
	goto st376;
tr736:
	{
    SET_DATA16_PREFIX(FALSE);
  }
	{ SET_CPU_FEATURE(CPUFeature_SSE2);      }
	goto st376;
tr1092:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st376;
st376:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof376;
case 376:
	if ( 192u <= (*( current_position)) )
		goto tr730;
	goto tr57;
tr1473:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st377;
st377:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof377;
case 377:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 378, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1168, 1169, 1170, 974, 1171, 974, 148, 1173, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st378:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof378;
case 378:
	{
		static const unsigned short jump_table[] = { 974, 35, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 36, 978, 45, 980, 980, 56, 982, 980, 980, 56, 982, 58, 974, 974, 974, 974, 974, 974, 59, 974, 974, 974, 974, 974, 974, 974, 974, 980, 980, 985, 982, 985, 985, 980, 980, 974, 986, 974, 974, 974, 974, 974, 974, 60, 974, 62, 974, 974, 974, 974, 974, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 989, 990, 980, 980, 980, 980, 980, 980, 980, 980, 980, 985, 985, 980, 980, 980, 980, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 974, 974, 991, 991, 992, 74, 74, 75, 991, 991, 991, 995, 974, 974, 974, 974, 974, 974, 996, 991, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 974, 974, 976, 974, 999, 1000, 974, 974, 974, 974, 974, 974, 999, 1000, 81, 1002, 1003, 1004, 974, 974, 974, 974, 1002, 1002, 974, 974, 83, 974, 1006, 1006, 1002, 1002, 1003, 1007, 1008, 1009, 85, 1011, 1008, 87, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 1013, 974, 991, 991, 991, 985, 991, 974, 1014, 991, 991, 1015, 991, 991, 991, 1015, 991, 1015, 991, 991, 1015, 1015, 991, 974, 1016, 991, 991, 1015, 991, 991, 991, 1015, 991, 974, 991, 991, 991, 985, 991, 1015, 1646, 991, 991, 991, 985, 991, 991, 991, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1474:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st379;
st379:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof379;
case 379:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 378, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 134, 55, 55, 1003, 1007, 1167, 1255, 1169, 1256, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1475:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st380;
st380:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof380;
case 380:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 378, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1168, 1169, 1170, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1476:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st381;
st381:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof381;
case 381:
	{
		static const unsigned short jump_table[] = { 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 378, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1000, 1154, 1006, 1155, 1158, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 1152, 1153, 1154, 1002, 1155, 1156, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1002, 974, 974, 974, 974, 96, 1162, 64, 1163, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 122, 974, 131, 55, 55, 1003, 1007, 1167, 1255, 1169, 1256, 974, 1171, 974, 148, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 1174, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 1177, 149, 150, 974, 974, 974, 974, 151, 152, 974, 974, 974, 974, 974, 974, 974, 974, 153, 154, 153, 154, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 168, 976, 976, 974, 974, 976, 976, 169, 170 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1477:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st382;
st382:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof382;
case 382:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 383, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 195, 55, 55, 1003, 1318, 1167, 1319, 1169, 1320, 974, 1321, 974, 148, 976, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 1647, 974, 974, 974, 1647, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st383:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof383;
case 383:
	{
		static const unsigned short jump_table[] = { 974, 35, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 36, 978, 45, 980, 980, 56, 982, 980, 980, 56, 982, 58, 974, 974, 974, 974, 974, 974, 59, 974, 974, 974, 974, 974, 974, 974, 974, 980, 980, 985, 982, 985, 985, 980, 980, 974, 986, 974, 974, 974, 974, 974, 974, 173, 974, 62, 974, 974, 974, 974, 974, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1330, 1331, 980, 980, 980, 980, 980, 980, 980, 980, 980, 985, 985, 980, 980, 980, 980, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 991, 974, 974, 991, 991, 992, 74, 74, 75, 991, 991, 991, 995, 974, 974, 974, 974, 974, 974, 1332, 991, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 76, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 998, 974, 974, 976, 974, 1333, 1310, 974, 974, 974, 974, 974, 974, 1333, 1310, 81, 1311, 1003, 1318, 974, 974, 974, 974, 1311, 1311, 974, 974, 174, 974, 1311, 1311, 1311, 1311, 1003, 1318, 1008, 1009, 85, 1335, 1008, 175, 1337, 1337, 1337, 1337, 1337, 1337, 1337, 1337, 974, 991, 991, 991, 985, 991, 974, 1338, 991, 991, 1015, 991, 991, 991, 1015, 991, 1015, 991, 991, 1015, 1015, 991, 974, 1016, 991, 991, 1015, 991, 991, 991, 1015, 991, 974, 991, 991, 991, 985, 991, 1015, 1646, 991, 991, 991, 985, 991, 991, 991, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1478:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st384;
st384:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof384;
case 384:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1410, 1155, 1312, 974, 974, 1152, 1310, 1154, 1411, 1155, 1312, 974, 383, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1479:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st385;
st385:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof385;
case 385:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 383, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1319, 1169, 1320, 974, 1435, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1480:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st386;
st386:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof386;
case 386:
	{
		static const unsigned short jump_table[] = { 1152, 1451, 1154, 1311, 1155, 1312, 974, 974, 1152, 1452, 1154, 1311, 1155, 1312, 974, 383, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1481:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st387;
st387:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof387;
case 387:
	{
		static const unsigned short jump_table[] = { 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 383, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 1152, 1310, 1154, 1311, 1155, 1312, 974, 974, 55, 55, 55, 55, 64, 96, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 1161, 974, 974, 974, 1311, 974, 974, 974, 974, 96, 1314, 64, 1315, 974, 974, 974, 974, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 95, 121, 194, 974, 224, 55, 55, 1003, 1318, 1167, 1413, 1169, 1414, 974, 1321, 974, 148, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 976, 976, 974, 1175, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 64, 96, 974, 974, 974, 974, 974, 974, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1176, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 149, 216, 974, 974, 974, 974, 151, 217, 974, 974, 974, 974, 974, 974, 974, 974, 153, 218, 153, 218, 974, 974, 974, 974, 155, 156, 157, 158, 159, 160, 161, 162, 95, 95, 95, 95, 974, 974, 974, 974, 1192, 76, 974, 95, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 167, 219, 976, 976, 974, 974, 976, 976, 169, 220 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st388:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof388;
case 388:
	{
		static const unsigned short jump_table[] = { 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 389, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 286, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 55, 974, 55, 974, 289, 974, 974, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1651, 1652, 1652, 1652, 1652, 1652, 1652, 1652, 1652, 976, 976, 976, 976, 976, 976, 976, 976, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 974, 974, 974, 1454, 974, 974, 323, 974, 289, 1463, 974, 1464, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 302, 974, 311, 974, 55, 974, 1467, 974, 1468, 974, 1469, 974, 1470, 974, 312, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 289, 974, 1647, 974, 974, 974, 1647, 974, 974, 974, 974, 974, 974, 974, 974, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 974, 313, 974, 974, 974, 974, 974, 314, 974, 974, 974, 974, 974, 974, 974, 974, 974, 315, 974, 315, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 328, 974, 336, 974, 974, 974, 974, 316, 974, 974, 974, 974, 974, 974, 974, 317 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st389:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof389;
case 389:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1484, 1484, 1483, 1483, 1484, 1484, 974, 974, 974, 974, 974, 974, 974, 271, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 277, 974, 278, 974, 974, 974, 974, 974, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1489, 1483, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1490, 281, 281, 282, 1483, 1483, 1483, 974, 974, 1493, 974, 974, 1494, 1494, 1495, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 1454, 974, 1467, 974, 974, 974, 974, 1454, 1454, 974, 974, 284, 974, 1454, 1454, 1454, 1454, 974, 1467, 1490, 974, 285, 1499, 1490, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1489, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1653, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr734:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st390;
st390:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof390;
case 390:
	{
		static const unsigned short jump_table[] = { 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 391, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 1453, 974, 1454, 974, 1455, 974, 974, 974, 55, 974, 55, 974, 289, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 976, 976, 976, 976, 976, 976, 976, 976, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 1461, 974, 974, 974, 1454, 974, 974, 974, 974, 289, 1463, 974, 1464, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 302, 974, 311, 974, 55, 974, 1467, 974, 1468, 974, 1469, 974, 1470, 974, 312, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 1472, 976, 976, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 289, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 1473, 974, 313, 974, 974, 974, 974, 974, 314, 974, 974, 974, 974, 974, 974, 974, 974, 974, 315, 974, 315, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 316, 974, 974, 974, 974, 974, 974, 974, 317 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st391:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof391;
case 391:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1484, 1484, 1483, 1483, 1484, 1484, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 277, 974, 278, 974, 974, 974, 974, 974, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1488, 1489, 1483, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1490, 281, 281, 282, 1483, 1483, 1483, 974, 974, 1493, 974, 974, 1494, 1494, 1495, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 974, 974, 974, 974, 974, 1496, 1453, 974, 1454, 974, 1467, 974, 974, 974, 974, 1454, 1454, 974, 974, 284, 974, 1454, 1454, 1454, 1454, 974, 1467, 1490, 974, 285, 1499, 1490, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1489, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1653, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr735:
	{
    SET_REX_PREFIX(*current_position);
  }
	goto st392;
st392:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof392;
case 392:
	if ( (*( current_position)) == 15u )
		goto st393;
	goto tr57;
st393:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof393;
case 393:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1484, 1484, 1483, 1483, 1484, 1484, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 320, 974, 321, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1591, 1483, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1490, 281, 281, 282, 1483, 1483, 1483, 974, 974, 1493, 974, 974, 1494, 1494, 1592, 1483, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1490, 974, 285, 1593, 1490, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1591, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1484, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974, 1483, 1483, 1483, 1483, 1483, 1483, 1653, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st394:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof394;
case 394:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 2, 919, 917, 917, 1656, 1657, 1658, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1659, 1660, 1661, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 920, 920, 920, 920, 8, 920, 920, 920, 1662, 1663, 1664, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1665, 1666, 1667, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 922, 922, 922, 922, 9, 922, 922, 922, 1656, 1668, 1669, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1659, 1670, 1671, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 1662, 1672, 1673, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1665, 1674, 1675, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr739:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st395;
st395:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof395;
case 395:
	{
		static const unsigned short jump_table[] = { 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1676, 974, 974, 974, 1677, 974, 974, 974, 1678, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974, 1679, 974, 974, 974, 1677, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr759:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st396;
st396:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof396;
case 396:
	switch( (*( current_position)) ) {
		case 166u: goto tr763;
		case 182u: goto tr763;
	}
	if ( (*( current_position)) < 158u ) {
		if ( (*( current_position)) < 142u ) {
			if ( 133u <= (*( current_position)) && (*( current_position)) <= 135u )
				goto tr763;
		} else if ( (*( current_position)) > 143u ) {
			if ( 149u <= (*( current_position)) && (*( current_position)) <= 151u )
				goto tr763;
		} else
			goto tr763;
	} else if ( (*( current_position)) > 159u ) {
		if ( (*( current_position)) < 204u ) {
			if ( 162u <= (*( current_position)) && (*( current_position)) <= 163u )
				goto tr763;
		} else if ( (*( current_position)) > 207u ) {
			if ( 236u <= (*( current_position)) && (*( current_position)) <= 239u )
				goto tr764;
		} else
			goto tr764;
	} else
		goto tr763;
	goto tr57;
tr763:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st397;
tr989:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st397;
tr990:
	{ SET_CPU_FEATURE(CPUFeature_FMA4);      }
	goto st397;
st397:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof397;
case 397:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 398, 974, 974, 974, 974, 974, 974, 974, 398, 974, 974, 974, 974, 974, 974, 974, 398, 974, 974, 974, 974, 974, 974, 974, 398, 974, 974, 974, 974, 974, 974, 974, 398, 974, 974, 974, 974, 974, 974, 974, 398, 974, 974, 974, 974, 974, 974, 974, 398, 974, 974, 974, 974, 974, 974, 974, 398, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st398:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof398;
case 398:
	{
		static const unsigned short jump_table[] = { 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685, 1685, 1685, 1685, 1685, 1685, 974, 1685, 1685 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr810:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st399;
tr768:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st399;
tr776:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st399;
tr771:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st399;
st399:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof399;
case 399:
	switch( (*( current_position)) ) {
		case 0u: goto tr769;
		case 16u: goto tr769;
		case 32u: goto tr769;
		case 48u: goto tr769;
		case 64u: goto tr769;
		case 80u: goto tr769;
		case 96u: goto tr769;
		case 112u: goto tr769;
		case 128u: goto tr769;
		case 144u: goto tr769;
		case 160u: goto tr769;
		case 176u: goto tr769;
		case 192u: goto tr769;
		case 208u: goto tr769;
		case 224u: goto tr769;
		case 240u: goto tr769;
	}
	goto tr57;
st400:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof400;
case 400:
	goto tr770;
tr811:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st401;
tr770:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st401;
st401:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof401;
case 401:
	goto tr771;
st402:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof402;
case 402:
	goto tr772;
tr828:
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st403;
tr812:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st403;
tr795:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st403;
tr772:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st403;
st403:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof403;
case 403:
	goto st404;
st404:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof404;
case 404:
	goto st405;
st405:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof405;
case 405:
	goto st406;
st406:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof406;
case 406:
	goto tr776;
tr764:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st407;
tr956:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st407;
tr991:
	{ SET_CPU_FEATURE(CPUFeature_AESAVX);    }
	goto st407;
tr1004:
	{ SET_CPU_FEATURE(CPUFeature_F16C);      }
	goto st407;
tr987:
	{ SET_CPU_FEATURE(CPUFeature_CLMULAVX);  }
	goto st407;
st407:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof407;
case 407:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 408, 974, 974, 974, 974, 974, 974, 974, 408, 974, 974, 974, 974, 974, 974, 974, 408, 974, 974, 974, 974, 974, 974, 974, 408, 974, 974, 974, 974, 974, 974, 974, 408, 974, 974, 974, 974, 974, 974, 974, 408, 974, 974, 974, 974, 974, 974, 974, 408, 974, 974, 974, 974, 974, 974, 974, 408, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr961:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st408;
st408:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof408;
case 408:
	{
		static const unsigned char jump_table[] = { 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116, 116, 116, 116, 116, 116, 0, 116, 116 };
		( current_state) = jump_table[(*( current_position))] + 974;
		goto _again;
	}
tr760:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st409;
st409:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof409;
case 409:
	if ( (*( current_position)) == 162u )
		goto tr763;
	goto tr57;
tr761:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st410;
st410:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof410;
case 410:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1680, 1680, 1680, 974, 974, 974, 974, 974, 974, 1680, 1680, 974, 974, 974, 974, 974, 1680, 1680, 1680, 974, 974, 974, 974, 974, 974, 1680, 1680, 974, 974, 1680, 1680, 974, 974, 1680, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1680, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1681, 1681, 1681, 1681, 974, 974, 974, 974, 974, 974, 974, 974, 1681, 1681, 1681, 1681, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1681, 1681, 1681, 1681, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr762:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st411;
st411:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof411;
case 411:
	if ( 162u <= (*( current_position)) && (*( current_position)) <= 163u )
		goto tr763;
	goto tr57;
tr740:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st412;
st412:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof412;
case 412:
	{
		static const unsigned short jump_table[] = { 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1696, 974, 974, 974, 1697, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974, 1695, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr778:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st413;
st413:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof413;
case 413:
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr781;
	goto tr57;
tr781:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st414;
tr955:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st414;
tr976:
	{ SET_CPU_FEATURE(CPUFeature_FMA);       }
	goto st414;
tr977:
	{ SET_CPU_FEATURE(CPUFeature_AESAVX);    }
	goto st414;
tr978:
	{ SET_CPU_FEATURE(CPUFeature_F16C);      }
	goto st414;
st414:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof414;
case 414:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 415, 974, 974, 974, 974, 974, 974, 974, 415, 974, 974, 974, 974, 974, 974, 974, 415, 974, 974, 974, 974, 974, 974, 974, 415, 974, 974, 974, 974, 974, 974, 974, 415, 974, 974, 974, 974, 974, 974, 974, 415, 974, 974, 974, 974, 974, 974, 974, 415, 974, 974, 974, 974, 974, 974, 974, 415, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr957:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st415;
st415:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof415;
case 415:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0, 0, 0, 0, 0, 0, 49, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 925;
		goto _again;
	}
tr779:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st416;
st416:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof416;
case 416:
	switch( (*( current_position)) ) {
		case 203u: goto tr781;
		case 219u: goto tr781;
	}
	if ( (*( current_position)) < 198u ) {
		if ( (*( current_position)) < 144u ) {
			if ( 128u <= (*( current_position)) && (*( current_position)) <= 131u )
				goto tr781;
		} else if ( (*( current_position)) > 155u ) {
			if ( 193u <= (*( current_position)) && (*( current_position)) <= 195u )
				goto tr781;
		} else
			goto tr781;
	} else if ( (*( current_position)) > 199u ) {
		if ( (*( current_position)) < 214u ) {
			if ( 209u <= (*( current_position)) && (*( current_position)) <= 211u )
				goto tr781;
		} else if ( (*( current_position)) > 215u ) {
			if ( 225u <= (*( current_position)) && (*( current_position)) <= 227u )
				goto tr781;
		} else
			goto tr781;
	} else
		goto tr781;
	goto tr57;
tr780:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st417;
st417:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof417;
case 417:
	if ( 128u <= (*( current_position)) && (*( current_position)) <= 129u )
		goto tr781;
	goto tr57;
tr741:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st418;
st418:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof418;
case 418:
	switch( (*( current_position)) ) {
		case 120u: goto tr783;
		case 248u: goto tr784;
	}
	goto tr57;
tr783:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st419;
st419:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof419;
case 419:
	if ( (*( current_position)) == 16u )
		goto tr785;
	goto tr57;
tr785:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st420;
tr787:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st420;
st420:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof420;
case 420:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1703, 974, 974, 974, 974, 974, 974, 974, 1703, 974, 974, 974, 974, 974, 974, 974, 1703, 974, 974, 974, 974, 974, 974, 974, 1703, 974, 974, 974, 974, 974, 974, 974, 1703, 974, 974, 974, 974, 974, 974, 974, 1703, 974, 974, 974, 974, 974, 974, 974, 1703, 974, 974, 974, 974, 974, 974, 974, 1703, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr786:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st421;
st421:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof421;
case 421:
	{
		static const unsigned short jump_table[] = { 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 974, 1356, 1356 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr784:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st422;
st422:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof422;
case 422:
	if ( (*( current_position)) == 16u )
		goto tr787;
	goto tr57;
tr742:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st423;
st423:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof423;
case 423:
	{
		static const unsigned short jump_table[] = { 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1705, 974, 974, 974, 1706, 974, 974, 974, 1707, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974, 1708, 974, 974, 974, 1706, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr788:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st424;
st424:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof424;
case 424:
	switch( (*( current_position)) ) {
		case 166u: goto tr792;
		case 182u: goto tr792;
	}
	if ( (*( current_position)) < 158u ) {
		if ( (*( current_position)) < 142u ) {
			if ( 133u <= (*( current_position)) && (*( current_position)) <= 135u )
				goto tr792;
		} else if ( (*( current_position)) > 143u ) {
			if ( 149u <= (*( current_position)) && (*( current_position)) <= 151u )
				goto tr792;
		} else
			goto tr792;
	} else if ( (*( current_position)) > 159u ) {
		if ( (*( current_position)) < 204u ) {
			if ( 162u <= (*( current_position)) && (*( current_position)) <= 163u )
				goto tr792;
		} else if ( (*( current_position)) > 207u ) {
			if ( 236u <= (*( current_position)) && (*( current_position)) <= 239u )
				goto tr793;
		} else
			goto tr793;
	} else
		goto tr792;
	goto tr57;
tr792:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st425;
tr1054:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st425;
tr1055:
	{ SET_CPU_FEATURE(CPUFeature_FMA4);      }
	goto st425;
st425:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof425;
case 425:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 426, 974, 974, 974, 974, 974, 974, 974, 426, 974, 974, 974, 974, 974, 974, 974, 426, 974, 974, 974, 974, 974, 974, 974, 426, 974, 974, 974, 974, 974, 974, 974, 426, 974, 974, 974, 974, 974, 974, 974, 426, 974, 974, 974, 974, 974, 974, 974, 426, 974, 974, 974, 974, 974, 974, 974, 426, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 400, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 402, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st426:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof426;
case 426:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0, 0, 0, 0, 0, 0, 27, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1685;
		goto _again;
	}
tr793:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st427;
tr1026:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st427;
tr1056:
	{ SET_CPU_FEATURE(CPUFeature_AESAVX);    }
	goto st427;
tr1059:
	{ SET_CPU_FEATURE(CPUFeature_F16C);      }
	goto st427;
tr1052:
	{ SET_CPU_FEATURE(CPUFeature_CLMULAVX);  }
	goto st427;
st427:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof427;
case 427:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 65, 974, 974, 974, 974, 974, 974, 974, 65, 974, 974, 974, 974, 974, 974, 974, 65, 974, 974, 974, 974, 974, 974, 974, 65, 974, 974, 974, 974, 974, 974, 974, 65, 974, 974, 974, 974, 974, 974, 974, 65, 974, 974, 974, 974, 974, 974, 974, 65, 974, 974, 974, 974, 974, 974, 974, 65, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 71, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 72, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr789:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st428;
st428:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof428;
case 428:
	if ( (*( current_position)) == 162u )
		goto tr792;
	goto tr57;
tr790:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st429;
st429:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof429;
case 429:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1709, 1709, 1709, 974, 974, 974, 974, 974, 974, 1709, 1709, 974, 974, 974, 974, 974, 1709, 1709, 1709, 974, 974, 974, 974, 974, 974, 1709, 1709, 974, 974, 1709, 1709, 974, 974, 1709, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1709, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1710, 1710, 1710, 1710, 974, 974, 974, 974, 974, 974, 974, 974, 1710, 1710, 1710, 1710, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1710, 1710, 1710, 1710, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr791:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st430;
st430:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof430;
case 430:
	if ( 162u <= (*( current_position)) && (*( current_position)) <= 163u )
		goto tr792;
	goto tr57;
tr743:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st431;
st431:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof431;
case 431:
	{
		static const unsigned short jump_table[] = { 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1714, 974, 974, 974, 1715, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974, 1713, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr796:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st432;
st432:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof432;
case 432:
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr799;
	goto tr57;
tr799:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st433;
tr1025:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st433;
tr1041:
	{ SET_CPU_FEATURE(CPUFeature_FMA);       }
	goto st433;
tr1042:
	{ SET_CPU_FEATURE(CPUFeature_AESAVX);    }
	goto st433;
tr1043:
	{ SET_CPU_FEATURE(CPUFeature_F16C);      }
	goto st433;
st433:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof433;
case 433:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 2, 974, 974, 974, 974, 974, 974, 974, 2, 974, 974, 974, 974, 974, 974, 974, 2, 974, 974, 974, 974, 974, 974, 974, 2, 974, 974, 974, 974, 974, 974, 974, 2, 974, 974, 974, 974, 974, 974, 974, 2, 974, 974, 974, 974, 974, 974, 974, 2, 974, 974, 974, 974, 974, 974, 974, 2, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 8, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 9, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr797:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st434;
st434:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof434;
case 434:
	switch( (*( current_position)) ) {
		case 203u: goto tr799;
		case 219u: goto tr799;
	}
	if ( (*( current_position)) < 198u ) {
		if ( (*( current_position)) < 144u ) {
			if ( 128u <= (*( current_position)) && (*( current_position)) <= 131u )
				goto tr799;
		} else if ( (*( current_position)) > 155u ) {
			if ( 193u <= (*( current_position)) && (*( current_position)) <= 195u )
				goto tr799;
		} else
			goto tr799;
	} else if ( (*( current_position)) > 199u ) {
		if ( (*( current_position)) < 214u ) {
			if ( 209u <= (*( current_position)) && (*( current_position)) <= 211u )
				goto tr799;
		} else if ( (*( current_position)) > 215u ) {
			if ( 225u <= (*( current_position)) && (*( current_position)) <= 227u )
				goto tr799;
		} else
			goto tr799;
	} else
		goto tr799;
	goto tr57;
tr798:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st435;
st435:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof435;
case 435:
	if ( 128u <= (*( current_position)) && (*( current_position)) <= 129u )
		goto tr799;
	goto tr57;
tr744:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st436;
st436:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof436;
case 436:
	switch( (*( current_position)) ) {
		case 120u: goto tr800;
		case 248u: goto tr801;
	}
	goto tr57;
tr800:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st437;
st437:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof437;
case 437:
	if ( (*( current_position)) == 16u )
		goto tr802;
	goto tr57;
tr802:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st438;
tr803:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st438;
st438:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof438;
case 438:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1349, 974, 974, 974, 974, 974, 974, 974, 1349, 974, 974, 974, 974, 974, 974, 974, 1349, 974, 974, 974, 974, 974, 974, 974, 1349, 974, 974, 974, 974, 974, 974, 974, 1349, 974, 974, 974, 974, 974, 974, 974, 1349, 974, 974, 974, 974, 974, 974, 974, 1349, 974, 974, 974, 974, 974, 974, 974, 1349, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1352, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 1354, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr801:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st439;
st439:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof439;
case 439:
	if ( (*( current_position)) == 16u )
		goto tr803;
	goto tr57;
tr745:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st440;
st440:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof440;
case 440:
	{
		static const unsigned short jump_table[] = { 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1721, 974, 974, 974, 1722, 974, 974, 974, 1723, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974, 1724, 974, 974, 974, 1722, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr804:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st441;
st441:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof441;
case 441:
	switch( (*( current_position)) ) {
		case 166u: goto tr808;
		case 182u: goto tr808;
	}
	if ( (*( current_position)) < 158u ) {
		if ( (*( current_position)) < 142u ) {
			if ( 133u <= (*( current_position)) && (*( current_position)) <= 135u )
				goto tr808;
		} else if ( (*( current_position)) > 143u ) {
			if ( 149u <= (*( current_position)) && (*( current_position)) <= 151u )
				goto tr808;
		} else
			goto tr808;
	} else if ( (*( current_position)) > 159u ) {
		if ( (*( current_position)) < 204u ) {
			if ( 162u <= (*( current_position)) && (*( current_position)) <= 163u )
				goto tr808;
		} else if ( (*( current_position)) > 207u ) {
			if ( 236u <= (*( current_position)) && (*( current_position)) <= 239u )
				goto tr809;
		} else
			goto tr809;
	} else
		goto tr808;
	goto tr57;
tr808:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st442;
tr1123:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st442;
tr1124:
	{ SET_CPU_FEATURE(CPUFeature_FMA4);      }
	goto st442;
st442:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof442;
case 442:
	{
		static const unsigned short jump_table[] = { 1727, 1727, 1727, 1727, 398, 974, 1727, 1727, 1727, 1727, 1727, 1727, 398, 974, 1727, 1727, 1727, 1727, 1727, 1727, 398, 974, 1727, 1727, 1727, 1727, 1727, 1727, 398, 974, 1727, 1727, 1727, 1727, 1727, 1727, 398, 974, 1727, 1727, 1727, 1727, 1727, 1727, 398, 974, 1727, 1727, 1727, 1727, 1727, 1727, 398, 974, 1727, 1727, 1727, 1727, 1727, 1727, 398, 974, 1727, 1727, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr809:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st443;
tr1083:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st443;
tr1125:
	{ SET_CPU_FEATURE(CPUFeature_AESAVX);    }
	goto st443;
tr1133:
	{ SET_CPU_FEATURE(CPUFeature_F16C);      }
	goto st443;
tr1121:
	{ SET_CPU_FEATURE(CPUFeature_CLMULAVX);  }
	goto st443;
st443:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof443;
case 443:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr805:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st444;
st444:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof444;
case 444:
	if ( (*( current_position)) == 162u )
		goto tr808;
	goto tr57;
tr806:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st445;
st445:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof445;
case 445:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1725, 1725, 1725, 974, 974, 974, 974, 974, 974, 1725, 1725, 974, 974, 974, 974, 974, 1725, 1725, 1725, 974, 974, 974, 974, 974, 974, 1725, 1725, 974, 974, 1725, 1725, 974, 974, 1725, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1725, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1726, 1726, 1726, 1726, 974, 974, 974, 974, 974, 974, 974, 974, 1726, 1726, 1726, 1726, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1726, 1726, 1726, 1726, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr807:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st446;
st446:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof446;
case 446:
	if ( 162u <= (*( current_position)) && (*( current_position)) <= 163u )
		goto tr808;
	goto tr57;
tr746:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st447;
st447:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof447;
case 447:
	{
		static const unsigned short jump_table[] = { 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1732, 974, 974, 974, 1733, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974, 1731, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr814:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st448;
st448:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof448;
case 448:
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr817;
	goto tr57;
tr817:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st449;
tr1081:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st449;
tr1110:
	{ SET_CPU_FEATURE(CPUFeature_FMA);       }
	goto st449;
tr1111:
	{ SET_CPU_FEATURE(CPUFeature_AESAVX);    }
	goto st449;
tr1112:
	{ SET_CPU_FEATURE(CPUFeature_F16C);      }
	goto st449;
st449:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof449;
case 449:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976, 976 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr815:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st450;
st450:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof450;
case 450:
	switch( (*( current_position)) ) {
		case 203u: goto tr817;
		case 219u: goto tr817;
	}
	if ( (*( current_position)) < 198u ) {
		if ( (*( current_position)) < 144u ) {
			if ( 128u <= (*( current_position)) && (*( current_position)) <= 131u )
				goto tr817;
		} else if ( (*( current_position)) > 155u ) {
			if ( 193u <= (*( current_position)) && (*( current_position)) <= 195u )
				goto tr817;
		} else
			goto tr817;
	} else if ( (*( current_position)) > 199u ) {
		if ( (*( current_position)) < 214u ) {
			if ( 209u <= (*( current_position)) && (*( current_position)) <= 211u )
				goto tr817;
		} else if ( (*( current_position)) > 215u ) {
			if ( 225u <= (*( current_position)) && (*( current_position)) <= 227u )
				goto tr817;
		} else
			goto tr817;
	} else
		goto tr817;
	goto tr57;
tr816:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st451;
st451:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof451;
case 451:
	if ( 128u <= (*( current_position)) && (*( current_position)) <= 129u )
		goto tr817;
	goto tr57;
tr747:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st452;
st452:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof452;
case 452:
	switch( (*( current_position)) ) {
		case 120u: goto tr818;
		case 248u: goto tr819;
	}
	goto tr57;
tr818:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st453;
st453:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof453;
case 453:
	if ( (*( current_position)) == 16u )
		goto tr820;
	goto tr57;
tr820:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st454;
tr821:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st454;
st454:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof454;
case 454:
	{
		static const unsigned short jump_table[] = { 1348, 1348, 1348, 1348, 1703, 974, 1348, 1348, 1348, 1348, 1348, 1348, 1703, 974, 1348, 1348, 1348, 1348, 1348, 1348, 1703, 974, 1348, 1348, 1348, 1348, 1348, 1348, 1703, 974, 1348, 1348, 1348, 1348, 1348, 1348, 1703, 974, 1348, 1348, 1348, 1348, 1348, 1348, 1703, 974, 1348, 1348, 1348, 1348, 1348, 1348, 1703, 974, 1348, 1348, 1348, 1348, 1348, 1348, 1703, 974, 1348, 1348, 1351, 1351, 1351, 1351, 1352, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1352, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1352, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1352, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1352, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1352, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1352, 1351, 1351, 1351, 1351, 1351, 1351, 1351, 1352, 1351, 1351, 1351, 1353, 1353, 1353, 1353, 1354, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1354, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1354, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1354, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1354, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1354, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1354, 1353, 1353, 1353, 1353, 1353, 1353, 1353, 1354, 1353, 1353, 1353, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355, 1355 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr819:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st455;
st455:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof455;
case 455:
	if ( (*( current_position)) == 16u )
		goto tr821;
	goto tr57;
tr748:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st456;
st456:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof456;
case 456:
	{
		static const unsigned short jump_table[] = { 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1739, 974, 974, 974, 1740, 974, 974, 974, 1741, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974, 1742, 974, 974, 974, 1740, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr822:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st457;
st457:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof457;
case 457:
	switch( (*( current_position)) ) {
		case 166u: goto tr826;
		case 182u: goto tr826;
	}
	if ( (*( current_position)) < 158u ) {
		if ( (*( current_position)) < 142u ) {
			if ( 133u <= (*( current_position)) && (*( current_position)) <= 135u )
				goto tr826;
		} else if ( (*( current_position)) > 143u ) {
			if ( 149u <= (*( current_position)) && (*( current_position)) <= 151u )
				goto tr826;
		} else
			goto tr826;
	} else if ( (*( current_position)) > 159u ) {
		if ( (*( current_position)) < 204u ) {
			if ( 162u <= (*( current_position)) && (*( current_position)) <= 163u )
				goto tr826;
		} else if ( (*( current_position)) > 207u ) {
			if ( 236u <= (*( current_position)) && (*( current_position)) <= 239u )
				goto tr827;
		} else
			goto tr827;
	} else
		goto tr826;
	goto tr57;
tr826:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st458;
tr1188:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st458;
tr1189:
	{ SET_CPU_FEATURE(CPUFeature_FMA4);      }
	goto st458;
st458:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof458;
case 458:
	{
		static const unsigned short jump_table[] = { 1727, 1727, 1727, 1727, 426, 1745, 1727, 1727, 1727, 1727, 1727, 1727, 426, 1745, 1727, 1727, 1727, 1727, 1727, 1727, 426, 1745, 1727, 1727, 1727, 1727, 1727, 1727, 426, 1745, 1727, 1727, 1727, 1727, 1727, 1727, 426, 1745, 1727, 1727, 1727, 1727, 1727, 1727, 426, 1745, 1727, 1727, 1727, 1727, 1727, 1727, 426, 1745, 1727, 1727, 1727, 1727, 1727, 1727, 426, 1745, 1727, 1727, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1728, 1728, 1728, 1728, 400, 1728, 1728, 1728, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 1729, 1729, 1729, 1729, 402, 1729, 1729, 1729, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399, 399 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr823:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st459;
st459:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof459;
case 459:
	if ( (*( current_position)) == 162u )
		goto tr826;
	goto tr57;
tr824:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st460;
st460:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof460;
case 460:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1743, 1743, 1743, 974, 974, 974, 974, 974, 974, 1743, 1743, 974, 974, 974, 974, 974, 1743, 1743, 1743, 974, 974, 974, 974, 974, 974, 1743, 1743, 974, 974, 1743, 1743, 974, 974, 1743, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1743, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1744, 1744, 1744, 1744, 974, 974, 974, 974, 974, 974, 974, 974, 1744, 1744, 1744, 1744, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1744, 1744, 1744, 1744, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr825:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st461;
st461:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof461;
case 461:
	if ( 162u <= (*( current_position)) && (*( current_position)) <= 163u )
		goto tr826;
	goto tr57;
tr749:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st462;
st462:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof462;
case 462:
	{
		static const unsigned short jump_table[] = { 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1747, 974, 974, 974, 1748, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974, 1746, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr829:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st463;
st463:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof463;
case 463:
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr832;
	goto tr57;
tr830:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st464;
st464:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof464;
case 464:
	switch( (*( current_position)) ) {
		case 203u: goto tr832;
		case 219u: goto tr832;
	}
	if ( (*( current_position)) < 198u ) {
		if ( (*( current_position)) < 144u ) {
			if ( 128u <= (*( current_position)) && (*( current_position)) <= 131u )
				goto tr832;
		} else if ( (*( current_position)) > 155u ) {
			if ( 193u <= (*( current_position)) && (*( current_position)) <= 195u )
				goto tr832;
		} else
			goto tr832;
	} else if ( (*( current_position)) > 199u ) {
		if ( (*( current_position)) < 214u ) {
			if ( 209u <= (*( current_position)) && (*( current_position)) <= 211u )
				goto tr832;
		} else if ( (*( current_position)) > 215u ) {
			if ( 225u <= (*( current_position)) && (*( current_position)) <= 227u )
				goto tr832;
		} else
			goto tr832;
	} else
		goto tr832;
	goto tr57;
tr831:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st465;
st465:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof465;
case 465:
	if ( 128u <= (*( current_position)) && (*( current_position)) <= 129u )
		goto tr832;
	goto tr57;
tr750:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st466;
st466:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof466;
case 466:
	switch( (*( current_position)) ) {
		case 120u: goto tr833;
		case 248u: goto tr834;
	}
	goto tr57;
tr833:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st467;
st467:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof467;
case 467:
	if ( (*( current_position)) == 16u )
		goto tr835;
	goto tr57;
tr834:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st468;
st468:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof468;
case 468:
	if ( (*( current_position)) == 16u )
		goto tr836;
	goto tr57;
tr751:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st469;
st469:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof469;
case 469:
	{
		static const unsigned short jump_table[] = { 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1754, 974, 974, 974, 974, 974, 974, 974, 1755, 974, 974, 974, 1697, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974, 1756, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr837:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st470;
st470:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof470;
case 470:
	switch( (*( current_position)) ) {
		case 1u: goto st471;
		case 2u: goto st473;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr781;
	goto tr57;
st471:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof471;
case 471:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1759, 974, 974, 974, 974, 974, 974, 974, 1759, 974, 974, 974, 974, 974, 974, 974, 1759, 974, 974, 974, 974, 974, 974, 974, 1759, 974, 974, 974, 974, 974, 974, 974, 1759, 974, 974, 974, 974, 974, 974, 974, 1759, 974, 974, 974, 974, 974, 974, 974, 1759, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr965:
	{
    SET_OPERAND_NAME(0, RegFromModRM(*current_position) |
                        RegisterExtentionFromREX(GET_REX_PREFIX()) |
                        RegisterExtentionFromVEX(GET_VEX_PREFIX2()));
  }
	goto st472;
tr842:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st472;
tr847:
	{ SET_CPU_FEATURE(CPUFeature_TBM);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st472;
tr1202:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st472;
tr1206:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	{
    SET_OPERAND_NAME(0, GetOperandFromVexAMD64(GET_VEX_PREFIX3()));
  }
	goto st472;
st472:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof472;
case 472:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0, 0, 0, 0, 0, 0, 31, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 943;
		goto _again;
	}
st473:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof473;
case 473:
	switch( (*( current_position)) ) {
		case 12u: goto tr842;
		case 52u: goto tr842;
		case 76u: goto tr843;
		case 116u: goto tr843;
		case 140u: goto tr844;
		case 180u: goto tr844;
	}
	goto tr57;
tr838:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st474;
st474:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof474;
case 474:
	{
		static const unsigned short jump_table[] = { 974, 471, 473, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1698, 1698, 1698, 1698, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 1698, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1698, 1698, 1698, 974, 974, 1698, 1698, 974, 974, 974, 1698, 974, 974, 974, 974, 974, 1698, 1698, 1698, 974, 974, 1698, 1698, 974, 974, 974, 1698, 974, 974, 974, 974, 974, 1698, 1698, 1698, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr839:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st475;
st475:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof475;
case 475:
	switch( (*( current_position)) ) {
		case 1u: goto st476;
		case 2u: goto st477;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr781;
	goto tr57;
st476:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof476;
case 476:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1764, 974, 974, 974, 974, 974, 974, 974, 1764, 974, 974, 974, 974, 974, 974, 974, 1764, 974, 974, 974, 974, 974, 974, 974, 1764, 974, 974, 974, 974, 974, 974, 974, 1764, 974, 974, 974, 974, 974, 974, 974, 1764, 974, 974, 974, 974, 974, 974, 974, 1764, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st477:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof477;
case 477:
	switch( (*( current_position)) ) {
		case 12u: goto tr847;
		case 52u: goto tr847;
		case 76u: goto tr848;
		case 116u: goto tr848;
		case 140u: goto tr849;
		case 180u: goto tr849;
	}
	goto tr57;
tr752:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st478;
st478:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof478;
case 478:
	{
		static const unsigned short jump_table[] = { 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1768, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1767, 974, 974, 974, 974, 974, 974, 974, 1769, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr850:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st479;
st479:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof479;
case 479:
	if ( (*( current_position)) == 18u )
		goto st480;
	goto tr57;
st480:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof480;
case 480:
	switch( (*( current_position)) ) {
		case 4u: goto tr854;
		case 12u: goto tr854;
		case 68u: goto tr855;
		case 76u: goto tr855;
		case 132u: goto tr856;
		case 140u: goto tr856;
	}
	goto tr57;
tr854:
	{ SET_CPU_FEATURE(CPUFeature_LWP);       }
	goto st481;
st481:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof481;
case 481:
	{
		static const unsigned short jump_table[] = { 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242, 1242, 1242, 1242, 1242, 1242, 974, 1242, 1242 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr851:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st482;
st482:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof482;
case 482:
	switch( (*( current_position)) ) {
		case 16u: goto tr785;
		case 18u: goto st480;
	}
	goto tr57;
tr852:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st483;
st483:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof483;
case 483:
	switch( (*( current_position)) ) {
		case 16u: goto tr787;
		case 18u: goto st480;
	}
	goto tr57;
tr753:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st484;
st484:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof484;
case 484:
	{
		static const unsigned short jump_table[] = { 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1774, 974, 974, 974, 974, 974, 974, 974, 1775, 974, 974, 974, 1715, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974, 1776, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr857:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st485;
st485:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof485;
case 485:
	switch( (*( current_position)) ) {
		case 1u: goto st486;
		case 2u: goto st487;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr799;
	goto tr57;
st486:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof486;
case 486:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1779, 974, 974, 974, 974, 974, 974, 974, 1779, 974, 974, 974, 974, 974, 974, 974, 1779, 974, 974, 974, 974, 974, 974, 974, 1779, 974, 974, 974, 974, 974, 974, 974, 1779, 974, 974, 974, 974, 974, 974, 974, 1779, 974, 974, 974, 974, 974, 974, 974, 1779, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 1760, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 1761, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st487:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof487;
case 487:
	switch( (*( current_position)) ) {
		case 12u: goto tr862;
		case 52u: goto tr862;
		case 76u: goto tr843;
		case 116u: goto tr843;
		case 140u: goto tr844;
		case 180u: goto tr844;
	}
	goto tr57;
tr858:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st488;
st488:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof488;
case 488:
	{
		static const unsigned short jump_table[] = { 974, 486, 487, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1716, 1716, 1716, 1716, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1716, 1716, 1716, 974, 974, 1716, 1716, 974, 974, 974, 1716, 974, 974, 974, 974, 974, 1716, 1716, 1716, 974, 974, 1716, 1716, 974, 974, 974, 1716, 974, 974, 974, 974, 974, 1716, 1716, 1716, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr859:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st489;
st489:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof489;
case 489:
	switch( (*( current_position)) ) {
		case 1u: goto st490;
		case 2u: goto st491;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr799;
	goto tr57;
st490:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof490;
case 490:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1782, 974, 974, 974, 974, 974, 974, 974, 1782, 974, 974, 974, 974, 974, 974, 974, 1782, 974, 974, 974, 974, 974, 974, 974, 1782, 974, 974, 974, 974, 974, 974, 974, 1782, 974, 974, 974, 974, 974, 974, 974, 1782, 974, 974, 974, 974, 974, 974, 974, 1782, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 1765, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 1766, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st491:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof491;
case 491:
	switch( (*( current_position)) ) {
		case 12u: goto tr865;
		case 52u: goto tr865;
		case 76u: goto tr848;
		case 116u: goto tr848;
		case 140u: goto tr849;
		case 180u: goto tr849;
	}
	goto tr57;
tr754:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st492;
st492:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof492;
case 492:
	{
		static const unsigned short jump_table[] = { 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1784, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1783, 974, 974, 974, 974, 974, 974, 974, 1785, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr866:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st493;
st493:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof493;
case 493:
	if ( (*( current_position)) == 18u )
		goto st494;
	goto tr57;
st494:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof494;
case 494:
	switch( (*( current_position)) ) {
		case 4u: goto tr870;
		case 12u: goto tr870;
		case 68u: goto tr855;
		case 76u: goto tr855;
		case 132u: goto tr856;
		case 140u: goto tr856;
	}
	goto tr57;
tr867:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st495;
st495:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof495;
case 495:
	switch( (*( current_position)) ) {
		case 16u: goto tr802;
		case 18u: goto st494;
	}
	goto tr57;
tr868:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st496;
st496:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof496;
case 496:
	switch( (*( current_position)) ) {
		case 16u: goto tr803;
		case 18u: goto st494;
	}
	goto tr57;
tr755:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st497;
st497:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof497;
case 497:
	{
		static const unsigned short jump_table[] = { 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1788, 974, 974, 974, 974, 974, 974, 974, 1789, 974, 974, 974, 1733, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1790, 974, 974, 974, 974, 974, 974, 974, 1791, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr871:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st498;
st498:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof498;
case 498:
	switch( (*( current_position)) ) {
		case 1u: goto st499;
		case 2u: goto st500;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr817;
	goto tr57;
st499:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof499;
case 499:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1794, 1794, 1794, 1794, 1759, 974, 1794, 1794, 1794, 1794, 1794, 1794, 1759, 974, 1794, 1794, 1794, 1794, 1794, 1794, 1759, 974, 1794, 1794, 1794, 1794, 1794, 1794, 1759, 974, 1794, 1794, 1794, 1794, 1794, 1794, 1759, 974, 1794, 1794, 1794, 1794, 1794, 1794, 1759, 974, 1794, 1794, 1794, 1794, 1794, 1794, 1759, 974, 1794, 1794, 974, 974, 974, 974, 974, 974, 974, 974, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 974, 974, 974, 974, 974, 974, 974, 974, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 974, 974, 974, 974, 974, 974, 974, 974, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st500:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof500;
case 500:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1794, 1794, 1794, 1794, 1759, 974, 1794, 1794, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1794, 1794, 1794, 1794, 1759, 974, 1794, 1794, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr872:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st501;
st501:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof501;
case 501:
	{
		static const unsigned short jump_table[] = { 974, 499, 500, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 502, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1734, 1734, 1734, 1734, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1734, 1734, 1734, 974, 974, 1734, 1734, 974, 974, 974, 1734, 974, 974, 974, 974, 974, 1734, 1734, 1734, 974, 974, 1734, 1734, 974, 974, 974, 1734, 974, 974, 974, 974, 974, 1734, 1734, 1734, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st502:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof502;
case 502:
	if ( (*( current_position)) > 199u ) {
		if ( 200u <= (*( current_position)) && (*( current_position)) <= 207u )
			goto tr883;
	} else if ( (*( current_position)) >= 192u )
		goto tr882;
	goto tr57;
tr873:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st503;
st503:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof503;
case 503:
	switch( (*( current_position)) ) {
		case 1u: goto st504;
		case 2u: goto st505;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr817;
	goto tr57;
st504:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof504;
case 504:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1803, 1803, 1803, 1803, 1764, 974, 1803, 1803, 1803, 1803, 1803, 1803, 1764, 974, 1803, 1803, 1803, 1803, 1803, 1803, 1764, 974, 1803, 1803, 1803, 1803, 1803, 1803, 1764, 974, 1803, 1803, 1803, 1803, 1803, 1803, 1764, 974, 1803, 1803, 1803, 1803, 1803, 1803, 1764, 974, 1803, 1803, 1803, 1803, 1803, 1803, 1764, 974, 1803, 1803, 974, 974, 974, 974, 974, 974, 974, 974, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 974, 974, 974, 974, 974, 974, 974, 974, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 974, 974, 974, 974, 974, 974, 974, 974, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st505:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof505;
case 505:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1803, 1803, 1803, 1803, 1764, 974, 1803, 1803, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1803, 1803, 1803, 1803, 1764, 974, 1803, 1803, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr874:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st506;
st506:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof506;
case 506:
	switch( (*( current_position)) ) {
		case 1u: goto st504;
		case 2u: goto st505;
		case 18u: goto st507;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr817;
	goto tr57;
st507:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof507;
case 507:
	if ( (*( current_position)) > 199u ) {
		if ( 200u <= (*( current_position)) && (*( current_position)) <= 207u )
			goto tr891;
	} else if ( (*( current_position)) >= 192u )
		goto tr882;
	goto tr57;
tr756:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st508;
st508:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof508;
case 508:
	{
		static const unsigned short jump_table[] = { 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1810, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1809, 974, 974, 974, 974, 974, 974, 974, 1811, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr892:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st509;
st509:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof509;
case 509:
	if ( (*( current_position)) == 18u )
		goto st510;
	goto tr57;
st510:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof510;
case 510:
	{
		static const unsigned short jump_table[] = { 1813, 1813, 1813, 1813, 1771, 974, 1813, 1813, 1813, 1813, 1813, 1813, 1771, 974, 1813, 1813, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1814, 1814, 1814, 1814, 1772, 1814, 1814, 1814, 1814, 1814, 1814, 1814, 1772, 1814, 1814, 1814, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1815, 1815, 1815, 1815, 1773, 1815, 1815, 1815, 1815, 1815, 1815, 1815, 1773, 1815, 1815, 1815, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 1816, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr893:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st511;
st511:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof511;
case 511:
	switch( (*( current_position)) ) {
		case 16u: goto tr820;
		case 18u: goto st510;
	}
	goto tr57;
tr894:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st512;
st512:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof512;
case 512:
	switch( (*( current_position)) ) {
		case 16u: goto tr821;
		case 18u: goto st510;
	}
	goto tr57;
tr757:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st513;
st513:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof513;
case 513:
	{
		static const unsigned short jump_table[] = { 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1817, 974, 974, 974, 974, 974, 974, 974, 1818, 974, 974, 974, 1748, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1819, 974, 974, 974, 974, 974, 974, 974, 1820, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr900:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st514;
st514:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof514;
case 514:
	switch( (*( current_position)) ) {
		case 1u: goto st515;
		case 2u: goto st516;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr832;
	goto tr57;
st515:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof515;
case 515:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1794, 1794, 1794, 1794, 1779, 1823, 1794, 1794, 1794, 1794, 1794, 1794, 1779, 1823, 1794, 1794, 1794, 1794, 1794, 1794, 1779, 1823, 1794, 1794, 1794, 1794, 1794, 1794, 1779, 1823, 1794, 1794, 1794, 1794, 1794, 1794, 1779, 1823, 1794, 1794, 1794, 1794, 1794, 1794, 1779, 1823, 1794, 1794, 1794, 1794, 1794, 1794, 1779, 1823, 1794, 1794, 974, 974, 974, 974, 974, 974, 974, 974, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 974, 974, 974, 974, 974, 974, 974, 974, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 974, 974, 974, 974, 974, 974, 974, 974, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st516:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof516;
case 516:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1794, 1794, 1794, 1794, 1779, 1823, 1794, 1794, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1794, 1794, 1794, 1794, 1779, 1823, 1794, 1794, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1795, 1795, 1795, 1795, 1760, 1795, 1795, 1795, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1796, 1796, 1796, 1796, 1761, 1796, 1796, 1796, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 1797, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr901:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st517;
st517:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof517;
case 517:
	{
		static const unsigned short jump_table[] = { 974, 515, 516, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 502, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1749, 1749, 1749, 1749, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 1749, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1749, 1749, 1749, 974, 974, 1749, 1749, 974, 974, 974, 1749, 974, 974, 974, 974, 974, 1749, 1749, 1749, 974, 974, 1749, 1749, 974, 974, 974, 1749, 974, 974, 974, 974, 974, 1749, 1749, 1749, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr902:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st518;
st518:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof518;
case 518:
	switch( (*( current_position)) ) {
		case 1u: goto st519;
		case 2u: goto st520;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr832;
	goto tr57;
st519:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof519;
case 519:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1803, 1803, 1803, 1803, 1782, 1826, 1803, 1803, 1803, 1803, 1803, 1803, 1782, 1826, 1803, 1803, 1803, 1803, 1803, 1803, 1782, 1826, 1803, 1803, 1803, 1803, 1803, 1803, 1782, 1826, 1803, 1803, 1803, 1803, 1803, 1803, 1782, 1826, 1803, 1803, 1803, 1803, 1803, 1803, 1782, 1826, 1803, 1803, 1803, 1803, 1803, 1803, 1782, 1826, 1803, 1803, 974, 974, 974, 974, 974, 974, 974, 974, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 974, 974, 974, 974, 974, 974, 974, 974, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 974, 974, 974, 974, 974, 974, 974, 974, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st520:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof520;
case 520:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1803, 1803, 1803, 1803, 1782, 1826, 1803, 1803, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1803, 1803, 1803, 1803, 1782, 1826, 1803, 1803, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1804, 1804, 1804, 1804, 1765, 1804, 1804, 1804, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1805, 1805, 1805, 1805, 1766, 1805, 1805, 1805, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 1806, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr903:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st521;
st521:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof521;
case 521:
	switch( (*( current_position)) ) {
		case 1u: goto st519;
		case 2u: goto st520;
		case 18u: goto st507;
	}
	if ( 144u <= (*( current_position)) && (*( current_position)) <= 155u )
		goto tr832;
	goto tr57;
tr758:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st522;
st522:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof522;
case 522:
	{
		static const unsigned short jump_table[] = { 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1828, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1827, 974, 974, 974, 974, 974, 974, 974, 1829, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr910:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st523;
st523:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof523;
case 523:
	if ( (*( current_position)) == 18u )
		goto st524;
	goto tr57;
st524:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof524;
case 524:
	switch( (*( current_position)) ) {
		case 4u: goto tr870;
		case 5u: goto tr914;
		case 12u: goto tr870;
		case 13u: goto tr914;
		case 68u: goto tr855;
		case 76u: goto tr855;
		case 132u: goto tr856;
		case 140u: goto tr856;
	}
	if ( (*( current_position)) < 64u ) {
		if ( (*( current_position)) <= 15u )
			goto tr896;
	} else if ( (*( current_position)) > 79u ) {
		if ( (*( current_position)) > 143u ) {
			if ( 192u <= (*( current_position)) && (*( current_position)) <= 207u )
				goto tr899;
		} else if ( (*( current_position)) >= 128u )
			goto tr898;
	} else
		goto tr897;
	goto tr57;
tr911:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st525;
st525:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof525;
case 525:
	switch( (*( current_position)) ) {
		case 16u: goto tr835;
		case 18u: goto st524;
	}
	goto tr57;
tr912:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st526;
st526:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof526;
case 526:
	switch( (*( current_position)) ) {
		case 16u: goto tr836;
		case 18u: goto st524;
	}
	goto tr57;
st527:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof527;
case 527:
	{
		static const unsigned short jump_table[] = { 974, 1832, 1833, 1834, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1835, 1836, 1837, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1838, 1839, 1840, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1841, 1842, 1843, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1844, 1845, 1834, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1846, 1847, 1837, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1848, 1849, 1840, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1850, 1851, 1843, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr915:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st528;
st528:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof528;
case 528:
	{
		static const unsigned short jump_table[] = { 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1852, 1853, 1854, 1855, 1856, 1857, 974, 1858, 1859, 1860, 1861, 1862, 1863, 1864, 1865, 1866, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 974, 1867, 1867, 974, 974, 974, 974, 974, 1868, 1869, 1869, 974, 1870, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr935:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st529;
st529:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof529;
case 529:
	switch( (*( current_position)) ) {
		case 18u: goto st530;
		case 22u: goto st530;
		case 81u: goto tr955;
		case 194u: goto tr956;
		case 198u: goto tr956;
	}
	if ( (*( current_position)) < 46u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 23u )
			goto tr955;
	} else if ( (*( current_position)) > 47u ) {
		if ( (*( current_position)) > 89u ) {
			if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr955;
		} else if ( (*( current_position)) >= 84u )
			goto tr955;
	} else
		goto tr955;
	goto tr57;
st530:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof530;
case 530:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1874, 974, 974, 974, 974, 974, 974, 974, 1874, 974, 974, 974, 974, 974, 974, 974, 1874, 974, 974, 974, 974, 974, 974, 974, 1874, 974, 974, 974, 974, 974, 974, 974, 1874, 974, 974, 974, 974, 974, 974, 974, 1874, 974, 974, 974, 974, 974, 974, 974, 1874, 974, 974, 974, 974, 974, 974, 974, 1874, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr936:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st531;
st531:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof531;
case 531:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 974, 974, 974, 974, 974, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 974, 974, 974, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974, 1872, 1872, 1872, 1872, 1872, 1872, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr937:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st532;
st532:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof532;
case 532:
	switch( (*( current_position)) ) {
		case 42u: goto tr955;
		case 81u: goto tr955;
		case 83u: goto tr955;
		case 194u: goto tr956;
	}
	if ( (*( current_position)) > 90u ) {
		if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
			goto tr955;
	} else if ( (*( current_position)) >= 88u )
		goto tr955;
	goto tr57;
tr938:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st533;
st533:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof533;
case 533:
	switch( (*( current_position)) ) {
		case 42u: goto tr955;
		case 81u: goto tr955;
		case 194u: goto tr956;
		case 208u: goto tr955;
	}
	if ( (*( current_position)) < 92u ) {
		if ( 88u <= (*( current_position)) && (*( current_position)) <= 90u )
			goto tr955;
	} else if ( (*( current_position)) > 95u ) {
		if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
			goto tr955;
	} else
		goto tr955;
	goto tr57;
tr939:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st534;
st534:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof534;
case 534:
	switch( (*( current_position)) ) {
		case 81u: goto tr955;
		case 194u: goto tr956;
		case 198u: goto tr956;
	}
	if ( (*( current_position)) < 84u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr955;
	} else if ( (*( current_position)) > 89u ) {
		if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
			goto tr955;
	} else
		goto tr955;
	goto tr57;
tr940:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st535;
st535:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof535;
case 535:
	switch( (*( current_position)) ) {
		case 81u: goto tr955;
		case 194u: goto tr956;
		case 198u: goto tr956;
		case 208u: goto tr955;
	}
	if ( (*( current_position)) < 84u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr955;
	} else if ( (*( current_position)) > 89u ) {
		if ( (*( current_position)) > 95u ) {
			if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
				goto tr955;
		} else if ( (*( current_position)) >= 92u )
			goto tr955;
	} else
		goto tr955;
	goto tr57;
tr941:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st536;
st536:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof536;
case 536:
	if ( (*( current_position)) == 208u )
		goto tr955;
	if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
		goto tr955;
	goto tr57;
tr942:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st537;
st537:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof537;
case 537:
	switch( (*( current_position)) ) {
		case 18u: goto st530;
		case 22u: goto st530;
		case 43u: goto tr955;
		case 194u: goto tr956;
		case 198u: goto tr956;
	}
	if ( (*( current_position)) < 40u ) {
		if ( 16u <= (*( current_position)) && (*( current_position)) <= 23u )
			goto tr955;
	} else if ( (*( current_position)) > 41u ) {
		if ( (*( current_position)) > 47u ) {
			if ( 81u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr955;
		} else if ( (*( current_position)) >= 46u )
			goto tr955;
	} else
		goto tr955;
	goto tr57;
tr943:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st538;
st538:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof538;
case 538:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 974, 1872, 974, 974, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1873, 974, 974, 974, 1872, 1872, 1872, 974, 974, 974, 974, 974, 1872, 1872, 974, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 974, 539, 974, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974, 1872, 1872, 1872, 1872, 1872, 1872, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st539:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof539;
case 539:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1878, 974, 974, 974, 974, 974, 974, 974, 1878, 974, 974, 974, 974, 974, 974, 974, 1878, 974, 974, 974, 974, 974, 974, 974, 1878, 974, 974, 974, 974, 974, 974, 974, 1878, 974, 974, 974, 974, 974, 974, 974, 1878, 974, 974, 974, 974, 974, 974, 974, 1878, 974, 974, 974, 974, 974, 974, 974, 1878, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr944:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st540;
st540:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof540;
case 540:
	switch( (*( current_position)) ) {
		case 22u: goto tr955;
		case 42u: goto tr955;
		case 111u: goto tr955;
		case 112u: goto tr956;
		case 194u: goto tr956;
		case 230u: goto tr955;
	}
	if ( (*( current_position)) < 81u ) {
		if ( (*( current_position)) > 18u ) {
			if ( 44u <= (*( current_position)) && (*( current_position)) <= 45u )
				goto tr964;
		} else if ( (*( current_position)) >= 16u )
			goto tr955;
	} else if ( (*( current_position)) > 83u ) {
		if ( (*( current_position)) > 95u ) {
			if ( 126u <= (*( current_position)) && (*( current_position)) <= 127u )
				goto tr955;
		} else if ( (*( current_position)) >= 88u )
			goto tr955;
	} else
		goto tr955;
	goto tr57;
tr975:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st541;
tr979:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st541;
tr964:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st541;
tr966:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st541;
st541:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof541;
case 541:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1882, 974, 974, 974, 974, 974, 974, 974, 1882, 974, 974, 974, 974, 974, 974, 974, 1882, 974, 974, 974, 974, 974, 974, 974, 1882, 974, 974, 974, 974, 974, 974, 974, 1882, 974, 974, 974, 974, 974, 974, 974, 1882, 974, 974, 974, 974, 974, 974, 974, 1882, 974, 974, 974, 974, 974, 974, 974, 1882, 974, 974, 974, 974, 974, 974, 974, 939, 974, 974, 974, 974, 974, 974, 974, 939, 974, 974, 974, 974, 974, 974, 974, 939, 974, 974, 974, 974, 974, 974, 974, 939, 974, 974, 974, 974, 974, 974, 974, 939, 974, 974, 974, 974, 974, 974, 974, 939, 974, 974, 974, 974, 974, 974, 974, 939, 974, 974, 974, 974, 974, 974, 974, 939, 974, 974, 974, 974, 974, 974, 974, 941, 974, 974, 974, 974, 974, 974, 974, 941, 974, 974, 974, 974, 974, 974, 974, 941, 974, 974, 974, 974, 974, 974, 974, 941, 974, 974, 974, 974, 974, 974, 974, 941, 974, 974, 974, 974, 974, 974, 974, 941, 974, 974, 974, 974, 974, 974, 974, 941, 974, 974, 974, 974, 974, 974, 974, 941, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr945:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st542;
st542:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof542;
case 542:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 1881, 1881, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 974, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr946:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st543;
st543:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof543;
case 543:
	switch( (*( current_position)) ) {
		case 43u: goto tr955;
		case 194u: goto tr956;
		case 198u: goto tr956;
	}
	if ( (*( current_position)) < 20u ) {
		if ( 16u <= (*( current_position)) && (*( current_position)) <= 17u )
			goto tr955;
	} else if ( (*( current_position)) > 21u ) {
		if ( (*( current_position)) > 41u ) {
			if ( 81u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr955;
		} else if ( (*( current_position)) >= 40u )
			goto tr955;
	} else
		goto tr955;
	goto tr57;
tr947:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st544;
st544:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof544;
case 544:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 974, 974, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 974, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 974, 974, 974, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 974, 974, 974, 974, 974, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr948:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st545;
st545:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof545;
case 545:
	switch( (*( current_position)) ) {
		case 18u: goto tr955;
		case 22u: goto tr955;
		case 91u: goto tr955;
		case 127u: goto tr955;
		case 230u: goto tr955;
	}
	goto tr57;
tr949:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st546;
st546:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof546;
case 546:
	switch( (*( current_position)) ) {
		case 18u: goto tr955;
		case 208u: goto tr955;
		case 230u: goto tr955;
		case 240u: goto tr955;
	}
	if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
		goto tr955;
	goto tr57;
tr950:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st547;
st547:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof547;
case 547:
	if ( (*( current_position)) == 42u )
		goto tr955;
	goto tr57;
tr951:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st548;
st548:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof548;
case 548:
	if ( (*( current_position)) == 110u )
		goto tr955;
	goto tr57;
tr952:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st549;
st549:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof549;
case 549:
	if ( (*( current_position)) == 42u )
		goto tr955;
	if ( 44u <= (*( current_position)) && (*( current_position)) <= 45u )
		goto tr966;
	goto tr57;
tr953:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st550;
st550:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof550;
case 550:
	if ( (*( current_position)) == 126u )
		goto tr955;
	goto tr57;
tr916:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st551;
st551:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof551;
case 551:
	{
		static const unsigned short jump_table[] = { 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1885, 974, 974, 974, 1886, 974, 974, 1884, 1887, 974, 974, 974, 1888, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974, 1889, 1890, 974, 974, 974, 1891, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr967:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st552;
st552:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof552;
case 552:
	switch( (*( current_position)) ) {
		case 242u: goto tr975;
		case 247u: goto tr975;
	}
	goto tr57;
tr968:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st553;
st553:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof553;
case 553:
	if ( (*( current_position)) < 55u ) {
		if ( (*( current_position)) < 40u ) {
			if ( (*( current_position)) <= 13u )
				goto tr955;
		} else if ( (*( current_position)) > 41u ) {
			if ( 43u <= (*( current_position)) && (*( current_position)) <= 47u )
				goto tr955;
		} else
			goto tr955;
	} else if ( (*( current_position)) > 64u ) {
		if ( (*( current_position)) < 166u ) {
			if ( 150u <= (*( current_position)) && (*( current_position)) <= 159u )
				goto tr976;
		} else if ( (*( current_position)) > 175u ) {
			if ( (*( current_position)) > 191u ) {
				if ( 219u <= (*( current_position)) && (*( current_position)) <= 223u )
					goto tr977;
			} else if ( (*( current_position)) >= 182u )
				goto tr976;
		} else
			goto tr976;
	} else
		goto tr955;
	goto tr57;
tr969:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st554;
st554:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof554;
case 554:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1893, 1893, 1893, 974, 1893, 974, 1893, 974, 1893, 974, 974, 974, 974, 974, 974, 974, 1893, 1893, 1893, 974, 1893, 974, 1893, 974, 1893, 974, 974, 974, 974, 974, 974, 974, 1893, 1893, 1893, 974, 1893, 974, 1893, 974, 1893, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr970:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st555;
st555:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof555;
case 555:
	{
		static const unsigned short jump_table[] = { 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 974, 1895, 974, 974, 974, 1872, 1872, 974, 974, 974, 1872, 1872, 1872, 974, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 974, 974, 974, 974, 974, 974, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 974, 974, 974, 974, 974, 974, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 1893, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1894, 1894, 1894, 1894, 1894, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr971:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st556;
st556:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof556;
case 556:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 1872, 974, 974, 974, 1895, 974, 974, 974, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1872, 1872, 1872, 1872, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1893, 1893, 1893, 974, 1893, 974, 1893, 974, 1893, 974, 974, 974, 974, 974, 974, 974, 1893, 1893, 1893, 974, 1893, 974, 1893, 974, 1893, 974, 974, 974, 974, 974, 974, 974, 1893, 1893, 1893, 974, 1893, 974, 1893, 974, 1893, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr972:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st557;
st557:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof557;
case 557:
	switch( (*( current_position)) ) {
		case 242u: goto tr979;
		case 247u: goto tr979;
	}
	goto tr57;
tr973:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st558;
st558:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof558;
case 558:
	if ( (*( current_position)) < 166u ) {
		if ( 150u <= (*( current_position)) && (*( current_position)) <= 159u )
			goto tr976;
	} else if ( (*( current_position)) > 175u ) {
		if ( 182u <= (*( current_position)) && (*( current_position)) <= 191u )
			goto tr976;
	} else
		goto tr976;
	goto tr57;
tr974:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st559;
st559:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof559;
case 559:
	switch( (*( current_position)) ) {
		case 154u: goto tr976;
		case 156u: goto tr976;
		case 158u: goto tr976;
		case 170u: goto tr976;
		case 172u: goto tr976;
		case 174u: goto tr976;
		case 186u: goto tr976;
		case 188u: goto tr976;
		case 190u: goto tr976;
	}
	if ( (*( current_position)) < 166u ) {
		if ( 150u <= (*( current_position)) && (*( current_position)) <= 152u )
			goto tr976;
	} else if ( (*( current_position)) > 168u ) {
		if ( 182u <= (*( current_position)) && (*( current_position)) <= 184u )
			goto tr976;
	} else
		goto tr976;
	goto tr57;
tr917:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st560;
st560:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof560;
case 560:
	{
		static const unsigned short jump_table[] = { 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1897, 974, 974, 974, 1898, 974, 974, 974, 1899, 974, 974, 974, 1900, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1901, 974, 974, 974, 1902, 974, 974, 974, 1903, 974, 974, 974, 1902, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr980:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st561;
st561:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof561;
case 561:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1873, 1873, 1873, 1873, 1873, 1873, 1873, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 1873, 1873, 974, 1904, 974, 974, 974, 1905, 1905, 1906, 1906, 1906, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1908, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr988:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st562;
st562:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof562;
case 562:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 563, 974, 974, 974, 974, 974, 974, 974, 563, 974, 974, 974, 974, 974, 974, 974, 563, 974, 974, 974, 974, 974, 974, 974, 563, 974, 974, 974, 974, 974, 974, 974, 563, 974, 974, 974, 974, 974, 974, 974, 563, 974, 974, 974, 974, 974, 974, 974, 563, 974, 974, 974, 974, 974, 974, 974, 563, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st563:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof563;
case 563:
	{
		static const unsigned short jump_table[] = { 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912, 1912, 1912, 1912, 1912, 1912, 974, 1912, 1912 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1126:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st564;
tr995:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st564;
tr1003:
	{
    SET_DISP_TYPE(DISP32);
    SET_DISP_PTR(current_position - 3);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st564;
tr998:
	{
    SET_DISP_TYPE(DISP8);
    SET_DISP_PTR(current_position);
  }
	{
    CheckAccess(instruction_start - data, base, index, restricted_register,
                valid_targets, &instruction_info_collected);
  }
	goto st564;
st564:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof564;
case 564:
	{
		static const unsigned short jump_table[] = { 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1913, 1913, 1913, 1913, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st565:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof565;
case 565:
	goto tr997;
tr1127:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st566;
tr997:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st566;
st566:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof566;
case 566:
	goto tr998;
st567:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof567;
case 567:
	goto tr999;
tr1191:
	{
    SET_MODRM_BASE(REG_RIP);
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st568;
tr1128:
	{
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(NO_REG);
    SET_MODRM_SCALE(0);
  }
	goto st568;
tr1058:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(NO_REG);
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st568;
tr999:
	{
    SET_DISP_TYPE(DISPNONE);
    SET_MODRM_BASE(BaseFromSIB(*current_position) |
                   BaseExtentionFromREX(GET_REX_PREFIX()) |
                   BaseExtentionFromVEX(GET_VEX_PREFIX2()));
    SET_MODRM_INDEX(index_registers[IndexFromSIB(*current_position) |
                                    IndexExtentionFromREX(GET_REX_PREFIX()) |
                                    IndexExtentionFromVEX(GET_VEX_PREFIX2())]);
    SET_MODRM_SCALE(ScaleFromSIB(*current_position));
  }
	goto st568;
st568:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof568;
case 568:
	goto st569;
st569:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof569;
case 569:
	goto st570;
st570:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof570;
case 570:
	goto st571;
st571:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof571;
case 571:
	goto tr1003;
tr981:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st572;
st572:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof572;
case 572:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 1873, 974, 1873, 1873, 974, 974, 1873, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 974, 974, 974, 974, 974, 974, 974, 1905, 1905, 1906, 1906, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 974, 974, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 974, 974, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr982:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st573;
st573:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof573;
case 573:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1873, 1873, 974, 974, 1873, 1873, 1873, 1873, 1873, 1873, 1873, 1873, 974, 974, 974, 974, 539, 539, 1873, 1873, 974, 974, 974, 974, 974, 1921, 974, 974, 539, 1873, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 1873, 1873, 974, 1904, 974, 974, 974, 1905, 1905, 1906, 1906, 1906, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 1907, 1907, 1873, 1873, 1873, 1873, 974, 974, 974, 974, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1908, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr983:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st574;
st574:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof574;
case 574:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1873, 1873, 1873, 974, 1873, 1873, 974, 974, 1873, 1873, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 1873, 974, 974, 974, 1921, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1873, 974, 974, 974, 974, 974, 974, 974, 1905, 1905, 1906, 1906, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 974, 974, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1907, 1907, 974, 974, 1907, 1907, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr984:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st575;
st575:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof575;
case 575:
	if ( (*( current_position)) < 92u ) {
		if ( 72u <= (*( current_position)) && (*( current_position)) <= 73u )
			goto tr988;
	} else if ( (*( current_position)) > 95u ) {
		if ( (*( current_position)) > 111u ) {
			if ( 120u <= (*( current_position)) && (*( current_position)) <= 127u )
				goto tr990;
		} else if ( (*( current_position)) >= 104u )
			goto tr990;
	} else
		goto tr990;
	goto tr57;
tr985:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st576;
st576:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof576;
case 576:
	if ( (*( current_position)) < 104u ) {
		if ( (*( current_position)) > 73u ) {
			if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr990;
		} else if ( (*( current_position)) >= 72u )
			goto tr988;
	} else if ( (*( current_position)) > 105u ) {
		if ( (*( current_position)) < 120u ) {
			if ( 108u <= (*( current_position)) && (*( current_position)) <= 109u )
				goto tr990;
		} else if ( (*( current_position)) > 121u ) {
			if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
				goto tr990;
		} else
			goto tr990;
	} else
		goto tr990;
	goto tr57;
tr986:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st577;
st577:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof577;
case 577:
	switch( (*( current_position)) ) {
		case 22u: goto tr956;
		case 34u: goto tr956;
	}
	if ( (*( current_position)) < 92u ) {
		if ( 72u <= (*( current_position)) && (*( current_position)) <= 73u )
			goto tr988;
	} else if ( (*( current_position)) > 95u ) {
		if ( (*( current_position)) > 111u ) {
			if ( 120u <= (*( current_position)) && (*( current_position)) <= 127u )
				goto tr990;
		} else if ( (*( current_position)) >= 104u )
			goto tr990;
	} else
		goto tr990;
	goto tr57;
tr918:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st578;
st578:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof578;
case 578:
	{
		static const unsigned short jump_table[] = { 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1922, 1923, 1924, 1925, 1926, 1927, 974, 1928, 1929, 1930, 1931, 1932, 1933, 1934, 1935, 1936, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 974, 1937, 1937, 974, 974, 974, 974, 974, 1938, 1939, 1939, 974, 1940, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1005:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st579;
st579:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof579;
case 579:
	switch( (*( current_position)) ) {
		case 18u: goto st580;
		case 22u: goto st580;
		case 81u: goto tr1025;
		case 194u: goto tr1026;
		case 198u: goto tr1026;
	}
	if ( (*( current_position)) < 46u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 23u )
			goto tr1025;
	} else if ( (*( current_position)) > 47u ) {
		if ( (*( current_position)) > 89u ) {
			if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1025;
		} else if ( (*( current_position)) >= 84u )
			goto tr1025;
	} else
		goto tr1025;
	goto tr57;
st580:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof580;
case 580:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1944, 974, 974, 974, 974, 974, 974, 974, 1944, 974, 974, 974, 974, 974, 974, 974, 1944, 974, 974, 974, 974, 974, 974, 974, 1944, 974, 974, 974, 974, 974, 974, 974, 1944, 974, 974, 974, 974, 974, 974, 974, 1944, 974, 974, 974, 974, 974, 974, 974, 1944, 974, 974, 974, 974, 974, 974, 974, 1944, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1875, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 1876, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1006:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st581;
st581:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof581;
case 581:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 974, 974, 974, 974, 974, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 974, 974, 974, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974, 1942, 1942, 1942, 1942, 1942, 1942, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1007:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st582;
st582:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof582;
case 582:
	switch( (*( current_position)) ) {
		case 42u: goto tr1025;
		case 81u: goto tr1025;
		case 83u: goto tr1025;
		case 194u: goto tr1026;
	}
	if ( (*( current_position)) > 90u ) {
		if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
			goto tr1025;
	} else if ( (*( current_position)) >= 88u )
		goto tr1025;
	goto tr57;
tr1008:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st583;
st583:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof583;
case 583:
	switch( (*( current_position)) ) {
		case 42u: goto tr1025;
		case 81u: goto tr1025;
		case 194u: goto tr1026;
		case 208u: goto tr1025;
	}
	if ( (*( current_position)) < 92u ) {
		if ( 88u <= (*( current_position)) && (*( current_position)) <= 90u )
			goto tr1025;
	} else if ( (*( current_position)) > 95u ) {
		if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
			goto tr1025;
	} else
		goto tr1025;
	goto tr57;
tr1009:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st584;
st584:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof584;
case 584:
	switch( (*( current_position)) ) {
		case 81u: goto tr1025;
		case 194u: goto tr1026;
		case 198u: goto tr1026;
	}
	if ( (*( current_position)) < 84u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1025;
	} else if ( (*( current_position)) > 89u ) {
		if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
			goto tr1025;
	} else
		goto tr1025;
	goto tr57;
tr1010:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st585;
st585:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof585;
case 585:
	switch( (*( current_position)) ) {
		case 81u: goto tr1025;
		case 194u: goto tr1026;
		case 198u: goto tr1026;
		case 208u: goto tr1025;
	}
	if ( (*( current_position)) < 84u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1025;
	} else if ( (*( current_position)) > 89u ) {
		if ( (*( current_position)) > 95u ) {
			if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
				goto tr1025;
		} else if ( (*( current_position)) >= 92u )
			goto tr1025;
	} else
		goto tr1025;
	goto tr57;
tr1011:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st586;
st586:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof586;
case 586:
	if ( (*( current_position)) == 208u )
		goto tr1025;
	if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
		goto tr1025;
	goto tr57;
tr1012:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st587;
st587:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof587;
case 587:
	switch( (*( current_position)) ) {
		case 18u: goto st580;
		case 22u: goto st580;
		case 43u: goto tr1025;
		case 194u: goto tr1026;
		case 198u: goto tr1026;
	}
	if ( (*( current_position)) < 40u ) {
		if ( 16u <= (*( current_position)) && (*( current_position)) <= 23u )
			goto tr1025;
	} else if ( (*( current_position)) > 41u ) {
		if ( (*( current_position)) > 47u ) {
			if ( 81u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1025;
		} else if ( (*( current_position)) >= 46u )
			goto tr1025;
	} else
		goto tr1025;
	goto tr57;
tr1013:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st588;
st588:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof588;
case 588:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 974, 1942, 974, 974, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1943, 974, 974, 974, 1942, 1942, 1942, 974, 974, 974, 974, 974, 1942, 1942, 974, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 974, 589, 974, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974, 1942, 1942, 1942, 1942, 1942, 1942, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st589:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof589;
case 589:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1946, 974, 974, 974, 974, 974, 974, 974, 1946, 974, 974, 974, 974, 974, 974, 974, 1946, 974, 974, 974, 974, 974, 974, 974, 1946, 974, 974, 974, 974, 974, 974, 974, 1946, 974, 974, 974, 974, 974, 974, 974, 1946, 974, 974, 974, 974, 974, 974, 974, 1946, 974, 974, 974, 974, 974, 974, 974, 1946, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1879, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 1880, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1014:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st590;
st590:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof590;
case 590:
	switch( (*( current_position)) ) {
		case 22u: goto tr1025;
		case 42u: goto tr1025;
		case 111u: goto tr1025;
		case 112u: goto tr1026;
		case 194u: goto tr1026;
		case 230u: goto tr1025;
	}
	if ( (*( current_position)) < 81u ) {
		if ( (*( current_position)) > 18u ) {
			if ( 44u <= (*( current_position)) && (*( current_position)) <= 45u )
				goto tr1030;
		} else if ( (*( current_position)) >= 16u )
			goto tr1025;
	} else if ( (*( current_position)) > 83u ) {
		if ( (*( current_position)) > 95u ) {
			if ( 126u <= (*( current_position)) && (*( current_position)) <= 127u )
				goto tr1025;
		} else if ( (*( current_position)) >= 88u )
			goto tr1025;
	} else
		goto tr1025;
	goto tr57;
tr1040:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st591;
tr1044:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st591;
tr1030:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st591;
tr1031:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st591;
st591:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof591;
case 591:
	{
		static const unsigned char jump_table[] = { 38, 38, 38, 38, 0, 38, 38, 38, 38, 38, 38, 38, 0, 38, 38, 38, 38, 38, 38, 38, 0, 38, 38, 38, 38, 38, 38, 38, 0, 38, 38, 38, 38, 38, 38, 38, 0, 38, 38, 38, 38, 38, 38, 38, 0, 38, 38, 38, 38, 38, 38, 38, 0, 38, 38, 38, 38, 38, 38, 38, 0, 38, 38, 38, 38, 38, 38, 38, 3, 38, 38, 38, 38, 38, 38, 38, 3, 38, 38, 38, 38, 38, 38, 38, 3, 38, 38, 38, 38, 38, 38, 38, 3, 38, 38, 38, 38, 38, 38, 38, 3, 38, 38, 38, 38, 38, 38, 38, 3, 38, 38, 38, 38, 38, 38, 38, 3, 38, 38, 38, 38, 38, 38, 38, 3, 38, 38, 38, 38, 38, 38, 38, 5, 38, 38, 38, 38, 38, 38, 38, 5, 38, 38, 38, 38, 38, 38, 38, 5, 38, 38, 38, 38, 38, 38, 38, 5, 38, 38, 38, 38, 38, 38, 38, 5, 38, 38, 38, 38, 38, 38, 38, 5, 38, 38, 38, 38, 38, 38, 38, 5, 38, 38, 38, 38, 38, 38, 38, 5, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38, 38 };
		( current_state) = jump_table[(*( current_position))] + 936;
		goto _again;
	}
tr1015:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st592;
st592:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof592;
case 592:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 1947, 1947, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 974, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1016:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st593;
st593:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof593;
case 593:
	switch( (*( current_position)) ) {
		case 43u: goto tr1025;
		case 194u: goto tr1026;
		case 198u: goto tr1026;
	}
	if ( (*( current_position)) < 20u ) {
		if ( 16u <= (*( current_position)) && (*( current_position)) <= 17u )
			goto tr1025;
	} else if ( (*( current_position)) > 21u ) {
		if ( (*( current_position)) > 41u ) {
			if ( 81u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1025;
		} else if ( (*( current_position)) >= 40u )
			goto tr1025;
	} else
		goto tr1025;
	goto tr57;
tr1017:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st594;
st594:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof594;
case 594:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 974, 974, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 974, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 974, 974, 974, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 974, 974, 974, 974, 974, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1018:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st595;
st595:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof595;
case 595:
	switch( (*( current_position)) ) {
		case 18u: goto tr1025;
		case 22u: goto tr1025;
		case 91u: goto tr1025;
		case 127u: goto tr1025;
		case 230u: goto tr1025;
	}
	goto tr57;
tr1019:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st596;
st596:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof596;
case 596:
	switch( (*( current_position)) ) {
		case 18u: goto tr1025;
		case 208u: goto tr1025;
		case 230u: goto tr1025;
		case 240u: goto tr1025;
	}
	if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
		goto tr1025;
	goto tr57;
tr1020:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st597;
st597:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof597;
case 597:
	if ( (*( current_position)) == 42u )
		goto tr1025;
	goto tr57;
tr1021:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st598;
st598:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof598;
case 598:
	if ( (*( current_position)) == 110u )
		goto tr1025;
	goto tr57;
tr1022:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st599;
st599:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof599;
case 599:
	if ( (*( current_position)) == 42u )
		goto tr1025;
	if ( 44u <= (*( current_position)) && (*( current_position)) <= 45u )
		goto tr1031;
	goto tr57;
tr1023:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st600;
st600:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof600;
case 600:
	if ( (*( current_position)) == 126u )
		goto tr1025;
	goto tr57;
tr919:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st601;
st601:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof601;
case 601:
	{
		static const unsigned short jump_table[] = { 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1950, 974, 974, 974, 1951, 974, 974, 1949, 1952, 974, 974, 974, 1953, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974, 1954, 1955, 974, 974, 974, 1956, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1032:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st602;
st602:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof602;
case 602:
	switch( (*( current_position)) ) {
		case 242u: goto tr1040;
		case 247u: goto tr1040;
	}
	goto tr57;
tr1033:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st603;
st603:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof603;
case 603:
	if ( (*( current_position)) < 55u ) {
		if ( (*( current_position)) < 40u ) {
			if ( (*( current_position)) <= 13u )
				goto tr1025;
		} else if ( (*( current_position)) > 41u ) {
			if ( 43u <= (*( current_position)) && (*( current_position)) <= 47u )
				goto tr1025;
		} else
			goto tr1025;
	} else if ( (*( current_position)) > 64u ) {
		if ( (*( current_position)) < 166u ) {
			if ( 150u <= (*( current_position)) && (*( current_position)) <= 159u )
				goto tr1041;
		} else if ( (*( current_position)) > 175u ) {
			if ( (*( current_position)) > 191u ) {
				if ( 219u <= (*( current_position)) && (*( current_position)) <= 223u )
					goto tr1042;
			} else if ( (*( current_position)) >= 182u )
				goto tr1041;
		} else
			goto tr1041;
	} else
		goto tr1025;
	goto tr57;
tr1034:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st604;
st604:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof604;
case 604:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1958, 1958, 1958, 974, 1958, 974, 1958, 974, 1958, 974, 974, 974, 974, 974, 974, 974, 1958, 1958, 1958, 974, 1958, 974, 1958, 974, 1958, 974, 974, 974, 974, 974, 974, 974, 1958, 1958, 1958, 974, 1958, 974, 1958, 974, 1958, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1035:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st605;
st605:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof605;
case 605:
	{
		static const unsigned short jump_table[] = { 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 974, 1960, 974, 974, 974, 1942, 1942, 974, 974, 974, 1942, 1942, 1942, 974, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 974, 974, 974, 974, 974, 974, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 974, 974, 974, 974, 974, 974, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 1958, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1959, 1959, 1959, 1959, 1959, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1036:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st606;
st606:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof606;
case 606:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 1942, 974, 974, 974, 1960, 974, 974, 974, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1942, 1942, 1942, 1942, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1958, 1958, 1958, 974, 1958, 974, 1958, 974, 1958, 974, 974, 974, 974, 974, 974, 974, 1958, 1958, 1958, 974, 1958, 974, 1958, 974, 1958, 974, 974, 974, 974, 974, 974, 974, 1958, 1958, 1958, 974, 1958, 974, 1958, 974, 1958, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1037:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st607;
st607:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof607;
case 607:
	switch( (*( current_position)) ) {
		case 242u: goto tr1044;
		case 247u: goto tr1044;
	}
	goto tr57;
tr1038:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st608;
st608:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof608;
case 608:
	if ( (*( current_position)) < 166u ) {
		if ( 150u <= (*( current_position)) && (*( current_position)) <= 159u )
			goto tr1041;
	} else if ( (*( current_position)) > 175u ) {
		if ( 182u <= (*( current_position)) && (*( current_position)) <= 191u )
			goto tr1041;
	} else
		goto tr1041;
	goto tr57;
tr1039:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st609;
st609:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof609;
case 609:
	switch( (*( current_position)) ) {
		case 154u: goto tr1041;
		case 156u: goto tr1041;
		case 158u: goto tr1041;
		case 170u: goto tr1041;
		case 172u: goto tr1041;
		case 174u: goto tr1041;
		case 186u: goto tr1041;
		case 188u: goto tr1041;
		case 190u: goto tr1041;
	}
	if ( (*( current_position)) < 166u ) {
		if ( 150u <= (*( current_position)) && (*( current_position)) <= 152u )
			goto tr1041;
	} else if ( (*( current_position)) > 168u ) {
		if ( 182u <= (*( current_position)) && (*( current_position)) <= 184u )
			goto tr1041;
	} else
		goto tr1041;
	goto tr57;
tr920:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st610;
st610:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof610;
case 610:
	{
		static const unsigned short jump_table[] = { 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1962, 974, 974, 974, 1963, 974, 974, 974, 1964, 974, 974, 974, 1965, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1966, 974, 974, 974, 1967, 974, 974, 974, 1968, 974, 974, 974, 1967, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1045:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st611;
st611:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof611;
case 611:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 1943, 1943, 1943, 1943, 1943, 1943, 1943, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 1943, 1943, 974, 1969, 974, 974, 974, 1970, 1970, 1971, 1971, 1971, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1973, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1053:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st612;
st612:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof612;
case 612:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 613, 974, 974, 974, 974, 974, 974, 974, 613, 974, 974, 974, 974, 974, 974, 974, 613, 974, 974, 974, 974, 974, 974, 974, 613, 974, 974, 974, 974, 974, 974, 974, 613, 974, 974, 974, 974, 974, 974, 974, 613, 974, 974, 974, 974, 974, 974, 974, 613, 974, 974, 974, 974, 974, 974, 974, 613, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 565, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 567, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st613:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof613;
case 613:
	{
		static const unsigned char jump_table[] = { 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0, 0, 0, 0, 0, 0, 63, 0, 0 };
		( current_state) = jump_table[(*( current_position))] + 1912;
		goto _again;
	}
tr1046:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st614;
st614:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof614;
case 614:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 1943, 974, 1943, 1943, 974, 974, 1943, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 974, 974, 974, 974, 974, 974, 974, 1970, 1970, 1971, 1971, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 974, 974, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 974, 974, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1047:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st615;
st615:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof615;
case 615:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1943, 1943, 974, 974, 1943, 1943, 1943, 1943, 1943, 1943, 1943, 1943, 974, 974, 974, 974, 589, 589, 1943, 1943, 974, 974, 974, 974, 974, 1976, 974, 974, 589, 1943, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 1943, 1943, 974, 1969, 974, 974, 974, 1970, 1970, 1971, 1971, 1971, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 1972, 1972, 1943, 1943, 1943, 1943, 974, 974, 974, 974, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1973, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1048:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st616;
st616:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof616;
case 616:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 1943, 1943, 1943, 974, 1943, 1943, 974, 974, 1943, 1943, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 1943, 974, 974, 974, 1976, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1943, 974, 974, 974, 974, 974, 974, 974, 1970, 1970, 1971, 1971, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 974, 974, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1972, 1972, 974, 974, 1972, 1972, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1049:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st617;
st617:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof617;
case 617:
	if ( (*( current_position)) < 92u ) {
		if ( 72u <= (*( current_position)) && (*( current_position)) <= 73u )
			goto tr1053;
	} else if ( (*( current_position)) > 95u ) {
		if ( (*( current_position)) > 111u ) {
			if ( 120u <= (*( current_position)) && (*( current_position)) <= 127u )
				goto tr1055;
		} else if ( (*( current_position)) >= 104u )
			goto tr1055;
	} else
		goto tr1055;
	goto tr57;
tr1050:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st618;
st618:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof618;
case 618:
	if ( (*( current_position)) < 104u ) {
		if ( (*( current_position)) > 73u ) {
			if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1055;
		} else if ( (*( current_position)) >= 72u )
			goto tr1053;
	} else if ( (*( current_position)) > 105u ) {
		if ( (*( current_position)) < 120u ) {
			if ( 108u <= (*( current_position)) && (*( current_position)) <= 109u )
				goto tr1055;
		} else if ( (*( current_position)) > 121u ) {
			if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
				goto tr1055;
		} else
			goto tr1055;
	} else
		goto tr1055;
	goto tr57;
tr1051:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st619;
st619:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof619;
case 619:
	switch( (*( current_position)) ) {
		case 22u: goto tr1026;
		case 34u: goto tr1026;
	}
	if ( (*( current_position)) < 92u ) {
		if ( 72u <= (*( current_position)) && (*( current_position)) <= 73u )
			goto tr1053;
	} else if ( (*( current_position)) > 95u ) {
		if ( (*( current_position)) > 111u ) {
			if ( 120u <= (*( current_position)) && (*( current_position)) <= 127u )
				goto tr1055;
		} else if ( (*( current_position)) >= 104u )
			goto tr1055;
	} else
		goto tr1055;
	goto tr57;
tr921:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st620;
st620:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof620;
case 620:
	{
		static const unsigned short jump_table[] = { 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1977, 1978, 1979, 1980, 1981, 1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1992, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 974, 1993, 1993, 974, 974, 974, 974, 974, 1994, 1995, 1995, 974, 1996, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1060:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st621;
st621:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof621;
case 621:
	switch( (*( current_position)) ) {
		case 18u: goto st622;
		case 22u: goto st622;
		case 23u: goto tr1082;
		case 81u: goto tr1081;
		case 194u: goto tr1083;
		case 198u: goto tr1083;
	}
	if ( (*( current_position)) < 46u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1081;
	} else if ( (*( current_position)) > 47u ) {
		if ( (*( current_position)) > 89u ) {
			if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1081;
		} else if ( (*( current_position)) >= 84u )
			goto tr1081;
	} else
		goto tr1081;
	goto tr57;
st622:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof622;
case 622:
	{
		static const unsigned short jump_table[] = { 2001, 2001, 2001, 2001, 1874, 974, 2001, 2001, 2001, 2001, 2001, 2001, 1874, 974, 2001, 2001, 2001, 2001, 2001, 2001, 1874, 974, 2001, 2001, 2001, 2001, 2001, 2001, 1874, 974, 2001, 2001, 2001, 2001, 2001, 2001, 1874, 974, 2001, 2001, 2001, 2001, 2001, 2001, 1874, 974, 2001, 2001, 2001, 2001, 2001, 2001, 1874, 974, 2001, 2001, 2001, 2001, 2001, 2001, 1874, 974, 2001, 2001, 2002, 2002, 2002, 2002, 1875, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 1875, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 1875, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 1875, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 1875, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 1875, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 1875, 2002, 2002, 2002, 2002, 2002, 2002, 2002, 1875, 2002, 2002, 2002, 2003, 2003, 2003, 2003, 1876, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 1876, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 1876, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 1876, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 1876, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 1876, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 1876, 2003, 2003, 2003, 2003, 2003, 2003, 2003, 1876, 2003, 2003, 2003, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004, 2004 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1082:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st623;
st623:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof623;
case 623:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1061:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st624;
st624:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof624;
case 624:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1999, 974, 1998, 1998, 1999, 1999, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 974, 974, 974, 974, 1998, 1998, 1998, 974, 974, 974, 974, 974, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 974, 974, 974, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 1998, 1998, 1998, 1998, 1998, 1998, 974, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1062:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st625;
st625:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof625;
case 625:
	switch( (*( current_position)) ) {
		case 42u: goto tr1081;
		case 81u: goto tr1081;
		case 83u: goto tr1081;
		case 194u: goto tr1083;
	}
	if ( (*( current_position)) > 90u ) {
		if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
			goto tr1081;
	} else if ( (*( current_position)) >= 88u )
		goto tr1081;
	goto tr57;
tr1063:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st626;
st626:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof626;
case 626:
	switch( (*( current_position)) ) {
		case 42u: goto tr1081;
		case 81u: goto tr1081;
		case 194u: goto tr1083;
		case 208u: goto tr1081;
	}
	if ( (*( current_position)) < 92u ) {
		if ( 88u <= (*( current_position)) && (*( current_position)) <= 90u )
			goto tr1081;
	} else if ( (*( current_position)) > 95u ) {
		if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
			goto tr1081;
	} else
		goto tr1081;
	goto tr57;
tr1064:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st627;
st627:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof627;
case 627:
	switch( (*( current_position)) ) {
		case 81u: goto tr1081;
		case 194u: goto tr1083;
		case 198u: goto tr1083;
	}
	if ( (*( current_position)) < 84u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1081;
	} else if ( (*( current_position)) > 89u ) {
		if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
			goto tr1081;
	} else
		goto tr1081;
	goto tr57;
tr1065:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st628;
st628:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof628;
case 628:
	switch( (*( current_position)) ) {
		case 81u: goto tr1081;
		case 194u: goto tr1083;
		case 198u: goto tr1083;
		case 208u: goto tr1081;
	}
	if ( (*( current_position)) < 84u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1081;
	} else if ( (*( current_position)) > 89u ) {
		if ( (*( current_position)) > 95u ) {
			if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
				goto tr1081;
		} else if ( (*( current_position)) >= 92u )
			goto tr1081;
	} else
		goto tr1081;
	goto tr57;
tr1066:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st629;
tr1252:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st629;
st629:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof629;
case 629:
	if ( 16u <= (*( current_position)) && (*( current_position)) <= 17u )
		goto tr1088;
	goto tr57;
tr1067:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st630;
st630:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof630;
case 630:
	if ( (*( current_position)) == 208u )
		goto tr1081;
	if ( (*( current_position)) > 17u ) {
		if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
			goto tr1081;
	} else if ( (*( current_position)) >= 16u )
		goto tr1088;
	goto tr57;
tr1068:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st631;
st631:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof631;
case 631:
	switch( (*( current_position)) ) {
		case 18u: goto st622;
		case 19u: goto tr1082;
		case 22u: goto st622;
		case 23u: goto tr1082;
		case 43u: goto tr1082;
		case 80u: goto tr1089;
		case 194u: goto tr1083;
		case 198u: goto tr1083;
	}
	if ( (*( current_position)) < 40u ) {
		if ( 16u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1081;
	} else if ( (*( current_position)) > 41u ) {
		if ( (*( current_position)) > 47u ) {
			if ( 81u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1081;
		} else if ( (*( current_position)) >= 46u )
			goto tr1081;
	} else
		goto tr1081;
	goto tr57;
tr1069:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st632;
st632:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof632;
case 632:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 1999, 1999, 1998, 1998, 1999, 1999, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 974, 1999, 974, 974, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2006, 1998, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 2000, 974, 974, 974, 1998, 1998, 1998, 974, 974, 974, 974, 974, 1998, 1998, 974, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 974, 633, 2008, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 974, 2006, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1999, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 1998, 1998, 1998, 1998, 1998, 1998, 2009, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st633:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof633;
case 633:
	{
		static const unsigned short jump_table[] = { 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013, 2013 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1070:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st634;
st634:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof634;
case 634:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1999, 1999, 1998, 974, 974, 974, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 974, 2014, 2014, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 1998, 974, 974, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1109:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st635;
tr1113:
	{ SET_CPU_FEATURE(CPUFeature_BMI1);      }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st635;
tr1097:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st635;
tr1099:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st635;
st635:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof635;
case 635:
	{
		static const unsigned short jump_table[] = { 935, 935, 935, 935, 1882, 974, 935, 935, 935, 935, 935, 935, 1882, 974, 935, 935, 935, 935, 935, 935, 1882, 974, 935, 935, 935, 935, 935, 935, 1882, 974, 935, 935, 935, 935, 935, 935, 1882, 974, 935, 935, 935, 935, 935, 935, 1882, 974, 935, 935, 935, 935, 935, 935, 1882, 974, 935, 935, 935, 935, 935, 935, 1882, 974, 935, 935, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 938, 938, 938, 938, 939, 938, 938, 938, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 940, 940, 940, 940, 941, 940, 940, 940, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942, 942 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1071:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st636;
st636:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof636;
case 636:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1999, 1999, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 974, 2014, 2014, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 974, 974, 974, 974, 974, 974, 1998, 1998, 1998, 974, 1998, 1998, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1999, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1072:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st637;
st637:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof637;
case 637:
	switch( (*( current_position)) ) {
		case 43u: goto tr1082;
		case 80u: goto tr1089;
		case 194u: goto tr1083;
		case 198u: goto tr1083;
	}
	if ( (*( current_position)) < 20u ) {
		if ( 16u <= (*( current_position)) && (*( current_position)) <= 17u )
			goto tr1081;
	} else if ( (*( current_position)) > 21u ) {
		if ( (*( current_position)) > 41u ) {
			if ( 81u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1081;
		} else if ( (*( current_position)) >= 40u )
			goto tr1081;
	} else
		goto tr1081;
	goto tr57;
tr1073:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st638;
st638:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof638;
case 638:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 974, 974, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 974, 1999, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2006, 1998, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 2015, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 974, 974, 974, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 974, 974, 974, 974, 974, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1999, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1098:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st639;
st639:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof639;
case 639:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934, 934 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1074:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st640;
st640:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof640;
case 640:
	switch( (*( current_position)) ) {
		case 18u: goto tr1081;
		case 22u: goto tr1081;
		case 91u: goto tr1081;
		case 127u: goto tr1081;
		case 230u: goto tr1081;
	}
	if ( 16u <= (*( current_position)) && (*( current_position)) <= 17u )
		goto tr1088;
	goto tr57;
tr1075:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st641;
st641:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof641;
case 641:
	switch( (*( current_position)) ) {
		case 18u: goto tr1081;
		case 208u: goto tr1081;
		case 230u: goto tr1081;
		case 240u: goto tr1082;
	}
	if ( (*( current_position)) > 17u ) {
		if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
			goto tr1081;
	} else if ( (*( current_position)) >= 16u )
		goto tr1088;
	goto tr57;
tr1076:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st642;
st642:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof642;
case 642:
	if ( (*( current_position)) == 42u )
		goto tr1081;
	goto tr57;
tr1077:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st643;
st643:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof643;
case 643:
	if ( (*( current_position)) == 110u )
		goto tr1081;
	goto tr57;
tr1078:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st644;
st644:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof644;
case 644:
	if ( (*( current_position)) == 42u )
		goto tr1081;
	if ( 44u <= (*( current_position)) && (*( current_position)) <= 45u )
		goto tr1099;
	goto tr57;
tr1079:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st645;
st645:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof645;
case 645:
	if ( (*( current_position)) == 126u )
		goto tr1100;
	goto tr57;
tr1100:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st646;
st646:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof646;
case 646:
	{
		static const unsigned short jump_table[] = { 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 917, 917, 917, 917, 415, 974, 917, 917, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 920, 920, 920, 920, 8, 920, 920, 920, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 922, 922, 922, 922, 9, 922, 922, 922, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924, 924 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr922:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st647;
st647:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof647;
case 647:
	{
		static const unsigned short jump_table[] = { 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2019, 974, 974, 974, 2020, 974, 974, 2018, 2021, 974, 974, 974, 2022, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974, 2023, 2024, 974, 974, 974, 2025, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1101:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st648;
st648:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof648;
case 648:
	switch( (*( current_position)) ) {
		case 242u: goto tr1109;
		case 247u: goto tr1109;
	}
	goto tr57;
tr1102:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st649;
st649:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof649;
case 649:
	{
		static const unsigned short jump_table[] = { 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 974, 1998, 1999, 1999, 1999, 1999, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2028, 2028, 2028, 2028, 2028, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1103:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st650;
st650:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof650;
case 650:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1999, 1999, 1999, 1999, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 974, 2027, 974, 2027, 974, 2027, 974, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 974, 2027, 974, 2027, 974, 2027, 974, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 974, 2027, 974, 2027, 974, 2027, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1104:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st651;
st651:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof651;
case 651:
	{
		static const unsigned short jump_table[] = { 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 974, 2029, 974, 974, 974, 1998, 1999, 974, 974, 974, 1998, 1998, 1998, 974, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 1998, 1998, 1999, 1998, 1999, 1999, 1999, 1999, 1998, 1998, 1998, 1998, 1998, 1998, 974, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 1998, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 2027, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2028, 2028, 2028, 2028, 2028, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1105:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st652;
st652:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof652;
case 652:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1998, 1998, 1998, 1998, 974, 974, 974, 2029, 974, 974, 974, 1998, 1999, 1999, 1999, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 1999, 1999, 1999, 1999, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 974, 2027, 974, 2027, 974, 2027, 974, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 974, 2027, 974, 2027, 974, 2027, 974, 974, 974, 974, 974, 974, 974, 2027, 2027, 2027, 974, 2027, 974, 2027, 974, 2027, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1106:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st653;
st653:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof653;
case 653:
	switch( (*( current_position)) ) {
		case 242u: goto tr1113;
		case 247u: goto tr1113;
	}
	goto tr57;
tr1107:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st654;
st654:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof654;
case 654:
	if ( (*( current_position)) < 166u ) {
		if ( 150u <= (*( current_position)) && (*( current_position)) <= 159u )
			goto tr1110;
	} else if ( (*( current_position)) > 175u ) {
		if ( 182u <= (*( current_position)) && (*( current_position)) <= 191u )
			goto tr1110;
	} else
		goto tr1110;
	goto tr57;
tr1108:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st655;
st655:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof655;
case 655:
	switch( (*( current_position)) ) {
		case 154u: goto tr1110;
		case 156u: goto tr1110;
		case 158u: goto tr1110;
		case 170u: goto tr1110;
		case 172u: goto tr1110;
		case 174u: goto tr1110;
		case 186u: goto tr1110;
		case 188u: goto tr1110;
		case 190u: goto tr1110;
	}
	if ( (*( current_position)) < 166u ) {
		if ( 150u <= (*( current_position)) && (*( current_position)) <= 152u )
			goto tr1110;
	} else if ( (*( current_position)) > 168u ) {
		if ( 182u <= (*( current_position)) && (*( current_position)) <= 184u )
			goto tr1110;
	} else
		goto tr1110;
	goto tr57;
tr923:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st656;
st656:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof656;
case 656:
	{
		static const unsigned short jump_table[] = { 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2031, 974, 974, 974, 2032, 974, 974, 974, 2033, 974, 974, 974, 2034, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2035, 974, 974, 974, 2036, 974, 974, 974, 2037, 974, 974, 974, 2036, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1114:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st657;
st657:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof657;
case 657:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 2000, 2000, 974, 2038, 974, 974, 974, 2039, 2039, 2040, 2040, 2040, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 2041, 2041, 2041, 2041, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 2041, 2041, 2041, 2041, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2042, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1122:
	{ SET_CPU_FEATURE(CPUFeature_XOP);       }
	goto st658;
st658:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof658;
case 658:
	{
		static const unsigned short jump_table[] = { 2043, 2043, 2043, 2043, 563, 974, 2043, 2043, 2043, 2043, 2043, 2043, 563, 974, 2043, 2043, 2043, 2043, 2043, 2043, 563, 974, 2043, 2043, 2043, 2043, 2043, 2043, 563, 974, 2043, 2043, 2043, 2043, 2043, 2043, 563, 974, 2043, 2043, 2043, 2043, 2043, 2043, 563, 974, 2043, 2043, 2043, 2043, 2043, 2043, 563, 974, 2043, 2043, 2043, 2043, 2043, 2043, 563, 974, 2043, 2043, 2044, 2044, 2044, 2044, 565, 2044, 2044, 2044, 2044, 2044, 2044, 2044, 565, 2044, 2044, 2044, 2044, 2044, 2044, 2044, 565, 2044, 2044, 2044, 2044, 2044, 2044, 2044, 565, 2044, 2044, 2044, 2044, 2044, 2044, 2044, 565, 2044, 2044, 2044, 2044, 2044, 2044, 2044, 565, 2044, 2044, 2044, 2044, 2044, 2044, 2044, 565, 2044, 2044, 2044, 2044, 2044, 2044, 2044, 565, 2044, 2044, 2044, 2045, 2045, 2045, 2045, 567, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 567, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 567, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 567, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 567, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 567, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 567, 2045, 2045, 2045, 2045, 2045, 2045, 2045, 567, 2045, 2045, 2045, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564, 564 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1115:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st659;
st659:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof659;
case 659:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 2000, 974, 2000, 2000, 974, 974, 2000, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 974, 974, 974, 974, 974, 974, 974, 2039, 2039, 2040, 2040, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 974, 974, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 974, 974, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1116:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st660;
st660:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof660;
case 660:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 2000, 2000, 974, 974, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 2000, 974, 974, 974, 974, 661, 661, 2048, 2049, 974, 974, 974, 974, 974, 2050, 974, 974, 633, 2000, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 2000, 2000, 974, 2038, 974, 974, 974, 2039, 2039, 2040, 2040, 2040, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 2041, 2041, 2000, 2000, 2000, 2000, 974, 974, 974, 974, 2041, 2041, 2041, 2041, 2041, 2041, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 2041, 2041, 2041, 2041, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2042, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st661:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof661;
case 661:
	{
		static const unsigned short jump_table[] = { 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2010, 2010, 2010, 2010, 1878, 974, 2010, 2010, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2011, 2011, 2011, 2011, 1879, 2011, 2011, 2011, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2012, 2012, 2012, 2012, 1880, 2012, 2012, 2012, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051, 2051 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1131:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_32_BIT); }
	goto st662;
tr1135:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	{ SET_OPERAND_TYPE(0, OPERAND_TYPE_64_BIT); }
	goto st662;
st662:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof662;
case 662:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104, 1104 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1132:
	{ SET_CPU_FEATURE(CPUFeature_AVX);       }
	goto st663;
st663:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof663;
case 663:
	{
		static const unsigned short jump_table[] = { 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1081, 1081, 1081, 1081, 408, 974, 1081, 1081, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1084, 1084, 1084, 1084, 71, 1084, 1084, 1084, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 1086, 1086, 1086, 1086, 72, 1086, 1086, 1086, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1117:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st664;
st664:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof664;
case 664:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 2000, 2000, 2000, 974, 2000, 2000, 974, 974, 2000, 2000, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 2000, 974, 974, 974, 2050, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2000, 974, 974, 974, 974, 974, 974, 974, 2039, 2039, 2040, 2040, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 974, 974, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2041, 2041, 974, 974, 2041, 2041, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1118:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st665;
st665:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof665;
case 665:
	if ( (*( current_position)) < 92u ) {
		if ( 72u <= (*( current_position)) && (*( current_position)) <= 73u )
			goto tr1122;
	} else if ( (*( current_position)) > 95u ) {
		if ( (*( current_position)) > 111u ) {
			if ( 120u <= (*( current_position)) && (*( current_position)) <= 127u )
				goto tr1124;
		} else if ( (*( current_position)) >= 104u )
			goto tr1124;
	} else
		goto tr1124;
	goto tr57;
tr1119:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st666;
st666:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof666;
case 666:
	if ( (*( current_position)) < 104u ) {
		if ( (*( current_position)) > 73u ) {
			if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1124;
		} else if ( (*( current_position)) >= 72u )
			goto tr1122;
	} else if ( (*( current_position)) > 105u ) {
		if ( (*( current_position)) < 120u ) {
			if ( 108u <= (*( current_position)) && (*( current_position)) <= 109u )
				goto tr1124;
		} else if ( (*( current_position)) > 121u ) {
			if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
				goto tr1124;
		} else
			goto tr1124;
	} else
		goto tr1124;
	goto tr57;
tr1120:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st667;
st667:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof667;
case 667:
	switch( (*( current_position)) ) {
		case 22u: goto tr1135;
		case 34u: goto tr1083;
	}
	if ( (*( current_position)) < 92u ) {
		if ( 72u <= (*( current_position)) && (*( current_position)) <= 73u )
			goto tr1122;
	} else if ( (*( current_position)) > 95u ) {
		if ( (*( current_position)) > 111u ) {
			if ( 120u <= (*( current_position)) && (*( current_position)) <= 127u )
				goto tr1124;
		} else if ( (*( current_position)) >= 104u )
			goto tr1124;
	} else
		goto tr1124;
	goto tr57;
tr924:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st668;
st668:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof668;
case 668:
	{
		static const unsigned short jump_table[] = { 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2053, 2054, 2055, 2056, 2057, 2058, 1983, 2059, 2060, 2061, 2062, 2063, 2064, 2065, 2066, 2067, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 974, 2068, 2068, 974, 974, 974, 974, 974, 2069, 2070, 2070, 974, 2071, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1136:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st669;
tr1246:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st669;
st669:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof669;
case 669:
	switch( (*( current_position)) ) {
		case 18u: goto st670;
		case 22u: goto st670;
		case 23u: goto tr1157;
		case 81u: goto tr1156;
		case 194u: goto tr1158;
		case 198u: goto tr1158;
	}
	if ( (*( current_position)) < 46u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1156;
	} else if ( (*( current_position)) > 47u ) {
		if ( (*( current_position)) > 89u ) {
			if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1156;
		} else if ( (*( current_position)) >= 84u )
			goto tr1156;
	} else
		goto tr1156;
	goto tr57;
st670:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof670;
case 670:
	{
		static const unsigned char jump_table[] = { 126, 126, 126, 126, 69, 201, 126, 126, 126, 126, 126, 126, 69, 201, 126, 126, 126, 126, 126, 126, 69, 201, 126, 126, 126, 126, 126, 126, 69, 201, 126, 126, 126, 126, 126, 126, 69, 201, 126, 126, 126, 126, 126, 126, 69, 201, 126, 126, 126, 126, 126, 126, 69, 201, 126, 126, 126, 126, 126, 126, 69, 201, 126, 126, 127, 127, 127, 127, 0, 127, 127, 127, 127, 127, 127, 127, 0, 127, 127, 127, 127, 127, 127, 127, 0, 127, 127, 127, 127, 127, 127, 127, 0, 127, 127, 127, 127, 127, 127, 127, 0, 127, 127, 127, 127, 127, 127, 127, 0, 127, 127, 127, 127, 127, 127, 127, 0, 127, 127, 127, 127, 127, 127, 127, 0, 127, 127, 127, 128, 128, 128, 128, 1, 128, 128, 128, 128, 128, 128, 128, 1, 128, 128, 128, 128, 128, 128, 128, 1, 128, 128, 128, 128, 128, 128, 128, 1, 128, 128, 128, 128, 128, 128, 128, 1, 128, 128, 128, 128, 128, 128, 128, 1, 128, 128, 128, 128, 128, 128, 128, 1, 128, 128, 128, 128, 128, 128, 128, 1, 128, 128, 128, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129, 129 };
		( current_state) = jump_table[(*( current_position))] + 1875;
		goto _again;
	}
tr1137:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st671;
tr1247:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st671;
st671:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof671;
case 671:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2074, 974, 2073, 2073, 2074, 2074, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 974, 974, 974, 974, 2073, 2073, 2073, 974, 974, 974, 974, 974, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2075, 974, 974, 974, 2075, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 2073, 2073, 2073, 2073, 2073, 2073, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1138:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st672;
st672:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof672;
case 672:
	switch( (*( current_position)) ) {
		case 42u: goto tr1156;
		case 81u: goto tr1156;
		case 83u: goto tr1156;
		case 194u: goto tr1158;
	}
	if ( (*( current_position)) > 90u ) {
		if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
			goto tr1156;
	} else if ( (*( current_position)) >= 88u )
		goto tr1156;
	goto tr57;
tr1139:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st673;
st673:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof673;
case 673:
	switch( (*( current_position)) ) {
		case 42u: goto tr1156;
		case 81u: goto tr1156;
		case 194u: goto tr1158;
		case 208u: goto tr1156;
	}
	if ( (*( current_position)) < 92u ) {
		if ( 88u <= (*( current_position)) && (*( current_position)) <= 90u )
			goto tr1156;
	} else if ( (*( current_position)) > 95u ) {
		if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
			goto tr1156;
	} else
		goto tr1156;
	goto tr57;
tr1140:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st674;
tr1250:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st674;
st674:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof674;
case 674:
	switch( (*( current_position)) ) {
		case 81u: goto tr1156;
		case 194u: goto tr1158;
		case 198u: goto tr1158;
	}
	if ( (*( current_position)) < 84u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1156;
	} else if ( (*( current_position)) > 89u ) {
		if ( 92u <= (*( current_position)) && (*( current_position)) <= 95u )
			goto tr1156;
	} else
		goto tr1156;
	goto tr57;
tr1141:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st675;
tr1251:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st675;
st675:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof675;
case 675:
	switch( (*( current_position)) ) {
		case 81u: goto tr1156;
		case 194u: goto tr1158;
		case 198u: goto tr1158;
		case 208u: goto tr1156;
	}
	if ( (*( current_position)) < 84u ) {
		if ( 20u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1156;
	} else if ( (*( current_position)) > 89u ) {
		if ( (*( current_position)) > 95u ) {
			if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
				goto tr1156;
		} else if ( (*( current_position)) >= 92u )
			goto tr1156;
	} else
		goto tr1156;
	goto tr57;
tr1142:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st676;
tr1253:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st676;
st676:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof676;
case 676:
	if ( (*( current_position)) == 208u )
		goto tr1156;
	if ( (*( current_position)) > 17u ) {
		if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
			goto tr1156;
	} else if ( (*( current_position)) >= 16u )
		goto tr1088;
	goto tr57;
tr1143:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st677;
tr1254:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st677;
st677:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof677;
case 677:
	switch( (*( current_position)) ) {
		case 18u: goto st670;
		case 19u: goto tr1157;
		case 22u: goto st670;
		case 23u: goto tr1157;
		case 43u: goto tr1157;
		case 80u: goto tr1089;
		case 194u: goto tr1158;
		case 198u: goto tr1158;
	}
	if ( (*( current_position)) < 40u ) {
		if ( 16u <= (*( current_position)) && (*( current_position)) <= 21u )
			goto tr1156;
	} else if ( (*( current_position)) > 41u ) {
		if ( (*( current_position)) > 47u ) {
			if ( 81u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1156;
		} else if ( (*( current_position)) >= 46u )
			goto tr1156;
	} else
		goto tr1156;
	goto tr57;
tr1144:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st678;
tr1255:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st678;
st678:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof678;
case 678:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 2074, 2074, 2073, 2073, 2074, 2074, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 974, 2074, 974, 974, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2006, 2073, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2075, 974, 974, 974, 2073, 2073, 2073, 974, 974, 974, 974, 974, 2073, 2073, 974, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2075, 974, 679, 2008, 2075, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 974, 2006, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2074, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2009, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
st679:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof679;
case 679:
	{
		static const unsigned char jump_table[] = { 131, 131, 131, 131, 67, 199, 131, 131, 131, 131, 131, 131, 67, 199, 131, 131, 131, 131, 131, 131, 67, 199, 131, 131, 131, 131, 131, 131, 67, 199, 131, 131, 131, 131, 131, 131, 67, 199, 131, 131, 131, 131, 131, 131, 67, 199, 131, 131, 131, 131, 131, 131, 67, 199, 131, 131, 131, 131, 131, 131, 67, 199, 131, 131, 132, 132, 132, 132, 0, 132, 132, 132, 132, 132, 132, 132, 0, 132, 132, 132, 132, 132, 132, 132, 0, 132, 132, 132, 132, 132, 132, 132, 0, 132, 132, 132, 132, 132, 132, 132, 0, 132, 132, 132, 132, 132, 132, 132, 0, 132, 132, 132, 132, 132, 132, 132, 0, 132, 132, 132, 132, 132, 132, 132, 0, 132, 132, 132, 133, 133, 133, 133, 1, 133, 133, 133, 133, 133, 133, 133, 1, 133, 133, 133, 133, 133, 133, 133, 1, 133, 133, 133, 133, 133, 133, 133, 1, 133, 133, 133, 133, 133, 133, 133, 1, 133, 133, 133, 133, 133, 133, 133, 1, 133, 133, 133, 133, 133, 133, 133, 1, 133, 133, 133, 133, 133, 133, 133, 1, 133, 133, 133, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134, 134 };
		( current_state) = jump_table[(*( current_position))] + 1879;
		goto _again;
	}
tr1145:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st680;
st680:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof680;
case 680:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2074, 2074, 2073, 974, 974, 974, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 974, 2079, 2079, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 2073, 974, 974, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2075, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2075, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1146:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st681;
st681:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof681;
case 681:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2074, 2074, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 974, 2079, 2079, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 974, 974, 974, 974, 974, 974, 2073, 2073, 2073, 974, 2073, 2073, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2075, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2075, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2074, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1147:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st682;
tr1258:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st682;
st682:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof682;
case 682:
	switch( (*( current_position)) ) {
		case 43u: goto tr1157;
		case 80u: goto tr1089;
		case 194u: goto tr1158;
		case 198u: goto tr1158;
	}
	if ( (*( current_position)) < 20u ) {
		if ( 16u <= (*( current_position)) && (*( current_position)) <= 17u )
			goto tr1156;
	} else if ( (*( current_position)) > 21u ) {
		if ( (*( current_position)) > 41u ) {
			if ( 81u <= (*( current_position)) && (*( current_position)) <= 95u )
				goto tr1156;
		} else if ( (*( current_position)) >= 40u )
			goto tr1156;
	} else
		goto tr1156;
	goto tr57;
tr1148:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st683;
tr1259:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st683;
st683:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof683;
case 683:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 974, 974, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 974, 2074, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2006, 2073, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 2080, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2075, 974, 974, 974, 2075, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 974, 974, 974, 974, 974, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2074, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1149:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st684;
tr1260:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st684;
st684:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof684;
case 684:
	switch( (*( current_position)) ) {
		case 18u: goto tr1156;
		case 22u: goto tr1156;
		case 91u: goto tr1156;
		case 127u: goto tr1156;
		case 230u: goto tr1156;
	}
	if ( 16u <= (*( current_position)) && (*( current_position)) <= 17u )
		goto tr1088;
	goto tr57;
tr1150:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st685;
tr1261:
	{
    /*
     * VEX shortened prefix 2nd byte format (first byte is 0xc5):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  ¬R   │    ¬vvvv (register number)    │   L   │       pp      ┃
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛
     *
     * It's converted to equivalent long (3 byte) form here (as in 0xc4):
     *     7       6       5       4       3       2       1       0
     * ┌───────┬═══════╤═══════╤═══════╤═══════╤═══════╤═══════╤═══════┒
     * │  ¬R   │ ¬X==1 │ ¬B==1 │         opcode map 1 == 00001         ┃ 2nd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     * ┌═══════┬───────┬───────┬───────┬───────┬───────┬───────┬───────┒
     * │  W==0 │    ¬vvvv (register number)    │   L   │       pp      ┃ 3rd
     * ┕━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┷━━━━━━━┛ byte
     */
    SET_VEX_PREFIX2(((*current_position) & VEX_R) | (VEX_X | VEX_B | VEX_MAP1));
    SET_VEX_PREFIX3((*current_position) & (~VEX_W));
  }
	goto st685;
st685:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof685;
case 685:
	switch( (*( current_position)) ) {
		case 18u: goto tr1156;
		case 208u: goto tr1156;
		case 230u: goto tr1156;
		case 240u: goto tr1157;
	}
	if ( (*( current_position)) > 17u ) {
		if ( 124u <= (*( current_position)) && (*( current_position)) <= 125u )
			goto tr1156;
	} else if ( (*( current_position)) >= 16u )
		goto tr1088;
	goto tr57;
tr1151:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st686;
st686:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof686;
case 686:
	if ( (*( current_position)) == 42u )
		goto tr1156;
	goto tr57;
tr1152:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st687;
st687:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof687;
case 687:
	if ( (*( current_position)) == 110u )
		goto tr1156;
	goto tr57;
tr1153:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st688;
st688:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof688;
case 688:
	if ( (*( current_position)) == 42u )
		goto tr1156;
	if ( 44u <= (*( current_position)) && (*( current_position)) <= 45u )
		goto tr1164;
	goto tr57;
tr1154:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st689;
st689:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof689;
case 689:
	if ( (*( current_position)) == 126u )
		goto tr1165;
	goto tr57;
tr925:
	{
    SET_VEX_PREFIX2(*current_position);
  }
	goto st690;
st690:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof690;
case 690:
	{
		static const unsigned short jump_table[] = { 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2084, 974, 974, 974, 2085, 974, 974, 2083, 2086, 974, 974, 974, 2087, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974, 2088, 2089, 974, 974, 974, 2090, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1166:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st691;
st691:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof691;
case 691:
	switch( (*( current_position)) ) {
		case 242u: goto tr1174;
		case 247u: goto tr1174;
	}
	goto tr57;
tr1167:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st692;
st692:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof692;
case 692:
	{
		static const unsigned short jump_table[] = { 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 974, 2073, 2074, 2074, 2074, 2074, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 974, 974, 974, 974, 974, 974, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 974, 974, 974, 974, 974, 974, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2093, 2093, 2093, 2093, 2093, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1168:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st693;
st693:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof693;
case 693:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2074, 2074, 2074, 2074, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2092, 2092, 2092, 974, 2092, 974, 2092, 974, 2092, 974, 974, 974, 974, 974, 974, 974, 2092, 2092, 2092, 974, 2092, 974, 2092, 974, 2092, 974, 974, 974, 974, 974, 974, 974, 2092, 2092, 2092, 974, 2092, 974, 2092, 974, 2092, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1169:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st694;
st694:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof694;
case 694:
	{
		static const unsigned short jump_table[] = { 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 974, 2094, 974, 974, 974, 2073, 2074, 974, 974, 974, 2073, 2073, 2073, 974, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 2073, 2073, 2074, 2073, 2074, 2074, 2074, 2074, 2073, 2073, 2073, 2073, 2073, 2073, 974, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 2073, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 974, 974, 974, 974, 974, 974, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 974, 974, 974, 974, 974, 974, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 2092, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2093, 2093, 2093, 2093, 2093, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974 };
		( current_state) = jump_table[(*( current_position))];
		goto _again;
	}
tr1170:
	{
    SET_VEX_PREFIX3(*current_position);
  }
	goto st695;
st695:
	if ( ++( current_position) == ( end_of_bundle) )
		goto _test_eof695;
case 695:
	{
		static const unsigned short jump_table[] = { 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2073, 2073, 2073, 2073, 974, 974, 974, 2094, 974, 974, 974, 2073, 2074, 2074, 2074, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 2074, 2074, 2074, 2074, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974, 974