// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Show the page action icon for all tabs.
chrome.tabs.onCreated.addListener(function(tab) {
  chrome.tabs.getAllInWindow(null, function(tabs) {
    for (var i = 0, t; t = tabs[i]; i++) {
      chrome.pageAction.show(t.id);
    }
  });
});

// Turn the background red when the user clicks on the page action.
chrome.pageAction.onClicked.addListener(function(tab) {
  chrome.tabs.executeScript(
      null, {code: "document.body.style.backgroundColor='red'"});
});
