
proc getInfo {} {
	global fileselect filinfo fileType  infoSon nchnls tcl_precision
	set tcl_precision 10
	set path $fileselect(path)
	if {[file writable $fileselect(dir)/$path]} {set rw ""} {set rw "\n\n***************\nWRITE-PROTECT\n***************"} 
	set fileType ""
	set typer [getSoundFileInfo  $fileselect(dir)/$path]
	    if {$typer != 0} {
		set infoSon(size) [file size $fileselect(dir)/$path]
		set infoSon(dur)  [lindex $typer 0]
		set infoSon(sr) [lindex $typer 1]
		set infoSon(type) [lindex $typer 2]
		set infoSon(chn) [lindex $typer 3]
		set infoSon(bit) [lindex $typer 4]
		set infoSon(frames) [expr $infoSon(dur) * $infoSon(sr)]
		set filinfo "Format: $infoSon(type)\nSize: $infoSon(size)\nDur: $infoSon(dur)\n$nchnls($infoSon(chn))--$infoSon(bit)bits\nSR: $infoSon(sr)\nFrames : $infoSon(frames)$rw"
		set fileType $nchnls($infoSon(chn))
		.fileselect.dr.buttons.ep.play config -state normal 
		.fileselect.dr.buttons.ep.play config -command {playSound $fileselect(dir)/$fileselect(path) .fileselect.dr.buttons.ep.play}
		.fileselect.dr.buttons.ep.edit config -state normal 		
		
	    } else {
		set typer [lrange [exec file  $fileselect(dir)/$path] 1 end]
		set sizer [file size $fileselect(dir)/$path]
		set infoSon(type) [lindex $typer 0]
		switch -- [file extension $fileselect(dir)/$path] {
		    .lpc {set typer "LPC analysis file";set fileType lpc}
		    .pv {set typer "FFT analysis file";set fileType pv}
		    .hetro {set typer "HETRO analysis file";set fileType hetro}
		    .cv {set typer "CONVOLVE analysis file";set fileType cv}
		    .snap {set typer "CECILIA snapshot file";set fileType snap}
		    .cec {set typer "CECILIA module file";set fileType cec}
		    .mid {set typer "Standard MidiFile";set filetype midi}
		}
		set filinfo "$typer\n$sizer bytes $rw"
		.fileselect.dr.buttons.ep.play config -state disabled 		
		.fileselect.dr.buttons.ep.edit config -state disabled 		
	}
}

proc fileDelete {} {
	global fileselect errno lan
	set path $fileselect(path)
	if {[file writable $fileselect(dir)/$fileselect(path)] == 0} {
		errFile2 "$lan(nom90)"
		return
	}
	if {$path == ""} {
		errFile2 "$lan(nom82)"
	} else {
		errFile "$lan(nom25) \n \"$fileselect(path)\" ?"
		if {$errno == 0} {
			exec rm $fileselect(dir)/$fileselect(path)
			.fileselect.top.path delete 0 end
			fileselectList $fileselect(dir)
		}
	}
	return
}

proc fileselectList { dir {files {}} } {
	global fileselect filter
	
	set ender [string trim [string range $filter [expr [string first "(" $filter] + 1] end] "()"]
	$fileselect(dirEnt) config -text $dir
	set fileselect(dir) $dir
	.fileselect.li.list delete 0 end
	.fileselect.li.list insert 0 Listing...
	update idletasks
	.fileselect.li.list delete 0
	if {[string length $files] == 0} {
		set files [glob -nocomplain $fileselect(dir)/*]
		.fileselect.li.list insert end ../
	}
	set yup 0
	set dirs {}
	set others {}
	foreach f [lsort $files] {
		if [file isdirectory $f] {
			lappend dirs [file tail $f]/
		} else {
			set yup 1
			if {$ender == "*"} {
				lappend others [file tail $f]
			} else {
			    foreach tag $ender {
				if {[file extension $f] == $tag} {
				    lappend others [file tail $f]			    
				}
			    }
			}
		}
	}
	if {$yup == 1} {	
	    foreach f [concat $dirs $others] {
		    .fileselect.li.list insert end $f}
	} else {
	    foreach f [concat $dirs] {
		.fileselect.li.list insert end $f}
	}	
}

proc fileRename {} {
	global fileselect okb  oldname lan
	set path $fileselect(path)
	set re .fileselect
 	if {$path == ""} {
		errFile2 "$lan(nom81)"
		resetButs
		return
	}
	if {[file writable $fileselect(dir)/$fileselect(path)] == 0} {
		errFile2 "$lan(nom90)"
		return
	}
	resetButs
	$re.top.l  config -text "$lan(nom76):"
	$re.dr.buttons.ren  config -state disabled
	$re.dr.buttons.ep.del  config -state disabled
	$okb config -state normal; \
	set oldname $path
	$re.dr.buttons.cancel config  -command resetButs
	$okb config -command  doNameChange
} 
    	

proc doNameChange {} {
global fileselect global okb  oldname lan
	set re .fileselect
 	set path $fileselect(path)
	if {$oldname == $path} {
		errFile2 $lan(nom83)"
		return
		}
	exec ln $fileselect(dir)/$oldname $fileselect(dir)/$path
	exec rm $fileselect(dir)/$oldname
	resetButs
	fileselectList $fileselect(dir)
	.fileselect.top.path delete 0 end					
}

proc fileselectOK2 {} {
	global fileselect   
    	if {$fileselect(path) == ""} { return}
	# Handle the parent directory specially
	if {[regexp {\.\./?} $fileselect(path)]} {
		set fileselect(path) {}
		set fileselect(dir) [string trimright $fileselect(dir) "/"]
		fileselectList [file dirname $fileselect(dir)]
		return
	}
    
	set path $fileselect(dir)/$fileselect(path)    
		
	if [file isdirectory $path] {
		set fileselect(path) {}
		fileselectList $path
		return
	} else {
	    set fileselect(path) $path
	    set fileselect(done) 1
	    return
	}
}

proc fileselectOK {} {
	global fileselect   
    	if {$fileselect(path) == ""} { return}
	# Handle the parent directory specially
	if {[regexp {\.\./?} $fileselect(path)]} {
		set fileselect(path) {}
		set fileselect(dir) [string trimright $fileselect(dir) "/"]
		fileselectList [file dirname $fileselect(dir)]
		return
	}
    
	set path $fileselect(dir)/$fileselect(path)
    
	if [file isdirectory $path] {
		set fileselect(path) {}
		fileselectList $path
		return
	}
	
	if [file exists $path] {
		set fileselect(path) $path
		set fileselect(done) 1
		return
	}
	# Neither a file or a directory.
	# See if glob will find something
	if [catch {glob $path} files] {
		# No, perhaps the user typed a new
		# absolute pathname
		if [catch {glob $fileselect(path)} path] {
			set fileselect(path) $path
			set fileselect(done) 1
		return
		} else {
			# OK - try again
			set fileselect(dir) [file dirname $fileselect(path)]
			set fileselect(path) [file tail $fileselect(path)]
			fileselectOK
			return
		}
	} else {
		# Ok - current directory is ok,
		# either select the file or list them.
		if {[llength [split $files]] == 1} {
			set fileselect(path) $files
			fileselectOK
		} else {
			set fileselect(dir) [file dirname [lindex $files 0]]
			fileselectList $fileselect(dir) $files
		}
	}
}

proc fileselectCancel {} {
    global  fileselect
    set fileselect(done) 1
    set fileselect(path) {}
}

proc fileselectClick2 { y } {
    global fileselect  
}

proc fileselectClick { y } {
    # Take the item the user clicked on
    global fileselect  killer
    if {[.fileselect.dr.buttons.ep.play cget -image] == "stop" } {
	.fileselect.dr.buttons.ep.play invoke
	tkwait variable killer}
	set l .fileselect.li.list
	set fileselect(path) [$l get [$l nearest $y]]
	focus $fileselect(pathEnt)
	getInfo
    }
    
    proc fileselectTake {} {
	# Take the currently selected list item and
	# change focus back to the entry
	global fileselect
	set l .fileselect.li.list
	set fileselect(path) [$l get [$l curselection]]
    }
    
proc soundEdit {which} {
	global fileselect soundName
	if {$which == "f"} {
	    editSoundFile $fileselect(dir)/$fileselect(path)
	} else {
	    editSoundFile $soundName 
	}
}


proc resetButs {} {
	global   lan
	set regbut  .fileselect.dr.buttons
	.fileselect.top.l  config -text "$lan(nom10):"
		set regbut  .fileselect.dr.buttons
	foreach but {ok.b cancel ren} {
		$regbut.$but config -state normal
		}
		$regbut.ep.edit config -state disabled
		$regbut.ep.del config -state normal
		$regbut.ep.play config -state disabled
	$regbut.ok.b config -text OK -command fileselectOK    	
	$regbut.cancel config -text "$lan(nom70)" -command fileselectCancel
	.fileselect.top.l  config -text "$lan(nom10):"

}


#*************************FILESELECTOR*****************************
proc fileselector {args} {
    global tcl_platform fileselect currentdir okb infob  fileType \
	    filinfo cfont typ  ceclib dpi color\
	    lan   homedir  redBut prefs filter
    set why [lindex $args 0]
    set default [lindex $args 1]
    set ttt [lindex $args 2]
    set currenTask [lindex $args 3]
#    set filter ""
    set filters ""
     if {$currenTask == 0} {   
	foreach thing $ttt {
	    lappend filters "[lindex $thing 0]  \([lindex $thing 1]\)"
	} 
	set filter [lindex $filters 0 ]
    } {	set filters "All files (*)" }

#    set filter [lindex $filters 0 ]
   
    set argt ""
    
    set sidir $prefs(SSDIR)
    set sfdir $prefs(SFDIR)
    set andir $prefs(SADIR)    
    
    set fileselect(dir) {}
    set fileselect(path) {}

    set t [toplevel .fileselect  -bd 0 -height 500 -width 500]
    wm minsize $t  550 600
    wm maxsize $t  550 600
    frame $t.m  -relief groove -bd 2
    message $t.m.msg -justify center -aspect 1000 -text $why
    pack $t.m.msg -side top -fill x -pady 5
    pack $t.m -side top  -fill x -pady 5 -padx 10
    
    # Create an entry for the pathname
    # The value is kept in fileselect(path)
    frame $t.top -relief groove -bd 0
    set fileselect(dirEnt) [label $t.top.dir -width 15  -justify center  ]
    pack $t.top.dir -side top -fill x  -pady 5
    label $t.top.l -text "$lan(nom10):" -padx 5 
    set e [entry $t.top.path -relief sunken  -textvariable fileselect(path) ]
    pack $t.top -side top -fill x -padx 10 -pady 5
    pack $t.top.l -side left 
    pack $t.top.path -side right -fill x -expand true -pady 1 -padx 10 
    set fileselect(pathEnt) $e
    
    # Set up bindings to invoke OK and Cancel
    bind $t <Return> "$t.dr.buttons.ok.b invoke"
    bind $e <Control-c> "$t.dr.buttons.cancel invoke"
    bind $t <Escape> "$t.dr.buttons.cancel invoke"
    focus $e
    
    # Create a listbox to hold the directory contents
    
    frame $t.li -relief groove -bd 2 -bg ${color}4
    listbox $t.li.list -relief groove -bd 3  -width 35 -height 15\
	    -highlightthickness 2 -bg gray80 -yscrollcommand [list $t.li.scroll set]
    scrollbar $t.li.scroll -takefocus 0   \
	    -width 10 -command [list $t.li.list yview]
    
    # Create the OK and Cancel buttons
    # The OK button has a rim to indicate it is the default
    frame $t.dr  
    frame $t.dr.buttons
    frame $t.dr.buttons.ok -bd 2 -relief sunken -relief groove -bd 2
    
    #define directory  buttons
    frame $t.dire -relief groove -bd 2
    button $t.dire.home  -takefocus 0 -text HOME  -command  "set fileselect(path) $homedir;fileselectOK"
    button $t.dire.sdir  -takefocus 0   -text SoundOUT  -command   "set fileselect(path) $sfdir;fileselectOK"
    button $t.dire.andir   -takefocus 0   -text SoundAN -command   "set fileselect(path) $andir ;fileselectOK" 
    button $t.dire.sidir   -takefocus 0   -text SoundIN  -command  "set fileselect(path) $sidir ;fileselectOK"
    
    pack $t.dire.home -side right  -expand 1 -pady 3 -padx 3
    pack $t.dire.sdir -side right  -expand 1 -pady 3 -padx 3
    pack $t.dire.andir -side right  -expand 1 -pady 3 -padx 3
    pack $t.dire.sidir -side right  -expand 1 -pady 3 -padx 3
    pack $t.dire -side bottom  -fill x -expand 0 -pady 10 -padx 10
    
    # define info frame
    # pack it at bottom
    frame $t.dr.inf  -bd 0 
    set infob [message $t.dr.inf.info -font $cfont(small) -aspect  150 -textvariable filinfo -justify left]
    pack $infob -side top  -anchor w 
    set filinfo  ""
    
    # Pack the list, scrollbar, and button box
    # in a horizontal stack below the upper widgets
    pack $t.li.list -side left  -fill both -expand y -pady 5 -padx 5
    pack $t.li.scroll -side left  -fill y -pady 5 -padx 5
    pack $t.li -side left -fill both  -expand y -pady 10 -padx 10
    pack $t.dr.buttons -side top  -expand 1 -pady 15 -padx 15 -anchor n
    pack $t.dr.inf -side top  -expand 1 -fill both -anchor n -pady 5 -padx 10 
    pack $t.dr -side left  -expand 0 -fill both  -pady 0 -padx 0 
    
    #define dialog box buttons
    button $t.dr.buttons.cancel    -takefocus 0  -text "$lan(nom70)" -command {fileselectCancel}  -width 15
    set okb [button $t.dr.buttons.ok.b   -takefocus 0  -width 15 -text OK   -command fileselectOK ]
    button $t.dr.buttons.ren    -takefocus 0  -text "$lan(nom71)"   -command fileRename  -width 15
    button $t.dr.buttons.con    -takefocus 0  -text "Convert"  -command {convSoundFile $fileselect(dir)/$fileselect(path)} -width 15
    frame $t.dr.buttons.ep 

    pack [button $t.dr.buttons.ep.del   -takefocus 0 -image dump -command fileDelete ] -side right -fill both -expand 1
    pack [button $t.dr.buttons.ep.edit  -takefocus 0 -image edi  -state disabled  -command {editSoundFile $fileselect(dir)/$fileselect(path)} ] -side right -fill both -expand 1
    pack [button $t.dr.buttons.ep.play   -takefocus 0 -image play   -state disabled  ] -side right -fill both -expand 1
    

eval optMenu $t.dr.buttons.filt filter \
	    {{fileselectList $fileselect(dir)}} [list $cfont(small)] $color 10 2 \
	    $filters
#puts $currenTask
	
    if {$currenTask == 0} {
	wm geometry $t +250+100
	pack $t.dr.buttons.ok -side top -padx 3 -pady 5 -fill x  -expand 1 -anchor n
	pack $okb -padx 1 -pady 1 -fill x 
        pack $t.dr.buttons.cancel -padx 3 -fill x -pady 5 -expand y
	pack $t.dr.buttons.ren -padx 3 -fill x -pady 5 -expand y
	pack $t.dr.buttons.con -padx 3 -fill x -pady 5 -expand y
	pack $t.dr.buttons.ep -padx 5 -fill x -pady 10 -anchor s
	pack $t.dr.buttons.filt -padx 3 -pady 5 -fill x -expand 1
	bind $t.li.list <Button-1> {fileselectClick %y}
	bind $t.li.list <Button-2> {fileselectClick %y ; fileselectOK}
	bind $t.li.list <Double-Button-1> {fileselectClick %y ; fileselectOK}
    }
	    
    if {$currenTask == 1} {
	wm geometry $t +150+100
	pack $t.dr.buttons.ok -side top -padx 3 -pady 5 -fill x  -expand 1 -anchor n
	pack $okb -padx 1 -pady 1 -fill x 
        pack $t.dr.buttons.cancel -padx 3 -fill x -pady 5 -expand y
	$t.top.path delete 0 end
	$okb config -command fileselectOK2
	focus $t.top.path
	$e insert 0 $ttt 
	$t.li.list config -height 10
	bind $t.li.list <Button-1> {fileselectClick %y}
	bind $t.li.list <Button-2> {fileselectClick %y ; fileselectOK2}
	bind $t.li.list <Double-Button-1> {fileselectClick %y ; fileselectOK2}
    }

    if {[string length $default] == 0} {
	    set fileselect(path) {}
	    set dir $sfdir
    }
    set fileselect(newf) {}
    set fileselect(dir) {}
    set fileselect(done) 0
    tkwait visibility .fileselect.li.list
    fileselectList $default
    grab set $t
    tkwait variable fileselect(done)
    set currentdir $fileselect(dir)
    $t.dr.buttons.filt.menu invoke 0
    catch {blowSelector}
    grab release $t
    catch {destroy .fileselect}
    if {$argt == ""} {
    return $fileselect(path)} else {return {$fileselect(path) $fileType}}
}


proc blowSelector {} {
global killer fileselect
	if {[.fileselect.dr.buttons.ep.play cget -image] == "stop" } {
	.fileselect.dr.buttons.ep.play invoke
	tkwait variable killer
	}	
}


proc getTheFucker {} {
global fileselect
set fileselect(path) $fileselect(dir)/$fileselect(newf)
set fileselect(done) 1
}
