#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

from terra.ui.base import EdjeWidget
from terra.core.terra_object import TerraObject


# TODO: add a more generic (non-panel specific) button

class PanelButtonWidget(EdjeWidget, TerraObject):
    terra_type = "Widget/PanelButton"

    def __init__(self, canvas, text="", group="widget/panel/button",
                 clicked_callback=None, parent=None, theme=None):
        EdjeWidget.__init__(self, canvas, group, parent=parent,
                            theme=theme)
        self.text = text
        self.part_text_set("text", self.text)
        self.clicked_callback = clicked_callback
        self.signal_callback_add("button,clicked", "*", self._on_button_clicked)

    def _on_button_clicked(self, *ignored):
        if self.clicked_callback is not None:
            self.clicked_callback(self)

    def theme_changed(self):
        self.part_text_set("text", self.text)

    def delete(self):
        # is this del needed?
        self.signal_callback_del("button,clicked", "*", self._on_button_clicked)
        self.clicked_callback = None
        EdjeWidget.delete(self)
