#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

#import logging

from terra.core.manager import Manager
from terra.core.plugin_prefs import PluginPrefs
from terra.utils.encoding import to_utf8

from model import VideoFeedFolder, VideoOnDemandFolder

__all__ = ("SettingsVideocastModelFolder", "SettingsVideocastFolderController", )

#log = logging.getLogger("plugins.canola-core.ondemand.video.settings")

mger = Manager()
settings = PluginPrefs("settings")

DownloadManager = mger.get_class("DownloadManager")
download_mger = DownloadManager()


class SettingsVideocastModelFolder(VideoFeedFolder):
    terra_type = "Model/Settings/Folder/InternetMedia/Videocast"
    title = "Videocasts"
    select_order = "ORDER BY epoch DESC"

    def item_new(self, uri, contents):
        feed = contents.feed
        title = to_utf8(feed.title)
        if feed.has_key("description"):
            desc = to_utf8(feed.description)
        else:
            desc = ""

        item = VideoOnDemandFolder(title, uri)
        item.desc = desc
        item.commit() # sets id and cover path

        item.fetch_cover(contents)

        return item

SettingsFeedFolderController = \
    mger.get_class("Controller/Settings/Folder/Feed")
class SettingsVideocastFolderController(SettingsFeedFolderController):
    terra_type = "Controller/Settings/Folder/InternetMedia/Videocast"

    acceptable_mime_types = [
        'application/rss+xml',
        'application/xml', # Some feeds return this
        'text/xml',  # This one is due to Feedburner
        'text/html', # Sadly required for some feeds :-(
        'application/atom+xml', 'application/atom',
        'text/xml+rss'
    ]
