#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import os
#import logging

from terra.core.manager import Manager
from terra.core.plugin_prefs import PluginPrefs
from terra.utils.encoding import to_utf8

from model import AudioFeedFolder, AudioOnDemandFolder

__all__ = ("SettingsPodcastModelFolder", "SettingsPodcastFolderController", )

#log = logging.getLogger("plugins.canola-core.podcast.settings")

mger = Manager()
settings_feed_folder_controller_cls = \
    mger.get_class("Controller/Settings/Folder/Feed")
settings = PluginPrefs("settings")

DownloadManager = mger.get_class("DownloadManager")
download_mger = DownloadManager()


class SettingsPodcastModelFolder(AudioFeedFolder):
    terra_type = "Model/Settings/Folder/InternetMedia/Podcast"
    title = "Podcasts"
    select_order = "ORDER BY epoch DESC"

    def item_new(self, uri, contents):
        feed = contents.feed
        title = to_utf8(feed.title)
        if feed.has_key("description"):
            desc = to_utf8(feed.description)
        else:
            desc = ""

        item = AudioOnDemandFolder(title, uri)
        item.desc = desc
        item.commit() # sets id and cover path

        if feed.has_key("image"):
            path = os.path.dirname(item.cover)
            if not os.path.exists(path):
                os.makedirs(path)

            def download_finished(exception, mimetype):
                process.on_finished_remove(download_finished)
                if exception is None:
                    item.commit()

            process = download_mger.add(feed.image.href, item.cover,
                                        ignore_limit=True)

            process.on_finished_add(download_finished)
            process.start()

        return item


class SettingsPodcastFolderController(settings_feed_folder_controller_cls):
    terra_type = "Controller/Settings/Folder/InternetMedia/Podcast"

    acceptable_mime_types = [
        'application/rss+xml',
        'application/xml', # Some feeds return this
        'text/xml',  # This one is due to Feedburner
        'text/html', # Sadly required for some feeds :-(
        'application/atom+xml', 'application/atom',
        'text/xml+rss'
    ]
