#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

import logging

from terra.core.manager import Manager

mger = Manager()
OptionsModelFolder = mger.get_class("Model/Options/Folder")

log = logging.getLogger("plugins.canola-core.ondemand.audio.options")


class AudioFeedOptionsModel(OptionsModelFolder):
    terra_type = "Model/Options/Folder/Media/Feeds/Audio"
    title = "Podcast Options"
    children_prefixes = ["Model/Options/Action/Media/Feeds",
                         "Model/Options/Action/Media/OnDemand"]


class OnDemandOptionsModel(OptionsModelFolder):
    terra_type = "Model/Options/Folder/Media/OnDemand"
    title = "Podcast Options"
    children_prefixes = ["Model/Options/Action/Media/OnDemand"]
