#
# This file is part of Canola
# Copyright (C) 2007-2009 Instituto Nokia de Tecnologia
# Contact: Renato Chencarek <renato.chencarek@openbossa.org>
#          Eduardo Lima (Etrunko) <eduardo.lima@openbossa.org>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#

from terra.core.model import ModelFolder
from terra.core.manager import Manager


class MainMenuFolderModel(ModelFolder):
    terra_type = "Model/Folder/MainMenu"
    task_prefix = "Model/Folder/Task"

    def __init__(self):
        ModelFolder.__init__(self, "Menu")

    def do_load(self):
        mger = Manager()

        # sorting tasks by these types on home screen
        task_groups = [("Audio", ["Local", "OnDemand", "IRadio"]),
                       ("Image", ["Local", "Photocast"]),
                       ("Video", ["Local", "OnDemand"]),
                       ("Shared", []),
                       ("Apps", [])]
        tasks = []

        for group, default_tasks  in task_groups:
            def order_list(cls_list, first_ones):
                if not cls_list:
                    return

                ret = []
                for c in first_ones:
                    for cls in cls_list:
                        if cls.terra_type.endswith(c):
                            ret.append(cls)
                last = list(set(cls_list).difference(set(ret)))
                ret.extend(last)

                return ret

            try:
                # regexp to get only immediate children, not grandchildren
                classes = mger.get_classes_by_regexp(
                    "%s/%s/[^/]*$" % (self.task_prefix, group))
                classes = order_list(classes, default_tasks)
                tasks.extend(classes)
            except ValueError:
                pass

        for cls in tasks:
            cls(self)
