from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestLockManager(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestLockManager, self).setUp()
        self.dbus_interface = "com.canonical.android.lockmanager" \
            ".ScreenLockManager"
        self.s_LockStatusChanged = "LockStatusChanged"
        self.m_isScreenLocked = "isScreenLocked"
        self.m_keepDeviceAwake = "keepDeviceAwake"
        self.m_lockDevice = "lockDevice"
        self.m_sleep = "sleep"
        self.m_unLockKeyGuard = "unLockKeyGuard"

    def tearDown(self):
        super(TestLockManager, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_lock.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_lock_s_LockStatusChanged(self):
        item = self.s_LockStatusChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_lock_m_isScreenLocked(self):
        item = self.m_isScreenLocked
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_lock_m_keepDeviceAwake(self):
        item = self.m_keepDeviceAwake
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_lock_m_lockDevice(self):
        item = self.m_lockDevice
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_lock_m_sleep(self):
        item = self.m_sleep
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_lock_m_unLockKeyGuard(self):
        item = self.m_unLockKeyGuard
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
