from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestBT(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestBT, self).setUp()
        self.dbus_interface = "org.bluez.Manager"
        self.m_DefaultAdapter = "DefaultAdapter"
        self.m_ListAdapters = "ListAdapters"
        self.s_PropertyChanged = "PropertyChanged"
        self.s_DefaultAdapterChanged = "DefaultAdapterChanged"
        self.s_AdapterRemoved = "AdapterRemoved"
        self.s_AdapterAdded = "AdapterAdded"

    def tearDown(self):
        super(TestBT, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_bt_man.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_bt_manager_m_DefaultAdapter(self):
        item = self.m_DefaultAdapter
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_manager_m_ListAdapters(self):
        item = self.m_ListAdapters
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_manager_signal_PropertyChanged(self):
        item = self.s_PropertyChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_bt_manager_signal_DefaultAdapterChanged(self):
        item = self.s_DefaultAdapterChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_bt_manager_signal_AdapterRemoved(self):
        item = self.s_AdapterRemoved
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_bt_manager_signal_AdapterAdded(self):
        item = self.s_AdapterAdded
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)
