from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestApplications(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestApplications, self).setUp()
        self.dbus_interface = "com.canonical.android.applications.Applications"
        self.s_applicationAdded = "applicationAdded"
        self.s_applicationNotFoundException = "applicationNotFoundException"
        self.s_applicationRemoved = "applicationRemoved"
        self.s_applicationReplaced = "applicationReplaced"
        self.m_getApplicationDetails = "getApplicationDetails"
        self.m_getForegroundApplication = "getForegroundApplication"
        self.m_launchApplication = "launchApplication"
        self.m_listInstalledApplications = "listInstalledApplications"
        self.m_listRunningApplications = "listRunningApplications"

    def tearDown(self):
        super(TestApplications, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_app.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_app_s_applicationAdded(self):
        item = self.s_applicationAdded
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_app_s_applicationNotFoundException(self):
        item = self.s_applicationNotFoundException
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_app_s_applicationRemoved(self):
        item = self.s_applicationRemoved
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_app_s_applicationReplaced(self):
        item = self.s_applicationReplaced
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_app_m_getApplicationDetails(self):
        item = self.m_getApplicationDetails
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_app_m_getForegroundApplication(self):
        item = self.m_getForegroundApplication
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_app_m_launchApplication(self):
        item = self.m_launchApplication
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_app_m_listInstalledApplications(self):
        item = self.m_listInstalledApplications
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_app_m_listRunningApplications(self):
        item = self.m_listRunningApplications
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
