if [ -z "$UNSHARED" ]; then
    export UNSHARED=1
    lxc-unshare -s MOUNT -- $0 $*
    exit $?
fi

export bin=/system/bin
export PATH=$bin:/usr/bin:/usr/sbin:/bin:/usr/local/bin:$PATH
export TERM=linux
export HOME=/root

# Get relevant paths/variables
file=$0
. "${file%/*}/paths.sh"
# Get the device specific stuff
. "${file%/*}/device.sh"

HOME_PATH="$UFA_DIR/ufa"
COMMAND="$UFA_DIR/run-lxc"
CONTAINER_PATH="$UFA_DIR/containers/ufa"
CONTAINER_NAME="ufa"
ROOTFS_PATH="$CONTAINER_PATH/rootfs"
DEBUG_MODE=""
# The logging paths are the same place on the disk, but processes have different
# views of them if they're in a chroot.
# some commands, like lxc-start run inside a chroot, they log to this path
DEBUG_PATH_INSIDE_CHROOT="/var/log/lxc.log"
# other commands, like lxc-stop run outside the chroot, they log to this path
DEBUG_PATH_OUTSIDE_CHROOT="$UFA_DIR/var/log/lxc.log"

if [ $# -eq 2 ];
    then
    if [ $2 = "debug" ] ;
    then
        DEBUG_MODE_INSIDE="-l debug -o $DEBUG_PATH_INSIDE_CHROOT"
        DEBUG_MODE_OUTSIDE="-l debug -o $DEBUG_PATH_OUTSIDE_CHROOT"
        CONSOLE_DEBUG="--console-log /var/log/lxc-console.log"
    fi
fi

case $1 in

status)
        $COMMAND lxc-info --state --name=$CONTAINER_NAME
        ;;
start)
        pre-start
        $COMMAND lxc-start -d -n $CONTAINER_NAME $DEBUG_MODE_INSIDE $CONSOLE_DEBUG
        ;;
stop)
        lxc-stop -n $CONTAINER_NAME $DEBUG_MODE_OUTSIDE
        post-stop
        rm -f $DEBUG_PATH_OUTSIDE_CHROOT
        ;;
suspend)
        $COMMAND lxc-freeze -n $CONTAINER_NAME $DEBUG_MODE_INSIDE
        ;;
resume)
        $COMMAND lxc-unfreeze -n $CONTAINER_NAME $DEBUG_MODE_INSIDE
        ;;
disk_size)
        # Will return "NNNNNN filename", where NNNNN is file size in 1k blocks
        echo `ls -s $UFA_DIR/filesystem.ext4`
        ;;
disk_resize)
        echo "This option is a no-op, to be implemented later"
        ;;
disk_check)
        e2fsck -fy $UFA_DIR/filesystem.ext4
        ;;
mount)
        echo "this option is now a no-op, run with start or shell"
        ;;
shell|console)
        lxc-console -n $CONTAINER_NAME $DEBUG_MODE_OUTSIDE
        if [ "$?" -ne "0" ]; then
            echo "trying to start the container, this will take a second"
            pre-start
            $COMMAND lxc-start -d -n $CONTAINER_NAME $DEBUG_MODE_INSIDE
            lxc-console -n $CONTAINER_NAME $DEBUG_MODE_OUTSIDE
        fi
        ;;
reboot)
        $UFA_DIR/bin/lxc-shutdown.sh -n $CONTAINER_NAME -r
        RET=$?
        post-stop
        pre-start
        exit $RET
        ;;
shutdown)
        $UFA_DIR/bin/lxc-shutdown.sh -n $CONTAINER_NAME
        RET=$?
        post-stop
        exit $RET
        ;;
esac
