#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'
'''
www.livemint.com
'''

from calibre.web.feeds.news import BasicNewsRecipe

class Edgesingapore(BasicNewsRecipe):
    title                 = 'The Edge Singapore'
    __author__            = 'Darko Miletic'
    description           = 'Financial news from Singapore'
    publisher             = 'The Edge Singapore'
    category              = 'news, finances, singapore'
    language = 'en'

    lang                  = 'en'
    oldest_article        = 15
    max_articles_per_feed = 100
    no_stylesheets        = True
    encoding              = 'utf-8'
    use_embedded_content  = False
    extra_css             = ' .contentheading{font-size: x-large} .small{font-size: small} .createdate{font-size: small; font-weight: bold} '


    conversion_options = {
                          'comment'          : description
                        , 'tags'             : category
                        , 'publisher'        : publisher
                        , 'author'           : publisher
                        , 'language'         : lang
                        , 'pretty_print'     : True
                        , 'linearize_tables' : True
                        }


    remove_tags = [
                    dict(name=['object','link','embed','form','iframe'])
                   ,dict(name='div',attrs={'id':'toolbar-article'})
                   ,dict(name='div',attrs={'class':'backtotop'})
                   ,dict(name='img',attrs={'alt':'Print'})
                  ]

    remove_tags_after = dict(name='div',attrs={'class':'backtotop'})

    feeds = [(u'Articles', u'http://feeds.feedburner.com/edgesg')]

    def print_version(self, url):
        return url + '?tmpl=component&print=1'

    def preprocess_html(self, soup):
        attribs = [  'style','font','valign'
                    ,'colspan','width','height'
                    ,'rowspan','summary','align'
                    ,'cellspacing','cellpadding'
                    ,'frames','rules','border'
                  ]
        for item in soup.body.findAll(name=['table','td','tr','th','caption','thead','tfoot','tbody','colgroup','col']):
            item.name = 'div'
            for attrib in attribs:
                if item.has_key(attrib):
                   del item[attrib]
        return self.adeify_images(soup)
