#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'
'''
www.hanselman.com/blog/
'''

from calibre.web.feeds.news import BasicNewsRecipe

class ScottHanselman(BasicNewsRecipe):
    title                 = "Scott Hanselman's Computer Zen"
    __author__            = 'Darko Miletic'
    description           = "Scott Hanselman's Thoughts on Programming, Technology, Fatherhood, and Life"
    category              = "Scott, Computer, Zen, .NET, C#, Hanselman, Scott, Weblog, Diabetes, Portland, Zimbabwe, ComputerZen.com - Scott Hanselman's Musings"
    publisher             = 'Scott Hanselman'
    author                = 'Scott Hanselman'
    language = 'en'

    oldest_article        = 30
    max_articles_per_feed = 100
    no_stylesheets        = True
    use_embedded_content  = True
    encoding              = 'utf-8'

    html2lrf_options = [
                          '--comment'  , description
                        , '--category' , category
                        , '--publisher', publisher
                        , '--author'   , author
                        ]

    html2epub_options = 'publisher="' + publisher + '"\ncomments="' + description + '"\ntags="' + category + '"\nauthors="' + author + '"'

    remove_tags = [
                     dict(name=['object','link'])
                    ,dict(name='div',attrs={'class':'feedflare'})
                  ]

    feeds = [(u'Articles', u'http://feeds2.feedburner.com/ScottHanselman' )]

