#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'
'''
www.glas-javnosti.rs
'''
import re
from calibre.web.feeds.news import BasicNewsRecipe

class GlasJavnosti(BasicNewsRecipe):
    title                 = 'Glas Javnosti'
    __author__            = 'Darko Miletic'
    description           = 'Glas javnosti - Mi ne ulepsavamo stvarnost'
    publisher             = 'Glas Javnosti'
    category              = 'news, politics, Serbia'
    oldest_article        = 2
    max_articles_per_feed = 100
    no_stylesheets        = False
    use_embedded_content  = False
    language = 'sr'

    lang                  = 'sr-Latn-RS'
    direction             = 'ltr'
    extra_css = '@font-face {font-family: "serif1";src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)} @font-face {font-family: "sans1";src:url(res:///opt/sony/ebook/FONT/tt0003m_.ttf)} body{font-family: serif1, serif} .article_description{font-family: sans1, sans-serif}'

    conversion_options = {
                          'comment'          : description
                        , 'tags'             : category
                        , 'publisher'        : publisher
                        , 'language'         : lang
                        , 'pretty_print'     : True
                        }


    preprocess_regexps = [(re.compile(u'\u0110'), lambda match: u'\u00D0')]

    keep_only_tags     = [
                            dict(name='div', attrs={'id':'above-content'})
                           ,dict(name='div', attrs={'class':'node'      })
                         ]
    remove_tags = [
                     dict(name=['object','link','img'])
                    ,dict(name='div',attrs={'class':['links','meta']})
                    ,dict(name='div',attrs={'id':'block-block-12'})
                  ]

    feeds          = [
                        (u'Politika', u'http://www.glas-javnosti.rs/aktuelni-clanci/2')
                       ,(u'Tema', u'http://www.glas-javnosti.rs/aktuelni-clanci/48')
                       ,(u'Drustvo', u'http://www.glas-javnosti.rs/aktuelni-clanci/17')
                       ,(u'Ekonomija', u'http://www.glas-javnosti.rs/aktuelni-clanci/16')
                       ,(u'Dosije', u'http://www.glas-javnosti.rs/aktuelni-clanci/65')
                       ,(u'Svet', u'http://www.glas-javnosti.rs/aktuelni-clanci/18')
                       ,(u'Hronika', u'http://www.glas-javnosti.rs/aktuelni-clanci/19')
                       ,(u'Kultura', u'http://www.glas-javnosti.rs/aktuelni-clanci/6')
                       ,(u'Ljudi i Dogadjaji', u'http://www.glas-javnosti.rs/aktuelni-clanci/37')
                       ,(u'Putovanja', u'http://www.glas-javnosti.rs/aktuelni-clanci/113')
                       ,(u'Feljton', u'http://www.glas-javnosti.rs/aktuelni-clanci/49')
                       ,(u'Sport', u'http://www.glas-javnosti.rs/aktuelni-clanci/1')
                       ,(u'Lov i Ribolov', u'http://www.glas-javnosti.rs/aktuelni-clanci/591')
                       ,(u'Nedelja', u'http://www.glas-javnosti.rs/aktuelni-clanci/1862')
                       ,(u'Glasno', u'http://www.glas-javnosti.rs/aktuelni-clanci/590')
                       ,(u'Tehnologija', u'http://www.glas-javnosti.rs/aktuelni-clanci/609')
                       ,(u'Reflektor', u'http://www.glas-javnosti.rs/aktuelni-clanci/717')
                       ,(u'Saznanja', u'http://www.glas-javnosti.rs/aktuelni-clanci/1694')
                       ,(u'Beograd', u'http://www.glas-javnosti.rs/aktuelni-clanci/40')
                       ,(u'Srbija', u'http://www.glas-javnosti.rs/aktuelni-clanci/114')
                       ,(u'Zapadna Srbija', u'http://www.glas-javnosti.rs/aktuelni-clanci/41')
                       ,(u'Istocna i Juzna Srbija', u'http://www.glas-javnosti.rs/aktuelni-clanci/42')
                       ,(u'Sumadija i Pomoravlje', u'http://www.glas-javnosti.rs/aktuelni-clanci/43')
                       ,(u'Vojvodina', u'http://www.glas-javnosti.rs/aktuelni-clanci/44')
                       ,(u'Republika Srpska', u'http://www.glas-javnosti.rs/aktuelni-clanci/45')
                       ,(u'Slobodno Vreme', u'http://www.glas-javnosti.rs/aktuelni-clanci/61')
                       ,(u'Konjske Snage', u'http://www.glas-javnosti.rs/aktuelni-clanci/46')
                     ]

    remove_attributes = ['style','width','height','font','border','align']

