#!/usr/bin/env  python

__license__   = 'GPL v3'
__copyright__ = '2009, Darko Miletic <darko.miletic at gmail.com>'

'''
glassrpske.com
'''

import re
from calibre.web.feeds.recipes import BasicNewsRecipe
from calibre.ebooks.BeautifulSoup import Tag

class GlasSrpske(BasicNewsRecipe):
    title                 = 'Glas Srpske'
    __author__            = 'Darko Miletic'
    description           = 'Latest news from republika srpska'
    publisher             = 'GLAS SRPSKE'
    category              = 'Novine, Dnevne novine, Vijesti, Novosti, Ekonomija, Sport, Crna Hronika, Banja Luka,, Republika Srpska, Bosna i Hercegovina'
    oldest_article        = 2
    max_articles_per_feed = 100
    no_stylesheets        = True
    encoding              = 'utf-8'
    use_embedded_content  = False
    cover_url             = 'http://www.glassrpske.com/var/slike/glassrpske-logo.png'
    lang                  = 'sr-BA'
    language = 'sr'

    INDEX                 = 'http://www.glassrpske.com'

    extra_css = '@font-face {font-family: "serif1";src:url(res:///opt/sony/ebook/FONT/tt0011m_.ttf)} body{font-family: serif1, serif} .article_description{font-family: serif1, serif}'

    conversion_options = {
                          'comment'          : description
                        , 'tags'             : category
                        , 'publisher'        : publisher
                        , 'language'         : lang
                        , 'pretty_print'     : True
                        }

    preprocess_regexps = [(re.compile(u'\u0110'), lambda match: u'\u00D0')]

    keep_only_tags = [dict(name='div', attrs={'class':'gl_cv paragraf'})]

    remove_tags = [dict(name=['object','link','base'])]

    feeds = [
               (u'Novosti'   , u'http://www.glassrpske.com/vijest/2/novosti/lat/'   )
              ,(u'Drustvo'   , u'http://www.glassrpske.com/vijest/3/drustvo/lat/'   )
              ,(u'Biznis'    , u'http://www.glassrpske.com/vijest/4/ekonomija/lat/' )
              ,(u'Kroz RS'   , u'http://www.glassrpske.com/vijest/5/krozrs/lat/'    )
              ,(u'Hronika'   , u'http://www.glassrpske.com/vijest/6/hronika/lat/'   )
              ,(u'Srbija'    , u'http://www.glassrpske.com/vijest/8/srbija/lat/'    )
              ,(u'Region'    , u'http://www.glassrpske.com/vijest/18/region/lat/'   )
              ,(u'Svijet'    , u'http://www.glassrpske.com/vijest/12/svijet/lat/'   )
              ,(u'Kultura'   , u'http://www.glassrpske.com/vijest/9/kultura/lat/'   )
              ,(u'Banja Luka', u'http://www.glassrpske.com/vijest/10/banjaluka/lat/')
              ,(u'Jet Set'   , u'http://www.glassrpske.com/vijest/11/jetset/lat/'   )
              ,(u'Muzika'    , u'http://www.glassrpske.com/vijest/19/muzika/lat/'   )
              ,(u'Sport'     , u'http://www.glassrpske.com/vijest/13/sport/lat/'    )
              ,(u'Kolumne'   , u'http://www.glassrpske.com/vijest/16/kolumne/lat/'  )
              ,(u'Plus'      , u'http://www.glassrpske.com/vijest/7/plus/lat/'      )
            ]

    def preprocess_html(self, soup):
        soup.html['xml:lang'] = self.lang
        soup.html['lang']     = self.lang
        mlang = Tag(soup,'meta',[("http-equiv","Content-Language"),("content",self.lang)])
        soup.head.insert(0,mlang)
        return soup

    def parse_index(self):
        totalfeeds = []
        lfeeds = self.get_feeds()
        for feedobj in lfeeds:
            feedtitle, feedurl = feedobj
            self.report_progress(0, _('Fetching feed')+' %s...'%(feedtitle if feedtitle else feedurl))
            articles = []
            soup = self.index_to_soup(feedurl)
            for item in soup.findAll('div', attrs={'class':'gl_rub'}):
                atag    = item.find('a')
                ptag    = item.find('p')
                datetag = item.find('span')
                url           = self.INDEX + atag['href']
                title         = self.tag_to_string(atag)
                description   = self.tag_to_string(ptag)
                date,sep,rest = self.tag_to_string(ptag).partition('|')
                articles.append({
                                      'title'      :title
                                     ,'date'       :date
                                     ,'url'        :url
                                     ,'description':description
                                    })
            totalfeeds.append((feedtitle, articles))
        return totalfeeds


