#ifndef __BOGNOR_QUEUE_H__
#define __BOGNOR_QUEUE_H__

#include <glib-object.h>


G_BEGIN_DECLS

#define BOGNOR_TYPE_QUEUE                                               \
   (bognor_queue_get_type())
#define BOGNOR_QUEUE(obj)                                               \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BOGNOR_TYPE_QUEUE,                      \
                                BognorQueue))
#define BOGNOR_QUEUE_CLASS(klass)                                       \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BOGNOR_TYPE_QUEUE,                         \
                             BognorQueueClass))
#define IS_BOGNOR_QUEUE(obj)                                            \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BOGNOR_TYPE_QUEUE))
#define IS_BOGNOR_QUEUE_CLASS(klass)                                    \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BOGNOR_TYPE_QUEUE))
#define BOGNOR_QUEUE_GET_CLASS(obj)                                     \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BOGNOR_TYPE_QUEUE,                       \
                               BognorQueueClass))

typedef struct _BognorQueuePrivate BognorQueuePrivate;
typedef struct _BognorQueue      BognorQueue;
typedef struct _BognorQueueClass BognorQueueClass;

typedef enum _BognorQueueItemType {
    AUDIO_TYPE,
    VISUAL_TYPE,
} BognorQueueItemType;

typedef struct _BognorQueueItem {
    char *uri;
    char *mimetype;
    BognorQueueItemType type;
} BognorQueueItem;

struct _BognorQueue {
    GObject parent;

    BognorQueuePrivate *priv;
};

struct _BognorQueueClass {
    GObjectClass parent_class;

    gboolean (*set_uri) (BognorQueue      *queue,
                         BognorQueueItem *item);

    gboolean (*set_audio_playing) (BognorQueue *queue,
                                   gboolean     playing);
    gboolean (*set_visual_playing) (BognorQueue *queue,
                                    gboolean     playing);

    gboolean (*set_audio_position) (BognorQueue *queue,
                                    double       position);
    gboolean (*get_audio_position) (BognorQueue *queue,
                                    double      *position);
    gboolean (*set_visual_position) (BognorQueue *queue,
                                     double       position);
    gboolean (*get_visual_position) (BognorQueue *queue,
                                     double      *position);
    gboolean (*force_visual) (BognorQueue *queue);
    gboolean (*add_item_to_recent) (BognorQueue     *queue,
                                    BognorQueueItem *item);
};

GType bognor_queue_get_type (void) G_GNUC_CONST;

gboolean bognor_queue_play (BognorQueue *queue,
                            GError     **error);

void bognor_queue_set_visual_enabled (BognorQueue *queue,
                                      gboolean     enabled);
gboolean bognor_queue_get_visual_enabled (BognorQueue *queue);
void bognor_queue_set_name (BognorQueue *queue,
                            const char  *name);
void bognor_queue_emit_position_changed (BognorQueue *queue,
                                         double       position,
                                         int          type);

BognorQueueItem *bognor_queue_get_current_item (BognorQueue *queue);
BognorQueueItem *bognor_queue_get_next_item (BognorQueue *queue);
void bognor_queue_play_next (BognorQueue *queue);
gboolean bognor_queue_get_is_playing (BognorQueue *queue);

G_END_DECLS

#endif /* __BOGNOR_QUEUE_H__ */
