#!/bin/bash

flag=1

echo -e "CSR BlueZ Started"
#HCI Device up command
sudo hciconfig hci0 up

#Start BlueZ command
sudo bluetoothd 

#Start Bluez in Debug Mode: logs /var/logs/messages
#bluetoothd --debug
#enable Bluetooth Radio if it is off
sudo bccmd -d hci0 enabletx;

#Show configuration of Bluetooth hardware
echo -e "Configuration of bluetooth hardware"
hciconfig -a

#CSR BlueZ menu items
while [ "$profile" != 9 ]
do
echo "################################################"
echo "#             BlueZ PROFILE MENU               #"
echo "#              1. SPP                          #"
echo "#              2. HFP                          #"
echo "#              3. A2DP/AVRCP                   #"
echo "#              4. OPP/FTP                      #"
echo "#              5. HID                          #"
echo "#              6. Disconnect a Device          #"
echo "#              7. BlueZ Radio ON               #"
echo "#              8. BlueZ Radio OFF              #"
echo "#              9. EXIT                         #"
echo "################################################"

echo "Enter your option <1-9> "
read profile

case $profile in
   "1") echo "SPP profile"
	spp.sh;;
   "2") echo "HFP profile"
	hfp.sh;;
   "3") echo "A2DP/AVRCP profile"
        a2dp.sh;;
   "4") echo "OPP profile"
	opp.sh;;
   "5") echo "HID profile"
        hid.sh;;
   "6") echo "List & Disconnect a Device"
        hcitool con
        echo -e "Enter the BDADDR of the Device to disconnect"
        read conn
        sudo hcitool dc $conn;;
   "7") if [ $flag = 0 ]
        then
	  sudo bccmd -d hci0 enabletx;
          flag=1
          echo "Radio ON"
        else
          echo "Radio already ON"
        fi;;
   "8") if [ $flag = 1 ]
        then
          sudo bccmd -d hci0 coldreset;
          sleep 2
          sudo bccmd -d hci0 disabletx;
          flag=0
          echo "Radio OFF"
        else
          echo "Radio already OFF"
        fi;;
   "9") echo "EXIT"
        exit 0;;
   *) echo "Sorry, Not a valid option, try again";;
esac
  echo -n "Press Enter to go to the Main Menu again"
  read nil
  clear
done


