/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2005-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <signal.h>

#include <glib.h>

#include <dbus/dbus-glib.h>

#include "dbus-glue.h"

static GMainLoop *main_loop = NULL;

static void sig_term(int sig)
{
	g_main_loop_quit(main_loop);
}

static gboolean passkey_agent_request(GObject *agent,
				const char *path, const char *address,
					DBusGMethodInvocation *context)
{
	return TRUE;
}

static gboolean passkey_agent_confirm(GObject *agent,
			const char *path, const char *address,
			const char *value, DBusGMethodInvocation *context)
{
	return TRUE;
}

static gboolean passkey_agent_cancel(GObject *agent,
			const char *path, const char *address, GError **error)
{
	return TRUE;
}

static gboolean passkey_agent_release(GObject *agent, GError **error)
{
	g_main_loop_quit(main_loop);

	return TRUE;
}

#include "passkey-agent-glue.h"

int main(int argc, char *argv[])
{
	struct sigaction sa;
	DBusGConnection *conn;
	DBusGProxy *proxy;
	GObject *object;
	GError *error = NULL;

	memset(&sa, 0, sizeof(sa));
	sa.sa_flags = SA_NOCLDSTOP;
	sa.sa_handler = sig_term;
	sigaction(SIGTERM, &sa, NULL);
	sigaction(SIGINT,  &sa, NULL);

	g_type_init();

	main_loop = g_main_loop_new(NULL, FALSE);

	conn = dbus_g_bus_get(DBUS_BUS_SYSTEM, &error);
	if (error != NULL) {
		g_printerr("Connecting to system bus failed: %s\n",
							error->message);
		g_main_loop_unref(main_loop);
		g_error_free(error);
		exit(1);
	}

	proxy = dbus_g_proxy_new_for_name(conn, "org.bluez", "/org/bluez/hci0",
							"org.bluez.Security");

	object = g_object_new(G_TYPE_OBJECT, NULL);

	dbus_g_object_type_install_info(G_TYPE_OBJECT,
					&dbus_glib_passkey_agent_object_info);

	dbus_g_connection_register_g_object(conn, "/org/bluez/agent", object);

	security_register_passkey_agent(proxy, "/org/bluez/agent",
						"00:11:22:33:44:55", NULL);

	g_main_loop_run(main_loop);

	security_unregister_passkey_agent(proxy, "/org/bluez/agent",
						"00:11:22:33:44:55", NULL);

	g_object_unref(proxy);

	g_object_unref(object);

	dbus_g_connection_unref(conn);

	g_main_loop_unref(main_loop);

	return 0;
}
