#include <glib.h>
#include <gio/gio.h>
#include <kozo.h>

#include <bickley/bkl-db.h>
#include <bickley/bkl-item.h>
#include <bickley/bkl-item-audio.h>

#include "metadata.h"

static GTimer *timer;
static KozoDB *db;
static GHashTable *fields;
static GMainLoop *main_loop;
static GPtrArray *songs = NULL;

static void
load_songlist (void)
{
    GPtrArray *songs;
    GError *error = NULL;
    BklItem *item;
    int i;

    songs = bkl_db_get_items (db, &error);
    if (error != NULL) {
        g_error ("Error getting items: %s", error->message);
    }

    g_timer_stop (timer);
    g_print ("Got %d songs in %.3f seconds\n", songs->len,
             g_timer_elapsed (timer, NULL));

    for (i = 0; i < songs->len; i++) {
        BklItem *item = songs->pdata[i];

        g_print ("%s\n", bkl_item_get_uri (item));
        if (IS_BKL_ITEM_AUDIO (item)) {
            g_print ("    %s\n", bkl_item_audio_get_title (item));
            g_print ("    %s\n", bkl_item_audio_get_album (item));
            g_print ("    Track %d of %d (disc %d)\n",
                     bkl_item_audio_get_track (item),
                     bkl_item_audio_get_max_tracks (item),
                     bkl_item_audio_get_disc (item));
        }
    }
}

int
main (int    argc,
      char **argv)
{
    GError *error = NULL;
    int i;

    g_thread_init (NULL);
    g_type_init ();

    kozo_util_init ();
    kozo_entry_init ();
    kozo_field_init ();
    kozo_expr_init ();
    kozo_db_init ();
    kozo_index_init ();

    main_loop = g_main_loop_new (NULL, FALSE);

    g_print ("Getting music DB\n");
    timer = g_timer_new ();

    db = bkl_db_get ("bickley-local", &error);
    if (!db) {
        g_printerr ("Could not get music database: %s\n", error->message);
        g_error_free (error);
        return 0;
    }

    g_print ("Got music DB in %0.3f seconds\n", g_timer_elapsed (timer, NULL));

    load_songlist ();

    g_main_loop_run (main_loop);

    kozo_db_unref (db);

    kozo_index_shutdown ();
    kozo_db_shutdown ();
    kozo_expr_shutdown ();
    kozo_field_shutdown ();
    kozo_entry_shutdown ();
    kozo_util_shutdown ();

    return 0;
}
