/*
 * Bickley - a meta data management framework, the file system spider.
 *
 * Copyright © 2007-2008 Øyvind Kolås <pippin@gimp.org>
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_PATH_FINDER_H__
#define __BKL_PATH_FINDER_H__

#include <glib.h>
#include <gio/gio.h>

#include "bkl-source.h"
#include "bkl-finder.h"

G_BEGIN_DECLS

typedef struct _BklPathFinder BklPathFinder;

struct _BklPathFinder {
    BklFinder finder;

    GQueue *pending;
    GFile *base_file;

    GHashTable *directories; /* Of BklPathFinderDir */
};

BklFinder *bkl_path_finder_new (BklSource  *source,
                                const char *uri);

G_END_DECLS
#endif
