#include <bkl/bkl-item.h>

struct _BklItem {
    BklItemType type;

    char *uri;
    char *mimetype;

    goffset size;
    glong mtime;
};

struct _BklItemExtended {
    BklItem item;

    glong last_used;
    glong use_count;
    int rating;
    gboolean pinned;
    GPtrArray *tags;
};

struct _BklItemAudio {
    BklItemExtended extended;

    char *title;
    char *album;

    GPtrArray *artists;
    GPtrArray *performers;
    char *conductor;
    char *composer;

    char *genre;
    char *comment;
    char *copyright;
    char *license;
    char *organisation;
    char *isrc;
    char *contact;
    char *year;

    guint track;
    guint maxtracks
    guint disc;
    guint duration;
};

struct _BklItemImage {
    BklItemExtended extended;

    char *title;
    char *description;
    char *camera_make;
    char *camera_model;
    char *taken_on;
    char *location;
    char *orientation;
    char *aperture;
    char *iso;
    char *software;
    char *author;
    char *copyright;
    char *comment;
    char *keywords;
    char *subject;
    char *focal_length;
    char *shutter_speed;

    guint width;
    guint height;
};

struct _BklItemVideo {
    BklItemExtended extended;

    char *title;
    char *director;
    char *series_name;

    guint season;
    guint episode;
    guint year;

    guint duration;
};

BklItem *
bkl_item_new (BklItemType type,
              const char *uri,
              const char *mimetype,
              goffset     size,
              glong       last_modified)
{
    BklItem *item = NULL;

    switch (type) {
    case BKL_ITEM_AUDIO:
        item = g_new0 (BklItemAudio, 1);
        break;

    case BKL_ITEM_IMAGE:
        item = g_new0 (BklItemImage, 1);
        break;

    case BKL_ITEM_VIDEO:
        item = g_new0 (BklItemVideo, 1);
        break;

    default:
        g_assert_not_reached ();
        break;
    }

    item->type = type;
    item->uri = g_strdup (uri);
    item->mimetype = g_strdup (mimetype);
    item->size = size;
    item->mtime = last_modified;

    return item;
}

const char *
bkl_item_get_uri (BklItem *item)
{
    return item->uri;
}

void
bkl_item_
const char *
bkl_item_get_mimetype (BklItem *mimetype)
{
    return item->mimetype;
}
