/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __BKL_ITEM_H__
#define __BKL_ITEM_H__

#include <glib-object.h>
#include <kozo.h>

G_BEGIN_DECLS

#define BKL_TYPE_ITEM                                                   \
   (bkl_item_get_type())
#define BKL_ITEM(obj)                                                   \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_ITEM,                          \
                                BklItem))
#define BKL_ITEM_CLASS(klass)                                           \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_ITEM,                             \
                             BklItemClass))
#define IS_BKL_ITEM(obj)                                                \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_ITEM))
#define IS_BKL_ITEM_CLASS(klass)                                        \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_ITEM))
#define BKL_ITEM_GET_CLASS(obj)                                         \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_ITEM,                           \
                               BklItemClass))

typedef struct _BklItemPrivate BklItemPrivate;
typedef struct _BklItem      BklItem;
typedef struct _BklItemClass BklItemClass;

typedef enum _BklItemType {
    BKL_ITEM_TYPE_NONE  = 0, 
    BKL_ITEM_TYPE_IMAGE = 1<<0,  /* the types are flags, making it possible */
    BKL_ITEM_TYPE_AUDIO = 1<<1,  /* to filter on type using bit arithmetic */
    BKL_ITEM_TYPE_VIDEO = 1<<2,
    BKL_ITEM_TYPE_BROKEN = 1<<3,
    BKL_ITEM_TYPE_PLAYLIST = 1<<4
} BklItemType;

struct _BklItem
{
    GObject parent;

    BklItemPrivate *priv;
};

struct _BklItemClass
{
    GObjectClass parent_class;
};

GType bkl_item_get_type (void) G_GNUC_CONST;

GSList *bkl_item_get_fields (BklItem *item);

BklItemType bkl_item_get_item_type (BklItem *item);
void bkl_item_set_item_type (BklItem    *item,
                             BklItemType type);

void bkl_item_set_uri (BklItem    *item,
                       const char *uri);
const char *bkl_item_get_uri (BklItem *item);

void bkl_item_set_mimetype (BklItem    *item,
                            const char *mimetype);
const char *bkl_item_get_mimetype (BklItem *item);

void bkl_item_set_size (BklItem *item,
                        goffset  size);
goffset bkl_item_get_size (BklItem *item);

void bkl_item_set_modification_time (BklItem *item,
                                     glong    mtime);
glong bkl_item_get_modification_time (BklItem *item);

void bkl_item_set_from_field (BklItem   *item,
                              KozoField *field);
char *bkl_item_to_string (BklItem *item);

G_END_DECLS

#endif /* __BKL_ITEM_H__ */
