#ifndef __BKL_SOURCE_CLIENT_H__
#define __BKL_SOURCE_CLIENT_H__

#include <glib-object.h>

#include <bickley/bkl-db.h>
#include <bickley/bkl-item.h>

G_BEGIN_DECLS

#define BKL_SOURCE_DBUS_SERVICE "org.moblin.Bickley.Orbiter"
#define BKL_SOURCE_DBUS_INTERFACE "org.moblin.Bickley.Source"

#define BKL_LOCAL_SOURCE_PATH "/org/moblin/Bickley/Sources/Local"

#define BKL_TYPE_SOURCE_CLIENT                                          \
   (bkl_source_client_get_type())
#define BKL_SOURCE_CLIENT(obj)                                          \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                BKL_TYPE_SOURCE_CLIENT,                 \
                                BklSourceClient))
#define BKL_SOURCE_CLIENT_CLASS(klass)                                  \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             BKL_TYPE_SOURCE_CLIENT,                    \
                             BklSourceClientClass))
#define IS_BKL_SOURCE_CLIENT(obj)                                       \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                BKL_TYPE_SOURCE_CLIENT))
#define IS_BKL_SOURCE_CLIENT_CLASS(klass)                               \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             BKL_TYPE_SOURCE_CLIENT))
#define BKL_SOURCE_CLIENT_GET_CLASS(obj)                                \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               BKL_TYPE_SOURCE_CLIENT,                  \
                               BklSourceClientClass))

typedef struct _BklSourceClientPrivate BklSourceClientPrivate;
typedef struct _BklSourceClient      BklSourceClient;
typedef struct _BklSourceClientClass BklSourceClientClass;

struct _BklSourceClient
{
    GObject parent;

    BklSourceClientPrivate *priv;
};

struct _BklSourceClientClass
{
    GObjectClass parent_class;
};

GType bkl_source_client_get_type (void) G_GNUC_CONST;
BklSourceClient *bkl_source_client_new (const char *path);
BklDB *bkl_source_client_get_db (BklSourceClient *client);
const char *bkl_source_client_get_path (BklSourceClient *client);

G_END_DECLS

#endif /* __BKL_SOURCE_CLIENT_H__ */
