<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    data-defs.php                                           */
/* Author:      Paul Waite                                              */
/* Description: Definitions for managing DATA of various types.         */
/*                                                                      */
/* ******************************************************************** */
/** @package utils */

/**
* Dat_keyvalues
* This class is a simple container class. It specifically deals
* with a collection of key=>value pairs in an internal array,
* and provides a few high-level functions to set these and
* read them out. Used in combo elements for forms.
* @package utils
*/
class dat_keyvalues {
  /** The array containing data in key=>value pairs */
  var $data = array();
  /** The total data items in our array */
  var $count = 0;
  // ....................................................................
  /** Constructor */
  function dat_keyvalues() {}
  // ....................................................................
  /**
  * Returns status of data.
  * Returns true if the container has some data in it, else
  * returns false.
  * @returns bool Status of data in the container.
  */
  function hasdata() {
    return (isset($this->data) && count($this->data) > 0);
  }
  // ....................................................................
  /**
  * Add query data
  * Add items from a query. The 'keyfield' parameter contains the
  * name of the field to get key value from, and 'displayfields' is
  * expected to contain a list of fields separated by the pipe "|"
  * char. Literals are also supported by using a pseudo-fieldname in
  * the list prefixed by a "#" char. In this case everything after the
  * "#" will be used as the content of that field.
  * @param object $query         Pointer to an executed Axyl query object
  * @param string $keyfield      Name of the key field to use.
  * @param string $displayfields List of display fields separated with "|".
  * @see add_item()
  */
  function add_querydata($query, $keyfield, $displayfields) {
    if ($query->hasdata) {
      $dispflds = explode("|", $displayfields);
      do {
        $key = $query->field($keyfield);
        $value = "";
        reset($dispflds);
        foreach ($dispflds as $fld) {
          if (substr($fld, 0, 1) == "#") {
            $value .= substr($fld, 1);
          }
          elseif (substr($fld, 0, 1) == "^") {
            $fld = substr($fld, 1);
            $value .= strtoupper($query->field($fld));
          }
          else {
            $value .= $query->field($fld);
          }
        }
        $this->additem($key, $value);
      } while ($query->get_next());
    }
  }
  // ....................................................................
  /**
  * Adds a key=>value pair item into the collection.
  * @param mixed $key   The key value to use
  * @param mixed $value The value to assign to the key
  */
  function additem($key, $value) {
    $this->data[$key] = $value;
    $this->count += 1;
  }
  // ....................................................................
  /** Clears all key=>value pair items from the collection. */
  function clearitems() {
    $this->data = array();
    $this->count = 0;
  }
  // ....................................................................
  /**
  * Reset the data
  * Resets the internal array to the start. This is used when
  * you need to repeatedly traverse the data.
  */
  function reset() {
    if (isset($this->data)) reset($this->data);
  }
  // ....................................................................
  /**
  * Find ordinal array index
  * Finds the ordinal array index of the element with key $key.
  * @param mixed $key  The key of the value to find the index of
  * @returns integer The index of the given key
  */
  function getitemindex($key) {
    $this->reset();
    $ix=0; $foundix=0;
    while ( list($searchkey, $val) = each($this->data) ) {
      $ix += 1;
      if ($key == $searchkey) {
        $foundix = $ix;
        break;
      }
    }
    $this->reset();
    return $foundix;
  }
  // ....................................................................
  /**
  * Return item value
  * Returns the value of the data item with the given key
  * @param mixed $key  The key of the value to find the index of
  * @returns mixed The value of the item
  */
  function getitem($key) {
    if (isset($this->data[$key])) return $this->data[$key];
    else return "";
  }
} // dat_keyvalues class

// ----------------------------------------------------------------------
?>