/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
package nz.net.catalyst.lucene.server;

/**
 * Lucene Range attributes.
 */

class RangeDef
{
  final String name;
  String from = null;
  String to = null;

  /**
   * Define a Range with no from/to attributes.  This is an invalid
   * range until one or both of the from/to attributes are filled in.
   */

  RangeDef(String name)
  {
    this.name = name;
  }

  public boolean equals(Object o)
  {
    if (this == o)
      return true;

    if (!(o instanceof RangeDef))
      return false;

    RangeDef that = (RangeDef)o;
    return this.name.equals(that.name);
  }
}
